/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import jet.universe.businesslogic.joinpathtools.GraphJoinPathAPI;
import jet.universe.businesslogic.joinpathtools.JoinPathSetAPI;
import jet.universe.businesslogic.joinpathtools.graph.GraphJoinPath;

public class JoinPathSet
implements JoinPathSetAPI {
    private ArrayList[] sections = new ArrayList[10];
    private int length = this.sections.length;
    private int maxSection = -1;
    private boolean runGetSectionCount = false;

    public JoinPathSet() {
        for (int i = 0; i < this.length; ++i) {
            this.sections[i] = new ArrayList();
        }
    }

    @Override
    public int getSectionCount() {
        int nullCount = 0;
        for (int i = 0; i <= this.maxSection; ++i) {
            if (this.sections[i].size() != 0) continue;
            this.sections[i] = null;
            ++nullCount;
        }
        if (nullCount > 0) {
            int offset = 0;
            ArrayList[] tem = new ArrayList[this.maxSection - nullCount + 1];
            for (int i = 0; i <= this.maxSection; ++i) {
                if (this.sections[i] == null) continue;
                tem[offset++] = this.sections[i];
            }
            this.sections = tem;
            this.maxSection -= nullCount;
            this.length = this.sections.length;
        }
        this.runGetSectionCount = true;
        return this.maxSection + 1;
    }

    @Override
    public GraphJoinPathAPI getSections(int index) {
        if (!this.runGetSectionCount) {
            this.getSectionCount();
        }
        if (index < 1 || index > this.maxSection + 1) {
            return null;
        }
        ArrayList list = this.sections[--index];
        GraphJoinPathAPI[] joinPaths = new GraphJoinPathAPI[list.size()];
        list.toArray(joinPaths);
        return joinPaths[0];
    }

    public void addJoinPath(GraphJoinPath joinPath, int sectionNum) {
        if (sectionNum > this.maxSection) {
            this.maxSection = sectionNum;
        }
        if (sectionNum >= this.length) {
            ArrayList[] tem = new ArrayList[this.length + 5];
            System.arraycopy(this.sections, 0, tem, 0, this.length);
            this.sections = tem;
            for (int i = this.length; i < this.sections.length; ++i) {
                this.sections[i] = new ArrayList();
            }
            this.length = this.sections.length;
        }
        ArrayList list = this.sections[sectionNum];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            GraphJoinPath existancePath = (GraphJoinPath)list.get(i);
            if (!existancePath.equals(joinPath)) continue;
            return;
        }
        list.add(joinPath);
        this.runGetSectionCount = false;
    }

    public String toString() {
        int count = this.getSectionCount();
        StringBuffer buf = new StringBuffer("Section Count : " + count);
        for (int i = 1; i <= count; ++i) {
            GraphJoinPathAPI joinPath = this.getSections(i);
            buf.append("\nSection : " + i + "\n");
            buf.append(joinPath.toString());
        }
        return buf.toString();
    }
}

