/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.EdgeHashMap;
import jet.universe.businesslogic.joinpathtools.graph.EdgeList;
import jet.universe.businesslogic.joinpathtools.graph.Graph;
import jet.universe.businesslogic.joinpathtools.graph.GraphLogicalException;
import jet.universe.businesslogic.joinpathtools.graph.PathList;
import jet.universe.businesslogic.joinpathtools.graph.Vertex;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;

public class Path {
    private VertexList vertexList = new VertexList();
    private EdgeList usedEdgeList = new EdgeList();

    public Path(VertexList vertexList) throws GraphLogicalException {
        if (vertexList.size() < 1) {
            throw new GraphLogicalException(10);
        }
        this.checkPathVertexList(vertexList);
        for (int i = 0; i < vertexList.size(); ++i) {
            this.vertexList.add(new Vertex(((Vertex)vertexList.get(i)).getKey()));
        }
    }

    public Path(EdgeList edgeList) throws GraphLogicalException {
        if (edgeList.size() < 1) {
            throw new GraphLogicalException(11);
        }
        EdgeList cloneList = (EdgeList)edgeList.clone();
        Edge eTem = (Edge)cloneList.remove(0);
        if (eTem.isPoint()) {
            this.vertexList.add(new Vertex(eTem.startKey()));
        } else {
            this.vertexList.add(new Vertex(eTem.startKey()));
            this.vertexList.add(new Vertex(eTem.endKey()));
        }
        while (true) {
            for (int i = 0; i < cloneList.size(); ++i) {
                eTem = (Edge)cloneList.get(i);
                if (this.getStartVertex().getKey().equals(eTem.startKey())) {
                    if (!eTem.isPoint()) {
                        this.vertexList.add(0, new Vertex(eTem.endKey()));
                    }
                    cloneList.remove(i);
                    continue;
                }
                if (this.getStartVertex().getKey().equals(eTem.endKey())) {
                    if (!eTem.isPoint()) {
                        this.vertexList.add(0, new Vertex(eTem.startKey()));
                    }
                    cloneList.remove(i);
                    continue;
                }
                if (this.getEndVertex().getKey().equals(eTem.startKey())) {
                    if (!eTem.isPoint()) {
                        this.vertexList.add(new Vertex(eTem.endKey()));
                    }
                    cloneList.remove(i);
                    continue;
                }
                if (!this.getEndVertex().getKey().equals(eTem.endKey())) continue;
                if (!eTem.isPoint()) {
                    this.vertexList.add(new Vertex(eTem.startKey()));
                }
                cloneList.remove(i);
            }
            break;
        }
        try {
            this.checkPathVertexList(this.vertexList);
        }
        catch (GraphLogicalException gLE) {
            throw new GraphLogicalException(12);
        }
        if (cloneList.size() > 0) {
            throw new GraphLogicalException(13);
        }
    }

    public Path(String[] vertexList) throws GraphLogicalException {
        VertexList tem = new VertexList();
        if (vertexList.length < 1) {
            throw new GraphLogicalException(14);
        }
        for (int i = 0; i < vertexList.length; ++i) {
            tem.add(new Vertex(vertexList[i]));
        }
        this.checkPathVertexList(tem);
        this.vertexList = tem;
    }

    private void checkPathVertexList(VertexList pathVertexList) throws GraphLogicalException {
        int size = pathVertexList.size();
        String[] vertices = new String[size];
        for (int i = 0; i < size; ++i) {
            String v = ((Vertex)pathVertexList.get(i)).getKey();
            for (int j = 0; j < i; ++j) {
                if (!vertices[j].equals(v)) continue;
                if (j == 0 && i == size - 1) {
                    return;
                }
                throw new GraphLogicalException(15, new Object[]{pathVertexList.toString()});
            }
            vertices[i] = v;
        }
    }

    public VertexList getVertexList() {
        return (VertexList)this.vertexList.clone();
    }

    public Vertex getStartVertex() {
        return (Vertex)this.vertexList.get(0);
    }

    public Vertex getEndVertex() {
        return (Vertex)this.vertexList.get(this.vertexList.size() - 1);
    }

    public Edge getStartEdge() {
        int length = this.getLength();
        if (length <= 1) {
            return null;
        }
        return new Edge(((Vertex)this.vertexList.get(0)).getKey(), ((Vertex)this.vertexList.get(1)).getKey());
    }

    public Edge getEndEdge() {
        int length = this.getLength();
        if (length <= 1) {
            return null;
        }
        return new Edge(((Vertex)this.vertexList.get(length - 2)).getKey(), ((Vertex)this.vertexList.get(length - 1)).getKey());
    }

    public Object clone() {
        try {
            return new Path(this.vertexList);
        }
        catch (GraphLogicalException gLE) {
            return null;
        }
    }

    public boolean isInGraph(Graph graph) {
        EdgeHashMap edgeListTem = graph.getEdgeList();
        for (int i = 0; i < this.vertexList.size() - 1; ++i) {
            String edgeKey1 = Edge.key(((Vertex)this.vertexList.get(i)).getKey(), ((Vertex)this.vertexList.get(i + 1)).getKey());
            String edgeKey2 = Edge.key(((Vertex)this.vertexList.get(i + 1)).getKey(), ((Vertex)this.vertexList.get(i)).getKey());
            if (edgeListTem.containsKey(edgeKey1) || edgeListTem.containsKey(edgeKey2)) continue;
            return false;
        }
        return true;
    }

    public boolean compareTo(Path path) {
        EdgeList pathEdgeList = path.getEdges();
        EdgeList thisEdgeList = this.getEdges();
        if (thisEdgeList.size() != pathEdgeList.size()) {
            return false;
        }
        for (int i = 0; i < thisEdgeList.size(); ++i) {
            Edge thisEdge = (Edge)thisEdgeList.get(i);
            boolean equalFlag = false;
            for (int j = 0; j < pathEdgeList.size(); ++j) {
                if (!thisEdge.equals((Edge)pathEdgeList.get(j))) continue;
                equalFlag = true;
                break;
            }
            if (equalFlag) continue;
            return false;
        }
        return true;
    }

    public PathList getIntersection(Path path) {
        VertexList temList = path.getVertexList();
        EdgeList thisEdges = this.getEdges();
        EdgeList pathEdges = path.getEdges();
        EdgeList commonEdges = new EdgeList();
        if (this.vertexList.size() == 1 || temList.size() == 1) {
            return new PathList();
        }
        int size = thisEdges.size();
        block0: for (int i = 0; i < size; ++i) {
            Edge edge = (Edge)thisEdges.get(i);
            int size2 = pathEdges.size();
            for (int j = 0; j < size2; ++j) {
                Edge edge2 = (Edge)pathEdges.get(j);
                if (!edge.equals(edge2)) continue;
                commonEdges.add(edge);
                continue block0;
            }
        }
        if (commonEdges.size() == 0) {
            return new PathList();
        }
        return Path.getPathsFromEdgeList(commonEdges);
    }

    public EdgeList getEdges() {
        EdgeList edges = new EdgeList();
        if (this.vertexList.size() == 1) {
            return null;
        }
        for (int i = 0; i < this.vertexList.size() - 1; ++i) {
            edges.add(new Edge(((Vertex)this.vertexList.get(i)).getKey(), ((Vertex)this.vertexList.get(i + 1)).getKey()));
        }
        return edges;
    }

    public void use(Path subPath) {
        EdgeList edgeList = subPath.getEdges();
        for (int i = 0; i < edgeList.size(); ++i) {
            this.usedEdgeList.add(edgeList.get(i));
        }
    }

    public PathList getUnusedSubPathes() {
        EdgeList thisEdgeList = this.getEdges();
        int size = thisEdgeList.size();
        EdgeList unusedEdges = new EdgeList();
        if (this.vertexList.size() == 1) {
            return new PathList();
        }
        block0: for (int i = 0; i < size; ++i) {
            int size2 = this.usedEdgeList.size();
            Edge eTem = (Edge)thisEdgeList.get(i);
            for (int j = 0; j < size2; ++j) {
                Edge usedEdge = (Edge)this.usedEdgeList.get(j);
                if (eTem.equals(usedEdge)) continue block0;
            }
            unusedEdges.add(eTem);
        }
        return Path.getPathsFromEdgeList(unusedEdges);
    }

    public boolean isContainsLoop() {
        if (this.vertexList.size() == 1) {
            return false;
        }
        return ((Vertex)this.vertexList.get(0)).getKey().equals(((Vertex)this.vertexList.get(this.vertexList.size() - 1)).getKey());
    }

    public int getIndex(Vertex v) {
        int length = this.vertexList.size();
        for (int i = 0; i < length; ++i) {
            if (!((Vertex)this.vertexList.get(i)).getKey().equals(v.getKey())) continue;
            return i;
        }
        return -1;
    }

    public int getLength() {
        return this.vertexList.size();
    }

    public boolean equals(Path p) {
        if (this.getLength() != p.getLength() || this.isContainsLoop() != p.isContainsLoop()) {
            return false;
        }
        VertexList pv = p.getVertexList();
        int length = p.getLength();
        boolean flag = true;
        if (this.isContainsLoop()) {
            int i;
            length = this.getLength();
            int[] location = new int[length - 1];
            for (i = 0; i < location.length; ++i) {
                int position = this.getIndex((Vertex)pv.get(i));
                if (position == -1) {
                    return false;
                }
                location[i] = position;
            }
            for (i = 0; i < location.length - 1; ++i) {
                if ((location[i] + 1) % location.length == location[i + 1]) continue;
                flag = false;
                break;
            }
            if (flag) {
                return true;
            }
            for (i = 0; i < location.length - 1; ++i) {
                if ((location[i] - 1 + location.length) % location.length == location[i + 1]) continue;
                return false;
            }
        } else {
            int i;
            for (i = 0; i < length; ++i) {
                if (((Vertex)this.vertexList.get(i)).getKey().equals(((Vertex)pv.get(i)).getKey())) continue;
                flag = false;
                break;
            }
            if (flag) {
                return true;
            }
            for (i = 0; i < length; ++i) {
                if (((Vertex)this.vertexList.get(i)).getKey().equals(((Vertex)pv.get(length - i - 1)).getKey())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isContainsEdge(Edge e) {
        EdgeList edgeList = this.getEdges();
        for (int i = 0; i < edgeList.size(); ++i) {
            Edge edge = (Edge)edgeList.get(i);
            if (!edge.equals(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsVertex(Vertex v) {
        VertexList vertexList = this.getVertexList();
        for (Vertex vertexNode : vertexList) {
            if (!vertexNode.getKey().equals(v.getKey())) continue;
            return true;
        }
        return false;
    }

    public VertexList getNeighbourVertex(Vertex v) {
        VertexList vertexList = this.getVertexList();
        VertexList vertexNaberList = new VertexList();
        for (int i = 0; i < vertexList.size(); ++i) {
            Vertex other;
            Vertex one;
            Vertex av = (Vertex)vertexList.get(i);
            if (!av.getKey().equals(v.getKey()) || !this.isContainsLoop()) continue;
            if (i == 0) {
                one = (Vertex)vertexList.get(1);
                vertexNaberList.add(one);
                other = (Vertex)vertexList.get(vertexList.size() - 2);
                vertexNaberList.add(other);
                break;
            }
            if (i == vertexList.size() - 1) {
                one = (Vertex)vertexList.get(i - 1);
                vertexNaberList.add(one);
                other = (Vertex)vertexList.get(1);
                vertexNaberList.add(other);
                break;
            }
            one = (Vertex)vertexList.get(i - 1);
            vertexNaberList.add(one);
            other = (Vertex)vertexList.get(i + 1);
            vertexNaberList.add(other);
        }
        return vertexNaberList;
    }

    public static PathList getPathsFromEdgeList(EdgeList edgeList) {
        EdgeList trimEdgeList = new EdgeList();
        int size = edgeList.size();
        PathList pathList = new PathList();
        Edge eTem = null;
        for (int i = 0; i < size; ++i) {
            eTem = (Edge)edgeList.get(i);
            if (trimEdgeList.contains(eTem)) continue;
            trimEdgeList.add(eTem);
        }
        size = trimEdgeList.size();
        if (size == 0) {
            return pathList;
        }
        block5: while (true) {
            ArrayList loopPaths;
            try {
                loopPaths = new Graph(trimEdgeList.toTwoDimensionArray()).getLoop();
            }
            catch (GraphLogicalException ex) {
                loopPaths = null;
            }
            if (loopPaths.size() == 0) break;
            Path loopPath = (Path)loopPaths.get(0);
            pathList.add(loopPath);
            EdgeList loopEdgeList = loopPath.getEdges();
            int size2 = loopEdgeList.size();
            int i = 0;
            while (true) {
                if (i >= size2) continue block5;
                eTem = (Edge)loopEdgeList.get(i);
                size = trimEdgeList.size();
                for (int j = 0; j < size; ++j) {
                    if (!eTem.equals((Edge)trimEdgeList.get(j))) continue;
                    trimEdgeList.remove(j);
                    break;
                }
                ++i;
            }
            break;
        }
        if (trimEdgeList.size() == 0) {
            return pathList;
        }
        do {
            VertexList vertexList = new VertexList();
            eTem = (Edge)trimEdgeList.remove(0);
            if (eTem.isPoint()) {
                vertexList.add(new Vertex(eTem.startKey()));
            } else {
                vertexList.add(new Vertex(eTem.startKey()));
                vertexList.add(new Vertex(eTem.endKey()));
            }
            while (true) {
                for (int i = 0; i < trimEdgeList.size(); ++i) {
                    Vertex startV = (Vertex)vertexList.get(0);
                    Vertex endV = (Vertex)vertexList.get(vertexList.size() - 1);
                    eTem = (Edge)trimEdgeList.get(i);
                    if (startV.getKey().equals(eTem.startKey())) {
                        if (!eTem.isPoint()) {
                            vertexList.add(0, new Vertex(eTem.endKey()));
                        }
                        trimEdgeList.remove(i);
                        continue;
                    }
                    if (startV.getKey().equals(eTem.endKey())) {
                        if (!eTem.isPoint()) {
                            vertexList.add(0, new Vertex(eTem.startKey()));
                        }
                        trimEdgeList.remove(i);
                        continue;
                    }
                    if (endV.getKey().equals(eTem.startKey())) {
                        if (!eTem.isPoint()) {
                            vertexList.add(new Vertex(eTem.endKey()));
                        }
                        trimEdgeList.remove(i);
                        continue;
                    }
                    if (!endV.getKey().equals(eTem.endKey())) continue;
                    if (!eTem.isPoint()) {
                        vertexList.add(new Vertex(eTem.startKey()));
                    }
                    trimEdgeList.remove(i);
                }
                break;
            }
            try {
                pathList.add(new Path(vertexList));
            }
            catch (GraphLogicalException gLE) {
                // empty catch block
            }
        } while (trimEdgeList.size() > 0);
        return pathList;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        int size = this.vertexList.size();
        strBuf.append("[");
        for (int i = 0; i < size; ++i) {
            strBuf.append(((Vertex)this.vertexList.get(i)).getKey() + " - ");
        }
        strBuf.append("]");
        return strBuf.toString();
    }
}

