/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import jet.universe.JetUJoinPath;
import jet.universe.businesslogic.joinpathtools.JoinPathSetAPI;
import jet.universe.businesslogic.joinpathtools.graph.Edge;
import jet.universe.businesslogic.joinpathtools.graph.EdgeHashMap;
import jet.universe.businesslogic.joinpathtools.graph.EdgeList;
import jet.universe.businesslogic.joinpathtools.graph.Graph;
import jet.universe.businesslogic.joinpathtools.graph.GraphJoinPath;
import jet.universe.businesslogic.joinpathtools.graph.GraphLogicalException;
import jet.universe.businesslogic.joinpathtools.graph.JoinList;
import jet.universe.businesslogic.joinpathtools.graph.JoinPathSet;
import jet.universe.businesslogic.joinpathtools.graph.NoSuchTableException;
import jet.universe.businesslogic.joinpathtools.graph.Path;
import jet.universe.businesslogic.joinpathtools.graph.PathList;
import jet.universe.businesslogic.joinpathtools.graph.TreeList;
import jet.universe.businesslogic.joinpathtools.graph.UserDefinedPathException;
import jet.universe.businesslogic.joinpathtools.graph.Vertex;
import jet.universe.businesslogic.joinpathtools.graph.VertexHashMap;
import jet.universe.businesslogic.joinpathtools.graph.VertexList;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;

public class PathFinder {
    private Graph globalGraph = null;
    private ArrayList userDefinedJoinPaths = new ArrayList(10);
    private JetUJoinPath[] uDJoinPaths = null;
    private ArrayList correlationGraphsInfo = new ArrayList();
    private CacheJoinPath cacheJoinPath = null;
    private Map joinMap = new HashMap();

    private PathFinder() {
    }

    public PathFinder(String[][] graph, String[][][] userDefinedPaths) throws UserDefinedPathException {
        int i;
        EdgeHashMap edgeList = new EdgeHashMap();
        ArrayList vertexes = new ArrayList();
        for (int i2 = 0; i2 < graph.length; ++i2) {
            String start = graph[i2][0];
            String end = graph[i2][1];
            this.addName(vertexes, start);
            this.addName(vertexes, end);
            if (start.equals(end)) continue;
            Edge edge = new Edge(start, end);
            String key1 = edge.getKey();
            String key2 = edge.getKey2();
            Edge existanceEdge = null;
            PsqlJoin join = new PsqlJoin();
            join.name = graph[i2][2];
            existanceEdge = (Edge)edgeList.get(key1);
            if (existanceEdge != null || (existanceEdge = (Edge)edgeList.get(key2)) != null) {
                existanceEdge.addPeerObject(join);
                continue;
            }
            edge.addPeerObject(join);
            edgeList.add(edge);
        }
        String[] tem = new String[vertexes.size()];
        vertexes.toArray(tem);
        VertexHashMap vertexList = new VertexHashMap();
        for (i = 0; i < tem.length; ++i) {
            Vertex vertex = new Vertex(tem[i]);
            vertexList.add(vertex);
        }
        this.globalGraph = new Graph(edgeList, vertexList);
        for (i = 0; i < userDefinedPaths.length; ++i) {
            String[][] joinPath = userDefinedPaths[i];
            UserDefinedJoinPath udjp = new UserDefinedJoinPath(joinPath);
            this.userDefinedJoinPaths.add(udjp);
        }
        this.checkUserDefinedPath(this.globalGraph, this.userDefinedJoinPaths);
    }

    private boolean addName(ArrayList names, String name2) {
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            if (!name2.equals(names.get(i))) continue;
            return false;
        }
        names.add(name2);
        return true;
    }

    public PathFinder(PsqlJoin[] allJoins, PsqlTable[] tables, JetUJoinPath[] joinPaths) throws UserDefinedPathException {
        int i;
        int len = allJoins.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.joinMap.put(allJoins[i2].name, allJoins[i2]);
        }
        EdgeHashMap edgeList = new EdgeHashMap();
        for (int i3 = 0; i3 < allJoins.length; ++i3) {
            String start = allJoins[i3].getTableFrom().getMappingName();
            String end = allJoins[i3].getTableTo().getMappingName();
            Edge edge = new Edge(start, end);
            String key1 = edge.getKey();
            String key2 = edge.getKey2();
            Edge existanceEdge = null;
            existanceEdge = (Edge)edgeList.get(key1);
            if (existanceEdge != null || (existanceEdge = (Edge)edgeList.get(key2)) != null) {
                existanceEdge.addPeerObject(allJoins[i3]);
                continue;
            }
            edge.addPeerObject(allJoins[i3]);
            edgeList.add(edge);
        }
        VertexHashMap vertexList = new VertexHashMap();
        for (i = 0; i < tables.length; ++i) {
            String qName = tables[i].getMappingName();
            Vertex vertex = new Vertex(qName);
            vertexList.add(vertex);
        }
        this.globalGraph = new Graph(edgeList, vertexList);
        this.uDJoinPaths = joinPaths;
        for (i = 0; i < this.uDJoinPaths.length; ++i) {
            UserDefinedJoinPath udjp = new UserDefinedJoinPath(this.uDJoinPaths[i]);
            this.userDefinedJoinPaths.add(udjp);
        }
        this.checkUserDefinedPath(this.globalGraph, this.userDefinedJoinPaths);
    }

    private void initialWorkSpace() {
        this.correlationGraphsInfo.clear();
        int size = this.userDefinedJoinPaths.size();
        for (int i = 0; i < size; ++i) {
            UserDefinedJoinPath tem = (UserDefinedJoinPath)this.userDefinedJoinPaths.get(i);
            tem.setAvailable(true);
            tem.clearCanSolveGroupLoopsIndex();
            tem.clearMutexJoinPaths();
        }
    }

    private GraphJoinPath createGraphJoinPath(CorrelationGraphInfo cGI) {
        GraphJoinPath graphJoinPath = new GraphJoinPath();
        PathList loopPaths = cGI.getGraph().getLoop();
        graphJoinPath.setUsedJoinPathsQualifyName(cGI.getUsedJoinPathsQualifyName());
        EdgeList edges = (EdgeList)cGI.getGraph().getTreeCover(cGI.getCanCoverVertexes()).get(0);
        int size = loopPaths.size();
        for (int i = 0; i < size; ++i) {
            EdgeList tem = ((Path)loopPaths.get(i)).getEdges();
            int size2 = tem.size();
            for (int j = 0; j < size2; ++j) {
                Edge e = (Edge)tem.get(j);
                if (edges.contains(e)) continue;
                edges.add(e);
            }
        }
        graphJoinPath.setJoins(this.takeJoins(edges, graphJoinPath.getUJPQN()));
        return graphJoinPath;
    }

    public JoinPathSetAPI findJoinPaths(String[] joinPathsQualifyName, String[] tablesQualifyName) throws NoSuchTableException, UserDefinedPathException {
        if (joinPathsQualifyName == null) {
            joinPathsQualifyName = new String[]{};
        }
        JoinPathSet joinPathSet = new JoinPathSet();
        if (this.cacheJoinPath != null && this.cacheJoinPath.equalsContext(joinPathsQualifyName, tablesQualifyName)) {
            CorrelationGraphInfo cGI = null;
            int size = this.correlationGraphsInfo.size();
            for (int i = 0; i < size; ++i) {
                cGI = (CorrelationGraphInfo)this.correlationGraphsInfo.get(i);
                joinPathSet.addJoinPath(this.createGraphJoinPath(cGI), cGI.getSectionNum());
            }
            return joinPathSet;
        }
        this.checkCoverTable(this.globalGraph, tablesQualifyName);
        this.checkUserSpecifiedJoinPaths(joinPathsQualifyName);
        this.initialWorkSpace();
        this.setCorrelationGraphInfo(this.getCorrelationGraphs(tablesQualifyName), tablesQualifyName);
        this.setJoinPathsProperty();
        int size = this.correlationGraphsInfo.size();
        for (int i = 0; i < size; ++i) {
            CorrelationGraphInfo cGI = (CorrelationGraphInfo)this.correlationGraphsInfo.get(i);
            EdgeList groupLoop = cGI.getOneUnsovledGroup();
            while (groupLoop != null) {
                String[] joinPaths = this.getJoinPathOptions(groupLoop);
                UserDefinedJoinPath joinPath = null;
                if (joinPaths.length == 0) {
                    joinPath = null;
                } else {
                    block3: for (int j = 0; j < joinPathsQualifyName.length; ++j) {
                        for (int m = 0; m < joinPaths.length; ++m) {
                            if (!joinPathsQualifyName[j].equals(joinPaths[m])) continue;
                            joinPath = this.getJoinPath(joinPaths[m]);
                            break block3;
                        }
                    }
                }
                if (joinPath == null && joinPaths.length > 0) {
                    ArrayList<String> usableJoinPath = new ArrayList<String>();
                    for (int j = 0; j < joinPaths.length; ++j) {
                        if (!this.canAddJoinPath(cGI, this.getJoinPath(joinPaths[j]))) continue;
                        usableJoinPath.add(joinPaths[j]);
                    }
                    joinPaths = new String[usableJoinPath.size()];
                    usableJoinPath.toArray(joinPaths);
                    if (joinPaths.length > 1) {
                        throw new UserDefinedPathException(16);
                    }
                    joinPath = joinPaths.length == 1 ? this.getJoinPath(joinPaths[0]) : null;
                }
                if (joinPath == null) {
                    cGI.addSolvedGroupIndex(cGI.getGroupIndex(groupLoop));
                    cGI.addUnsolvedGroupLoop(groupLoop);
                } else {
                    this.solvedMultiLogics(cGI, joinPath, false);
                }
                groupLoop = cGI.getOneUnsovledGroup();
            }
            joinPathSet.addJoinPath(this.createGraphJoinPath(cGI), cGI.getSectionNum());
        }
        return joinPathSet;
    }

    private JoinList takeJoins(EdgeList edges, String[] usedJoinPathsQN) {
        JoinList tem = new JoinList();
        int edgesSize = edges.size();
        Edge globalE = null;
        Edge e = null;
        EdgeHashMap globalEdges = this.globalGraph.getEdgeList();
        EdgeList joinPathsEdges = new EdgeList();
        for (int i = 0; i < usedJoinPathsQN.length; ++i) {
            EdgeList joinPathEdges = this.getUserDefinedJoinPath(usedJoinPathsQN[i]).getEdgeList();
            int size = joinPathEdges.size();
            int index = -1;
            for (int j = 0; j < size; ++j) {
                e = (Edge)joinPathEdges.get(j);
                index = joinPathsEdges.indexOf(e);
                if (index == -1) {
                    joinPathsEdges.add(e);
                    continue;
                }
                JoinList peerJoins = new JoinList();
                Edge temEdge = new Edge(e.startKey(), e.endKey());
                temEdge.setPeerObjects(peerJoins);
                peerJoins.addAll(((Edge)joinPathsEdges.get(index)).getPeerObjects());
                ArrayList appendJoins = e.getPeerObjects();
                for (int m = 0; m < appendJoins.size(); ++m) {
                    if (peerJoins.contains(appendJoins.get(m))) continue;
                    peerJoins.add(appendJoins.get(m));
                }
                joinPathsEdges.set(index, temEdge);
            }
        }
        for (int j = 0; j < edgesSize; ++j) {
            e = (Edge)edges.get(j);
            int index = -1;
            index = joinPathsEdges.indexOf(e);
            if (index != -1) {
                globalE = (Edge)joinPathsEdges.get(index);
            } else {
                globalE = (Edge)globalEdges.get(e.getKey());
                if (globalE == null) {
                    globalE = (Edge)globalEdges.get(e.getKey2());
                }
            }
            tem.addAll(globalE.getPeerObjects());
        }
        return tem;
    }

    private void solvedMultiLogics(CorrelationGraphInfo cGI, UserDefinedJoinPath joinPath, boolean checkAddTable) throws UserDefinedPathException {
        if (!joinPath.isAvailable()) {
            throw new UserDefinedPathException(17);
        }
        joinPath.use();
        int[] indexes = joinPath.getCanSolveGroupLoopsIndexes();
        EdgeList joinPathEdges = joinPath.getEdgeList();
        cGI.addSolvedGroupIndex(indexes);
        cGI.addUsedJoinPathsQualifyName(joinPath.getQualifyName());
        Graph g = cGI.getGraph();
        for (int i = 0; i < indexes.length; ++i) {
            EdgeList groupEdges = cGI.getGroup(indexes[i]);
            int size2 = groupEdges.size();
            for (int j = 0; j < size2; ++j) {
                Edge e = (Edge)groupEdges.get(j);
                if (joinPathEdges.contains(e)) continue;
                g.removeEdge(e);
            }
        }
        Edge e = (Edge)joinPathEdges.get(0);
        String[] vertexes = new String[]{e.startKey(), e.endKey()};
        try {
            g = g.getConnectedGraph(new Path(vertexes));
        }
        catch (GraphLogicalException e1) {
            // empty catch block
        }
        if (!checkAddTable && g.getCannotCoverVertexes(cGI.getCanCoverVertexes()).length > 0) {
            throw new UserDefinedPathException(18);
        }
        EdgeList[] unsolvedGroups = cGI.getUnsovledGroup();
        for (int i = 0; i < unsolvedGroups.length; ++i) {
            e = (Edge)unsolvedGroups[i].get(0);
            if (g.getEdgeList().containsKey(e.getKey()) || g.getEdgeList().containsKey(e.getKey2())) continue;
            cGI.addSolvedGroupIndex(cGI.getGroupIndex(unsolvedGroups[i]));
        }
        cGI.setGraph(g);
    }

    boolean canAddJoinPath(CorrelationGraphInfo cGI, UserDefinedJoinPath joinPath) {
        int[] indexes = joinPath.getCanSolveGroupLoopsIndexes();
        EdgeList joinPathEdges = joinPath.getEdgeList();
        Graph g = (Graph)cGI.getGraph().clone();
        for (int i = 0; i < indexes.length; ++i) {
            EdgeList groupEdges = cGI.getGroup(indexes[i]);
            int size2 = groupEdges.size();
            for (int j = 0; j < size2; ++j) {
                Edge e = (Edge)groupEdges.get(j);
                if (joinPathEdges.contains(e)) continue;
                g.removeEdge(e);
            }
        }
        Edge e = (Edge)joinPathEdges.get(0);
        String[] vertexes = new String[]{e.startKey(), e.endKey()};
        try {
            g = g.getConnectedGraph(new Path(vertexes));
        }
        catch (GraphLogicalException e1) {
            // empty catch block
        }
        return g.getCannotCoverVertexes(cGI.getCanCoverVertexes()).length <= 0;
    }

    public String[] getCandidateJoinPathsQualifyName(String[] joinPathsQualifyName, String[] tablesQualifyName) throws UserDefinedPathException, NoSuchTableException {
        if (joinPathsQualifyName == null) {
            joinPathsQualifyName = new String[]{};
        }
        this.cacheJoinPath = new CacheJoinPath();
        this.checkCoverTable(this.globalGraph, tablesQualifyName);
        this.checkUserSpecifiedJoinPaths(joinPathsQualifyName);
        this.initialWorkSpace();
        this.setCorrelationGraphInfo(this.getCorrelationGraphs(tablesQualifyName), tablesQualifyName);
        this.setJoinPathsProperty();
        int size = this.correlationGraphsInfo.size();
        for (int i = 0; i < size; ++i) {
            CorrelationGraphInfo cGI = (CorrelationGraphInfo)this.correlationGraphsInfo.get(i);
            EdgeList groupLoop = cGI.getOneUnsovledGroup();
            while (groupLoop != null) {
                String[] joinPaths = this.getJoinPathOptions(groupLoop);
                UserDefinedJoinPath joinPath = null;
                if (joinPaths.length == 0) {
                    joinPath = null;
                } else {
                    block2: for (int j = 0; j < joinPathsQualifyName.length; ++j) {
                        for (int m = 0; m < joinPaths.length; ++m) {
                            if (!joinPathsQualifyName[j].equals(joinPaths[m])) continue;
                            joinPath = this.getJoinPath(joinPaths[m]);
                            break block2;
                        }
                    }
                }
                if (joinPath == null && joinPaths.length > 0) {
                    ArrayList<String> usableJoinPath = new ArrayList<String>();
                    for (int j = 0; j < joinPaths.length; ++j) {
                        if (!this.canAddJoinPath(cGI, this.getJoinPath(joinPaths[j]))) continue;
                        usableJoinPath.add(joinPaths[j]);
                    }
                    joinPaths = new String[usableJoinPath.size()];
                    usableJoinPath.toArray(joinPaths);
                    if (joinPaths.length > 1) {
                        this.cacheJoinPath = null;
                        return joinPaths;
                    }
                    joinPath = joinPaths.length == 1 ? this.getJoinPath(joinPaths[0]) : null;
                }
                if (joinPath == null) {
                    cGI.addSolvedGroupIndex(cGI.getGroupIndex(groupLoop));
                    cGI.addUnsolvedGroupLoop(groupLoop);
                } else {
                    this.solvedMultiLogics(cGI, joinPath, false);
                }
                groupLoop = cGI.getOneUnsovledGroup();
            }
        }
        this.cacheJoinPath.setContext(joinPathsQualifyName, tablesQualifyName);
        return new String[0];
    }

    public String[] getCannotAddTable(String[] joinPathsQualifyName, String[] tablesQualifyName) throws NoSuchTableException, UserDefinedPathException {
        if (joinPathsQualifyName == null) {
            joinPathsQualifyName = new String[]{};
        }
        this.checkCoverTable(this.globalGraph, tablesQualifyName);
        this.checkUserSpecifiedJoinPaths(joinPathsQualifyName);
        this.initialWorkSpace();
        this.setCorrelationGraphInfo(this.getCorrelationGraphs(tablesQualifyName), tablesQualifyName);
        this.setJoinPathsProperty();
        ArrayList<String> cannotAddTables = new ArrayList<String>();
        int size = this.correlationGraphsInfo.size();
        for (int i = 0; i < size; ++i) {
            CorrelationGraphInfo cGI = (CorrelationGraphInfo)this.correlationGraphsInfo.get(i);
            EdgeList groupLoop = cGI.getOneUnsovledGroup();
            while (groupLoop != null) {
                String[] joinPaths = this.getJoinPathOptions(groupLoop);
                UserDefinedJoinPath joinPath = null;
                if (joinPaths.length == 0) {
                    joinPath = null;
                } else {
                    block2: for (int j = 0; j < joinPathsQualifyName.length; ++j) {
                        for (int m = 0; m < joinPaths.length; ++m) {
                            if (!joinPathsQualifyName[j].equals(joinPaths[m])) continue;
                            joinPath = this.getJoinPath(joinPaths[m]);
                            break block2;
                        }
                    }
                }
                if (joinPath == null) {
                    cGI.addSolvedGroupIndex(cGI.getGroupIndex(groupLoop));
                } else {
                    this.solvedMultiLogics(cGI, joinPath, true);
                }
                groupLoop = cGI.getOneUnsovledGroup();
            }
            String[] canCV = cGI.getGraph().getCannotCoverVertexes(cGI.getCanCoverVertexes());
            for (int j = 0; j < canCV.length; ++j) {
                cannotAddTables.add(canCV[j]);
            }
        }
        String[] tem = new String[cannotAddTables.size()];
        cannotAddTables.toArray(tem);
        return tem;
    }

    private void setCorrelationGraphInfo(Graph[] correlationGraphs, String[] vertexes) {
        for (int i = 0; i < correlationGraphs.length; ++i) {
            CorrelationGraphInfo cGI = new CorrelationGraphInfo();
            cGI.setSectionNum(i);
            cGI.setCanCoverVertexes(correlationGraphs[i].getCanCoverVertexes(vertexes));
            cGI.setGraph(correlationGraphs[i]);
            cGI.setGroupLoops(this.groupLoops(correlationGraphs[i]));
            this.correlationGraphsInfo.add(cGI);
        }
    }

    private EdgeList[] groupLoops(Graph g) {
        ArrayList<EdgeList> groups = new ArrayList<EdgeList>(10);
        PathList loops = g.getLoop();
        while (loops.size() > 0) {
            boolean flag;
            EdgeList group = ((Path)loops.remove(0)).getEdges();
            int size = loops.size();
            do {
                flag = false;
                block2: for (int i = 0; i < size; ++i) {
                    EdgeList loop = ((Path)loops.get(i)).getEdges();
                    int size2 = loop.size();
                    for (int j = 0; j < size2; ++j) {
                        if (!group.contains((Edge)loop.get(j))) continue;
                        flag = true;
                        for (int m = 0; m < size2; ++m) {
                            if (group.contains((Edge)loop.get(m))) continue;
                            group.add((Edge)loop.get(m));
                        }
                        loops.remove(i);
                        size = loops.size();
                        --i;
                        continue block2;
                    }
                }
            } while (flag);
            groups.add(group);
        }
        EdgeList[] tem = new EdgeList[groups.size()];
        groups.toArray(tem);
        return tem;
    }

    private String[] getJoinPathOptions(EdgeList loopGroup) {
        ArrayList<String> optionName = new ArrayList<String>();
        ArrayList<UserDefinedJoinPath> optionPaths = new ArrayList<UserDefinedJoinPath>();
        int size = this.userDefinedJoinPaths.size();
        int size2 = loopGroup.size();
        UserDefinedJoinPath minCapabilityP = null;
        UserDefinedJoinPath temP = null;
        block0: for (int i = 0; i < size; ++i) {
            temP = (UserDefinedJoinPath)this.userDefinedJoinPaths.get(i);
            if (!temP.isAvailable()) continue;
            EdgeList joinPath = temP.getEdgeList();
            for (int j = 0; j < size2; ++j) {
                if (joinPath.contains((Edge)loopGroup.get(j)) && (minCapabilityP == null ? (minCapabilityP = temP).getCanSolveGroupLoopsIndexes().length == 1 : minCapabilityP.getCanSolveGroupLoopsIndexes().length > temP.getCanSolveGroupLoopsIndexes().length && (minCapabilityP = temP).getCanSolveGroupLoopsIndexes().length == 1)) break block0;
            }
        }
        if (minCapabilityP == null) {
            return new String[0];
        }
        UserDefinedJoinPath[] temPs = minCapabilityP.getMutexJoinPath();
        optionName.add(minCapabilityP.getQualifyName());
        optionPaths.add(minCapabilityP);
        for (int i = 0; i < temPs.length; ++i) {
            if (!temPs[i].isAvailable()) continue;
            optionName.add(temPs[i].getQualifyName());
            optionPaths.add(temPs[i]);
        }
        Object[] forSort = new UserDefinedJoinPath[optionPaths.size()];
        optionPaths.toArray(forSort);
        Arrays.sort(forSort);
        String[] tem = new String[forSort.length];
        for (int i = 0; i < tem.length; ++i) {
            tem[i] = ((UserDefinedJoinPath)forSort[i]).getQualifyName();
        }
        return tem;
    }

    private String[] getMutexJoinPaths(EdgeList loopGroup) {
        ArrayList<String> mutexName = new ArrayList<String>();
        int size = this.userDefinedJoinPaths.size();
        int size2 = loopGroup.size();
        block0: for (int i = 0; i < size; ++i) {
            UserDefinedJoinPath temP = (UserDefinedJoinPath)this.userDefinedJoinPaths.get(i);
            EdgeList joinPath = temP.getEdgeList();
            for (int j = 0; j < size2; ++j) {
                if (!joinPath.contains((Edge)loopGroup.get(j))) continue;
                mutexName.add(temP.getQualifyName());
                continue block0;
            }
        }
        String[] tem = new String[mutexName.size()];
        mutexName.toArray(tem);
        return tem;
    }

    private void setJoinPathsProperty() {
        int size = this.correlationGraphsInfo.size();
        for (int i = 0; i < size; ++i) {
            EdgeList[] groupLoops = ((CorrelationGraphInfo)this.correlationGraphsInfo.get(i)).getGroupLoops();
            int size2 = groupLoops.length;
            for (int j = 0; j < size2; ++j) {
                UserDefinedJoinPath A;
                int m;
                String[] mutexJoinPaths = this.getMutexJoinPaths(groupLoops[j]);
                for (m = 0; m < mutexJoinPaths.length; ++m) {
                    A = this.getJoinPath(mutexJoinPaths[m]);
                    A.setCorrelationGraphInfo((CorrelationGraphInfo)this.correlationGraphsInfo.get(i));
                    A.addCanSolveGroupLoopsIndex(j);
                }
                for (m = 0; m < mutexJoinPaths.length - 1; ++m) {
                    A = this.getJoinPath(mutexJoinPaths[m]);
                    for (int n = m + 1; n < mutexJoinPaths.length; ++n) {
                        UserDefinedJoinPath B = this.getJoinPath(mutexJoinPaths[n]);
                        A.addMutexJoinPath(B);
                        B.addMutexJoinPath(A);
                    }
                }
            }
        }
    }

    private boolean isContainsJoinPath(String joinPathQualifyName) {
        int size = this.userDefinedJoinPaths.size();
        for (int i = 0; i < size; ++i) {
            if (!((UserDefinedJoinPath)this.userDefinedJoinPaths.get(i)).getQualifyName().equals(joinPathQualifyName)) continue;
            return true;
        }
        return false;
    }

    private UserDefinedJoinPath getJoinPath(String joinPathQualifyName) {
        int size = this.userDefinedJoinPaths.size();
        for (int i = 0; i < size; ++i) {
            if (!((UserDefinedJoinPath)this.userDefinedJoinPaths.get(i)).getQualifyName().equals(joinPathQualifyName)) continue;
            return (UserDefinedJoinPath)this.userDefinedJoinPaths.get(i);
        }
        return null;
    }

    private Graph[] getCorrelationGraphs(String[] vertexes) {
        Graph g = (Graph)this.globalGraph.clone();
        PathList loopPaths = g.getLoop();
        int loopNum = loopPaths.size();
        TreeList coverTrees = g.getTreeCover(vertexes);
        Graph[] corGraphs = new Graph[coverTrees.size()];
        if (loopNum == 0) {
            for (int i = 0; i < corGraphs.length; ++i) {
                try {
                    corGraphs[i] = new Graph(((EdgeList)coverTrees.get(i)).toTwoDimensionArray());
                    continue;
                }
                catch (GraphLogicalException ex) {
                    // empty catch block
                }
            }
            return corGraphs;
        }
        for (int i = 0; i < corGraphs.length; ++i) {
            EdgeList edges = (EdgeList)coverTrees.get(i);
            EdgeList tem = new EdgeList();
            block6: for (int j = 0; j < loopNum; ++j) {
                EdgeList loopEdges = ((Path)loopPaths.get(j)).getEdges();
                int loopEdgeNum = loopEdges.size();
                for (int m = 0; m < loopEdgeNum; ++m) {
                    if (!edges.contains((Edge)loopEdges.get(m))) continue;
                    tem.addAll(loopEdges);
                    continue block6;
                }
            }
            int temSize = tem.size();
            for (int j = 0; j < temSize; ++j) {
                if (edges.contains((Edge)tem.get(j))) continue;
                edges.add((Edge)tem.get(j));
            }
            try {
                corGraphs[i] = new Graph(edges.toTwoDimensionArray());
                continue;
            }
            catch (GraphLogicalException ex) {
                // empty catch block
            }
        }
        return corGraphs;
    }

    public String[][][] getSolvedLoopsGroup() {
        EdgeList[] groups = this.groupLoops(this.globalGraph);
        ArrayList<EdgeList> solvedGroups = new ArrayList<EdgeList>();
        int size = this.userDefinedJoinPaths.size();
        block0: for (int i = 0; i < groups.length; ++i) {
            int size2 = groups[i].size();
            for (int j = 0; j < size2; ++j) {
                Edge e = (Edge)groups[i].get(j);
                for (int m = 0; m < size; ++m) {
                    if (!((UserDefinedJoinPath)this.userDefinedJoinPaths.get(m)).getEdgeList().contains(e)) continue;
                    solvedGroups.add(groups[i]);
                    continue block0;
                }
            }
        }
        EdgeList[] tem = new EdgeList[solvedGroups.size()];
        solvedGroups.toArray(tem);
        String[][][] result = new String[tem.length][][];
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            result[i] = tem[i].toTwoDimensionArray();
        }
        return result;
    }

    public String[][][] getUnsolvedLoopsGroup() {
        EdgeList[] groups = this.groupLoops(this.globalGraph);
        ArrayList<EdgeList> unsolvedGroups = new ArrayList<EdgeList>();
        int size = this.userDefinedJoinPaths.size();
        block0: for (int i = 0; i < groups.length; ++i) {
            int size2 = groups[i].size();
            for (int j = 0; j < size2; ++j) {
                Edge e = (Edge)groups[i].get(j);
                for (int m = 0; m < size; ++m) {
                    if (((UserDefinedJoinPath)this.userDefinedJoinPaths.get(m)).getEdgeList().contains(e)) continue block0;
                }
            }
            unsolvedGroups.add(groups[i]);
        }
        EdgeList[] tem = new EdgeList[unsolvedGroups.size()];
        unsolvedGroups.toArray(tem);
        String[][][] result = new String[tem.length][][];
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            result[i] = tem[i].toTwoDimensionArray();
        }
        return result;
    }

    UserDefinedJoinPath getUserDefinedJoinPath(String joinPathQN) {
        UserDefinedJoinPath joinPath = null;
        int size = this.userDefinedJoinPaths.size();
        for (int i = 0; i < size; ++i) {
            joinPath = (UserDefinedJoinPath)this.userDefinedJoinPaths.get(i);
            if (!joinPathQN.equals(joinPath.getQualifyName())) continue;
            return joinPath;
        }
        return null;
    }

    private void checkCoverTable(Graph graph, String[] coverVertices) throws NoSuchTableException {
        int i;
        VertexHashMap vertexHashMap = graph.getVertexList();
        Hashtable<String, String> temHashtable = new Hashtable<String, String>();
        String[] vertices = null;
        VertexList uncoverVertices = new VertexList();
        int size = coverVertices.length;
        int size2 = 0;
        for (i = 0; i < size; ++i) {
            if (temHashtable.containsKey(coverVertices[i])) continue;
            temHashtable.put(coverVertices[i], coverVertices[i]);
        }
        size2 = temHashtable.size();
        if (size2 != size) {
            Enumeration enumeration = temHashtable.elements();
            int offset = 0;
            vertices = new String[size2];
            while (enumeration.hasMoreElements()) {
                vertices[offset++] = (String)enumeration.nextElement();
            }
            coverVertices = vertices;
            size = coverVertices.length;
        }
        for (i = 0; i < size; ++i) {
            if (vertexHashMap.containsKey(coverVertices[i])) continue;
            uncoverVertices.add(new Vertex(coverVertices[i]));
        }
        if (uncoverVertices.size() > 0) {
            throw new NoSuchTableException(19, new Object[]{uncoverVertices.toString()});
        }
    }

    private void checkUserDefinedPath(Graph graph, ArrayList userDefinedPaths) throws UserDefinedPathException {
        int size = userDefinedPaths.size();
        EdgeHashMap edgeHashMap = graph.getEdgeList();
        StringBuffer notExistenceError = new StringBuffer("\n");
        int notExistenceErrorLength = notExistenceError.length();
        StringBuffer notConnectError = new StringBuffer("\n");
        int notConnectErrorLength = notConnectError.length();
        for (int i = 0; i < size; ++i) {
            EdgeList edgeList = ((UserDefinedJoinPath)userDefinedPaths.get(i)).getEdgeList();
            EdgeList unexistEdge = new EdgeList();
            int size2 = edgeList.size();
            try {
                Graph g = new Graph(edgeList.toTwoDimensionArray());
                if (g.getConnectedGraphNum() > 1) {
                    notConnectError.append("\t");
                    notConnectError.append(edgeList.toString());
                    notConnectError.append("\n");
                }
            }
            catch (GraphLogicalException e) {
                // empty catch block
            }
            for (int j = 0; j < size2; ++j) {
                Edge edge = (Edge)edgeList.get(j);
                Edge edge2 = new Edge(edge.endKey(), edge.startKey());
                if (edgeHashMap.containsKey(edge.getKey()) || edgeHashMap.containsKey(edge2.getKey())) continue;
                unexistEdge.add(edge);
            }
            if (unexistEdge.size() <= 0) continue;
            notExistenceError.append("\t");
            notExistenceError.append(unexistEdge.toString());
            notExistenceError.append(" of user defined path ");
            notExistenceError.append(edgeList.toString() + "\n");
        }
        if (notConnectError.length() > notConnectErrorLength) {
            throw new UserDefinedPathException(20, new Object[]{notConnectError.toString()});
        }
        if (notExistenceErrorLength < notExistenceError.length()) {
            throw new UserDefinedPathException(21, new Object[]{notExistenceError.toString()});
        }
    }

    private void checkUserSpecifiedJoinPaths(String[] joinPathsQualifyName) throws UserDefinedPathException {
        if (joinPathsQualifyName.length == 0) {
            return;
        }
        StringBuffer unexistJoinPaths = new StringBuffer("\n\t");
        int oldLength = unexistJoinPaths.length();
        for (int i = 0; i < joinPathsQualifyName.length; ++i) {
            if (this.isContainsJoinPath(joinPathsQualifyName[i])) continue;
            unexistJoinPaths.append(joinPathsQualifyName[i]);
            unexistJoinPaths.append(", ");
        }
        if (unexistJoinPaths.length() > oldLength) {
            throw new UserDefinedPathException(22, new Object[]{unexistJoinPaths.toString()});
        }
    }

    public String[] getUncontainTables(String[] tablesQualifyName, String[] tables2) {
        ArrayList<String> uncontainTables = new ArrayList<String>();
        block0: for (int i = 0; i < tablesQualifyName.length; ++i) {
            for (int j = 0; j < tables2.length; ++j) {
                if (tables2[j].equals(tablesQualifyName[i])) continue block0;
            }
            uncontainTables.add(tablesQualifyName[i]);
        }
        String[] tem = new String[uncontainTables.size()];
        uncontainTables.toArray(tem);
        return tem;
    }

    private class CorrelationGraphInfo {
        private int sectionNum = 0;
        private String[] canCoverVertexes;
        private Graph g;
        private EdgeList[] groupLoops;
        private ArrayList solvedGroupIndex = new ArrayList(5);
        private ArrayList joinPathsQualifyName = new ArrayList(10);
        private ArrayList unsolvedGroupLoop = new ArrayList(5);

        private CorrelationGraphInfo() {
        }

        public void addUsedJoinPathsQualifyName(String usedJoinPathsQualifyName) {
            this.joinPathsQualifyName.add(usedJoinPathsQualifyName);
        }

        public String[] getUsedJoinPathsQualifyName() {
            String[] tem = new String[this.joinPathsQualifyName.size()];
            this.joinPathsQualifyName.toArray(tem);
            return tem;
        }

        void addSolvedGroupIndex(int[] indexes) {
            for (int i = 0; i < indexes.length; ++i) {
                this.solvedGroupIndex.add(new Integer(indexes[i]));
            }
        }

        void addSolvedGroupIndex(int index) {
            this.solvedGroupIndex.add(new Integer(index));
        }

        EdgeList getOneUnsovledGroup() {
            int size = this.groupLoops.length;
            int size2 = this.solvedGroupIndex.size();
            EdgeList tem = null;
            block0: for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size2; ++j) {
                    if (i == (Integer)this.solvedGroupIndex.get(j)) continue block0;
                }
                tem = this.groupLoops[i];
                break;
            }
            return tem;
        }

        EdgeList[] getUnsovledGroup() {
            int size = this.groupLoops.length;
            int size2 = this.solvedGroupIndex.size();
            ArrayList<EdgeList> unsolved = new ArrayList<EdgeList>();
            block0: for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size2; ++j) {
                    if (i == (Integer)this.solvedGroupIndex.get(j)) continue block0;
                }
                unsolved.add(this.groupLoops[i]);
            }
            EdgeList[] tem = new EdgeList[unsolved.size()];
            unsolved.toArray(tem);
            return tem;
        }

        int getGroupIndex(EdgeList group) {
            for (int i = 0; i < this.groupLoops.length; ++i) {
                if (!this.groupLoops[i].equals(group)) continue;
                return i;
            }
            return -1;
        }

        void setGroupLoops(EdgeList[] groupLoops) {
            this.groupLoops = groupLoops;
        }

        void setSectionNum(int sectionNum) {
            this.sectionNum = sectionNum;
        }

        void setCanCoverVertexes(String[] vertexes) {
            this.canCoverVertexes = vertexes;
        }

        void setGraph(Graph g) {
            this.g = g;
        }

        EdgeList[] getGroupLoops() {
            return this.groupLoops;
        }

        EdgeList getGroup(int index) {
            return this.groupLoops[index];
        }

        int getSectionNum() {
            return this.sectionNum;
        }

        String[] getCanCoverVertexes() {
            return this.canCoverVertexes;
        }

        Graph getGraph() {
            return this.g;
        }

        void addUnsolvedGroupLoop(EdgeList groupLoop) {
            this.unsolvedGroupLoop.add(groupLoop);
        }

        EdgeList[] getUnsolvedGroupLoop() {
            EdgeList[] tem = new EdgeList[this.unsolvedGroupLoop.size()];
            this.unsolvedGroupLoop.toArray(tem);
            return tem;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Sections : " + this.sectionNum + "\n");
            buf.append("Graph :\n");
            buf.append("\t" + this.g);
            return buf.toString();
        }
    }

    private class UserDefinedJoinPath
    implements Comparable {
        private EdgeList edgeList = new EdgeList();
        private String qualifyName = "";
        private boolean available = true;
        private ArrayList mutexGroup = new ArrayList(10);
        private ArrayList canSolveGroupLoopsIndex = new ArrayList(5);
        private CorrelationGraphInfo cGI = null;

        UserDefinedJoinPath(JetUJoinPath joinPath) {
            this.qualifyName = joinPath.getName();
            PsqlJoin[] joins = joinPath.getJoins();
            for (int i = 0; i < joins.length; ++i) {
                Edge newEdge = new Edge(joins[i].getTableFrom().getMappingName(), joins[i].getTableTo().getMappingName());
                newEdge.addPeerObject(joins[i]);
                int index = -1;
                index = this.edgeList.indexOf(newEdge);
                if (index != -1) {
                    Edge tem = (Edge)this.edgeList.get(index);
                    tem.addPeerObject(joins[i]);
                    continue;
                }
                this.edgeList.add(newEdge);
            }
        }

        UserDefinedJoinPath(String[][] joinPath) {
            this.qualifyName = joinPath[0][3];
            for (int i = 0; i < joinPath.length; ++i) {
                Edge newEdge = new Edge(joinPath[i][0], joinPath[i][1]);
                PsqlJoin join = new PsqlJoin();
                join.name = joinPath[i][2];
                int index = -1;
                index = this.edgeList.indexOf(newEdge);
                if (index != -1) {
                    Edge tem = (Edge)this.edgeList.get(index);
                    tem.addPeerObject(join);
                    continue;
                }
                newEdge.addPeerObject(join);
                this.edgeList.add(newEdge);
            }
        }

        void setCorrelationGraphInfo(CorrelationGraphInfo cGI) {
            this.cGI = cGI;
        }

        CorrelationGraphInfo getCorrelationGraphInfo() {
            return this.cGI;
        }

        void addCanSolveGroupLoopsIndex(int index) {
            this.canSolveGroupLoopsIndex.add(new Integer(index));
        }

        int[] getCanSolveGroupLoopsIndexes() {
            int[] tem = new int[this.canSolveGroupLoopsIndex.size()];
            for (int i = 0; i < tem.length; ++i) {
                tem[i] = (Integer)this.canSolveGroupLoopsIndex.get(i);
            }
            return tem;
        }

        void clearCanSolveGroupLoopsIndex() {
            this.canSolveGroupLoopsIndex.clear();
        }

        void clearMutexJoinPaths() {
            this.mutexGroup.clear();
        }

        boolean isAvailable() {
            return this.available;
        }

        void setAvailable(boolean available) {
            this.available = available;
        }

        String getQualifyName() {
            return this.qualifyName;
        }

        EdgeList getEdgeList() {
            return this.edgeList;
        }

        void addMutexJoinPath(UserDefinedJoinPath joinPath) {
            this.mutexGroup.add(joinPath);
        }

        UserDefinedJoinPath[] getMutexJoinPath() {
            UserDefinedJoinPath[] tem = new UserDefinedJoinPath[this.mutexGroup.size()];
            this.mutexGroup.toArray(tem);
            return tem;
        }

        void use() {
            int size = this.mutexGroup.size();
            this.setAvailable(false);
            for (int i = 0; i < size; ++i) {
                ((UserDefinedJoinPath)this.mutexGroup.get(i)).setAvailable(false);
            }
        }

        public int compareTo(Object o) {
            int targetCapability;
            int thisCapability = this.getCanSolveGroupLoopsIndexes().length;
            if (thisCapability == (targetCapability = ((UserDefinedJoinPath)o).getCanSolveGroupLoopsIndexes().length)) {
                return 0;
            }
            if (thisCapability > targetCapability) {
                return -1;
            }
            return 1;
        }
    }

    private class CacheJoinPath {
        private String[] specifiedJoinPaths = new String[0];
        private String[] coverVertexes = new String[0];

        private CacheJoinPath() {
        }

        void setJoinPathsQualifyName(String[] joinPathsQualifyName) {
            this.specifiedJoinPaths = joinPathsQualifyName;
        }

        void setTablesQualifyName(String[] tablesQualifyName) {
            this.coverVertexes = tablesQualifyName;
        }

        void setContext(String[] joinPathsQualifyName, String[] tablesQualifyName) {
            this.specifiedJoinPaths = joinPathsQualifyName;
            this.coverVertexes = tablesQualifyName;
        }

        boolean equalsContext(String[] joinPathsQualifyName, String[] tablesQualifyName) {
            int j;
            int i;
            if (joinPathsQualifyName.length != this.specifiedJoinPaths.length || tablesQualifyName.length != this.coverVertexes.length) {
                return false;
            }
            block0: for (i = 0; i < joinPathsQualifyName.length; ++i) {
                for (j = 0; j < this.specifiedJoinPaths.length; ++j) {
                    if (joinPathsQualifyName[i].equals(this.specifiedJoinPaths[j])) continue block0;
                }
                return false;
            }
            block2: for (i = 0; i < tablesQualifyName.length; ++i) {
                for (j = 0; j < this.coverVertexes.length; ++j) {
                    if (tablesQualifyName[i].equals(this.coverVertexes[j])) continue block2;
                }
                return false;
            }
            return true;
        }
    }
}

