/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.businesslogic.joinpathtools.graph;

import jet.universe.businesslogic.joinpathtools.graph.Child;
import jet.universe.businesslogic.joinpathtools.graph.ChildHashMap;
import jet.universe.businesslogic.joinpathtools.graph.GraphElement;
import jet.universe.businesslogic.joinpathtools.graph.NodeEdgeAdjacency;
import jet.universe.businesslogic.joinpathtools.graph.NodeEdgeAdjacencyHashMap;

public class Vertex
extends GraphElement {
    private String parentKey = "";
    private Vertex parent = null;
    private int color = 0;
    public int descovery = 0;
    public int finish = 0;
    private boolean selected = false;
    public NodeEdgeAdjacencyHashMap adjEdges = new NodeEdgeAdjacencyHashMap();
    private ChildHashMap children = new ChildHashMap();
    private int childCount = 0;
    public String rootKey = "";

    public Vertex(String name2) {
        super(name2);
    }

    public int color() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public Vertex getParent() {
        return this.parent;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public void setParent(Vertex parent) {
        this.parent = parent;
    }

    public void addAdjacentEdge(NodeEdgeAdjacency edge) {
        this.adjEdges.add(edge);
    }

    public void deleteAdjacentEdge(String vertexKey) {
        this.adjEdges.markAsDeleted(vertexKey);
    }

    public void removeAdjacentEdge(String vertexKey) {
        this.adjEdges.remove(vertexKey);
    }

    public String getEdgeKey(String vertexKey) {
        NodeEdgeAdjacency adj = (NodeEdgeAdjacency)this.adjEdges.get(vertexKey);
        return adj.getEdgeKey();
    }

    public int getEdgeCount() {
        return this.adjEdges.size();
    }

    public void addChild(Child child) {
        this.children.add(child);
        ++this.childCount;
    }

    public void deleteChild(String childKey) {
        this.children.markAsDeleted(childKey);
        --this.childCount;
    }

    public int childCount() {
        return this.childCount;
    }

    public void select() {
        this.selected = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String firstChildKey() {
        String childKey2 = null;
        for (String childKey2 : this.children.keySet()) {
            Child child = (Child)this.children.get(childKey2);
            if (child.isDeleted()) continue;
            childKey2 = child.getKey();
            break;
        }
        return childKey2;
    }
}

