/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.DataInputStream;
import java.io.IOException;

class cp_info {
    private int tag;
    int ref0;
    int ref1;
    Object val;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;

    public void load(DataInputStream di) throws IOException {
        this.tag = di.readUnsignedByte();
        switch (this.tag) {
            case 7: 
            case 8: {
                this.ref0 = di.readUnsignedShort();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.ref0 = di.readUnsignedShort();
                this.ref1 = di.readUnsignedShort();
                break;
            }
            case 3: {
                this.val = new Integer(di.readInt());
                break;
            }
            case 4: {
                this.val = new Float(di.readFloat());
                break;
            }
            case 5: {
                this.val = new Long(di.readLong());
                break;
            }
            case 6: {
                this.val = new Double(di.readDouble());
                break;
            }
            case 1: {
                this.val = di.readUTF();
                break;
            }
            default: {
                throw new IOException("bad tag:" + this.tag);
            }
        }
    }

    public int getInt() {
        return (Integer)this.val;
    }

    public long getLong() {
        return (Long)this.val;
    }

    public float getFloat() {
        return ((Float)this.val).floatValue();
    }

    public double getDouble() {
        return (Double)this.val;
    }

    public int getIndex0() {
        return this.ref0;
    }

    public int getIndex1() {
        return this.ref1;
    }

    public String getUTF() {
        return (String)this.val;
    }

    public int getTag() {
        return this.tag;
    }
}

