/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.dsdriver;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.log.JRLogger;
import jet.universe.dsdriver.UDSDriverFormatException;

public class UDSDriver {
    public static final char driverDelimiter = '=';
    public static final String schemeDelimiter = ":/";
    public static final String strParameterDelimiter = ";";
    public static final char pathPrefix = '/';
    public static final String strPackageDelimiter = ".";
    public static final String strJRQueryScheme = "jrquery";
    public static final String strDefaultDriverName = "CatalogQuery";
    String strDriverName;
    String strScheme;
    String strClassName;
    String[] strParams = new String[0];
    boolean bDefaultDriver = false;
    private static JRLogger logger = JRLogger.getLogger(UDSDriver.class.getName());

    public UDSDriver() {
    }

    public UDSDriver(String strDriver) throws UDSDriverFormatException {
        this.setDriver(strDriver);
    }

    public UDSDriver(String strDriverName, String strURL) throws UDSDriverFormatException {
        this.setURL(strURL);
        this.setDriverName(strDriverName);
    }

    public UDSDriver(String strDriverName, String strScheme, String strClassName, String[] strParams) {
        this.setDriverName(strDriverName);
        this.strScheme = strScheme;
        this.strClassName = strClassName;
        this.strParams = strParams;
    }

    protected void parseDriver(String strDriver) throws UDSDriverFormatException {
        int iPos = strDriver.indexOf(61);
        if (iPos < 0) {
            this.strDriverName = "";
            this.setURL(strDriver);
        } else {
            this.strDriverName = strDriver.substring(0, iPos);
            this.setURL(strDriver.substring(iPos + 1, strDriver.length()));
        }
    }

    public String buildDriver() {
        return this.getDriverName() + '=' + this.getURL();
    }

    public void setDriver(String strDriver) throws UDSDriverFormatException {
        if (strDriver.equals(strDefaultDriverName)) {
            this.strDriverName = strDefaultDriverName;
            this.strScheme = strJRQueryScheme;
            this.bDefaultDriver = true;
        } else {
            this.parseDriver(strDriver);
        }
    }

    public String getDriver() {
        if (this.bDefaultDriver) {
            return strDefaultDriverName;
        }
        return this.buildDriver();
    }

    public void setURL(String strURL) throws UDSDriverFormatException {
        this.parseURL(strURL);
    }

    public String getURL() {
        return this.buildURL();
    }

    protected void parseURL(String strURL) throws UDSDriverFormatException {
        int iPos1 = strURL.indexOf(schemeDelimiter);
        if (iPos1 < 0) {
            throw new UDSDriverFormatException(0, "");
        }
        this.strScheme = strURL.substring(0, iPos1);
        String strParamsString = null;
        int iPos2 = strURL.indexOf(strParameterDelimiter, iPos1 + schemeDelimiter.length());
        if (iPos2 < 0) {
            this.strClassName = strURL.substring(iPos1 + schemeDelimiter.length(), strURL.length());
        } else {
            this.strClassName = strURL.substring(iPos1 + schemeDelimiter.length(), iPos2);
            strParamsString = strURL.substring(iPos2 + 1, strURL.length());
        }
        if (this.strClassName == null || this.strClassName.length() == 0) {
            throw new UDSDriverFormatException(2, "");
        }
        if (!UDSDriver.isValidClassName(this.strClassName)) {
            throw new UDSDriverFormatException(1, this.strClassName);
        }
        if (strParamsString != null && strParamsString.length() != 0) {
            this.setParamsString(strParamsString);
        }
    }

    public static boolean isValidClassName(String strClassName) {
        StringTokenizer tokenizer = new StringTokenizer(strClassName, strPackageDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String strId = tokenizer.nextToken();
            if (UDSDriver.isIdentifier(strId)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifier(String strId) {
        int iLength = strId.length();
        char ch = strId.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            return false;
        }
        for (int i = 1; i < iLength; ++i) {
            ch = strId.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return true;
    }

    protected String buildURL() {
        String strRet = "";
        if (this.strScheme != null && this.strScheme.length() != 0) {
            strRet = strRet + this.strScheme;
            if (this.strClassName != null && this.strClassName.length() != 0) {
                strRet = strRet + schemeDelimiter + this.strClassName;
                String strParamsString = this.getParamsString();
                if (strParamsString != null && strParamsString.length() != 0) {
                    strRet = strRet + strParameterDelimiter + strParamsString;
                }
            }
        }
        return strRet;
    }

    public void setDriverName(String strDriverName) {
        assert (strDriverName.indexOf(61) < 0) : "Driver name shouldn't contains equal sign";
        this.strDriverName = strDriverName;
    }

    public String getDriverName() {
        return this.strDriverName;
    }

    public void setScheme(String strScheme) {
        this.strScheme = strScheme;
    }

    public String getScheme() {
        return this.strScheme;
    }

    public void setClassName(String strClassName) {
        this.strClassName = strClassName;
    }

    public String getClassName() {
        return this.strClassName;
    }

    public void setParams(String[] strParams) {
        this.strParams = strParams;
    }

    public String[] getParams() {
        return this.strParams;
    }

    public void setParamsString(String strParamsString) {
        this.parseParamsString(strParamsString);
    }

    public String getParamsString() {
        return this.buildParamsString();
    }

    protected void parseParamsString(String strParamsString) {
        if (strParamsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(strParamsString, strParameterDelimiter);
            Vector<String> vecParams = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                vecParams.addElement(tokenizer.nextToken());
            }
            int iSize = vecParams.size();
            this.strParams = new String[iSize];
            for (int i = 0; i < iSize; ++i) {
                this.strParams[i] = (String)vecParams.elementAt(i);
            }
        }
    }

    protected String buildParamsString() {
        String strParamsString = "";
        int iSize = this.strParams.length;
        for (int i = 0; i < iSize; ++i) {
            strParamsString = strParamsString + this.strParams[i];
            if (i + 1 >= iSize) continue;
            strParamsString = strParamsString + strParameterDelimiter;
        }
        return strParamsString;
    }

    public boolean isDefaultDriver() {
        return this.bDefaultDriver;
    }

    public String toString() {
        String params = "";
        if (this.strParams != null) {
            int iParamCount = this.strParams.length;
            for (int i = 0; i < iParamCount; ++i) {
                params = params + this.strParams[i];
                if (iParamCount + 1 >= iParamCount) continue;
                params = params + strParameterDelimiter;
            }
        }
        return "UDSDriver[DriverName=" + this.strDriverName + "," + "Scheme=" + this.strScheme + "," + "ClassName=" + this.strClassName + "," + "Params=" + params + "]";
    }
}

