/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.dsdriver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import jet.ReportEnv;
import jet.log.JRLogger;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.dsdriver.UDSDriverManagerListener;

public class UDSDriverManager {
    protected static final String strDriverFile = "jrdata.drv";
    protected static boolean bLoad = false;
    protected static Vector vecDrivers = new Vector();
    protected static Vector listeners = new Vector();
    private static JRLogger logger = JRLogger.getLogger(UDSDriverManager.class.getName());

    protected static void Load() {
        File flDriverFile = new File(ReportEnv.binPath, strDriverFile);
        try {
            String driver;
            BufferedReader reader = new BufferedReader(new FileReader(flDriverFile));
            while ((driver = reader.readLine()) != null) {
                try {
                    vecDrivers.addElement(new UDSDriver(driver));
                }
                catch (UDSDriverFormatException uDSDriverFormatException) {}
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void Save() {
        UDSDriverManager.initialize();
        File flDriverFile = new File(ReportEnv.binPath, strDriverFile);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(flDriverFile));
            int iDriverCount = vecDrivers.size();
            for (int i = 0; i < iDriverCount; ++i) {
                UDSDriver dsDriver = (UDSDriver)vecDrivers.elementAt(i);
                if (dsDriver.bDefaultDriver) continue;
                String driver = dsDriver.getDriver();
                writer.write(driver);
                if (i + 1 >= iDriverCount) continue;
                writer.newLine();
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            logger.debug(e);
        }
        catch (IOException e) {
            logger.debug(e);
        }
    }

    protected static void initialize() {
        if (!bLoad) {
            try {
                vecDrivers.addElement(new UDSDriver("CatalogQuery"));
            }
            catch (UDSDriverFormatException e) {
                logger.debug(e);
            }
            UDSDriverManager.Load();
            bLoad = true;
            UDSDriverManager.DriverChanged();
        }
    }

    public static void rollback() {
        vecDrivers.removeAllElements();
        try {
            vecDrivers.addElement(new UDSDriver("CatalogQuery"));
        }
        catch (UDSDriverFormatException e) {
            logger.debug(e);
        }
        UDSDriverManager.Load();
        UDSDriverManager.DriverChanged();
    }

    public static void addDriver(UDSDriver dsDriver) {
        UDSDriverManager.initialize();
        vecDrivers.addElement(dsDriver);
        UDSDriverManager.DriverChanged();
    }

    public static void removeDriver(UDSDriver dsDriver) {
        UDSDriverManager.initialize();
        vecDrivers.removeElement(dsDriver);
        UDSDriverManager.DriverChanged();
    }

    public static UDSDriver removeDriver(String strDriverName) {
        UDSDriverManager.initialize();
        UDSDriver dsDriver = UDSDriverManager.getDriverByName(strDriverName);
        vecDrivers.removeElement(dsDriver);
        UDSDriverManager.DriverChanged();
        return dsDriver;
    }

    public static Vector getDrivers() {
        UDSDriverManager.initialize();
        return vecDrivers;
    }

    public static Vector getDriverStrings() {
        Vector vDriver = UDSDriverManager.getDrivers();
        Vector<String> vecRet = new Vector<String>();
        int iSize = vDriver.size();
        for (int i = 0; i < iSize; ++i) {
            vecRet.addElement(((UDSDriver)vDriver.elementAt(i)).getDriver());
        }
        return vecRet;
    }

    public static Vector getDriversByScheme(String strScheme) {
        UDSDriverManager.initialize();
        Vector<UDSDriver> vecReturn = new Vector<UDSDriver>();
        int iDriverCount = vecDrivers.size();
        for (int i = 0; i < iDriverCount; ++i) {
            UDSDriver dsDriver = (UDSDriver)vecDrivers.elementAt(i);
            if (!strScheme.equalsIgnoreCase(dsDriver.getScheme())) continue;
            vecReturn.addElement(dsDriver);
        }
        return vecReturn;
    }

    public static Vector getDriverStringsByScheme(String strScheme) {
        Vector vDriver = UDSDriverManager.getDriversByScheme(strScheme);
        Vector<String> vecRet = new Vector<String>();
        int iSize = vDriver.size();
        for (int i = 0; i < iSize; ++i) {
            vecRet.addElement(((UDSDriver)vDriver.elementAt(i)).getDriver());
        }
        return vecRet;
    }

    public static Vector getDriverNamesByScheme(String strScheme) {
        Vector vDriver = UDSDriverManager.getDriversByScheme(strScheme);
        Vector<String> vecRet = new Vector<String>();
        int iSize = vDriver.size();
        for (int i = 0; i < iSize; ++i) {
            vecRet.addElement(((UDSDriver)vDriver.elementAt(i)).getDriverName());
        }
        return vecRet;
    }

    public static UDSDriver getDriverByName(String strDriverName) {
        assert (strDriverName != null) : "Illegal arguement";
        UDSDriverManager.initialize();
        int iDriverCount = vecDrivers.size();
        for (int i = 0; i < iDriverCount; ++i) {
            UDSDriver dsDriver = (UDSDriver)vecDrivers.elementAt(i);
            if (!strDriverName.equalsIgnoreCase(dsDriver.getDriverName())) continue;
            return dsDriver;
        }
        return null;
    }

    public static void addDSDriverManagerListener(UDSDriverManagerListener listener) {
        if (!listeners.contains(listener)) {
            listeners.addElement(listener);
        }
    }

    public static void removeDSDriverManagerListener(UDSDriverManagerListener listener) {
        if (listeners.contains(listener)) {
            listeners.removeElement(listener);
        }
    }

    public static void DriverChanged() {
        int iSize = listeners.size();
        for (int i = 0; i < iSize; ++i) {
            ((UDSDriverManagerListener)listeners.elementAt(i)).DriverChanged();
        }
    }
}

