/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.dynamicsecurity;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.acl.JetAcl;
import jet.controls.JetObject;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.transform.ExpressionTransform;
import jet.export.xml.LoadXSDException;
import jet.export.xml.ObjectToXML;
import jet.export.xml.XMLToObject;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.universe.JetUAcl;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.MemberSecurityItem;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.dynamicsecurity.DynamicSecurity;
import jet.universe.dynamicsecurity.DynamicSecurityAclKey;
import jet.universe.dynamicsecurity.DynamicSecurityMlsKey;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DynamicSecurityTool {
    public static final String ROOTTAG = "CatalogDynamicSecurity";
    public static final String DATA_SOURCE_TAG = "Database";
    public static final String CATALOG_NAME_TAG = "CatalogName";
    public static final String DATA_SOURCE_NAME_TAG = "Name";
    public static final String QUERY_NAME_TAG = "QueryName";
    public static final String BUSINESSTYPE_TAG = "BusinessType";
    public static final String BUSINESSNAME_TAG = "BusinessName";
    public static final String BUSINESSCUBE = "BusinessCube";
    public static final String REPORTCUBE = "ReportCube";
    public static final String BUSINESSVIEW = "BusinessView";
    public static final String UNIFIEDBUSINESSVIEW = "UnifiedBusinessView";
    public static final String UACL_TAG = "UAcl";
    public static final String ACL_NAME_TAG = "AclName";
    public static final String ACL_TAG = "ACL";
    public static final String MEMBERSECURITYENTRY = "BVSecurityEntry";
    public static final String ITEM_TAG = "BVACL";
    public static final String GROUP_TAG = "Group";
    public static final String ROLE_TAG = "Role";
    public static final String USER_TAG = "User";
    public static final String BV_GROUP_DISPLAYNAME_TAG = "BVGroupDisplayName";
    public static final String MEMBER_PERMISSION_TAG = "MemeberPermission";
    public static final String ELEMENT_VISIBLE_PERMISSION_TAG = "ElementVisiblePermission";
    public static final String ELEMENT_ACCESS_PERMISSION_TAG = "ElementAccessPermission";
    public static final String ALLOWUNSPECIFIEDMEMBERS_TAG = "AllowUnspecifiedMembers";
    public static final String ALLOWSET_VALUE_EXP_TAG = "AllowValueList";
    public static final String ALLOWSET_LOGIC_EXP_TAG = "AllowExp";
    public static final String DENYSET_VALUE_EXP_TAG = "DenyValueList";
    public static final String DENYSET_LOGIC_EXP_TAG = "DenyExp";
    public static final String DENYFLAG = "Deny";
    public static final String ALLOWFLAG = "Allow";
    public static final String UNKNOWNFLAG = "Unknown";

    public static void saveSecurity(JetUUniverse universe, String SecurityFileName) throws WriteFailureException, LoadXSDException {
        File file = new File(SecurityFileName);
        if (file.exists()) {
            if (file.canWrite()) {
                file.delete();
            } else {
                throw new RuntimeException(SecurityFileName + " already existing!");
            }
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            DynamicSecurityTool.buildDocument(doc, universe);
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            format.setIndent(2);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(SecurityFileName)));
            XMLSerializer serializer = new XMLSerializer(bw, format);
            serializer.serialize(doc);
        }
        catch (IOException exp) {
            throw new RuntimeException("write SecurityFile [" + SecurityFileName + "]  fail!");
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
    }

    private static void buildDocument(Document document, JetUUniverse universe) throws WriteFailureException, LoadXSDException {
        Element root = document.createElement(ROOTTAG);
        document.appendChild(root);
        Element catalogName = document.createElement(CATALOG_NAME_TAG);
        root.appendChild(catalogName);
        catalogName.appendChild(document.createTextNode(universe.getName()));
        Vector children = universe.getChildren();
        for (JetObject child : children) {
            if (!(child instanceof JetUDatabase)) continue;
            JetUDatabase db = (JetUDatabase)child;
            DynamicSecurityTool.buildDataSourceSecurity(document, root, db);
        }
    }

    private static void buildDataSourceSecurity(Document document, Element root, JetUDatabase db) throws WriteFailureException, LoadXSDException {
        String dataSourceName = db.getResourceName();
        Element dataSource = document.createElement(DATA_SOURCE_TAG);
        root.appendChild(dataSource);
        Element dataSourceNameEle = document.createElement(DATA_SOURCE_NAME_TAG);
        dataSource.appendChild(dataSourceNameEle);
        dataSourceNameEle.appendChild(document.createTextNode(dataSourceName));
        Vector acls = db.getAcls();
        for (JetUAcl uacl : acls) {
            JetAcl acl = uacl.getAcl();
            String aclName = acl.getName();
            Element uaclEle = document.createElement(UACL_TAG);
            dataSource.appendChild(uaclEle);
            Element aclNameEle = document.createElement(ACL_NAME_TAG);
            uaclEle.appendChild(aclNameEle);
            aclNameEle.appendChild(document.createTextNode(aclName));
            Document aclEle = ObjectToXML.toDocument(acl, 4);
            Element ele = (Element)aclEle.getFirstChild();
            NamedNodeMap attrs = ele.getAttributes();
            while (attrs != null && attrs.getLength() > 0) {
                ele.removeAttributeNode((Attr)attrs.item(0));
            }
            Node a = document.importNode(ele, true);
            uaclEle.appendChild(a);
        }
        Vector<UnifiedBusinessView> bvs = db.getBvs();
        for (UnifiedBusinessView ubv : bvs) {
            Element memberSecurityEntryEle = DynamicSecurityTool.addMlsEntry(document, "", UNIFIEDBUSINESSVIEW, ubv.getName());
            dataSource.appendChild(memberSecurityEntryEle);
            DynamicSecurityTool.addEntry(document, memberSecurityEntryEle, ubv);
        }
    }

    private static void addEntry(Document document, Element memberSecurityEntryEle, UnifiedBusinessView ubv) throws LoadXSDException, DOMException {
        MemberSecurityEntry memberSecurityEntry = ubv.getMemberSecurityEntry();
        Vector items = memberSecurityEntry.getChildren();
        for (MemberSecurityItem item : items) {
            Element denySetEle;
            Element allowSetEle;
            String dimensionName = item.dimensionName.get();
            BLNode node = ubv.getByDisplayName(dimensionName);
            if (node == null) continue;
            String qdName = dimensionName;
            Element itemEle = document.createElement(ITEM_TAG);
            memberSecurityEntryEle.appendChild(itemEle);
            Element ele = null;
            int type = item.principalType.get();
            if (type == 3) {
                ele = document.createElement(GROUP_TAG);
            } else if (type == 2) {
                ele = document.createElement(ROLE_TAG);
            } else if (type == 1) {
                ele = document.createElement(USER_TAG);
            }
            itemEle.appendChild(ele);
            ele.appendChild(document.createTextNode(item.principalName.get()));
            Element dimNameEle = document.createElement(BV_GROUP_DISPLAYNAME_TAG);
            itemEle.appendChild(dimNameEle);
            dimNameEle.appendChild(document.createTextNode(qdName));
            Element visiblePermissionEle = document.createElement(ELEMENT_VISIBLE_PERMISSION_TAG);
            itemEle.appendChild(visiblePermissionEle);
            String textNode = null;
            textNode = item.permission_visible_deny.get() ? DENYFLAG : (item.permission_visible.get() ? ALLOWFLAG : UNKNOWNFLAG);
            visiblePermissionEle.appendChild(document.createTextNode(textNode));
            Element accessPermissionEle = document.createElement(ELEMENT_ACCESS_PERMISSION_TAG);
            itemEle.appendChild(accessPermissionEle);
            String accessTextNode = null;
            accessTextNode = item.permission_access_deny.get() ? DENYFLAG : (item.permission_access_allow.get() ? ALLOWFLAG : UNKNOWNFLAG);
            accessPermissionEle.appendChild(document.createTextNode(accessTextNode));
            Element memberPermissionEle = document.createElement(MEMBER_PERMISSION_TAG);
            itemEle.appendChild(memberPermissionEle);
            memberPermissionEle.setAttribute(ALLOWUNSPECIFIEDMEMBERS_TAG, item.isAllowUnspecified() ? "True" : "False");
            if (item.allowIExpressionType.get() == 1) {
                allowSetEle = document.createElement(ALLOWSET_VALUE_EXP_TAG);
                itemEle.appendChild(allowSetEle);
                allowSetEle.appendChild(DynamicSecurityTool.expToElement(item.getAllowIExpression(), document, dimensionName));
            } else {
                allowSetEle = document.createElement(ALLOWSET_LOGIC_EXP_TAG);
                itemEle.appendChild(allowSetEle);
                allowSetEle.appendChild(DynamicSecurityTool.expToElement(item.getAllowIExpression(), document, dimensionName));
            }
            if (item.denyIExpressionType.get() == 1) {
                denySetEle = document.createElement(DENYSET_VALUE_EXP_TAG);
                itemEle.appendChild(denySetEle);
                denySetEle.appendChild(DynamicSecurityTool.expToElement(item.getDenyIExpression(), document, dimensionName));
                continue;
            }
            denySetEle = document.createElement(DENYSET_LOGIC_EXP_TAG);
            itemEle.appendChild(denySetEle);
            denySetEle.appendChild(DynamicSecurityTool.expToElement(item.getDenyIExpression(), document, dimensionName));
        }
    }

    private static Node expToElement(IExpression iExpression, Document document, String dimensionName) throws LoadXSDException {
        if (iExpression == null) {
            iExpression = MemberSecurityEntry.BOOLFALSE;
        }
        Document expDoc = ExpressionTransform.expToXml(iExpression, dimensionName, true, true);
        Element ele = (Element)expDoc.getFirstChild();
        Node ret = document.importNode(ele, true);
        return ret;
    }

    private static IExpression elementToExp(Node node, String dimensionName) throws LoadXSDException, ConditionException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
        Document expDoc = builder.newDocument();
        Node expNode = null;
        NodeList expList = ((Element)node).getChildNodes();
        for (int i = 0; i < expList.getLength(); ++i) {
            Node child = expList.item(i);
            if (child.getNodeType() != 1) continue;
            expNode = child;
            break;
        }
        expDoc.appendChild(expDoc.importNode(expNode, true));
        IExpression exp = ExpressionTransform.xmlToExp(expDoc, dimensionName, 1);
        return exp;
    }

    private static Element addMlsEntry(Document document, String queryName, String businessType, String businessName) {
        Element memberSecurityEntryEle = document.createElement(MEMBERSECURITYENTRY);
        Element queryNameEle = document.createElement(QUERY_NAME_TAG);
        memberSecurityEntryEle.appendChild(queryNameEle);
        queryNameEle.appendChild(document.createTextNode(queryName));
        Element businessTypeEle = document.createElement(BUSINESSTYPE_TAG);
        memberSecurityEntryEle.appendChild(businessTypeEle);
        businessTypeEle.appendChild(document.createTextNode(businessType));
        Element businessNameEle = document.createElement(BUSINESSNAME_TAG);
        memberSecurityEntryEle.appendChild(businessNameEle);
        businessNameEle.appendChild(document.createTextNode(businessName));
        return memberSecurityEntryEle;
    }

    public static DynamicSecurity loadDynamicSecurity(File SecurityFile) throws ParserConfigurationException, SAXException, IOException, ReadFailureException, LoadXSDException, ConditionException {
        DynamicSecurity ret = new DynamicSecurity();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(SecurityFile);
        Element root = (Element)doc.getElementsByTagName(ROOTTAG).item(0);
        if (root == null) {
            throw new RuntimeException("Wrong CatalogDynamicSecurity File");
        }
        NodeList dataSourceList = root.getElementsByTagName(DATA_SOURCE_TAG);
        for (int i = 0; i < dataSourceList.getLength(); ++i) {
            Element dataSource = (Element)dataSourceList.item(i);
            String dataSourceName = dataSource.getElementsByTagName(DATA_SOURCE_NAME_TAG).item(0).getTextContent();
            NodeList uaclList = dataSource.getElementsByTagName(UACL_TAG);
            for (int j = 0; j < uaclList.getLength(); ++j) {
                Element uacl = (Element)uaclList.item(j);
                String aclName = uacl.getElementsByTagName(ACL_NAME_TAG).item(0).getTextContent();
                DynamicSecurityAclKey aclKey = new DynamicSecurityAclKey(dataSourceName, aclName);
                Node acl = uacl.getElementsByTagName(ACL_TAG).item(0);
                DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dfactory.newDocumentBuilder();
                Document aclDoc = builder.newDocument();
                aclDoc.appendChild(aclDoc.importNode(acl, true));
                JetAcl jetAcl = (JetAcl)XMLToObject.toObject(aclDoc, 4);
                ret.aclSecurities.put(aclKey, jetAcl);
            }
            NodeList bvSecurityEntryList = dataSource.getElementsByTagName(MEMBERSECURITYENTRY);
            for (int j = 0; j < bvSecurityEntryList.getLength(); ++j) {
                Element bvSecurityEntry = (Element)bvSecurityEntryList.item(j);
                if (bvSecurityEntry == null) continue;
                String queryName = bvSecurityEntry.getElementsByTagName(QUERY_NAME_TAG).item(0).getTextContent();
                String businessTypeStr = bvSecurityEntry.getElementsByTagName(BUSINESSTYPE_TAG).item(0).getTextContent();
                String businessName = bvSecurityEntry.getElementsByTagName(BUSINESSNAME_TAG).item(0).getTextContent();
                int businessType = businessTypeStr.equals(BUSINESSCUBE) ? 1 : (businessTypeStr.equals(REPORTCUBE) ? 1 : 2);
                DynamicSecurityMlsKey key = new DynamicSecurityMlsKey(dataSourceName, queryName, businessType, businessName);
                MemberSecurityEntry value = DynamicSecurityTool.buildMemberSecurityEntry(bvSecurityEntry);
                ret.mlsSecurities.put(key, value);
            }
        }
        return ret;
    }

    private static MemberSecurityEntry buildMemberSecurityEntry(Element bvSecurityEntry) throws LoadXSDException, ConditionException {
        MemberSecurityEntry ret = new MemberSecurityEntry();
        if (bvSecurityEntry != null) {
            NodeList bvaclList = bvSecurityEntry.getElementsByTagName(ITEM_TAG);
            for (int j = 0; j < bvaclList.getLength(); ++j) {
                Node nodeAccessPermission;
                Element bvAcl = (Element)bvaclList.item(j);
                Node groupNode = bvAcl.getElementsByTagName(GROUP_TAG).item(0);
                Node roleNode = bvAcl.getElementsByTagName(ROLE_TAG).item(0);
                Node userNode = bvAcl.getElementsByTagName(USER_TAG).item(0);
                String principalName = null;
                int principalType = 0;
                if (groupNode != null) {
                    principalType = 3;
                    principalName = groupNode.getTextContent();
                } else if (roleNode != null) {
                    principalType = 2;
                    principalName = roleNode.getTextContent();
                } else if (userNode != null) {
                    principalType = 1;
                    principalName = userNode.getTextContent();
                } else {
                    throw new RuntimeException("Wrong CatalogDynamicSecurity File");
                }
                String dimensionName = bvAcl.getElementsByTagName(BV_GROUP_DISPLAYNAME_TAG).item(0).getTextContent();
                MemberSecurityItem msi = new MemberSecurityItem(principalType, principalName, dimensionName);
                Node nodeVisiblePermission = bvAcl.getElementsByTagName(ELEMENT_VISIBLE_PERMISSION_TAG).item(0);
                if (nodeVisiblePermission != null) {
                    String visiblePermissionStr = nodeVisiblePermission.getTextContent();
                    if (DENYFLAG.equals(visiblePermissionStr)) {
                        msi.setPermission_visible_deny(true);
                        msi.setPermission_visible_allow(false);
                    } else if (ALLOWFLAG.equals(visiblePermissionStr)) {
                        msi.setPermission_visible_deny(false);
                        msi.setPermission_visible_allow(true);
                    } else {
                        msi.setPermission_visible_deny(false);
                        msi.setPermission_visible_allow(false);
                    }
                }
                if ((nodeAccessPermission = bvAcl.getElementsByTagName(ELEMENT_ACCESS_PERMISSION_TAG).item(0)) != null) {
                    String accessPermissionStr = nodeAccessPermission.getTextContent();
                    if (DENYFLAG.equals(accessPermissionStr)) {
                        msi.setPermission_access_deny(true);
                        msi.setPermission_access_allow(false);
                    } else if (ALLOWFLAG.equals(accessPermissionStr)) {
                        msi.setPermission_access_deny(false);
                        msi.setPermission_access_allow(true);
                    } else {
                        msi.setPermission_access_deny(false);
                        msi.setPermission_access_allow(false);
                    }
                }
                Element nodeMemberPermission = (Element)bvAcl.getElementsByTagName(MEMBER_PERMISSION_TAG).item(0);
                String allowUnspecifiedMembers = nodeMemberPermission.getAttribute(ALLOWUNSPECIFIEDMEMBERS_TAG);
                boolean allowUsm = "true".equalsIgnoreCase(allowUnspecifiedMembers);
                msi.setAllowUnspecified(allowUsm);
                Node allowValueNode = bvAcl.getElementsByTagName(ALLOWSET_VALUE_EXP_TAG).item(0);
                Node allowExpNode = bvAcl.getElementsByTagName(ALLOWSET_LOGIC_EXP_TAG).item(0);
                boolean allowIsExp = false;
                IExpression allowExp = null;
                if (allowValueNode != null) {
                    allowIsExp = false;
                    allowExp = DynamicSecurityTool.elementToExp(allowValueNode, dimensionName);
                } else if (allowExpNode != null) {
                    allowIsExp = true;
                    allowExp = DynamicSecurityTool.elementToExp(allowExpNode, dimensionName);
                } else {
                    throw new RuntimeException("Wrong CatalogDynamicSecurity File");
                }
                try {
                    msi.setAllowIExpression(allowExp);
                }
                catch (ConditionException e) {
                    throw new RuntimeException("Wrong CatalogDynamicSecurity File");
                }
                if (!allowIsExp) {
                    msi.allowIExpressionType.set(1);
                }
                Node denyValueNode = bvAcl.getElementsByTagName(DENYSET_VALUE_EXP_TAG).item(0);
                Node denyExpNode = bvAcl.getElementsByTagName(DENYSET_LOGIC_EXP_TAG).item(0);
                boolean denyIsExp = false;
                IExpression denyExp = null;
                if (denyValueNode != null) {
                    denyIsExp = false;
                    denyExp = DynamicSecurityTool.elementToExp(denyValueNode, dimensionName);
                } else if (denyExpNode != null) {
                    denyIsExp = true;
                    denyExp = DynamicSecurityTool.elementToExp(denyExpNode, dimensionName);
                } else {
                    throw new RuntimeException("Wrong CatalogDynamicSecurity File");
                }
                try {
                    msi.setDenyIExpression(denyExp);
                }
                catch (ConditionException e) {
                    // empty catch block
                }
                if (!denyIsExp) {
                    msi.denyIExpressionType.set(1);
                }
                ret.addSecurityItem(msi);
            }
        }
        return ret;
    }
}

