/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import java.util.Vector;
import jet.datasource.InputStreamFactory;
import jet.universe.engine.UFakeHDSColumn;
import jet.universe.engine.UFakeTable;
import jet.util.Containable;

public class UFakeHDSTable
extends UFakeTable
implements Containable {
    Vector tables = new Vector();
    UFakeHDSTable parent;
    String uri;
    boolean isAttrib = false;
    private InputStreamFactory streamFactory;

    public UFakeHDSTable(String name2) {
        super(name2);
    }

    public UFakeHDSTable(String name2, UFakeHDSTable parent) {
        super(name2);
        this.parent = parent;
        if (this.parent != null) {
            this.parent.tables.addElement(this);
        }
    }

    void appendTable(UFakeHDSTable table) {
        this.tables.addElement(table);
    }

    void appendTable(String name2) {
        this.tables.addElement(new UFakeHDSTable(name2, this));
    }

    public void appendColumn(String name2, String fullName, boolean isFldInWhere, int sqlType, String format, boolean array, boolean attribute, int colIndex) {
        this.cols.addElement(new UFakeHDSColumn(name2, fullName, isFldInWhere, sqlType, format, array, attribute, colIndex));
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    public String getTableName() {
        return this.getFullName().substring(this.getFullName().lastIndexOf(".") + 1);
    }

    public Vector getCols() {
        return this.cols;
    }

    public Vector getTabs() {
        return this.tables;
    }

    public UFakeHDSTable findTableByName(String name2) {
        Vector tabls = this.getTabs();
        UFakeHDSTable tbl = null;
        for (int i = 0; i < tabls.size(); ++i) {
            tbl = (UFakeHDSTable)tabls.elementAt(i);
            int idx = name2.indexOf(".");
            if (idx > -1) {
                String subName = name2.substring(0, idx);
                if (!tbl.getTableName().equalsIgnoreCase(subName)) continue;
                tbl = tbl.findTableByName(name2.substring(idx + 1));
                return tbl;
            }
            if (!tbl.getTableName().equalsIgnoreCase(name2)) continue;
            return tbl;
        }
        return null;
    }

    @Override
    public Vector getChildren() {
        Vector ret = (Vector)this.cols.clone();
        ret.addAll(this.tables);
        return ret;
    }

    public void setAttrib(boolean isAttrib) {
        this.isAttrib = isAttrib;
    }

    public boolean getAttrib() {
        return this.isAttrib;
    }

    public Vector getAllCols() {
        int i;
        Vector ret = new Vector();
        ret.addAll(this.cols);
        int iSize = this.tables.size();
        for (i = 0; i < iSize; ++i) {
            UFakeHDSTable tab = (UFakeHDSTable)this.tables.elementAt(i);
            if (!this.isAttrib && !tab.isAttrib) continue;
            ret.addAll(tab.getAllCols(true));
        }
        iSize = ret.size();
        if (iSize > this.cols.size()) {
            for (i = 0; i < iSize; ++i) {
                ((UFakeHDSColumn)ret.elementAt((int)i)).colIndex = i + 1;
            }
        }
        return ret;
    }

    private Vector getAllCols(boolean isAttrib) {
        Vector ret = new Vector();
        ret.addAll(this.cols);
        int iSize = this.tables.size();
        for (int i = 0; i < iSize; ++i) {
            UFakeHDSTable tab = (UFakeHDSTable)this.tables.elementAt(i);
            if (!isAttrib && !this.isAttrib && !tab.isAttrib) continue;
            ret.addAll(tab.getAllCols(true));
        }
        return ret;
    }

    public Vector getRealTabs() {
        Vector<UFakeHDSTable> ret = new Vector<UFakeHDSTable>();
        int iSize = this.tables.size();
        for (int i = 0; i < iSize; ++i) {
            UFakeHDSTable tab = (UFakeHDSTable)this.tables.elementAt(i);
            if (tab.isAttrib) continue;
            ret.addElement(tab);
        }
        return ret;
    }

    public InputStreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }
}

