/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.connect.DbQuery;
import jet.dataengine.api.DSException;
import jet.dataengine.util.StringTools;
import jet.datasource.JRColDesc;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.universe.JetUDBField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUParameter;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUUniverse;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import toolkit.db.gui.JdbcDatabase;

public class UFileQueryEngine
extends UQueryEngine {
    protected JetUFileQuery uFileQuery;
    protected FileQuery fileQuery;
    protected Hashtable htPsqlParamPair = null;
    private static JRLogger logger = JRLogger.getLogger(UFileQueryEngine.class.getName());

    public UFileQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
    }

    public UFileQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, null);
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uFileQuery = (JetUFileQuery)this.unvs.getQueriableByResourceName(dataSourceName, strQueryName);
        this.fileQuery = this.uFileQuery.getFileQuery().getCopy();
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (!(dbfld instanceof JetUFileQueryField)) {
                throw new FldNotFoundInQuery(this.strQueryName, (String)key);
            }
            if (((JetUFileQueryField)dbfld).getFileQuery().isSimilar(this.uFileQuery)) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    void initParamNamesInQry() {
        this.putParamInFileQueryToBuf(true);
    }

    @Override
    protected void initQuery() {
        this.putParamInFileQueryToBuf();
    }

    protected void putParamInFileQueryToBuf() {
        this.putParamInFileQueryToBuf(false);
    }

    protected void putParamInFileQueryToBuf(boolean cache) {
        this.fileQuery.parseStatement(this.unvs, this.dataSourceName, this.jCnnt, this.rptUserName);
        this.htPsqlParamPair = this.fileQuery.getParameterValuePairs();
        int iParamCount = this.htPsqlParamPair.size();
        String paramName = null;
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            paramName = uParam.getResourceNameInUpperCase();
            if (cache) {
                this.paramNames.add(paramName);
                continue;
            }
            this.putParameter(paramName, uParam);
        }
    }

    protected void putParamToFileQueryBuf() {
        this.htPsqlParamPair = this.fileQuery.getParameterValuePairs();
        int iParamCount = this.htPsqlParamPair.size();
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            ParamDesc rptParameter = (ParamDesc)this.paramsBuff.get(uParam.getResourceNameInUpperCase());
            this.htPsqlParamPair.put(uParam, rptParameter);
        }
    }

    @Override
    protected void createDbQuery() throws FldNotFoundInQuery {
        JdbcDatabase jdbcDatabase = this.createJdbcDatabase(this.uFileQuery.getTransactionIsolation(), this.uFileQuery.getReadOnly());
        JetUSupportInfo suppInfo = this.getSupportInfo();
        this.dbQuery = new DbQuery(jdbcDatabase, suppInfo.getExtraNameChar(), suppInfo.getQuoteChar(), suppInfo.getExtraKeywords());
        this.dbQuery.setJdbcDriversConfig(this.jdbcDriversConfig);
        this.dbQuery.setFileQueryId();
        this.setFileQueryStatement();
    }

    protected void setFileQueryStatement() {
        this.putParamToFileQueryBuf();
        this.dbQuery.setSqlStatement(this.fileQuery.getResolvedStatement(this.unvs, this.dataSourceName, this.jCnnt, this.rptUserName, true, this.getJavaFormula()));
        this.dbQuery.setRawSqlStatement(this.fileQuery.getStatement());
        if (logger.isDebugEnabled()) {
            logger.debug("Trace info, Qualifier is: " + this.fileQuery.getQualifier());
        }
        if (!StringTools.isEmptyStringWithTrim(this.fileQuery.getQualifier())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Trace info, Qualifier is not empty " + this.fileQuery.getQualifier());
            }
            this.dbQuery.setDbCatalogName(this.fileQuery.getQualifier());
        }
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        super.updateSubLink(theSubLinks);
        if (!this.paramLinks.isEmpty()) {
            this.setFileQueryStatement();
        }
    }

    @Override
    protected void prepareBuffers() {
        if (this.dbQuery != null) {
            JetUDBField dbfld;
            Vector vecFileQueryFields = this.uFileQuery.getFields();
            int iTotalCol = vecFileQueryFields.size();
            int idbFieldIndex = 1;
            this.vecDbFields = new Vector(this.htDbFields.size() + 1);
            this.aiDbFieldsBackIndex = new int[iTotalCol + 1];
            for (int i = 1; i < iTotalCol + 1; ++i) {
                this.aiDbFieldsBackIndex[i] = -1;
            }
            Enumeration e = this.htDbFields.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                dbfld = (JetUDBField)this.htDbFields.get(key);
                int iColIndex = ((JetUFileQueryField)dbfld).getColIndex();
                this.vecDbFields.addElement(key);
                this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
            }
            if (this.htDbFieldsInLocalWhere != null) {
                int idbFieldIndexInLocalWhere = 1;
                this.vecDbFieldsInLocalWhere = new Vector(this.htDbFieldsInLocalWhere.size() + 1);
                this.aiDbFieldsInLocalWhereBackIndex = new int[iTotalCol + 1];
                for (int i = 1; i < iTotalCol + 1; ++i) {
                    this.aiDbFieldsInLocalWhereBackIndex[i] = -1;
                }
                Enumeration e2 = this.htDbFieldsInLocalWhere.keys();
                while (e2.hasMoreElements()) {
                    Object key = e2.nextElement();
                    dbfld = (JetUDBField)this.htDbFieldsInLocalWhere.get(key);
                    int iColIndexInLocalWhere = ((JetUFileQueryField)dbfld).getColIndex();
                    this.vecDbFieldsInLocalWhere.addElement(key);
                    this.aiDbFieldsInLocalWhereBackIndex[iColIndexInLocalWhere] = idbFieldIndexInLocalWhere++;
                }
            }
        }
        this.vecFormulas = this.fmlsContainer.getFormulas();
    }

    @Override
    public boolean supportServerSubLink() {
        return false;
    }

    @Override
    public boolean supportOrderBy() {
        return false;
    }

    @Override
    public void setOrderBy(Vector mapFlds, Vector sorts) {
    }

    @Override
    public JRColDesc[] getColDescs() {
        Vector vecFileQueryFields = this.uFileQuery.getFields();
        int iTotalCol = vecFileQueryFields.size();
        JetUFileQueryField fqField = null;
        JRColDesc[] ColDescs = new JRColDesc[iTotalCol + 1];
        for (int i = 0; i < iTotalCol; ++i) {
            fqField = (JetUFileQueryField)vecFileQueryFields.elementAt(i);
            int iColIndex = fqField.getColIndex();
            DbColDesc coldesc = fqField.getColDesc();
            String strFieldName = fqField.getResourceName();
            ColDescs[iColIndex] = new JRColDesc(strFieldName, coldesc.getSqlType(), coldesc.getPrecision(), coldesc.getScale(), coldesc.getNullable());
        }
        return ColDescs;
    }

    @Override
    protected Vector getTotalCols() {
        return this.uFileQuery.getFields();
    }

    @Override
    protected void setUserDefinedSqlString() {
    }
}

