/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.bean.EngSInfo;
import jet.connect.RecordFilter;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.datasource.JRColDesc;
import jet.datasource.JRHierarchicalDataSource;
import jet.datasource.JRHierarchicalDataset;
import jet.datasource.JRResultSetException;
import jet.datasource.JRSecurityHierarchicalDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUHDSField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.engine.UFakeHDSTable;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.HDSNameFinder;
import jet.universe.psql.HDSWhereParser;
import jet.universe.psql.RptPsqlQuery;
import jet.util.StringTools;
import jet.util.URIParameterResolver;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.sql.CritNode;

public class UHDSEngine
extends UQueryEngine {
    protected JetUHierDataSource uHDS;
    JRHierarchicalDataSource hDataSource = null;
    String strResolvedParameter = null;
    Hashtable htParameters = new Hashtable();
    Hashtable cols = new Hashtable();
    UFakeHDSTable root = null;
    protected Hashtable fmlWhere;
    private URIParameterResolver uriResolver;
    private List columnSequence;
    private EngSInfo engsinfo = null;
    boolean isRelease = false;
    Vector vBreakBranch = null;

    public UHDSEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLink, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLink, bUseResultFile);
        this.bUseUserDataSource = true;
        this.uriResolver = new URIParameterResolver();
        this.columnSequence = mappingFlds;
    }

    public void setInstance(EngSInfo engsinfo) {
        this.engsinfo = engsinfo;
    }

    public EngSInfo getInstance() {
        return this.engsinfo;
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uHDS = (JetUHierDataSource)this.unvs.getQueriableByResourceName(dataSourceName, strQueryName);
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (!(dbfld instanceof JetUHDSField)) {
                throw new FldNotFoundInQuery(this.strQueryName, (String)key);
            }
            if (((JetUHDSField)dbfld).getHDS() == this.uHDS) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        super.updateSubLink(theSubLinks);
        if (!this.paramLinks.isEmpty()) {
            this.putParameterToDataSource();
        }
    }

    private void createDatasource() throws LoadUserDataSourceException {
        String strClassName = this.uHDS.getClassName();
        try {
            Class<?> clsHDS = Class.forName(strClassName);
            this.hDataSource = (JRHierarchicalDataSource)clsHDS.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new LoadUserDataSourceException(1, strClassName);
        }
        catch (InstantiationException e) {
            throw new LoadUserDataSourceException(2, strClassName);
        }
        catch (IllegalAccessException e) {
            throw new LoadUserDataSourceException(3, strClassName);
        }
    }

    @Override
    void initParamNamesInQry() {
    }

    @Override
    protected void initQuery() throws LoadUserDataSourceException {
        if (this.hDataSource == null) {
            this.createDatasource();
        }
        try {
            this.putParamInHDSToBuf();
        }
        catch (JRUserDataSourceException e) {
            throw new LoadUserDataSourceException(3, "Can not load the parameter to a Properties object.");
        }
    }

    protected void putParamInHDSToBuf() throws JRUserDataSourceException {
        StringBuffer strBuf = new StringBuffer(this.uHDS.getParameter());
        String strParamName = null;
        while ((strParamName = DbTools.getFirstParameterNameInString(strBuf, new StringBuffer())) != null) {
            this.putParamToBuf(strParamName);
        }
        this.uriResolver.setURI(this.uHDS.getURI());
        Vector paramNames = this.uriResolver.getParameterNames();
        for (int i = 0; i < paramNames.size(); ++i) {
            String pName = (String)paramNames.elementAt(i);
            this.putParamToBuf(pName);
        }
        Vector vParams = this.uHDS.getParams();
        if (vParams != null) {
            int size = vParams.size();
            for (int i = 0; i < size; ++i) {
                this.putParamToBuf((String)vParams.elementAt(i));
            }
        }
    }

    protected void putParamToBuf(String strParamName) {
        JetUDatabase udb = this.unvs.getDatabase(this.dataSourceName);
        JetUResourceEntity re = udb.getResourceByName(strParamName);
        if (re != null && re instanceof JetUParameter) {
            JetUParameter up = (JetUParameter)re;
            ParamDesc parameter = up.getParamDesc();
            parameter.setBeColumn(0);
            this.paramsBuff.put(strParamName.toUpperCase(), parameter);
        }
    }

    protected void putParameterToDataSource() {
        StringBuffer retStr = new StringBuffer();
        StringBuffer strBuf = new StringBuffer(this.uHDS.getParameter());
        StringBuffer strBefore = new StringBuffer();
        String strParamName = null;
        while ((strParamName = DbTools.getFirstParameterNameInString(strBuf, strBefore)) != null) {
            ParamDesc rp2 = (ParamDesc)this.paramsBuff.get(strParamName.toUpperCase());
            if (rp2 != null) {
                retStr.append(strBefore);
                retStr.append(rp2.getValue().toString());
                continue;
            }
            int spec = DbTools.isSpecialField(strParamName);
            switch (spec) {
                case 0: {
                    retStr.append(strBefore);
                    retStr.append(this.rptUserName == null ? "" : this.rptUserName);
                }
            }
        }
        retStr.append(strBefore);
        this.strResolvedParameter = retStr.toString();
    }

    @Override
    protected void createDbQuery() throws JRUserDataSourceException, LoadUserDataSourceException, JRResultSetException {
        UFakeHDSTable parentTable;
        UFakeHDSTable fakeTable;
        String branchName;
        String colName;
        String tabName;
        JetUHDSField dbfld;
        Object key;
        this.putParameterToDataSource();
        Hashtable<String, UFakeHDSTable> fakeTables = new Hashtable<String, UFakeHDSTable>();
        boolean isStrucAttrib = false;
        boolean first = true;
        int size = this.columnSequence.size();
        for (int i = 0; i < size; ++i) {
            key = this.columnSequence.get(i);
            dbfld = (JetUHDSField)this.htDbFields.get(key);
            if (dbfld == null) continue;
            tabName = ((JetUHDSTable)dbfld.getParent()).getFullName();
            JetUHDSTable colTable = (JetUHDSTable)dbfld.getParent();
            colName = dbfld.getFullName();
            StringTokenizer tok = new StringTokenizer(tabName, ".");
            branchName = "";
            fakeTable = (UFakeHDSTable)fakeTables.get(tabName);
            if (fakeTable == null) {
                first = true;
                while (tok.hasMoreTokens()) {
                    JetUHDSTable cur;
                    parentTable = (UFakeHDSTable)fakeTables.get(branchName);
                    if (first) {
                        branchName = branchName + tok.nextToken();
                        first = false;
                    } else {
                        branchName = branchName + "." + tok.nextToken();
                    }
                    if ((fakeTable = (UFakeHDSTable)fakeTables.get(branchName)) != null) continue;
                    fakeTable = new UFakeHDSTable(branchName, parentTable);
                    fakeTables.put(branchName, fakeTable);
                    for (cur = colTable; cur != null && !cur.getFullName().equals(branchName); cur = (JetUHDSTable)cur.getParent()) {
                    }
                    if (cur != null) {
                        fakeTable.setAttrib(cur.isAttrib());
                    }
                    if (parentTable != null) continue;
                    this.root = fakeTable;
                    String uri = this.uriResolver.resolve(this.paramsBuff);
                    uri = this.getFinalURI(uri);
                    this.root.setURI(uri);
                }
            }
            fakeTable.appendColumn((String)key, colName, false, dbfld.getSqlType(), dbfld.getFormat(), dbfld.isArray(), dbfld.isAttribute(), fakeTable.getCols().size() + 1);
        }
        if (this.htDbFieldsInLocalWhere != null) {
            Enumeration e = this.htDbFieldsInLocalWhere.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                dbfld = (JetUHDSField)this.htDbFieldsInLocalWhere.get(key);
                tabName = ((JetUHDSTable)dbfld.getParent()).getFullName();
                isStrucAttrib = ((JetUHDSTable)dbfld.getParent()).isAttrib();
                colName = dbfld.getFullName();
                StringTokenizer tok = new StringTokenizer(tabName, ".");
                branchName = "";
                fakeTable = (UFakeHDSTable)fakeTables.get(tabName);
                if (fakeTable == null) {
                    first = true;
                    while (tok.hasMoreTokens()) {
                        parentTable = (UFakeHDSTable)fakeTables.get(branchName);
                        if (first) {
                            branchName = branchName + tok.nextToken();
                            first = false;
                        } else {
                            branchName = branchName + "." + tok.nextToken();
                        }
                        if ((fakeTable = (UFakeHDSTable)fakeTables.get(branchName)) != null) continue;
                        fakeTable = new UFakeHDSTable(branchName, parentTable);
                        fakeTables.put(branchName, fakeTable);
                        if (parentTable != null) continue;
                        this.root = fakeTable;
                        String uri = this.uriResolver.resolve(this.paramsBuff);
                        uri = this.getFinalURI(uri);
                        this.root.setURI(uri);
                    }
                }
                fakeTable.setAttrib(isStrucAttrib);
                fakeTable.appendColumn((String)key, colName, true, dbfld.getSqlType(), dbfld.getFormat(), dbfld.isArray(), dbfld.isAttribute(), fakeTable.getCols().size() + 1);
            }
        }
    }

    private String getFinalURI(String uri) {
        String path;
        String string = path = uri != null ? uri : null;
        if (!(path == null || path.indexOf(File.separator) > -1 || path.indexOf("/") > -1 || path.startsWith("file:") || path.startsWith("http:") || path.startsWith("https:") || path.startsWith("ftp:") || !path.endsWith(".xml"))) {
            path = this.unvs.getFilePath() + path;
        }
        return path;
    }

    @Override
    public JRColDesc[] getColDescs() {
        return null;
    }

    @Override
    public boolean haveLocalWhere() {
        return !this.localLinks.isEmpty() || this.fmlWhere != null;
    }

    @Override
    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError, DSException, ParseFormulaFailedException {
        super.putFormulasInLocalWhereToBuffer();
        if (this.fmlWhere != null) {
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                JetUWhereFormula temp = (JetUWhereFormula)this.fmlWhere.get(name2);
                if (!temp.isParsedOK()) {
                    throw new QueryWhereFormulaGrammarError(temp.getResourceName());
                }
                this.fmlsInLocalWhere.putFormula(temp.getResourceName(), temp);
            }
        }
    }

    @Override
    public ResultSet getResultSet() {
        return null;
    }

    public JRHierarchicalDataset getHierarchicalDataset() throws JRUserDataSourceException {
        String sParamHDS = this.strResolvedParameter;
        JRHierarchicalDataset hdata = null;
        this.isRelease = false;
        this.hDataSource.setUsedFields(this.root);
        hdata = this.hDataSource instanceof JRSecurityHierarchicalDataSource && this.secCxt != null ? ((JRSecurityHierarchicalDataSource)this.hDataSource).getHierarchicalDataset(this.secCxt, sParamHDS) : this.hDataSource.getHierarchicalDataset(sParamHDS);
        return hdata;
    }

    @Override
    protected void purifyFldsInLocalWhereCon() throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Enumeration e = this.htDbFieldsInLocalWhere.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JetUHDSField dbfld = (JetUHDSField)this.htDbFieldsInLocalWhere.get(key);
            String tabName = ((JetUHDSTable)dbfld.getParent()).getFullName();
            String colName = dbfld.getFullName();
            if (this.vBreakBranch == null) {
                this.vBreakBranch = new Vector();
                this.vBreakBranch.addElement(tabName);
            } else {
                int iS = this.vBreakBranch.size();
                boolean find = false;
                for (int i = 0; i < iS; ++i) {
                    int lcur;
                    int lsmall;
                    String item = (String)this.vBreakBranch.elementAt(i);
                    int litem = item.length();
                    int n = lsmall = litem > (lcur = tabName.length()) ? lcur : litem;
                    if (!item.substring(0, lsmall).equals(tabName.substring(0, lsmall))) continue;
                    if (lcur > lsmall) {
                        this.vBreakBranch.setElementAt(tabName, i);
                    }
                    find = true;
                    break;
                }
                if (!find) {
                    this.vBreakBranch.addElement(tabName);
                }
            }
            if (!this.htDbFields.containsKey(key)) continue;
            this.htDbFieldsInLocalWhere.remove(key);
        }
    }

    @Override
    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid {
    }

    @Override
    public void end() throws SQLException {
        if (!this.isRelease) {
            this.hDataSource.releaseHierarchicalDataset();
            this.isRelease = true;
        }
    }

    @Override
    public boolean supportServerSubLink() {
        return false;
    }

    @Override
    public boolean supportOrderBy() {
        return false;
    }

    @Override
    public Vector getTotalCols() {
        return null;
    }

    public UFakeHDSTable getRoot() {
        return this.root;
    }

    @Override
    protected void setUserDefinedSqlString() {
    }

    public JetUHierDataSource getDataSource() {
        return this.uHDS;
    }

    @Override
    protected void prepareBuffers() throws DSException, ParseFormulaFailedException {
        super.prepareBuffers();
        if (this.fmlWhere != null) {
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                JetUWhereFormula temp = (JetUWhereFormula)this.fmlWhere.get(name2);
                this.fmlsContainer.setFormulaWhere(temp.getResourceName(), temp);
            }
        }
    }

    public void setFormulaWhere(Hashtable fmlWhereNames) {
        if (fmlWhereNames != null) {
            if (fmlWhereNames.size() < 1) {
                return;
            }
            this.fmlWhere = new Hashtable();
            Enumeration e = fmlWhereNames.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                String branch = (String)fmlWhereNames.get(name2);
                this.fmlWhere.put(branch, this.uHDS.getWhereFormula(name2));
            }
        }
    }

    public Vector getBreakBranch() {
        return this.vBreakBranch;
    }

    @Override
    public String getFormulaWhere() {
        String ret = null;
        if (this.fmlWhere != null) {
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                if (ret == null) {
                    ret = ((JetUWhereFormula)this.fmlWhere.get(name2)).getResourceName();
                    continue;
                }
                ret = ret + " ; " + ((JetUWhereFormula)this.fmlWhere.get(name2)).getResourceName();
            }
        }
        return ret;
    }

    public String getFormulaWhere(String name2) {
        if (this.fmlWhere != null) {
            return ((JetUWhereFormula)this.fmlWhere.get(name2)).getResourceName();
        }
        return null;
    }

    public String[] getFormulaWheres() {
        String[] ret = null;
        if (this.fmlWhere != null) {
            int iSize = this.fmlWhere.size();
            if (iSize < 1) {
                return null;
            }
            ret = new String[iSize];
            iSize = 0;
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                ret[iSize++] = ((JetUWhereFormula)this.fmlWhere.get(name2)).getResourceName();
            }
        }
        return ret;
    }

    public JetRptFormula getRptFormulaWhere() {
        Enumeration e;
        if (this.fmlWhere != null && (e = this.fmlWhere.keys()).hasMoreElements()) {
            String name2 = (String)e.nextElement();
            return ((JetUWhereFormula)this.fmlWhere.get(name2)).createNewJetRptFmlInstance();
        }
        return null;
    }

    public JetRptFormula getRptFormulaWhere(String name2) {
        if (this.fmlWhere != null) {
            return ((JetUWhereFormula)this.fmlWhere.get(name2)).createNewJetRptFmlInstance();
        }
        return null;
    }

    public JetRptFormula[] getRptFormulaWheres() {
        JetRptFormula[] ret = null;
        if (this.fmlWhere != null) {
            int iSize = this.fmlWhere.size();
            if (iSize < 1) {
                return null;
            }
            ret = new JetRptFormula[iSize];
            iSize = 0;
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                ret[iSize++] = ((JetUWhereFormula)this.fmlWhere.get(name2)).createNewJetRptFmlInstance();
            }
        }
        return ret;
    }

    public Hashtable getRptFormulaWheres_h() {
        Hashtable<String, JetRptFormula> ret = null;
        if (this.fmlWhere != null) {
            int iSize = this.fmlWhere.size();
            if (iSize < 1) {
                return null;
            }
            ret = new Hashtable<String, JetRptFormula>();
            Enumeration e = this.fmlWhere.keys();
            while (e.hasMoreElements()) {
                String name2 = (String)e.nextElement();
                ret.put(name2, ((JetUWhereFormula)this.fmlWhere.get(name2)).createNewJetRptFmlInstance());
            }
        }
        return ret;
    }

    @Override
    public void setSecPolicy(IExpression exp) {
        super.setSecPolicy(exp);
        Hashtable<Integer, String> htSpecFields = new Hashtable<Integer, String>();
        HDSWhereParser wp = new HDSWhereParser(this.unvs.getSingleThread() ? 0 : 10000, exp);
        CritNode node = wp.parse(new HDSNameFinder(this.uHDS));
        this.strLocalSecurity = node.getFormulaString();
        if (!StringTools.nullOrAllSpaces(this.strLocalSecurity)) {
            this.mpNames = DbTools.getMappingNamesInRawSql(this.strLocalSecurity);
            for (int i = 0; i < this.mpNames.size(); ++i) {
                String name2 = (String)this.mpNames.elementAt(i);
                int specField = DbTools.isSpecialField(name2);
                if (specField == -1) {
                    this.htMPNameDescPairs.put(name2, this.unvs.getSQLType(this.dataSourceName, this.strQueryName, name2));
                    continue;
                }
                if (specField == 0) {
                    htSpecFields.put(new Integer(specField), this.getRptUserName());
                    continue;
                }
                htSpecFields.put(new Integer(specField), this.unvs.getSpecialField(specField));
            }
            this.secFilter = this.jCnnt != null ? new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs, this.jCnnt.getDateFormat(), this.jCnnt.getTimestampFormat(), this.jCnnt.getTimeFormat()) : new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs);
            this.secFilter.setSpecFields(htSpecFields);
            this.secFilter.setParameters(this.paramsBuff);
        }
    }
}

