/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import com.jinfonet.dataservice.api.schema.relational.datasource.JDSDataField;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbConnection;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbDataField;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnLink;
import jet.connect.DbCompCol;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbTableLink;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.RecordFilter;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine8.core.pushdown.ExpPushDownParser;
import jet.dataengine8.core.queryengine.sqltoolkit.DataEngineV8NameFinder;
import jet.dataengine8.core.queryengine.sqltoolkit.IExpressionBuilder4WhereString;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.AggInfos;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.datasource.JRColDesc;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.report.JetRptSubLink;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUDBField;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.engine.UFakeColumn;
import jet.universe.engine.UFakeTable;
import jet.universe.engine.UPsqlQueryEngine;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.HDSWhereParser;
import jet.universe.psql.RptPsqlNameFinder;
import jet.universe.psql.RptPsqlQuery;
import jet.util.DbValueComparer;
import jet.util.HashVector;
import jet.util.StringTools;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.AggregationInfo;
import toolkit.db.api.ColumnInfo;
import toolkit.db.api.ConnectionInfo;
import toolkit.db.api.GroupInfo;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.api.TableInfo;
import toolkit.db.gui.JdbcDatabase;
import toolkit.db.mongo.MongoQuery;
import toolkit.db.sql.CritNode;

public class UMongoEngine
extends UQueryEngine {
    protected JetUQuery uQuery;
    protected RptPsqlQuery psqlQuery;
    protected JetUWhereFormula fmlWhere;
    protected Hashtable fakeTables = null;
    protected Hashtable dbTables = null;
    protected Hashtable dbCompCols = null;
    protected Vector CompCols = null;
    protected Hashtable htPsqlParamPair = null;
    protected String strPSQLQueryWhere = null;
    protected String strSubLinkWhere = null;
    protected String strRawPSQLQueryWhere = null;
    protected String strRawSubLinkWhere = null;
    MongoQuery mongoQuery = null;
    private SQLMapInfo sqlMapInfo = null;
    protected CritNode sNode;
    private static JRLogger logger = JRLogger.getLogger(UPsqlQueryEngine.class.getName());

    public UMongoEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile, RptPsqlQuery demandPsqlQuery) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, demandPsqlQuery);
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uQuery = this.unvs.GetQueryByResourceName(dataSourceName, strQueryName);
        this.psqlQuery = demandPsqlQuery != null ? demandPsqlQuery : this.uQuery.getPsqlQuery().getCopy();
        this.fmlWhere = !StringTools.nullOrAllSpaces(this.psqlQuery.getWhereFormulaName()) ? this.uQuery.getWhereFormula(this.psqlQuery.getWhereFormulaName()) : this.uQuery.getWhereFormula();
    }

    @Override
    protected void setUserSupportInfoRptPsql() {
        JetUJdbcSupportInfo suppInfo = this.getUserSupportInfo();
        if (this.psqlQuery != null && suppInfo != null) {
            this.psqlQuery.setUserSupportInfo(suppInfo);
        }
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (dbfld instanceof JetUQueryField || dbfld instanceof JetUField) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    public boolean haveLocalWhere() {
        return super.haveLocalWhere() || this.fmlWhere != null;
    }

    @Override
    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError, DSException, ParseFormulaFailedException {
        super.putFormulasInLocalWhereToBuffer();
        if (this.fmlWhere != null) {
            if (!this.fmlWhere.isParsedOK()) {
                throw new QueryWhereFormulaGrammarError(this.uQuery.getResourceName());
            }
            this.fmlsInLocalWhere.putFormula(this.fmlWhere.getResourceName(), this.fmlWhere);
        }
    }

    @Override
    public void initialize() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException, DSException {
        this.initGroupParameters();
        super.initialize();
    }

    @Override
    void initParamNamesInQry() {
        RptPsqlQuery rpq = this.psqlQuery.getCopy();
        rpq.setReplacedWhere(this.strWherePortion);
        rpq.setReparse();
        rpq.prepareWhereClauseString(false);
        Hashtable paramPair = rpq.getParameterValuePairs();
        Enumeration keys = paramPair.keys();
        while (keys.hasMoreElements()) {
            this.paramNames.add(((JetUParameter)keys.nextElement()).getResourceNameInUpperCase());
        }
    }

    @Override
    protected void initQuery() {
        this.psqlQuery.setReplacedWhere(this.strWherePortion);
        this.psqlQuery.setReparse();
        this.psqlQuery.prepareWhereClauseString(false);
        this.putParamInPsqlToBuf();
    }

    protected void putParamInPsqlToBuf() {
        this.htPsqlParamPair = this.psqlQuery.getParameterValuePairs();
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            this.putParameter(uParam.getResourceNameInUpperCase(), uParam);
        }
    }

    protected void putParamToPsqlBuf() {
        this.htPsqlParamPair = this.psqlQuery.getParameterValuePairs();
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            ParamDesc rptParameter = (ParamDesc)this.paramsBuff.get(uParam.getResourceNameInUpperCase());
            this.htPsqlParamPair.put(uParam, rptParameter);
        }
    }

    @Override
    protected void createDbQuery() throws FldNotFoundInQuery {
        JetUTableView tbl;
        String tabName;
        String qlf;
        DbCompCol compCol;
        String colName;
        JetUDBField dbfld;
        DbTableLink dbTable;
        JetUSupportInfo suppInfo = this.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strQuoteChar = suppInfo.getQuoteChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        if (this.htDbFields.isEmpty() && (this.htDbFieldsInLocalWhere == null || this.htDbFieldsInLocalWhere.isEmpty())) {
            return;
        }
        JdbcDatabase jdbcDatabase = this.createJdbcDatabase(this.uQuery.getTransactionIsolation(), this.uQuery.getReadOnly());
        this.mongoQuery = new MongoQuery();
        this.mongoQuery.setDistinct(this.psqlQuery.isDistinct() || this.isDistinct());
        Vector tables = this.psqlQuery.getPsqlTablesVector();
        int tabCount = tables.size();
        this.fakeTables = new Hashtable();
        this.dbTables = new Hashtable();
        for (int i = 0; i < tabCount; ++i) {
            PsqlTable psqlTable = (PsqlTable)tables.elementAt(i);
            String strTableName = psqlTable.getName();
            String strTableCorrName = psqlTable.getNameCorr();
            dbTable = new DbTableLink(psqlTable.getQualifier(), psqlTable.getOwner(), strTableName, psqlTable.getCorrelationName(), psqlTable.getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
            strTableCorrName = psqlTable.getQualifier() + psqlTable.getOwner() + strTableCorrName;
            this.dbTables.put(strTableCorrName, dbTable);
            this.fakeTables.put(strTableCorrName, new UFakeTable(strTableName));
        }
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            dbfld = (JetUDBField)this.htDbFields.get(key);
            colName = dbfld.getFldName();
            if (dbfld instanceof JetUCompColQueryField) {
                if (this.dbCompCols == null || this.CompCols == null) {
                    this.dbCompCols = new Hashtable();
                    this.CompCols = new Vector();
                }
                compCol = new DbCompCol(colName, ((JetUCompColQueryField)dbfld).getExpression());
                this.dbCompCols.put(key, compCol);
                this.CompCols.addElement(new UFakeColumn((String)key, false));
                continue;
            }
            qlf = "";
            if (dbfld instanceof JetUFldQueryField) {
                tabName = ((JetUFldQueryField)dbfld).getTableAlias();
                qlf = ((JetUFldQueryField)dbfld).getQlf();
            } else if (dbfld instanceof JetUField) {
                tbl = ((JetUField)dbfld).getTable();
                tabName = tbl.isAlias() ? tbl.getResourceName() : tbl.getTableName();
                qlf = tbl.getQualifier() + tbl.getOwner();
            } else {
                tabName = dbfld.getTableName();
            }
            dbTable = (DbTableLink)this.dbTables.get(qlf + tabName);
            if (dbTable == null) {
                dbTable = (DbTableLink)this.dbTables.get(tabName);
            }
            if (dbTable != null) {
                dbTable.appendColumn(new DbColumnLink((String)key, colName));
            }
            if (this.fakeTables.get(qlf + tabName) == null) continue;
            ((UFakeTable)this.fakeTables.get(qlf + tabName)).appendColumn((String)key, false);
        }
        if (this.htDbFieldsInLocalWhere != null) {
            e = this.htDbFieldsInLocalWhere.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                dbfld = (JetUDBField)this.htDbFieldsInLocalWhere.get(key);
                colName = dbfld.getFldName();
                if (dbfld instanceof JetUCompColQueryField) {
                    if (this.dbCompCols == null || this.CompCols == null) {
                        this.dbCompCols = new Hashtable();
                        this.CompCols = new Vector();
                    }
                    compCol = new DbCompCol(colName, ((JetUCompColQueryField)dbfld).getExpression());
                    this.dbCompCols.put(key, compCol);
                    this.CompCols.addElement(new UFakeColumn((String)key, true));
                    continue;
                }
                qlf = "";
                if (dbfld instanceof JetUFldQueryField) {
                    tabName = ((JetUFldQueryField)dbfld).getTableAlias();
                    qlf = ((JetUFldQueryField)dbfld).getQlf();
                } else if (dbfld instanceof JetUField) {
                    tabName = dbfld.getTableName();
                    tbl = ((JetUField)dbfld).getTable();
                    qlf = tbl.getQualifier() + tbl.getOwner();
                } else {
                    tabName = dbfld.getTableName();
                }
                dbTable = (DbTableLink)this.dbTables.get(qlf + tabName);
                if (dbTable == null) {
                    dbTable = (DbTableLink)this.dbTables.get(tabName);
                }
                dbTable.appendColumn(new DbColumnLink((String)key, colName));
                ((UFakeTable)this.fakeTables.get(qlf + tabName)).appendColumn((String)key, true);
            }
        }
        this.setPSQLQueryWhere();
        if (this.CompCols != null && this.dbCompCols != null) {
            int iSize = this.CompCols.size();
            for (int i = 0; i < iSize; ++i) {
                UFakeColumn fColumn = (UFakeColumn)this.CompCols.elementAt(i);
                DbCompCol dbCompCol = (DbCompCol)this.dbCompCols.get(fColumn.name);
                dbCompCol.setExpression(this.psqlQuery.resolveMappingNames(dbCompCol.getExpression(), this.getJavaFormula()));
            }
        }
        if (!this.serverLinks.isEmpty() || !this.serverSecurity.isEmpty() || this.sNode != null) {
            this.setServerSubLink();
        }
        this.setWhereClause();
        this.psqlQuery.setReplacedWhere(null);
    }

    @Override
    protected void setUserDefinedSqlString() {
    }

    public JetRptFormula getRptFormulaWhere() {
        if (this.fmlWhere != null) {
            return this.fmlWhere.createNewJetRptFmlInstance();
        }
        return null;
    }

    public Hashtable getCanbeSqlFormulaWhere() {
        Hashtable<JetUFormula, String> ret = new Hashtable<JetUFormula, String>();
        HashVector hvFormulas = this.getFormulasInLocalWhere();
        Hashtable fmls = this.psqlQuery.getFormulaValuePairs();
        Enumeration ufmls = fmls.keys();
        while (ufmls.hasMoreElements()) {
            JetUFormula ufml = (JetUFormula)ufmls.nextElement();
            JetRptFormula rptfml = ufml.createNewJetRptFmlInstance();
            String val = (String)fmls.get(ufml);
            if (hvFormulas != null) {
                if (this.inLocalWhereFormula(hvFormulas, rptfml)) continue;
                ret.put(ufml, val);
                continue;
            }
            ret.put(ufml, val);
        }
        return ret;
    }

    boolean inLocalWhereFormula(HashVector hvFormulas, JetRptFormula rptfml) {
        String name2 = rptfml.getName();
        Enumeration fmls = hvFormulas.Elements();
        while (fmls.hasMoreElements()) {
            JetRptFormula fml = (JetRptFormula)fmls.nextElement();
            if (!fml.getName().equalsIgnoreCase(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportServerSubLink() {
        return super.supportServerSubLink() ? this.psqlQuery.getUserDefinedQueryStmt().equals("") : false;
    }

    @Override
    public void setOrderBy(Vector mapFlds, Vector sorts) {
        this.aOrderBys = new Vector[]{mapFlds, sorts};
    }

    @Override
    public boolean supportOrderBy() {
        return super.supportOrderBy() ? this.psqlQuery.getUserDefinedQueryStmt().equals("") : false;
    }

    @Override
    public void setSubLinks(Vector theSubLinks) throws DSException, ParseFormulaFailedException {
        if (!(this.subLinks != null && theSubLinks != null && this.subLinks.size() == theSubLinks.size() || this.subLinks == null && theSubLinks == null)) {
            super.setSubLinks(theSubLinks);
            this.prepareBuffers();
            this.setServerSubLink();
            this.setWhereClause();
        }
    }

    protected void setPSQLQueryWhere() {
        this.putParamToPsqlBuf();
        this.psqlQuery.resolveFormulaWhere(this.paramsBuff, this.getJavaFormula());
        if (this.psqlQuery.isIgnorePredicateIfParamIsNull()) {
            this.psqlQuery.prepareWhereClauseString(this.paramsBuff, false);
        } else {
            this.psqlQuery.prepareWhereClauseString(null, false);
        }
        if (this.psqlQuery.getRepreparedStatus()) {
            this.putParamToPsqlBuf();
        }
        this.strPSQLQueryWhere = this.psqlQuery.getWhereClauseString(false, this.getJavaFormula());
    }

    protected void setServerSubLink() {
        String strServerSecurity;
        String strQualifiedName;
        String strMapName;
        JetUResourceEntity entity;
        DbValueComparer link;
        int iSize = this.serverLinks.size();
        boolean bFirstLink = true;
        this.strSubLinkWhere = "";
        for (int i = 0; i < iSize; ++i) {
            link = (DbValueComparer)this.serverLinks.elementAt(i);
            if (this.psqlQuery.isIgnorePredicateIfParamIsNull() && link.value.isNull() || !((entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName = link.columnName)) instanceof JetUDBField)) continue;
            strQualifiedName = this.getQaulifiedName(strMapName);
            if (!bFirstLink) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            if (!(entity instanceof JetUCompColQueryField)) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                continue;
            }
            DbCompCol col = (DbCompCol)this.dbCompCols.get(strQualifiedName);
            if (col != null) {
                String str = this.psqlQuery.resolveMappingNames(col.getExpression(), this.getJavaFormula());
                this.strSubLinkWhere = this.strSubLinkWhere.concat(str + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                continue;
            }
            this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
        }
        if (this.hasReportRLS) {
            iSize = this.serverSecurity.size();
            boolean firstSec = true;
            for (int i = 0; i < iSize; ++i) {
                link = (DbValueComparer)this.serverSecurity.elementAt(i);
                strMapName = link.columnName;
                entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (!(entity instanceof JetUDBField)) continue;
                strQualifiedName = this.getQaulifiedName(strMapName);
                if (bFirstLink) {
                    bFirstLink = false;
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" ( ");
                    firstSec = false;
                } else if (!firstSec) {
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" or ");
                } else {
                    firstSec = false;
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ( ");
                }
                if (!(entity instanceof JetUCompColQueryField)) {
                    if (link.value instanceof DbDateTime) {
                        this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                        continue;
                    }
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + " " + link.getOperString() + " " + link.value);
                    continue;
                }
                DbCompCol col = (DbCompCol)this.dbCompCols.get(strQualifiedName);
                if (col != null) {
                    String str = this.psqlQuery.resolveMappingNames(col.getExpression(), this.getJavaFormula());
                    if (link.value instanceof DbDateTime) {
                        this.strSubLinkWhere = this.strSubLinkWhere.concat(str + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                        continue;
                    }
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(str + " " + link.getOperString() + " " + link.value);
                    continue;
                }
                this.strSubLinkWhere = link.value instanceof DbDateTime ? this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value)) : this.strSubLinkWhere.concat(strQualifiedName + " " + link.getOperString() + " " + link.value);
            }
            if (!firstSec) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" ) ");
            }
        } else if (this.sNode != null && !StringTools.nullOrAllSpaces(strServerSecurity = this.sNode.getConditionString())) {
            if (!bFirstLink) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            this.strSubLinkWhere = this.strSubLinkWhere.concat("( " + strServerSecurity + " )");
        }
    }

    protected void setRawServerSubLink() {
        boolean bFirstLink = true;
        this.strRawSubLinkWhere = "";
        for (int i = 0; i < this.rptServerLinks.size(); ++i) {
            JetRptSubLink link = (JetRptSubLink)this.rptServerLinks.elementAt(i);
            String strMapName = link.sNSubColumn;
            JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
            if (!(entity instanceof JetUDBField)) continue;
            if (!bFirstLink) {
                this.strRawSubLinkWhere = this.strRawSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            String strQualifiedName = this.getQaulifiedName(strMapName);
            String strOperator = link.sNOperator;
            String strRevOperator = strOperator.equals("<=") ? ">=" : (strOperator.equals(">=") ? "<=" : (strOperator.equals(">") ? "<" : (strOperator.equals(">") ? "<" : strOperator)));
            String strMainColumn = link.sNMainColumn;
            if (strMainColumn.indexOf(" ") != -1) {
                strMainColumn = '\"' + strMainColumn + '\"';
            }
            this.strRawSubLinkWhere = this.strRawSubLinkWhere + strQualifiedName + strRevOperator + "@" + strMainColumn;
        }
    }

    protected void setWhereClause() {
        String strWhereClause;
        block9: {
            strWhereClause = null;
            if (this.strPSQLQueryWhere != null) {
                strWhereClause = this.strPSQLQueryWhere;
            }
            if (this.strSubLinkWhere != null && !this.strSubLinkWhere.equals("")) {
                strWhereClause = this.strPSQLQueryWhere == null || this.strPSQLQueryWhere.equals("") ? this.strSubLinkWhere : strWhereClause + " and (" + this.strSubLinkWhere + ")";
            }
            if (!StringTools.nullOrAllSpaces(strWhereClause)) {
                try {
                    if (this.psqlQuery != null) {
                        RptPsqlNameFinder finder = new RptPsqlNameFinder(this.psqlQuery);
                        DataEngineV8NameFinder dataEngineV8NameFinder = new DataEngineV8NameFinder(finder);
                        ResourceContainer resourceContainer = new ResourceContainer(this.unvs, this.dataSourceName, null, this.reportFormulas);
                        IExpressionBuilder4WhereString parser = new IExpressionBuilder4WhereString(resourceContainer);
                        parser.parser(dataEngineV8NameFinder, strWhereClause);
                        IExpression expression = parser.getAllExpression();
                        JRdbConnection connectionInfo = QueryTransform.parseConnection(this.jCnnt);
                        ExpPushDownParser expPushDownParser = ExpPushDownParser.getInstance(expression, resourceContainer, connectionInfo, this.jCnnt.getSupportInfo());
                        strWhereClause = expPushDownParser.getSQLConditionString();
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug("Parser where clause string error! : " + strWhereClause);
                }
            }
        }
        if (!StringTools.nullOrAllSpaces(this.pushDownWhereString)) {
            strWhereClause = StringTools.nullOrAllSpaces(strWhereClause) ? this.pushDownWhereString : ExpPushDownParser.buildServerAnd(strWhereClause, this.pushDownWhereString, this.jCnnt);
        }
        if (!StringTools.nullOrAllSpaces(strWhereClause)) {
            this.mongoQuery.setWhere(strWhereClause);
            if (logger.isDebugEnabled()) {
                logger.debug("Set where clause string to mongo query : " + strWhereClause);
            }
        }
    }

    public String getDbValueString(RptPsqlQuery psqlQuery, DbValue value) {
        String strRet = value.toString();
        if (value instanceof DbChar) {
            strRet = RptPsqlQuery.convertStringString(strRet);
        } else if (value instanceof DbDateTime) {
            if (value instanceof DbDate) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getDateFormat());
            } else if (value instanceof DbTime) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getTimeFormat());
            } else if (value instanceof DbTimestamp) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getTimestampFormat());
            }
            strRet = RptPsqlQuery.convertDateString(strRet, this.unvs, this.jCnnt, psqlQuery.getSupportInfo());
        }
        return strRet;
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        super.updateSubLink(theSubLinks);
        if (this.dbQuery == null) {
            return;
        }
        if (!this.serverLinks.isEmpty()) {
            this.setServerSubLink();
        }
        if (!this.paramLinks.isEmpty()) {
            this.setPSQLQueryWhere();
        }
        if (!this.serverLinks.isEmpty() || !this.paramLinks.isEmpty()) {
            this.setWhereClause();
        }
    }

    @Override
    protected void prepareBuffers() throws DSException, ParseFormulaFailedException {
        if (this.mongoQuery != null && !this.psqlQuery.hasUnion()) {
            UFakeColumn fColumn;
            int iColCount;
            int i;
            Vector vecCols;
            UFakeTable fTable;
            Object okey;
            int iTotalCol = 0;
            Enumeration e = this.dbTables.keys();
            while (e.hasMoreElements()) {
                okey = e.nextElement();
                fTable = (UFakeTable)this.fakeTables.get(okey);
                vecCols = fTable.cols;
                iTotalCol += vecCols.size();
            }
            if (this.CompCols != null) {
                iTotalCol += this.CompCols.size();
            }
            this.vecDbFields = new Vector(this.htDbFields.size() + 1);
            this.aiDbFieldsBackIndex = new int[iTotalCol + 1];
            for (i = 1; i < iTotalCol + 1; ++i) {
                this.aiDbFieldsBackIndex[i] = -1;
            }
            if (this.htDbFieldsInLocalWhere != null) {
                this.vecDbFieldsInLocalWhere = new Vector(this.htDbFieldsInLocalWhere.size() + 1);
                this.aiDbFieldsInLocalWhereBackIndex = new int[iTotalCol + 1];
                for (i = 1; i < iTotalCol + 1; ++i) {
                    this.aiDbFieldsInLocalWhereBackIndex[i] = -1;
                }
            }
            int iColIndex = 1;
            int idbFieldIndex = 1;
            int idbFieldInLocalWhereIndex = 1;
            Enumeration e2 = this.dbTables.keys();
            while (e2.hasMoreElements()) {
                okey = e2.nextElement();
                fTable = (UFakeTable)this.fakeTables.get(okey);
                vecCols = fTable.cols;
                iColCount = vecCols.size();
                for (int i2 = 0; i2 < iColCount; ++i2) {
                    fColumn = (UFakeColumn)vecCols.elementAt(i2);
                    if (fColumn.isFldInWhere) {
                        if (this.htDbFieldsInLocalWhere != null) {
                            this.vecDbFieldsInLocalWhere.addElement(fColumn.name);
                            this.aiDbFieldsInLocalWhereBackIndex[iColIndex] = idbFieldInLocalWhereIndex++;
                        }
                    } else {
                        this.vecDbFields.addElement(fColumn.name);
                        this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                    }
                    ++iColIndex;
                }
            }
            if (this.CompCols != null) {
                iColCount = this.CompCols.size();
                for (int i3 = 0; i3 < iColCount; ++i3) {
                    fColumn = (UFakeColumn)this.CompCols.elementAt(i3);
                    if (fColumn.isFldInWhere) {
                        if (this.htDbFieldsInLocalWhere != null) {
                            this.vecDbFieldsInLocalWhere.addElement(fColumn.name);
                            this.aiDbFieldsInLocalWhereBackIndex[iColIndex] = idbFieldInLocalWhereIndex++;
                        }
                    } else {
                        this.vecDbFields.addElement(fColumn.name);
                        this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                    }
                    ++iColIndex;
                }
            }
        } else if (this.mongoQuery != null) {
            Vector selCols = this.psqlQuery.vSelCols;
            int iSize = selCols.size();
            this.vecDbFields = new Vector(iSize + 1);
            this.aiDbFieldsBackIndex = new int[iSize + 1];
            for (int i = 0; i < iSize; ++i) {
                this.vecDbFields.addElement(((PsqlSelColumn)selCols.elementAt(i)).getMappingName().toUpperCase());
                this.aiDbFieldsBackIndex[i] = i;
            }
            this.aiDbFieldsBackIndex[iSize] = iSize;
        }
        super.prepareBuffers();
        if (this.fmlWhere != null) {
            this.fmlsContainer.setFormulaWhere(this.fmlWhere.getResourceName(), this.fmlWhere);
        }
    }

    @Override
    public String getFormulaWhere() {
        if (this.fmlWhere != null) {
            return this.fmlWhere.getResourceName();
        }
        return null;
    }

    public String getInnerJoinCnd() {
        return this.psqlQuery.getInnerJoinCnd();
    }

    public String getWhereCnd() {
        return this.psqlQuery.getWhereCnd();
    }

    @Override
    protected Vector getTotalCols() {
        return this.uQuery.getFields();
    }

    @Override
    public JRColDesc[] getColDescs() {
        int iDbFldsCount = 0;
        if (this.vecDbFields != null) {
            iDbFldsCount += this.vecDbFields.size();
        }
        if (this.haveLocalWhere()) {
            iDbFldsCount += this.vecDbFieldsInLocalWhere.size();
        }
        if (iDbFldsCount > 0) {
            JRColDesc[] ColDescs = new JRColDesc[iDbFldsCount + 1];
            for (int i = 1; i <= iDbFldsCount; ++i) {
                String strFieldName;
                if (this.aiDbFieldsBackIndex[i] != -1) {
                    strFieldName = (String)this.vecDbFields.elementAt(this.aiDbFieldsBackIndex[i] - 1);
                } else {
                    assert (this.vecDbFieldsInLocalWhere != null && this.aiDbFieldsInLocalWhereBackIndex != null) : "Fields in formula can not be null";
                    strFieldName = (String)this.vecDbFieldsInLocalWhere.elementAt(this.aiDbFieldsInLocalWhereBackIndex[i] - 1);
                }
                DbColDesc coldesc = this.unvs.getSQLType(this.dataSourceName, this.strQueryName, strFieldName);
                ColDescs[i] = new JRColDesc(strFieldName, coldesc.getSqlType(), coldesc.getPrecision(), coldesc.getScale(), coldesc.getNullable());
            }
            return ColDescs;
        }
        return null;
    }

    public String[] getSelectColNames() {
        JRColDesc[] cols = this.getColDescs();
        if (cols != null) {
            String[] names = new String[cols.length - 1];
            for (int i = 1; i < cols.length; ++i) {
                names[i - 1] = cols[i].getColName();
            }
            return names;
        }
        return null;
    }

    public RptPsqlQuery getPsqlQuery() {
        return this.psqlQuery;
    }

    @Override
    public boolean metaChanged(ResultSet rs) throws SQLException {
        return !this.psqlQuery.getUserDefinedQueryStmt().equals("");
    }

    @Override
    public int[] updateColMap(ResultSet rst) throws SQLException {
        ResultSetMetaData metaData = rst.getMetaData();
        int[] se2rm = new int[metaData.getColumnCount() + 1];
        for (int i = 1; i < se2rm.length; ++i) {
            se2rm[i] = -1;
        }
        String[] expectFlds = this.getSelectColNames();
        int qlfOpt = this.jCnnt.getQualifiedNamePattern();
        block1: for (int i = 1; i < expectFlds.length + 1; ++i) {
            String expectFld = expectFlds[i - 1];
            String columnName = null;
            String tableName = null;
            String schemaName = null;
            String catalogName = null;
            JetUQueryField qryFld = (JetUQueryField)this.htDbFields.get(expectFld);
            if (qryFld == null) {
                qryFld = (JetUQueryField)this.htDbFieldsInLocalWhere.get(expectFld);
            }
            boolean bCompColOrAlliasTabCol = false;
            if (qryFld instanceof JetUCompColQueryField) {
                bCompColOrAlliasTabCol = true;
                columnName = qryFld.colName.get();
            } else {
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, null, expectFld);
                if (entity != null) {
                    JetUField uField = (JetUField)entity;
                    columnName = uField.colName.get();
                    JetUTableView uTable = uField.getTable();
                    tableName = uTable.tableName.get();
                    schemaName = uTable.owner.get();
                    catalogName = uTable.qualifier.get();
                } else {
                    bCompColOrAlliasTabCol = true;
                    JetUFldQueryField qField = (JetUFldQueryField)this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, expectFld);
                    columnName = qField.colName.get();
                }
            }
            for (int j = 1; j < se2rm.length; ++j) {
                boolean bEqual;
                if (se2rm[j] != -1) continue;
                if (bCompColOrAlliasTabCol) {
                    if (!columnName.equalsIgnoreCase(metaData.getColumnName(j))) continue;
                    se2rm[j] = i;
                    continue block1;
                }
                String tName = metaData.getTableName(j);
                boolean bl = bEqual = columnName.equalsIgnoreCase(metaData.getColumnName(j)) && (tName == null || tName.trim().length() < 1 || tableName.equalsIgnoreCase(tName));
                if (bEqual && qlfOpt >= 1) {
                    String schName = metaData.getSchemaName(j);
                    boolean bl2 = bEqual = schName == null || schName.trim().length() < 1 || schemaName.equalsIgnoreCase(schName);
                }
                if (bEqual && qlfOpt == 2) {
                    String catName = metaData.getCatalogName(j);
                    boolean bl3 = bEqual = catName == null || catName.trim().length() < 1 || catalogName.equalsIgnoreCase(catName);
                }
                if (!bEqual) continue;
                se2rm[j] = i;
                continue block1;
            }
        }
        return se2rm;
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.uQuery = null;
        this.psqlQuery = null;
        this.fmlWhere = null;
        if (this.htDbFieldsInLocalWhere != null) {
            this.htDbFieldsInLocalWhere.clear();
        }
        this.htDbFieldsInLocalWhere = null;
        this.fmlsInLocalWhere = null;
        if (this.vecFormulasInLocalWhere != null) {
            this.vecFormulasInLocalWhere.clear();
        }
        this.vecFormulasInLocalWhere = null;
        this.fakeTables = null;
        this.dbTables = null;
        this.dbCompCols = null;
        this.CompCols = null;
        if (this.mongoQuery != null && this.bStarted) {
            try {
                this.end();
            }
            catch (Exception e) {
                logger.debug(e);
            }
        }
        this.mongoQuery = null;
    }

    @Override
    void PrintInput() {
    }

    @Override
    void PrintInitialized() {
    }

    @Override
    void PrintOutPut() {
    }

    @Override
    public void setSecPolicy(IExpression exp) {
        super.setSecPolicy(exp);
        if (this.psqlQuery != null) {
            Hashtable<Integer, String> htSpecFields = new Hashtable<Integer, String>();
            RptPsqlNameFinder nf = new RptPsqlNameFinder(this.psqlQuery);
            HDSWhereParser wp = new HDSWhereParser(this.unvs.getSingleThread() ? 0 : 10000, exp);
            CritNode node = wp.parse(nf);
            CritNode lNode = node.getLocalNode();
            this.strLocalSecurity = lNode.getFormulaString();
            if (!StringTools.nullOrAllSpaces(this.strLocalSecurity)) {
                this.mpNames = DbTools.getMappingNamesInRawSql(this.strLocalSecurity);
                for (int i = 0; i < this.mpNames.size(); ++i) {
                    String name2 = (String)this.mpNames.elementAt(i);
                    int specField = DbTools.isSpecialField(name2);
                    if (specField == -1) {
                        this.htMPNameDescPairs.put(name2, this.unvs.getSQLType(this.dataSourceName, this.strQueryName, name2));
                        continue;
                    }
                    if (specField != 0) continue;
                    htSpecFields.put(new Integer(specField), this.rptUserName);
                }
                this.secFilter = this.jCnnt != null ? new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs, this.jCnnt.getDateFormat(), this.jCnnt.getTimestampFormat(), this.jCnnt.getTimeFormat()) : new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs);
                this.secFilter.setSpecFields(htSpecFields);
                this.secFilter.setParameters(this.paramsBuff);
            }
            if (this.supportServerSubLink()) {
                this.sNode = node.getServerNode();
            }
        }
    }

    @Override
    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid, DSException {
        if (this.mongoQuery != null) {
            this.bStarted = true;
            if (this.jCnnt != null) {
                int i;
                ConnectionInfo conInfo = null;
                conInfo = new ConnectionInfo(this.strJdbcDriver, this.strURL, this.strUID, this.strPSWD, this.jCnnt.getDateFormat(), this.jCnnt.getTimeFormat(), this.jCnnt.getTimestampFormat(), this.jCnnt.getTransactionIsolation(), this.jCnnt.getReadOnly(), this.jCnnt.getQualifiedNamePattern(), this.jCnnt.getExtraNamePattern(), this.jCnnt.getEncodingPattern());
                this.mongoQuery.setConnection(conInfo);
                TableInfo tableInfo = null;
                ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>(this.dbTables.size());
                Hashtable<String, TableInfo> tables = new Hashtable<String, TableInfo>();
                Enumeration e = this.dbTables.keys();
                while (e.hasMoreElements()) {
                    Object okey = e.nextElement();
                    DbTableLink dbTable = (DbTableLink)this.dbTables.get(okey);
                    tableInfo = new TableInfo(dbTable.getMappingName(), dbTable.getTableName(false), dbTable.getCorrelationName(), dbTable.getOwner(), dbTable.getCatalog());
                    tableInfos.add(tableInfo);
                    String tmapname = dbTable.getMappingName();
                    tables.put(tmapname, tableInfo);
                }
                this.mongoQuery.setTables(tableInfos);
                AggInfos agginfo = this.getAttributeContainer().getAggInfos();
                if (agginfo == null) {
                    JDSDataField[] dbfields = this.getAttributeContainer().getAllDBFields();
                    ColumnInfo[] columnInfos = new ColumnInfo[dbfields.length];
                    for (i = 0; i < dbfields.length; ++i) {
                        if (!(dbfields[i] instanceof JRdbDataField)) continue;
                        JRdbDataField dataField = (JRdbDataField)dbfields[i];
                        columnInfos[dataField.getFieldIndex() - 1] = this.buildCI(dataField.getAliasName(), tables);
                    }
                    this.mongoQuery.setProjections(new ArrayList<ColumnInfo>(Arrays.asList(columnInfos)));
                } else {
                    String[] groups = agginfo.getGroupbys();
                    Integer[] order = agginfo.getGroupbyOrder();
                    ArrayList<GroupInfo> groupInfos = new ArrayList<GroupInfo>(groups.length);
                    for (int i2 = 0; i2 < groups.length; ++i2) {
                        groupInfos.add(new GroupInfo(this.buildCI(groups[i2], tables), order[i2]));
                    }
                    AggregationKey[] aggs = agginfo.getAggKey();
                    ArrayList<AggregationInfo> aggInfos = new ArrayList<AggregationInfo>(aggs.length);
                    for (int i3 = 0; i3 < aggs.length; ++i3) {
                        aggInfos.add(new AggregationInfo(this.buildCI(aggs[i3].getBaseColumn(), tables), aggs[i3].getAggFunctionType()));
                    }
                    this.mongoQuery.setGroupAggs(aggInfos);
                    this.mongoQuery.setGroupBys(groupInfos);
                }
                if (this.aOrderBys != null && this.aOrderBys[0].size() > 0) {
                    int iSize = this.aOrderBys[0].size();
                    ArrayList<GroupInfo> sortInfos = new ArrayList<GroupInfo>(iSize);
                    for (i = 0; i < iSize; ++i) {
                        int iOrder = ((String)this.aOrderBys[1].get(i)).equalsIgnoreCase("ASC") ? 0 : 1;
                        sortInfos.add(new GroupInfo(this.buildCI((String)this.aOrderBys[0].get(i), tables), iOrder));
                    }
                    this.mongoQuery.setSorts(sortInfos);
                }
            }
            this.rs = this.mongoQuery.getResultSet();
        }
    }

    private ColumnInfo buildCI(String mapName, Hashtable tables) throws DSException {
        ColumnInfo ret = null;
        JDSDataField dbfield = (JDSDataField)this.getAttributeContainer().getElementByAliasName(mapName);
        if (dbfield instanceof JRdbDataField) {
            JRdbDataField dataField = (JRdbDataField)dbfield;
            TableInfo tinfo = dataField.useExpression() ? null : (TableInfo)tables.get(dataField.getRelationModel().getAliasName());
            ret = new ColumnInfo(dataField.getAliasName(), dataField.getName(), dataField.getExpression(), dataField.useExpression(), tinfo, dataField.getFieldIndex());
        }
        return ret;
    }

    @Override
    public void end() throws SQLException {
        block7: {
            if (this.rs != null) {
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Exception e) {
                    this.rs = null;
                }
            }
            if (this.mongoQuery != null && this.bStarted) {
                this.bStarted = false;
                if (this.sqlStatement == null || this.sqlStatement.trim().length() <= 0) {
                    this.sqlStatement = "";
                }
                try {
                    this.mongoQuery.close();
                    this.mongoQuery = null;
                    this.rs = null;
                }
                catch (Exception EQ) {
                    this.mongoQuery = null;
                    this.rs = null;
                    if (!logger.isErrorEnabled()) break block7;
                    logger.error("", EQ);
                }
            }
        }
    }

    @Override
    public void closeResultSet() throws SQLException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Exception e) {
                this.rs = null;
            }
        }
    }
}

