/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.connect.DbDateTime;
import jet.connect.DbProcedure;
import jet.connect.DbValue;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.dataengine.api.DSException;
import jet.datasource.JRColDesc;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataTypeDef;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.universe.JetUDBField;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.RptPsqlQuery;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.ProcParaInfo;
import toolkit.db.gui.JdbcDatabase;

public class UProcedureEngine
extends UQueryEngine {
    protected JetUProcedure uProcedure;
    Vector vecParams;
    DbProcedure dbProcedure;
    boolean bConecting;
    Hashtable outParameters = new Hashtable();
    Hashtable specFldsParameters = new Hashtable();
    private static JRLogger logger = JRLogger.getLogger(UProcedureEngine.class.getName());

    public UProcedureEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLink, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLink, bUseResultFile);
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uProcedure = (JetUProcedure)this.unvs.getQueriableByResourceName(dataSourceName, strQueryName);
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (!(dbfld instanceof JetUProcField)) {
                throw new FldNotFoundInQuery(this.strQueryName, (String)key);
            }
            if (((JetUProcField)dbfld).getProcedure() == this.uProcedure) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        super.updateSubLink(theSubLinks);
        if (!this.paramLinks.isEmpty()) {
            this.putParamToProcedure();
        }
    }

    @Override
    void initParamNamesInQry() {
        this.putParamInProcedureToBuf(true);
    }

    @Override
    protected void initQuery() {
        this.putParamInProcedureToBuf();
    }

    protected void putParamInProcedureToBuf() {
        this.putParamInProcedureToBuf(false);
    }

    protected void putParamInProcedureToBuf(boolean cache) {
        Vector vecParameters = this.uProcedure.getParameters();
        this.outParameters.clear();
        int iSize = vecParameters.size();
        String paramName = null;
        for (int i = 0; i < iSize; ++i) {
            JetUProcParameter procParam = (JetUProcParameter)vecParameters.elementAt(i);
            paramName = procParam.getResourceName().toUpperCase();
            if (cache) {
                if (procParam.getIsSpecialField()) continue;
                this.paramNames.add(paramName);
                continue;
            }
            if (procParam.isINParameter()) {
                if (!procParam.getIsSpecialField()) {
                    this.putParameter(paramName, procParam);
                    continue;
                }
                this.addSpecFldParameter(paramName, procParam);
                continue;
            }
            this.addOutParameter(paramName, procParam);
        }
    }

    private ProcParaInfo createProcParamInfo(String strRscName, JetUProcParameter procParam) {
        return new ProcParaInfo(procParam.index.get(), strRscName, (Integer)procParam.type.get(), procParam.sqlType.get(), procParam.sqlTypeName.get(), procParam.precision.get(), procParam.length.get(), (short)procParam.scale.get(), (short)procParam.radix.get(), (short)procParam.nullable.get(), false, procParam.value.get(), false, procParam.getIsSpecialField());
    }

    protected void addSpecFldParameter(String strRscName, JetUProcParameter procParam) {
        this.specFldsParameters.put(strRscName, this.createProcParamInfo(strRscName, procParam));
    }

    protected void addOutParameter(String strRscName, JetUProcParameter procParam) {
        this.outParameters.put(strRscName, this.createProcParamInfo(strRscName, procParam));
    }

    protected void putParameter(String strRscName, JetUProcParameter procParam) {
        if (!this.paramsBuff.containsKey(strRscName)) {
            String v;
            Vector<String> vStrValue = null;
            JetUParameter RsEntity = null;
            JetUResourceEntity resourceEntity = null;
            try {
                resourceEntity = procParam.getUniverse().getMaterialByName(this.dataSourceName, strRscName);
                if (resourceEntity instanceof JetUParameter) {
                    RsEntity = (JetUParameter)resourceEntity;
                } else if (resourceEntity instanceof JetUFormula) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String sprompt = null;
            String suserFormat = null;
            Vector vlimit = null;
            if (RsEntity != null) {
                super.putParameter(strRscName, RsEntity);
                return;
            }
            sprompt = JResource.getMessage("CAT_PROCEDURE_PARAMETER_1", new String[]{String.valueOf(procParam.getIndex()), procParam.getProcedureName(), procParam.getSQLTypeName()});
            if (vStrValue == null) {
                vStrValue = new Vector<String>(2);
            }
            if (!vStrValue.contains(v = procParam.getValue())) {
                vStrValue.addElement(v);
            }
            ParamDesc parameter = new ParamDesc(procParam.getResourceName(), DataTypeDef.toTypeString(DataTypeDef.SqlToFml(procParam.getSQLType(), false)), sprompt, vlimit, vStrValue, suserFormat, -1, -1);
            String importSQl = "";
            String column = "";
            if (RsEntity instanceof JetUParameter) {
                JetUParameter uPara = RsEntity;
                importSQl = uPara.getParamDesc().getImportSql();
                column = uPara.getParamDesc().getColumn();
                if (uPara.isReferPara()) {
                    Hashtable referUParam = new Hashtable();
                    uPara.getAllReferP(this.unvs, this.dataSourceName, this.strQueryName, referUParam);
                    Enumeration e = referUParam.keys();
                    while (e.hasMoreElements()) {
                        String name2 = (String)e.nextElement();
                        if (this.mappingFlds.contains(name2.toUpperCase())) continue;
                        this.putParameter(name2.toUpperCase(), (JetUParameter)referUParam.get(name2));
                    }
                }
            }
            if (!importSQl.equals("") || !column.equals("") || RsEntity != null && RsEntity.getProperties().get("ImportSql") != null && ((JetProperty)RsEntity.getProperties().get("ImportSql")).toString().trim().length() > 0) {
                parameter.setDataSource(RsEntity.getDatabase().getResourceName());
                parameter.setImportSql(((JetProperty)RsEntity.getProperties().get("ImportSql")).toString().trim());
                parameter.setBeColumn(4);
                parameter.setColumn(RsEntity.column.get());
                parameter.setColumns(RsEntity.columns.get());
                parameter.setDistinct(RsEntity.distinct.get());
                parameter.setFormat(RsEntity.getFormat());
                parameter.setImportParams(((JetVector)RsEntity.getProperties().get("ReferParams")).get());
            } else {
                parameter.setBeColumn(0);
            }
            this.paramsBuff.put(strRscName, parameter);
        }
    }

    protected void putParamToProcedure() {
        ProcParaInfo param;
        this.vecParams = new Vector();
        Vector procedureParameters = this.uProcedure.getParameters();
        Object aliseName = null;
        String strValue = null;
        DbValue dbValue = null;
        int iLen = procedureParameters.size();
        for (int i = 0; i < iLen; ++i) {
            JetUProcParameter procParam = (JetUProcParameter)procedureParameters.get(i);
            if (procParam.getIsSpecialField()) continue;
            String strRscName = procParam.getResourceName().toUpperCase();
            ParamDesc rptParameter = (ParamDesc)this.paramsBuff.get(strRscName);
            strValue = null;
            dbValue = rptParameter != null ? rptParameter.getValue() : this.getConstantFormulaValue(strRscName);
            int iSQLType = procParam.getSQLType();
            switch (iSQLType) {
                case 91: {
                    strValue = ((DbDateTime)dbValue).toFormatString(this.jCnnt.getDateFormat());
                    break;
                }
                case 92: {
                    strValue = ((DbDateTime)dbValue).toFormatString(this.jCnnt.getTimeFormat());
                    break;
                }
                case 93: {
                    strValue = ((DbDateTime)dbValue).toFormatString(this.jCnnt.getTimestampFormat());
                    break;
                }
                default: {
                    strValue = dbValue.toString();
                }
            }
            boolean bIsNull = false;
            bIsNull = dbValue.isNull() || dbValue.toString().length() < 1;
            boolean bSpecialField = false;
            param = new ProcParaInfo(procParam.getIndex(), procParam.getParameterName(), procParam.getType(), iSQLType, procParam.getSQLTypeName(), procParam.getPrecision(), procParam.getLength(), (short)procParam.getScale(), (short)procParam.getRadix(), (short)procParam.getNullable(), true, strValue, bIsNull, bSpecialField);
            this.vecParams.addElement(param);
        }
        Enumeration e = this.outParameters.keys();
        while (e.hasMoreElements()) {
            String name2 = (String)e.nextElement();
            this.vecParams.addElement(this.outParameters.get(name2));
        }
        e = this.specFldsParameters.keys();
        while (e.hasMoreElements()) {
            String name3 = (String)e.nextElement();
            param = (ProcParaInfo)this.specFldsParameters.get(name3);
            if (this.rptUserName == null) {
                param.setValue("");
            } else {
                param.setValue(this.rptUserName);
            }
            this.vecParams.addElement(param);
        }
        if (this.dbProcedure != null) {
            this.dbProcedure.setParameter(this.vecParams);
        }
    }

    @Override
    protected void createDbQuery() {
        JdbcDatabase jdbcDatabase = this.createJdbcDatabase(this.uProcedure.getTransactionIsolation(), this.uProcedure.getReadOnly());
        this.dbProcedure = new DbProcedure(jdbcDatabase, this.uProcedure.getQualifier(), this.uProcedure.getOwner(), this.uProcedure.getProcedureName(), this.vecParams, this.jCnnt.getQualifiedNamePattern(), this.jCnnt);
        this.dbProcedure.getSupportInfo(this.getSupportInfo());
        this.dbProcedure.setJdbcDriversConfig(this.jdbcDriversConfig);
        this.putParamToProcedure();
    }

    @Override
    protected void prepareBuffers() {
        if (this.dbProcedure != null) {
            Vector vecProcedureFields = this.uProcedure.getFields();
            int iTotalCol = vecProcedureFields.size();
            int idbFieldIndex = 1;
            this.vecDbFields = new Vector(this.htDbFields.size() + 1);
            this.aiDbFieldsBackIndex = new int[iTotalCol + 1];
            for (int i = 1; i < iTotalCol + 1; ++i) {
                this.aiDbFieldsBackIndex[i] = -1;
            }
            Enumeration e = this.htDbFields.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
                int iColIndex = ((JetUProcField)dbfld).getColIndex();
                this.vecDbFields.addElement(key);
                this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
            }
        }
        this.vecFormulas = this.fmlsContainer.getFormulas();
    }

    @Override
    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid {
        this.bStarted = true;
        try {
            this.rs = this.dbProcedure.getResultSet();
        }
        catch (JRStopEngineException jRStopEngineException) {
            // empty catch block
        }
    }

    @Override
    public void end() throws SQLException {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
            }
        }
        if (this.dbProcedure != null && this.bStarted) {
            this.bStarted = false;
            this.dbProcedure.close();
        }
    }

    @Override
    public String getSqlStatement() {
        return this.dbProcedure.getSqlStatement();
    }

    @Override
    public boolean supportServerSubLink() {
        return false;
    }

    @Override
    public boolean supportOrderBy() {
        return false;
    }

    @Override
    public void setOrderBy(Vector mapFlds, Vector sorts) {
    }

    @Override
    public JRColDesc[] getColDescs() {
        Vector vecProcedureFields = this.uProcedure.getFields();
        int iTotalCol = vecProcedureFields.size();
        JetUProcField fqField = null;
        JRColDesc[] ColDescs = new JRColDesc[iTotalCol + 1];
        for (int i = 0; i < iTotalCol; ++i) {
            fqField = (JetUProcField)vecProcedureFields.elementAt(i);
            int iColIndex = fqField.getColIndex();
            DbColDesc coldesc = fqField.getColDesc();
            String strFieldName = fqField.getResourceName();
            ColDescs[iColIndex] = new JRColDesc(strFieldName, coldesc.getSqlType(), coldesc.getPrecision(), coldesc.getScale(), coldesc.getNullable());
        }
        return ColDescs;
    }

    @Override
    protected Vector getTotalCols() {
        return this.uProcedure.getFields();
    }

    @Override
    protected void setUserDefinedSqlString() {
    }

    @Override
    public void clearMem() {
        super.clearMem();
        try {
            this.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DbProcedure getDbProcedure() {
        return this.dbProcedure;
    }
}

