/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnLink;
import jet.connect.DbCompCol;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbQuery;
import jet.connect.DbTableLink;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.connect.RecordFilter;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.datasource.JRColDesc;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.report.JetRptSubLink;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUDBField;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUWhereFormula;
import jet.universe.engine.UFakeColumn;
import jet.universe.engine.UFakeTable;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.FileQuery;
import jet.universe.psql.HDSWhereParser;
import jet.universe.psql.JoinsImpl;
import jet.universe.psql.PointEx;
import jet.universe.psql.QueryInfoBuilder;
import jet.universe.psql.RptPsqlNameFinder;
import jet.universe.psql.RptPsqlQuery;
import jet.util.DbValueComparer;
import jet.util.HashVector;
import jet.util.StringTools;
import toolkit.db.DbTools;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;
import toolkit.db.api.ParameterInfo;
import toolkit.db.api.QueryInfo;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.api.SQLNameAnalyser;
import toolkit.db.api.SQLStmtCreator;
import toolkit.db.gui.JdbcDatabase;
import toolkit.db.sql.CritNode;
import toolkit.db.sql.comments.SqlCommentsTool;

public class UPsqlQueryEngine
extends UQueryEngine {
    protected JetUQuery uQuery;
    protected RptPsqlQuery psqlQuery;
    protected JetUWhereFormula fmlWhere;
    protected Hashtable fakeTables = null;
    protected Hashtable dbTables = null;
    protected Hashtable dbCompCols = null;
    protected Vector CompCols = null;
    protected Hashtable htPsqlParamPair = null;
    protected String strPSQLQueryWhere = null;
    protected String strSubLinkWhere = null;
    protected String strRawPSQLQueryWhere = null;
    protected String strRawSubLinkWhere = null;
    private SQLMapInfo sqlMapInfo = null;
    protected CritNode sNode;
    private static JRLogger logger = JRLogger.getLogger(UPsqlQueryEngine.class.getName());
    private QueryInfo queryInfo = null;
    private SQLStmtCreator sqlStmtCreator = null;

    public UPsqlQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
    }

    public UPsqlQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile, RptPsqlQuery demandPsqlQuery) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, demandPsqlQuery);
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uQuery = this.unvs.GetQueryByResourceName(dataSourceName, strQueryName);
        this.psqlQuery = demandPsqlQuery != null ? demandPsqlQuery : this.uQuery.getPsqlQuery().getCopy();
        this.fmlWhere = this.psqlQuery.isSubRptPsqlQuery() ? (!StringTools.nullOrAllSpaces(this.psqlQuery.getWhereFormulaName()) ? this.uQuery.getWhereFormula(this.psqlQuery.getWhereFormulaName()) : null) : this.uQuery.getWhereFormula();
    }

    @Override
    protected void setUserSupportInfoRptPsql() {
        JetUJdbcSupportInfo suppInfo = this.getUserSupportInfo();
        if (this.psqlQuery != null && suppInfo != null) {
            this.psqlQuery.setUserSupportInfo(suppInfo);
        }
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (dbfld instanceof JetUQueryField || dbfld instanceof JetUField) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    public boolean haveLocalWhere() {
        return super.haveLocalWhere() || this.fmlWhere != null;
    }

    @Override
    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError, DSException, ParseFormulaFailedException {
        super.putFormulasInLocalWhereToBuffer();
        if (this.fmlWhere != null) {
            if (!this.fmlWhere.isParsedOK()) {
                throw new QueryWhereFormulaGrammarError(this.uQuery.getResourceName());
            }
            this.fmlsInLocalWhere.putFormula(this.fmlWhere.getResourceName(), this.fmlWhere);
        }
    }

    @Override
    public void initialize() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException, DSException {
        this.initGroupParameters();
        this.initSQLStmtCreatorOrSQLNameAnalyserParams();
        if (!this.uQuery.enableSQLStmtCreator.get() && this.uQuery.enableSQLNameAnalyser.get()) {
            this.initSQLMapInfo();
            this.psqlQuery.setSQLMapInfo(this.sqlMapInfo);
        }
        super.initialize();
    }

    private void initSQLMapInfo() throws DSException {
        SQLNameAnalyser sqlNameAnalyser;
        block4: {
            sqlNameAnalyser = null;
            try {
                sqlNameAnalyser = this.unvs.createSQLNameAnalyser(this.dataSourceName);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("Failed to load the clss for  SQLNameAnalyser", e);
            }
        }
        if (sqlNameAnalyser != null && this.uQuery.enableSQLNameAnalyser.get()) {
            this.sqlMapInfo = this.psqlQuery.createSQLMapInfo();
            this.sqlMapInfo.setQlfOpt(this.jCnnt.getQualifiedNamePattern());
            ParameterInfo[] params = new ParameterInfo[this.paramsBuff.size()];
            int count = 0;
            Enumeration e = this.paramsBuff.elements();
            while (e.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)e.nextElement();
                params[count++] = new ParameterInfo(paramDesc.name, paramDesc.type, paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
            }
            sqlNameAnalyser.getSQLMapInfo(this.sqlMapInfo, params);
        }
    }

    @Override
    void initParamNamesInQry() {
        RptPsqlQuery rpq = this.psqlQuery.getCopy();
        rpq.setReplacedWhere(this.strWherePortion);
        rpq.setReparse();
        rpq.prepareWhereClauseString(false);
        Hashtable paramPair = rpq.getParameterValuePairs();
        Enumeration keys = paramPair.keys();
        while (keys.hasMoreElements()) {
            this.paramNames.add(((JetUParameter)keys.nextElement()).getResourceNameInUpperCase());
        }
    }

    @Override
    protected void initQuery() {
        this.psqlQuery.setReplacedWhere(this.strWherePortion);
        this.psqlQuery.setReparse();
        this.psqlQuery.prepareWhereClauseString(false);
        this.putParamInPsqlToBuf();
    }

    protected void putParamInPsqlToBuf() {
        this.htPsqlParamPair = this.psqlQuery.getParameterValuePairs();
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            this.putParameter(uParam.getResourceNameInUpperCase(), uParam);
        }
    }

    protected void putParamToPsqlBuf() {
        this.putParamToPsqlBuf(this.psqlQuery);
    }

    protected void putParamToPsqlBuf(RptPsqlQuery curPsqlQuery) {
        this.htPsqlParamPair = curPsqlQuery.getParameterValuePairs();
        Enumeration e = this.htPsqlParamPair.keys();
        while (e.hasMoreElements()) {
            JetUParameter uParam = (JetUParameter)e.nextElement();
            ParamDesc rptParameter = (ParamDesc)this.paramsBuff.get(uParam.getResourceNameInUpperCase());
            this.htPsqlParamPair.put(uParam, rptParameter);
        }
    }

    private void initSQLStmtCreatorOrSQLNameAnalyserParams() {
        block4: {
            JetUParameter[] params;
            String connName;
            block3: {
                String string = connName = this.jCnnt == null ? "" : this.jCnnt.getResourceName();
                if (!this.uQuery.enableSQLStmtCreator.get()) break block3;
                JetUParameter[] params2 = this.unvs.getSQLStmtCreatorParams(this.dataSourceName, connName);
                if (params2 == null) break block4;
                for (int i = 0; i < params2.length; ++i) {
                    if (params2[i] == null) continue;
                    this.putParameter(params2[i].getResourceNameInUpperCase(), params2[i]);
                }
                break block4;
            }
            if (this.uQuery.enableSQLNameAnalyser.get() && (params = this.unvs.getSQLNameAnalyserParams(this.dataSourceName, connName)) != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == null) continue;
                    this.putParameter(params[i].getResourceNameInUpperCase(), params[i]);
                }
            }
        }
    }

    @Override
    protected void createDbQuery() throws FldNotFoundInQuery {
        JetUTableView tbl;
        String tabName;
        String qlf;
        DbCompCol compCol;
        String colName;
        JetUDBField dbfld;
        DbTableLink dbTable;
        JetUSupportInfo suppInfo = this.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strQuoteChar = suppInfo.getQuoteChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        if (this.htDbFields.isEmpty() && (this.htDbFieldsInLocalWhere == null || this.htDbFieldsInLocalWhere.isEmpty())) {
            return;
        }
        JdbcDatabase jdbcDatabase = this.createJdbcDatabase(this.uQuery.getTransactionIsolation(), this.uQuery.getReadOnly());
        this.dbQuery = new DbQuery(jdbcDatabase, strExtraNameChar, strQuoteChar, strExtraKeywords);
        this.dbQuery.setJdbcDriversConfig(this.jdbcDriversConfig);
        this.dbQuery.setQuery(this.uQuery);
        this.dbQuery.setQlfOpt(this.jCnnt.getQualifiedNamePattern());
        this.dbQuery.setDistinct(this.psqlQuery.isDistinct() || this.isDistinct());
        this.dbQuery.setSQLMapInfo(this.sqlMapInfo);
        if (this.aggInfos != null) {
            this.dbQuery.setAggInfos(this.aggInfos);
        }
        this.updateUserDefinedQueryStmt();
        Vector tables = this.psqlQuery.getPsqlTablesVector();
        int tabCount = tables.size();
        this.fakeTables = new Hashtable();
        this.dbTables = new Hashtable();
        for (int i = 0; i < tabCount; ++i) {
            PsqlTable psqlTable = (PsqlTable)tables.elementAt(i);
            String strTableName = psqlTable.getName();
            String strTableCorrName = psqlTable.getNameCorr();
            dbTable = new DbTableLink(psqlTable.getQualifier(), psqlTable.getOwner(), strTableName, psqlTable.getCorrelationName(), psqlTable.getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
            strTableCorrName = psqlTable.getQualifier() + psqlTable.getOwner() + strTableCorrName;
            this.dbTables.put(strTableCorrName, dbTable);
            this.fakeTables.put(strTableCorrName, new UFakeTable(strTableName));
        }
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            dbfld = (JetUDBField)this.htDbFields.get(key);
            colName = dbfld.getFldName();
            if (dbfld instanceof JetUCompColQueryField) {
                if (this.dbCompCols == null || this.CompCols == null) {
                    this.dbCompCols = new Hashtable();
                    this.CompCols = new Vector();
                }
                compCol = new DbCompCol(colName, ((JetUCompColQueryField)dbfld).getExpression());
                this.dbCompCols.put(key, compCol);
                this.CompCols.addElement(new UFakeColumn((String)key, false));
                continue;
            }
            qlf = "";
            if (dbfld instanceof JetUFldQueryField) {
                tabName = ((JetUFldQueryField)dbfld).getTableAlias();
                qlf = ((JetUFldQueryField)dbfld).getQlf();
            } else if (dbfld instanceof JetUField) {
                tbl = ((JetUField)dbfld).getTable();
                tabName = tbl.isAlias() ? tbl.getResourceName() : tbl.getTableName();
                qlf = tbl.getQualifier() + tbl.getOwner();
            } else {
                tabName = dbfld.getTableName();
            }
            dbTable = (DbTableLink)this.dbTables.get(qlf + tabName);
            if (dbTable == null) {
                dbTable = (DbTableLink)this.dbTables.get(tabName);
            }
            if (dbTable != null) {
                dbTable.appendColumn(new DbColumnLink((String)key, colName));
            }
            if (this.fakeTables.get(qlf + tabName) == null) continue;
            ((UFakeTable)this.fakeTables.get(qlf + tabName)).appendColumn((String)key, false);
        }
        if (this.htDbFieldsInLocalWhere != null) {
            e = this.htDbFieldsInLocalWhere.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                dbfld = (JetUDBField)this.htDbFieldsInLocalWhere.get(key);
                colName = dbfld.getFldName();
                if (dbfld instanceof JetUCompColQueryField) {
                    if (this.dbCompCols == null || this.CompCols == null) {
                        this.dbCompCols = new Hashtable();
                        this.CompCols = new Vector();
                    }
                    compCol = new DbCompCol(colName, ((JetUCompColQueryField)dbfld).getExpression());
                    this.dbCompCols.put(key, compCol);
                    this.CompCols.addElement(new UFakeColumn((String)key, true));
                    continue;
                }
                qlf = "";
                if (dbfld instanceof JetUFldQueryField) {
                    tabName = ((JetUFldQueryField)dbfld).getTableAlias();
                    qlf = ((JetUFldQueryField)dbfld).getQlf();
                } else if (dbfld instanceof JetUField) {
                    tabName = dbfld.getTableName();
                    tbl = ((JetUField)dbfld).getTable();
                    qlf = tbl.getQualifier() + tbl.getOwner();
                } else {
                    tabName = dbfld.getTableName();
                }
                dbTable = (DbTableLink)this.dbTables.get(qlf + tabName);
                if (dbTable == null) {
                    dbTable = (DbTableLink)this.dbTables.get(tabName);
                }
                dbTable.appendColumn(new DbColumnLink((String)key, colName));
                ((UFakeTable)this.fakeTables.get(qlf + tabName)).appendColumn((String)key, true);
            }
        }
        this.setPSQLQueryWhere();
        Enumeration e2 = this.dbTables.keys();
        while (e2.hasMoreElements()) {
            Object okey = e2.nextElement();
            this.dbQuery.appendTable((DbTableLink)this.dbTables.get(okey));
        }
        if (this.CompCols != null && this.dbCompCols != null) {
            int iSize = this.CompCols.size();
            for (int i = 0; i < iSize; ++i) {
                UFakeColumn fColumn = (UFakeColumn)this.CompCols.elementAt(i);
                DbCompCol dbCompCol = (DbCompCol)this.dbCompCols.get(fColumn.name);
                this.dbQuery.appendTable(dbCompCol);
                dbCompCol.setExpression(this.psqlQuery.resolveMappingNames(dbCompCol.getExpression(), this.getJavaFormula()));
            }
        }
        Vector vJoins = this.psqlQuery.getPsqlJoinsVector();
        int sz = vJoins.size();
        JoinsImpl joinsImpl = new JoinsImpl(this.unvs, this.dataSourceName, this.strQueryName, this.getConnection());
        joinsImpl.setDbQuery(this.dbQuery);
        joinsImpl.setSupportInfo(strExtraNameChar, strQuoteChar, strExtraKeywords);
        joinsImpl.setSQLMapInfo(this.sqlMapInfo);
        if (this.aggInfos != null) {
            joinsImpl.setAggInfos(this.aggInfos);
        }
        this.dbQuery.setJoinsIntf(joinsImpl);
        for (int i = 0; i < sz; ++i) {
            PsqlJoin psqlJoin = (PsqlJoin)vJoins.elementAt(i);
            joinsImpl.addPsqlJoin(psqlJoin);
        }
        this.dbQuery.setObjParams(this.psqlQuery.getObjDrvParams());
        if (!this.serverLinks.isEmpty() || !this.serverSecurity.isEmpty() || this.sNode != null) {
            this.setServerSubLink();
        }
        if (this.bResolveRpt && this.rptServerLinks != null && !this.rptServerLinks.isEmpty()) {
            this.setRawServerSubLink();
        }
        if (this.bResolveRpt) {
            this.setRawWhereClause();
        } else {
            this.setWhereClause();
        }
        this.psqlQuery.setReplacedWhere(null);
        this.dbQuery.setWhereFilter(this.psqlQuery.getSimpleTableWhere());
        this.dbQuery.setJoinInfo(this.psqlQuery.getPsqlJoinsVector());
        this.dbQuery.setDbBufferInfo(this.dbBufferInfo);
        Vector unions = this.psqlQuery.getUnionVector();
        int unionSize = unions.size();
        if (unionSize > 0) {
            JetUQuery query = null;
            PsqlUnion union = null;
            RptPsqlQuery unionQuery = null;
            StringBuffer buffer = new StringBuffer(128);
            String sqlString = null;
            for (int i = 0; i < unionSize; ++i) {
                union = (PsqlUnion)unions.elementAt(i);
                query = this.unvs.GetQueryByResourceName(this.dataSourceName, union.getUnionQuery());
                if (query == null) continue;
                unionQuery = query.getPsqlQuery().getCopy();
                unionQuery.setModified();
                unionQuery.setRptUserName(this.rptUserName);
                this.putParamToPsqlBuf(unionQuery);
                unionQuery.resolveFormulaWhere(this.paramsBuff, this.getJavaFormula());
                if (unionQuery.isIgnorePredicateIfParamIsNull()) {
                    unionQuery.prepareWhereClauseString(this.paramsBuff, false);
                } else {
                    unionQuery.prepareWhereClauseString(null, false);
                }
                if (unionQuery.getRepreparedStatus()) {
                    this.putParamToPsqlBuf(unionQuery);
                }
                sqlString = this.bResolveRpt ? unionQuery.getUnionQueryString(false, unionQuery.getRawWhereClauseString(false, true)) : unionQuery.getUnionQueryString(false, unionQuery.getWhereClauseString(false, this.getJavaFormula()));
                buffer.append(" UNION ").append(union.isUnionAll() ? " ALL " : "").append(sqlString);
            }
            this.dbQuery.setUnion(buffer.toString());
        }
        this.dbQuery.setAddtionWhereString(this.pushDownWhereString);
        this.dbQuery.setJdbcDriversConfig(this.jdbcDriversConfig);
    }

    @Override
    protected void setUserDefinedSqlString() throws DSException {
        if (this.uQuery.enableSQLStmtCreator.get()) {
            this.initSQLStmtCreatorQueryInfo();
            if (this.queryInfo != null) {
                String sqlString = this.sqlStmtCreator.getSQLStmt(this.queryInfo);
                this.dbQuery.setSqlStatement(sqlString);
                this.dbQuery.setUserCreatedQuery(true);
            }
        }
    }

    private void initSQLStmtCreatorQueryInfo() throws DSException {
        block4: {
            if (this.sqlStmtCreator == null) {
                try {
                    this.sqlStmtCreator = this.unvs.createSQLStmtCreator(this.dataSourceName);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error("Failed to load the clss for  sql statement creator", e);
                }
            }
        }
        if (this.sqlStmtCreator != null && this.queryInfo == null) {
            this.queryInfo = QueryInfoBuilder.buildQueryInfo(this);
        }
    }

    public JetRptFormula getRptFormulaWhere() {
        if (this.fmlWhere != null) {
            return this.fmlWhere.createNewJetRptFmlInstance();
        }
        return null;
    }

    public Hashtable getCanbeSqlFormulaWhere() {
        Hashtable<JetUFormula, String> ret = new Hashtable<JetUFormula, String>();
        HashVector hvFormulas = this.getFormulasInLocalWhere();
        Hashtable fmls = this.psqlQuery.getFormulaValuePairs();
        Enumeration ufmls = fmls.keys();
        while (ufmls.hasMoreElements()) {
            JetUFormula ufml = (JetUFormula)ufmls.nextElement();
            JetRptFormula rptfml = ufml.createNewJetRptFmlInstance();
            String val = (String)fmls.get(ufml);
            if (hvFormulas != null) {
                if (this.inLocalWhereFormula(hvFormulas, rptfml)) continue;
                ret.put(ufml, val);
                continue;
            }
            ret.put(ufml, val);
        }
        return ret;
    }

    boolean inLocalWhereFormula(HashVector hvFormulas, JetRptFormula rptfml) {
        String name2 = rptfml.getName();
        Enumeration fmls = hvFormulas.Elements();
        while (fmls.hasMoreElements()) {
            JetRptFormula fml = (JetRptFormula)fmls.nextElement();
            if (!fml.getName().equalsIgnoreCase(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportServerSubLink() {
        return super.supportServerSubLink() ? this.psqlQuery.getUserDefinedQueryStmt().equals("") : false;
    }

    @Override
    public boolean supportOrderBy() {
        return super.supportOrderBy() ? this.psqlQuery.getUserDefinedQueryStmt().equals("") : false;
    }

    @Override
    public void setSubLinks(Vector theSubLinks) throws DSException, ParseFormulaFailedException {
        if (!(this.subLinks != null && theSubLinks != null && this.subLinks.size() == theSubLinks.size() || this.subLinks == null && theSubLinks == null)) {
            super.setSubLinks(theSubLinks);
            if (this.dbQuery == null) {
                return;
            }
            this.prepareBuffers();
            this.setServerSubLink();
            this.setWhereClause();
        }
    }

    protected void setPSQLQueryWhere() {
        this.putParamToPsqlBuf();
        this.psqlQuery.resolveFormulaWhere(this.paramsBuff, this.getJavaFormula());
        if (this.psqlQuery.isIgnorePredicateIfParamIsNull()) {
            this.psqlQuery.prepareWhereClauseString(this.paramsBuff, false);
        } else {
            this.psqlQuery.prepareWhereClauseString(null, false);
        }
        if (this.psqlQuery.getRepreparedStatus()) {
            this.putParamToPsqlBuf();
        }
        if (this.bResolveRpt) {
            this.strRawPSQLQueryWhere = this.psqlQuery.getRawWhereClauseString(false, true);
        } else {
            this.strPSQLQueryWhere = this.psqlQuery.getWhereClauseString(false, this.getJavaFormula());
        }
    }

    protected void setServerSubLink() {
        String strServerSecurity;
        String strQualifiedName;
        String strMapName;
        JetUResourceEntity entity;
        DbValueComparer link;
        int iSize = this.serverLinks.size();
        boolean bFirstLink = true;
        this.strSubLinkWhere = "";
        for (int i = 0; i < iSize; ++i) {
            link = (DbValueComparer)this.serverLinks.elementAt(i);
            if (this.psqlQuery.isIgnorePredicateIfParamIsNull() && link.value.isNull() || !((entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName = link.columnName)) instanceof JetUDBField)) continue;
            strQualifiedName = this.getQaulifiedName(strMapName);
            if (!bFirstLink) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            if (!(entity instanceof JetUCompColQueryField)) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                continue;
            }
            DbCompCol col = (DbCompCol)this.dbCompCols.get(strQualifiedName);
            if (col != null) {
                String str = this.psqlQuery.resolveMappingNames(col.getExpression(), this.getJavaFormula());
                this.strSubLinkWhere = this.strSubLinkWhere.concat(str + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                continue;
            }
            this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
        }
        if (this.hasReportRLS) {
            iSize = this.serverSecurity.size();
            boolean firstSec = true;
            for (int i = 0; i < iSize; ++i) {
                link = (DbValueComparer)this.serverSecurity.elementAt(i);
                strMapName = link.columnName;
                entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (!(entity instanceof JetUDBField)) continue;
                strQualifiedName = this.getQaulifiedName(strMapName);
                if (bFirstLink) {
                    bFirstLink = false;
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" ( ");
                    firstSec = false;
                } else if (!firstSec) {
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" or ");
                } else {
                    firstSec = false;
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ( ");
                }
                if (!(entity instanceof JetUCompColQueryField)) {
                    if (link.value instanceof DbDateTime) {
                        this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                        continue;
                    }
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(strQualifiedName + " " + link.getOperString() + " " + link.value);
                    continue;
                }
                DbCompCol col = (DbCompCol)this.dbCompCols.get(strQualifiedName);
                if (col != null) {
                    String str = this.psqlQuery.resolveMappingNames(col.getExpression(), this.getJavaFormula());
                    if (link.value instanceof DbDateTime) {
                        this.strSubLinkWhere = this.strSubLinkWhere.concat(str + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value));
                        continue;
                    }
                    this.strSubLinkWhere = this.strSubLinkWhere.concat(str + " " + link.getOperString() + " " + link.value);
                    continue;
                }
                this.strSubLinkWhere = link.value instanceof DbDateTime ? this.strSubLinkWhere.concat(strQualifiedName + link.getOperString() + this.getDbValueString(this.psqlQuery, link.value)) : this.strSubLinkWhere.concat(strQualifiedName + " " + link.getOperString() + " " + link.value);
            }
            if (!firstSec) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" ) ");
            }
        } else if (this.sNode != null && !StringTools.nullOrAllSpaces(strServerSecurity = this.sNode.getConditionString())) {
            if (!bFirstLink) {
                this.strSubLinkWhere = this.strSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            this.strSubLinkWhere = this.strSubLinkWhere.concat("( " + strServerSecurity + " )");
        }
    }

    protected void setRawServerSubLink() {
        boolean bFirstLink = true;
        this.strRawSubLinkWhere = "";
        for (int i = 0; i < this.rptServerLinks.size(); ++i) {
            JetRptSubLink link = (JetRptSubLink)this.rptServerLinks.elementAt(i);
            String strMapName = link.sNSubColumn;
            JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
            if (!(entity instanceof JetUDBField)) continue;
            if (!bFirstLink) {
                this.strRawSubLinkWhere = this.strRawSubLinkWhere.concat(" and ");
            } else {
                bFirstLink = false;
            }
            String strQualifiedName = this.getQaulifiedName(strMapName);
            String strOperator = link.sNOperator;
            String strRevOperator = strOperator.equals("<=") ? ">=" : (strOperator.equals(">=") ? "<=" : (strOperator.equals(">") ? "<" : (strOperator.equals(">") ? "<" : strOperator)));
            String strMainColumn = link.sNMainColumn;
            if (strMainColumn.indexOf(" ") != -1) {
                strMainColumn = '\"' + strMainColumn + '\"';
            }
            this.strRawSubLinkWhere = this.strRawSubLinkWhere + strQualifiedName + strRevOperator + "@" + strMainColumn;
        }
    }

    protected void setWhereClause() {
        String strWhereClause = null;
        if (this.strPSQLQueryWhere != null) {
            strWhereClause = this.strPSQLQueryWhere;
        }
        if (this.strSubLinkWhere != null && !this.strSubLinkWhere.equals("")) {
            strWhereClause = this.strPSQLQueryWhere == null || this.strPSQLQueryWhere.equals("") ? this.strSubLinkWhere : strWhereClause + " and (" + this.strSubLinkWhere + ")";
        }
        this.dbQuery.setWhereClause(strWhereClause);
    }

    protected void setRawWhereClause() {
        String strRawWhereClause = null;
        if (this.strRawPSQLQueryWhere != null) {
            strRawWhereClause = this.strRawPSQLQueryWhere;
        }
        if (this.strRawSubLinkWhere != null && !this.strRawSubLinkWhere.equals("")) {
            strRawWhereClause = this.strRawPSQLQueryWhere == null || this.strRawPSQLQueryWhere.equals("") ? this.strRawSubLinkWhere : strRawWhereClause + " and (" + this.strRawSubLinkWhere + ")";
        }
        this.dbQuery.setRawWhereClause(strRawWhereClause);
    }

    public String getDbValueString(RptPsqlQuery psqlQuery, DbValue value) {
        String strRet = value.toString();
        if (value instanceof DbChar) {
            strRet = RptPsqlQuery.convertStringString(strRet);
        } else if (value instanceof DbDateTime) {
            if (value instanceof DbDate) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getDateFormat());
            } else if (value instanceof DbTime) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getTimeFormat());
            } else if (value instanceof DbTimestamp) {
                strRet = ((DbDateTime)value).toFormatString(this.jCnnt.getTimestampFormat());
            }
            strRet = RptPsqlQuery.convertDateString(strRet, this.unvs, this.jCnnt, psqlQuery.getSupportInfo());
        }
        return strRet;
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        if (this.uQuery.enableSQLStmtCreator.get() && this.sqlStmtCreator != null) {
            this.initSQLStmtCreatorQueryInfo();
            QueryInfoBuilder.updateSubLinks(this.queryInfo, theSubLinks);
            String sqlString = this.sqlStmtCreator.getSQLStmt(this.queryInfo);
            this.dbQuery.setSqlStatement(sqlString);
            this.dbQuery.setUserCreatedQuery(true);
            return;
        }
        super.updateSubLink(theSubLinks);
        if (this.dbQuery == null) {
            return;
        }
        if (!this.serverLinks.isEmpty()) {
            this.setServerSubLink();
        }
        if (!this.paramLinks.isEmpty()) {
            this.setPSQLQueryWhere();
        }
        if (!this.serverLinks.isEmpty() || !this.paramLinks.isEmpty()) {
            this.setWhereClause();
        }
        this.updateUserDefinedQueryStmt();
    }

    @Override
    protected void prepareBuffers() throws DSException, ParseFormulaFailedException {
        if (this.dbQuery != null && !this.psqlQuery.hasUnion()) {
            UFakeColumn fColumn;
            int iColCount;
            int i;
            Vector vecCols;
            UFakeTable fTable;
            Object okey;
            int iTotalCol = 0;
            Enumeration e = this.dbTables.keys();
            while (e.hasMoreElements()) {
                okey = e.nextElement();
                fTable = (UFakeTable)this.fakeTables.get(okey);
                vecCols = fTable.cols;
                iTotalCol += vecCols.size();
            }
            if (this.CompCols != null) {
                iTotalCol += this.CompCols.size();
            }
            this.vecDbFields = new Vector(this.htDbFields.size() + 1);
            this.aiDbFieldsBackIndex = new int[iTotalCol + 1];
            for (i = 1; i < iTotalCol + 1; ++i) {
                this.aiDbFieldsBackIndex[i] = -1;
            }
            if (this.htDbFieldsInLocalWhere != null) {
                this.vecDbFieldsInLocalWhere = new Vector(this.htDbFieldsInLocalWhere.size() + 1);
                this.aiDbFieldsInLocalWhereBackIndex = new int[iTotalCol + 1];
                for (i = 1; i < iTotalCol + 1; ++i) {
                    this.aiDbFieldsInLocalWhereBackIndex[i] = -1;
                }
            }
            int iColIndex = 1;
            int idbFieldIndex = 1;
            int idbFieldInLocalWhereIndex = 1;
            Enumeration e2 = this.dbTables.keys();
            while (e2.hasMoreElements()) {
                okey = e2.nextElement();
                fTable = (UFakeTable)this.fakeTables.get(okey);
                vecCols = fTable.cols;
                iColCount = vecCols.size();
                for (int i2 = 0; i2 < iColCount; ++i2) {
                    fColumn = (UFakeColumn)vecCols.elementAt(i2);
                    if (fColumn.isFldInWhere) {
                        if (this.htDbFieldsInLocalWhere != null) {
                            this.vecDbFieldsInLocalWhere.addElement(fColumn.name);
                            this.aiDbFieldsInLocalWhereBackIndex[iColIndex] = idbFieldInLocalWhereIndex++;
                        }
                    } else {
                        this.vecDbFields.addElement(fColumn.name);
                        this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                    }
                    ++iColIndex;
                }
            }
            if (this.CompCols != null) {
                iColCount = this.CompCols.size();
                for (int i3 = 0; i3 < iColCount; ++i3) {
                    fColumn = (UFakeColumn)this.CompCols.elementAt(i3);
                    if (fColumn.isFldInWhere) {
                        if (this.htDbFieldsInLocalWhere != null) {
                            this.vecDbFieldsInLocalWhere.addElement(fColumn.name);
                            this.aiDbFieldsInLocalWhereBackIndex[iColIndex] = idbFieldInLocalWhereIndex++;
                        }
                    } else {
                        this.vecDbFields.addElement(fColumn.name);
                        this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                    }
                    ++iColIndex;
                }
            }
        } else if (this.dbQuery != null) {
            Vector selCols = this.psqlQuery.vSelCols;
            int iSize = selCols.size();
            this.vecDbFields = new Vector(iSize + 1);
            this.aiDbFieldsBackIndex = new int[iSize + 1];
            for (int i = 0; i < iSize; ++i) {
                this.vecDbFields.addElement(((PsqlSelColumn)selCols.elementAt(i)).getMappingName().toUpperCase());
                this.aiDbFieldsBackIndex[i] = i;
            }
            this.aiDbFieldsBackIndex[iSize] = iSize;
        }
        super.prepareBuffers();
        if (this.fmlWhere != null) {
            this.fmlsContainer.setFormulaWhere(this.fmlWhere.getResourceName(), this.fmlWhere);
        }
    }

    @Override
    public String getFormulaWhere() {
        if (this.fmlWhere != null) {
            return this.fmlWhere.getResourceName();
        }
        return null;
    }

    public String getInnerJoinCnd() {
        return this.psqlQuery.getInnerJoinCnd();
    }

    public String getWhereCnd() {
        return this.psqlQuery.getWhereCnd();
    }

    @Override
    protected Vector getTotalCols() {
        return this.uQuery.getFields();
    }

    @Override
    public JRColDesc[] getColDescs() {
        int iDbFldsCount = 0;
        if (this.vecDbFields != null) {
            iDbFldsCount += this.vecDbFields.size();
        }
        if (this.haveLocalWhere()) {
            iDbFldsCount += this.vecDbFieldsInLocalWhere.size();
        }
        if (iDbFldsCount > 0) {
            JRColDesc[] ColDescs = new JRColDesc[iDbFldsCount + 1];
            for (int i = 1; i <= iDbFldsCount; ++i) {
                String strFieldName;
                if (this.aiDbFieldsBackIndex[i] != -1) {
                    strFieldName = (String)this.vecDbFields.elementAt(this.aiDbFieldsBackIndex[i] - 1);
                } else {
                    assert (this.vecDbFieldsInLocalWhere != null && this.aiDbFieldsInLocalWhereBackIndex != null) : "Fields in formula can not be null";
                    strFieldName = (String)this.vecDbFieldsInLocalWhere.elementAt(this.aiDbFieldsInLocalWhereBackIndex[i] - 1);
                }
                DbColDesc coldesc = this.unvs.getSQLType(this.dataSourceName, this.strQueryName, strFieldName);
                ColDescs[i] = new JRColDesc(strFieldName, coldesc.getSqlType(), coldesc.getPrecision(), coldesc.getScale(), coldesc.getNullable());
            }
            return ColDescs;
        }
        return null;
    }

    public String[] getSelectColNames() {
        JRColDesc[] cols = this.getColDescs();
        if (cols != null) {
            String[] names = new String[cols.length - 1];
            for (int i = 1; i < cols.length; ++i) {
                names[i - 1] = cols[i].getColName();
            }
            return names;
        }
        return null;
    }

    public RptPsqlQuery getPsqlQuery() {
        return this.psqlQuery;
    }

    @Override
    public boolean metaChanged(ResultSet rs) throws SQLException {
        return !this.psqlQuery.getUserDefinedQueryStmt().equals("");
    }

    @Override
    public int[] updateColMap(ResultSet rst) throws SQLException {
        ResultSetMetaData metaData = rst.getMetaData();
        int[] se2rm = new int[metaData.getColumnCount() + 1];
        for (int i = 1; i < se2rm.length; ++i) {
            se2rm[i] = -1;
        }
        String[] expectFlds = this.getSelectColNames();
        int qlfOpt = this.jCnnt.getQualifiedNamePattern();
        block1: for (int i = 1; i < expectFlds.length + 1; ++i) {
            String expectFld = expectFlds[i - 1];
            String columnName = null;
            String tableName = null;
            String schemaName = null;
            String catalogName = null;
            JetUQueryField qryFld = (JetUQueryField)this.htDbFields.get(expectFld);
            if (qryFld == null) {
                qryFld = (JetUQueryField)this.htDbFieldsInLocalWhere.get(expectFld);
            }
            boolean bCompColOrAlliasTabCol = false;
            if (qryFld instanceof JetUCompColQueryField) {
                bCompColOrAlliasTabCol = true;
                columnName = qryFld.colName.get();
            } else {
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, null, expectFld);
                if (entity != null) {
                    JetUField uField = (JetUField)entity;
                    columnName = uField.colName.get();
                    JetUTableView uTable = uField.getTable();
                    tableName = uTable.tableName.get();
                    schemaName = uTable.owner.get();
                    catalogName = uTable.qualifier.get();
                } else {
                    bCompColOrAlliasTabCol = true;
                    JetUFldQueryField qField = (JetUFldQueryField)this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, expectFld);
                    columnName = qField.colName.get();
                }
            }
            for (int j = 1; j < se2rm.length; ++j) {
                boolean bEqual;
                if (se2rm[j] != -1) continue;
                if (bCompColOrAlliasTabCol) {
                    if (!columnName.equalsIgnoreCase(metaData.getColumnName(j))) continue;
                    se2rm[j] = i;
                    continue block1;
                }
                String tName = metaData.getTableName(j);
                boolean bl = bEqual = columnName.equalsIgnoreCase(metaData.getColumnName(j)) && (tName == null || tName.trim().length() < 1 || tableName.equalsIgnoreCase(tName));
                if (bEqual && qlfOpt >= 1) {
                    String schName = metaData.getSchemaName(j);
                    boolean bl2 = bEqual = schName == null || schName.trim().length() < 1 || schemaName.equalsIgnoreCase(schName);
                }
                if (bEqual && qlfOpt == 2) {
                    String catName = metaData.getCatalogName(j);
                    boolean bl3 = bEqual = catName == null || catName.trim().length() < 1 || catalogName.equalsIgnoreCase(catName);
                }
                if (!bEqual) continue;
                se2rm[j] = i;
                continue block1;
            }
        }
        return se2rm;
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.uQuery = null;
        this.psqlQuery = null;
        this.fmlWhere = null;
        if (this.htDbFieldsInLocalWhere != null) {
            this.htDbFieldsInLocalWhere.clear();
        }
        this.htDbFieldsInLocalWhere = null;
        this.fmlsInLocalWhere = null;
        if (this.vecFormulasInLocalWhere != null) {
            this.vecFormulasInLocalWhere.clear();
        }
        this.vecFormulasInLocalWhere = null;
        this.fakeTables = null;
        this.dbTables = null;
        this.dbCompCols = null;
        this.CompCols = null;
    }

    @Override
    void PrintInput() {
    }

    @Override
    void PrintInitialized() {
    }

    @Override
    void PrintDbQuery() {
    }

    @Override
    void PrintOutPut() {
    }

    @Override
    public void setSecPolicy(IExpression exp) {
        super.setSecPolicy(exp);
        if (this.psqlQuery != null) {
            Hashtable<Integer, String> htSpecFields = new Hashtable<Integer, String>();
            RptPsqlNameFinder nf = new RptPsqlNameFinder(this.psqlQuery);
            HDSWhereParser wp = new HDSWhereParser(this.unvs.getSingleThread() ? 0 : 10000, exp);
            CritNode node = wp.parse(nf);
            CritNode lNode = node.getLocalNode();
            this.strLocalSecurity = lNode.getFormulaString();
            if (!StringTools.nullOrAllSpaces(this.strLocalSecurity)) {
                this.mpNames = DbTools.getMappingNamesInRawSql(this.strLocalSecurity);
                for (int i = 0; i < this.mpNames.size(); ++i) {
                    String name2 = (String)this.mpNames.elementAt(i);
                    int specField = DbTools.isSpecialField(name2);
                    if (specField == -1) {
                        this.htMPNameDescPairs.put(name2, this.unvs.getSQLType(this.dataSourceName, this.strQueryName, name2));
                        continue;
                    }
                    if (specField != 0) continue;
                    htSpecFields.put(new Integer(specField), this.rptUserName);
                }
                this.secFilter = this.jCnnt != null ? new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs, this.jCnnt.getDateFormat(), this.jCnnt.getTimestampFormat(), this.jCnnt.getTimeFormat()) : new RecordFilter(this.strLocalSecurity, this.htMPNameDescPairs);
                this.secFilter.setSpecFields(htSpecFields);
                this.secFilter.setParameters(this.paramsBuff);
            }
            if (this.supportServerSubLink()) {
                this.sNode = node.getServerNode();
            }
        }
    }

    private void updateUserDefinedQueryStmt() {
        String udqs = this.psqlQuery.getUserDefinedQueryStmt();
        if (!udqs.equals("")) {
            JetUJdbcSupportInfo spinfo;
            Vector v;
            JetUJDBCConnection uc;
            Vector vPos;
            Hashtable htSpecFields;
            Hashtable htFVPairs;
            Hashtable htPOPairs;
            Hashtable<Object, ParamDesc> htPVPairs;
            if (FileQuery.parseStatement(udqs = SqlCommentsTool.removeComments(udqs), htPVPairs = new Hashtable<Object, ParamDesc>(5), htPOPairs = new Hashtable(5), htFVPairs = new Hashtable(5), htSpecFields = new Hashtable(), vPos = new Vector(2), this.unvs, this.dataSourceName, uc = (JetUJDBCConnection)(v = this.unvs.getDatabase(this.dataSourceName).getConnections()).elementAt(0), spinfo = (JetUJdbcSupportInfo)uc.getSupportInfo(), null, this.rptUserName)) {
                boolean last = false;
                int sz = vPos.size();
                for (int i = 0; i < sz; ++i) {
                    PointEx point = (PointEx)vPos.elementAt(i);
                    Object o = htPOPairs.get(point);
                    if (!(o instanceof JetUParameter)) continue;
                    ParamDesc p = (ParamDesc)this.paramsBuff.get(((JetUParameter)o).getResourceNameInUpperCase());
                    htPVPairs.put(o, p);
                }
                Set set = this.paramsBuff.keySet();
                for (Object element : set) {
                    String parameterName;
                    JetUResourceEntity entity;
                    if (!(element instanceof String) || !((entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, parameterName = (String)element)) instanceof JetUParameter)) continue;
                    JetUParameter jetUParameter = (JetUParameter)entity;
                    ParamDesc paramDesc = (ParamDesc)this.paramsBuff.get(parameterName.toUpperCase());
                    htPVPairs.put(jetUParameter, paramDesc);
                }
                udqs = FileQuery.getResolvedStatement(udqs, htPVPairs, htPOPairs, htFVPairs, htSpecFields, vPos, this.unvs, this.dataSourceName, uc, spinfo, null);
            }
            this.dbQuery.setUserDefinedQueryStmt(udqs);
        }
    }
}

