/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.datasource.JDSDataField;
import com.jinfonet.dataservice.api.schema.relational.datasource.relational.JRdbDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import com.jinfonet.util.JRLog;
import java.awt.Frame;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbColDesc;
import jet.connect.DbQuery;
import jet.connect.DbValue;
import jet.connect.RecordFilter;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine8.core.queryengine.transform.AggInfos;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.datasource.JRColDesc;
import jet.datasource.JRExternalQueryRunner;
import jet.datasource.JRResultSet;
import jet.datasource.JRResultSetException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.exception.UserException;
import jet.formula.FormulaInfo;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.VarsTable;
import jet.log.JRLogger;
import jet.report.JetRptSubLink;
import jet.rptengine.RptFormulaContainer;
import jet.server.api.SecurityContext;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWherePortion;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.universe.engine.UFileQueryEngine;
import jet.universe.engine.UHDSEngine;
import jet.universe.engine.UMongoEngine;
import jet.universe.engine.UProcedureEngine;
import jet.universe.engine.UPsqlQueryEngine;
import jet.universe.engine.UUDSEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.mongodb.JetUMongoConnection;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.RptPsqlTools;
import jet.universe.resultfile.UResultFileResultSet;
import jet.util.DbValueComparer;
import jet.util.HashVector;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;
import toolkit.db.PsqlTable;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.gui.JdbcDatabase;
import toolkit.db.queryoptimization.ColumnInfo;
import toolkit.db.queryoptimization.ConnectionInfo;
import toolkit.db.queryoptimization.Optimizer;
import toolkit.db.queryoptimization.QueryInfo;
import toolkit.db.queryoptimization.QueryOptimizer;

public abstract class UQueryEngine {
    protected JetUUniverse unvs;
    protected String strQueryName;
    protected String dataSourceName = "";
    protected Vector mappingFlds;
    protected Vector groupParams;
    protected Vector subLinks;
    protected Vector rptSubLinks;
    protected Vector[] aOrderBys;
    protected String strWherePortion;
    protected String strWherePortionName;
    protected String orderBy;
    protected JetUJDBCConnection jCnnt = null;
    protected Hashtable htDbFields = new Hashtable();
    protected RptFormulaContainer fmlsContainer = null;
    protected Hashtable htDbFieldsInLocalWhere = null;
    protected RptFormulaContainer fmlsInLocalWhere = null;
    protected Vector vecDbFields = null;
    protected int[] aiDbFieldsBackIndex = new int[0];
    protected Vector vecDbFieldsInLocalWhere = null;
    protected int[] aiDbFieldsInLocalWhereBackIndex = new int[0];
    protected HashVector vecFormulas = null;
    protected HashVector vecFormulasInLocalWhere = null;
    protected Hashtable paramsBuff = new Hashtable();
    protected Vector serverLinks = new Vector();
    protected Vector localLinks = new Vector();
    protected Vector paramLinks = new Vector();
    protected Vector rptServerLinks = null;
    protected Vector rptLocalLinks = null;
    protected Vector rptParamLinks = null;
    protected String strURL = null;
    protected String strUID = null;
    protected String strPSWD = null;
    protected String strJdbcDriver = null;
    private String sJNDIdatasource = null;
    protected boolean bUseDefaultConnection = true;
    protected boolean bStarted = false;
    protected DbQuery dbQuery = null;
    protected ResultSet rs = null;
    protected File flResultFile = null;
    protected boolean bUseResultFile = false;
    protected boolean bUseDSDriver = false;
    protected boolean bUseCacheQuery = false;
    protected UDSDriver dsdriver = null;
    protected boolean bUseUserDataSource = false;
    protected boolean bRunnerStart = false;
    protected JRExternalQueryRunner jreqRunner = null;
    private boolean bIsJinfonetOOJDBCDriver = false;
    protected String sqlStatement = "";
    private boolean isDynamic = false;
    protected transient int[] dbBufferInfo = null;
    protected Connection userDbConnection = null;
    protected ResultSet userResultSet = null;
    private boolean fetchSupportInfo = false;
    int id;
    protected boolean bResolveRpt = false;
    protected Vector serverSecurity = new Vector();
    protected Vector localSecurity = new Vector();
    protected boolean hasReportRLS;
    protected String strLocalSecurity;
    protected Vector mpNames = new Vector();
    protected Hashtable htMPNameDescPairs;
    protected RecordFilter secFilter;
    boolean cache = false;
    Vector paramNames = new Vector();
    protected SecurityContext secCxt = null;
    private AttributeContainer attributeContainer = null;
    private static JRLogger logger = JRLogger.getLogger(UQueryEngine.class.getName());
    protected String userTimeZone = "";
    protected String rptUserName;
    protected String pushDownWhereString;
    protected JdbcDriversConfig jdbcDriversConfig;
    private boolean needCloseSettingConnection;
    private JavaFormula jf = null;
    private boolean bDistinct = false;
    Hashtable constantFV = null;
    AggInfos aggInfos = null;
    Hashtable reportFormulas = null;

    public void setUserTimeZone(String userTimeZone) {
        this.userTimeZone = userTimeZone;
        if (this.unvs != null) {
            this.unvs.setUserTimeZone(userTimeZone);
        }
    }

    public void setConstantFormulaValues(Hashtable cfv) {
        this.constantFV = cfv;
    }

    public DbValue getConstantFormulaValue(String mappingname) {
        if (this.constantFV == null) {
            return null;
        }
        return (DbValue)this.constantFV.get(mappingname.toUpperCase());
    }

    public void setDistinct(boolean bDistinct) {
        this.bDistinct = bDistinct;
    }

    public boolean isDistinct() {
        return this.bDistinct;
    }

    public void setJavaFormula(JavaFormula jf) {
        this.jf = jf;
    }

    public JavaFormula getJavaFormula() {
        return this.jf;
    }

    public UQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        this(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, null, bUseResultFile, null);
    }

    public UQueryEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile, RptPsqlQuery psqlQuery) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        String strJdbcDriver;
        this.unvs = unvs;
        this.mappingFlds = mappingFlds;
        this.groupParams = groupParams;
        this.subLinks = subLinks;
        this.bUseResultFile = bUseResultFile;
        this.rptSubLinks = rptSubLinks;
        this.setQuery(dataSourceName, strQueryName, psqlQuery);
        JetUQueriable jQuery = null;
        JetUConnection cnnt = null;
        if (psqlQuery != null) {
            cnnt = psqlQuery.getUConnection();
        } else {
            jQuery = this.unvs.getQueriableByResourceName(dataSourceName, strQueryName);
            JetUConnection[] cons = jQuery.getConnections();
            if (cons != null && cons.length > 0) {
                cnnt = cons[0];
            } else if (jQuery instanceof JetUUserDataSource) {
                cnnt = unvs.getDatabase(dataSourceName).getConnection();
            }
        }
        if (cnnt != null && cnnt instanceof JetUJDBCConnection) {
            this.jCnnt = (JetUJDBCConnection)cnnt;
        } else {
            if (jQuery instanceof JetUFileQuery) {
                throw new CannotFindEntity(true, ((JetUFileQuery)jQuery).connectionName.get());
            }
            if (jQuery instanceof JetUProcedure) {
                throw new CannotFindEntity(true, ((JetUProcedure)jQuery).connectionName.get());
            }
        }
        String string = strJdbcDriver = this.jCnnt == null ? null : this.jCnnt.getJdbcDriver();
        if (strJdbcDriver != null && strJdbcDriver.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            this.bIsJinfonetOOJDBCDriver = true;
        }
    }

    protected void setQuery(String strQueryName) {
        this.setQuery("", strQueryName, null);
    }

    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery psqlQuery) {
        this.strQueryName = strQueryName;
        this.dataSourceName = dataSourceName;
    }

    public void setConnection(String strURL, String strUID, String strPSWD, String strJdbcDriver) {
        this.strURL = strURL;
        this.strUID = strUID;
        this.strPSWD = strPSWD;
        this.strJdbcDriver = strJdbcDriver;
        if (strJdbcDriver != null && strJdbcDriver.equals("com.jinfonet.jdbc.obj.ObjectDriver")) {
            this.bIsJinfonetOOJDBCDriver = true;
        }
        this.bUseDefaultConnection = false;
    }

    public void setNeedCloseSettingConnection(boolean needCloseSettingConnection) {
        this.needCloseSettingConnection = needCloseSettingConnection;
    }

    public boolean needCloseSettingConnection() {
        return this.needCloseSettingConnection;
    }

    public void setConnection(Connection userDbConnection) {
        this.userDbConnection = userDbConnection;
    }

    public void setUserResultSet(ResultSet userResultSet) {
        this.userResultSet = userResultSet;
    }

    public void setFetchSupportInfo(boolean fetchSupportInfo) {
        this.fetchSupportInfo = fetchSupportInfo;
    }

    public void setDSDriver(String strDriver) throws LoadUserDataSourceException {
        if (strDriver != null && !strDriver.equals("")) {
            try {
                this.dsdriver = new UDSDriver(strDriver);
                this.bUseCacheQuery = strDriver.startsWith("jrquery:/jet.universe.resultfile.UResultFileResultSet");
                this.bUseDSDriver = !this.dsdriver.isDefaultDriver();
            }
            catch (UDSDriverFormatException e) {
                throw new LoadUserDataSourceException(0, "");
            }
        } else {
            this.bUseDSDriver = false;
        }
    }

    public void setExternalQueryRunner(JRExternalQueryRunner jreqRunner) {
        this.jreqRunner = jreqRunner;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setSecurityContext(SecurityContext sc) {
        this.secCxt = sc;
    }

    abstract void initParamNamesInQry() throws LoadUserDataSourceException;

    public void initialize() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException, DSException {
        if (this instanceof UHDSEngine) {
            this.cache = false;
        } else if (this instanceof UPsqlQueryEngine) {
            JetUQuery uqry = this.unvs.GetQueryByResourceName(this.dataSourceName, this.strQueryName);
            if (uqry.enableSQLStmtCreator.get()) {
                this.cache = false;
            }
        }
        if (this.cache) {
            this.initParamNamesInQry();
        }
        if (!this.bResolveRpt) {
            this.initGroupParameters();
            this.initSubLink();
        } else {
            this.initRptSubLink();
        }
        this.initMappingFields();
        this.initLocalWhere();
        this.initQuery();
        if (!this.bResolveRpt) {
            this.initParamLink();
        }
    }

    protected void initSubLink() throws CannotFindEntity, SubLinkError {
        this.serverLinks.removeAllElements();
        this.localLinks.removeAllElements();
        this.paramLinks.removeAllElements();
        if (this.subLinks != null) {
            DbValueComparer link;
            int iSize = this.subLinks.size();
            for (int i = 0; i < iSize; ++i) {
                link = (DbValueComparer)this.subLinks.elementAt(i);
                String strMapName = link.columnName;
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (entity == null) {
                    throw new CannotFindEntity(strMapName);
                }
                if (entity instanceof JetUDBField) {
                    this.serverLinks.addElement(link);
                    continue;
                }
                if (entity instanceof JetUFormulaInterface) {
                    this.localLinks.addElement(link);
                    continue;
                }
                if (entity instanceof JetUParameter) {
                    if (this.cache && this.paramNames.contains(link.columnName)) {
                        this.cache = false;
                    }
                    if (link.operator != 0) {
                        throw new SubLinkError(link.columnName);
                    }
                    this.paramLinks.addElement(link);
                    continue;
                }
                assert (false) : "Unknow type of field";
            }
            if (!this.supportServerSubLink() || this.cache) {
                int i;
                Vector<DbValueComparer> vecServerToLocalLinks = new Vector<DbValueComparer>();
                iSize = this.serverLinks.size();
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.serverLinks.elementAt(i);
                    vecServerToLocalLinks.addElement(link);
                }
                iSize = vecServerToLocalLinks.size();
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)vecServerToLocalLinks.elementAt(i);
                    this.serverLinks.removeElement(link);
                    this.localLinks.addElement(link);
                }
            }
        }
    }

    public void setRecSec(Vector recConds) throws CannotFindEntity {
        int iSize;
        this.serverSecurity.removeAllElements();
        this.localSecurity.removeAllElements();
        if (recConds != null) {
            iSize = recConds.size();
            for (int i = 0; i < iSize; ++i) {
                DbValueComparer link = (DbValueComparer)recConds.elementAt(i);
                String strMapName = link.columnName;
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (entity == null) {
                    throw new CannotFindEntity(strMapName);
                }
                if (entity instanceof JetUDBField && this.supportServerSubLink()) {
                    this.serverSecurity.addElement(link);
                    continue;
                }
                this.localSecurity.addElement(link);
            }
        }
        if (this.localSecurity.size() > 0) {
            iSize = this.serverSecurity.size();
            for (int i = 0; i < iSize; ++i) {
                this.localSecurity.addElement(this.serverSecurity.elementAt(i));
            }
            this.serverSecurity.removeAllElements();
        }
    }

    public void setSecPolicy(IExpression exp) {
        if (this.hasReportRLS) {
            return;
        }
        if (this.mpNames == null) {
            this.mpNames = new Vector();
        } else {
            this.mpNames.removeAllElements();
        }
        if (this.htMPNameDescPairs == null) {
            this.htMPNameDescPairs = new Hashtable();
        }
    }

    public RecordFilter getLocalSecFilter() {
        return this.secFilter;
    }

    public void setReportRLS(boolean b) {
        this.hasReportRLS = b;
    }

    protected void initRptSubLink() throws CannotFindEntity, SubLinkError {
        if (this.rptSubLinks != null) {
            JetRptSubLink link;
            int i;
            this.rptServerLinks = new Vector(3);
            this.rptLocalLinks = new Vector(3);
            this.rptParamLinks = new Vector(3);
            int iSize = this.rptSubLinks.size();
            for (i = 0; i < iSize; ++i) {
                link = (JetRptSubLink)this.rptSubLinks.elementAt(i);
                String strMapName = link.sNSubColumn;
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (entity == null) {
                    throw new CannotFindEntity(strMapName);
                }
                if (entity instanceof JetUDBField) {
                    this.rptServerLinks.addElement(link);
                    continue;
                }
                if (entity instanceof JetUFormulaInterface) {
                    this.rptLocalLinks.addElement(link);
                    continue;
                }
                if (!(entity instanceof JetUParameter)) continue;
                if (!link.sNOperator.equals(DbValueComparer.strOper[0])) {
                    throw new SubLinkError(link.sNMainColumn);
                }
                this.rptParamLinks.addElement(link);
            }
            if (!this.supportServerSubLink()) {
                iSize = this.rptServerLinks.size();
                for (i = 0; i < iSize; ++i) {
                    link = (JetRptSubLink)this.rptServerLinks.elementAt(i);
                    this.rptLocalLinks.addElement(link);
                    this.rptServerLinks.removeElement(link);
                }
            }
        }
    }

    public void setSubLinks(Vector theSubLinks) throws DSException, ParseFormulaFailedException {
        block3: {
            this.subLinks = theSubLinks;
            try {
                this.initSubLink();
                if (this.haveLocalWhere()) {
                    this.initLocalWhere();
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error("", e);
            }
        }
    }

    protected void initParamLink() throws SubLinkError {
        if (!this.paramLinks.isEmpty()) {
            int iSize = this.paramLinks.size();
            DbValueComparer link = null;
            try {
                for (int i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.paramLinks.elementAt(i);
                    this.setParameterValue(link.columnName, link.value);
                }
            }
            catch (InvalidParameterException e) {
                throw new SubLinkError(link.columnName);
            }
        }
    }

    protected void initGroupParameters() {
        if (this.groupParams != null && !this.groupParams.isEmpty()) {
            int iSize = this.groupParams.size();
            for (int i = 0; i < iSize; ++i) {
                String strParamName = (String)this.groupParams.elementAt(i);
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strParamName);
                if (!(entity instanceof JetUParameter)) continue;
                this.putParameter(strParamName.toUpperCase(), (JetUParameter)entity, 1);
            }
        }
    }

    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        int iFldCount = this.mappingFlds.size();
        this.fmlsContainer = this.dataSourceName == null ? new RptFormulaContainer(this.unvs, this.strQueryName) : new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        String dsName = this.dataSourceName;
        for (int i = 0; i < iFldCount; ++i) {
            JetUResourceEntity en;
            String strRscName = (String)this.mappingFlds.elementAt(i);
            JetUResourceEntity entity = dsName != null ? this.unvs.getResourceByName(dsName, this.strQueryName, strRscName) : this.unvs.getResourceByName(this.strQueryName, strRscName);
            if (entity == null && (en = this.unvs.getAnyResourceByName(strRscName)) != null && en instanceof JetUParameter) {
                entity = en;
            }
            if (entity == null) {
                throw new CannotFindEntity(strRscName);
            }
            if (entity instanceof JetUDBField) {
                this.htDbFields.put(strRscName, entity);
                continue;
            }
            if (entity instanceof JetUFormulaInterface) {
                this.putFormula(this.fmlsContainer, strRscName, (JetUFormulaInterface)((Object)entity));
                continue;
            }
            if (entity instanceof JetUParameter) {
                this.putParameter(strRscName.toUpperCase(), (JetUParameter)entity);
                continue;
            }
            assert (false) : "Unknow type of field";
        }
        this.putRefFldsToBuf(this.fmlsContainer, this.htDbFields);
        this.putRefParamToBuf(this.fmlsContainer);
    }

    protected void initLocalWhere() throws QueryWhereFormulaGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, FormulaRingException, ParseFormulaFailedException, CannotUseGlobalVarInFrmlWhere, CannotFindFrmlRefFld, FormulaHasGrammarError, DSException {
        if (this.haveLocalWhere()) {
            this.htDbFieldsInLocalWhere = new Hashtable();
            this.fmlsInLocalWhere = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
            this.putFormulasInLocalWhereToBuffer();
            VarsTable gVarTable = new VarsTable();
            gVarTable.addOnlyUserName();
            this.fmlsInLocalWhere.parseFormulas(true, gVarTable);
            VarsTable table = (VarsTable)this.fmlsInLocalWhere.getGVarTable().clone();
            table.remove("USERNAME");
            if (table.size() != 0) {
                throw new CannotUseGlobalVarInFrmlWhere();
            }
            this.putFldsInLocalLinkToBuf();
            this.putRefFldsToBuf(this.fmlsInLocalWhere, this.htDbFieldsInLocalWhere);
            this.putRefParamToBuf(this.fmlsInLocalWhere);
        }
    }

    public boolean haveLocalWhere() {
        return !this.localLinks.isEmpty() || this.secFilter != null || !this.localSecurity.isEmpty();
    }

    protected void putFormulasInLocalWhereToBuffer() throws FormulaHasGrammarError, QueryWhereFormulaGrammarError, DSException, ParseFormulaFailedException {
        block5: {
            block4: {
                JetUResourceEntity entity;
                String strMapName;
                DbValueComparer link;
                int i;
                int iSize;
                if (!this.localLinks.isEmpty()) {
                    iSize = this.localLinks.size();
                    for (i = 0; i < iSize; ++i) {
                        link = (DbValueComparer)this.localLinks.elementAt(i);
                        strMapName = link.columnName;
                        entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                        if (!(entity instanceof JetUFormulaInterface)) continue;
                        this.putFormula(this.fmlsInLocalWhere, strMapName, (JetUFormulaInterface)((Object)entity));
                    }
                }
                if (this.localSecurity.isEmpty()) break block4;
                iSize = this.localSecurity.size();
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.localSecurity.elementAt(i);
                    strMapName = link.columnName;
                    entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                    if (!(entity instanceof JetUFormulaInterface)) continue;
                    this.putFormula(this.fmlsInLocalWhere, strMapName, (JetUFormulaInterface)((Object)entity));
                }
                break block5;
            }
            if (this.mpNames == null) break block5;
            int iSize = this.mpNames.size();
            for (int i = 0; i < iSize; ++i) {
                String strMapName = (String)this.mpNames.elementAt(i);
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (!(entity instanceof JetUFormulaInterface)) continue;
                this.putFormula(this.fmlsInLocalWhere, strMapName, (JetUFormulaInterface)((Object)entity));
            }
        }
    }

    protected void putFldsInLocalLinkToBuf() {
        block5: {
            block4: {
                JetUResourceEntity entity;
                String strMapName;
                DbValueComparer link;
                int i;
                int iSize;
                if (!this.localLinks.isEmpty()) {
                    iSize = this.localLinks.size();
                    for (i = 0; i < iSize; ++i) {
                        link = (DbValueComparer)this.localLinks.elementAt(i);
                        strMapName = link.columnName;
                        entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                        if (!(entity instanceof JetUDBField)) continue;
                        this.htDbFieldsInLocalWhere.put(entity.getResourceNameInUpperCase(), entity);
                    }
                }
                if (this.localSecurity.isEmpty()) break block4;
                iSize = this.localSecurity.size();
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.localSecurity.elementAt(i);
                    strMapName = link.columnName;
                    entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                    if (!(entity instanceof JetUDBField)) continue;
                    this.htDbFieldsInLocalWhere.put(entity.getResourceNameInUpperCase(), entity);
                }
                break block5;
            }
            if (this.mpNames == null) break block5;
            int iSize = this.mpNames.size();
            for (int i = 0; i < iSize; ++i) {
                String strMapName = (String)this.mpNames.elementAt(i);
                JetUResourceEntity entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (!(entity instanceof JetUDBField)) continue;
                this.htDbFieldsInLocalWhere.put(entity.getResourceNameInUpperCase(), entity);
            }
        }
    }

    protected void purifyFmlsInLocalWhereCon() {
        HashVector hashFrmls = this.fmlsInLocalWhere.getFormulas();
        int iCount = hashFrmls.size();
        for (int i = iCount - 1; i >= 0; --i) {
            String key = (String)hashFrmls.elementAt(i);
            if (!this.fmlsContainer.containsReal(key)) continue;
            this.fmlsInLocalWhere.removeFrml(key);
        }
    }

    protected void purifyFldsInLocalWhereCon() throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Enumeration e = this.htDbFieldsInLocalWhere.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JetUResourceEntity entity = (JetUResourceEntity)this.htDbFieldsInLocalWhere.get(key);
            if (!this.htDbFields.containsKey(key)) continue;
            this.htDbFieldsInLocalWhere.remove(key);
        }
    }

    protected abstract void initQuery() throws LoadUserDataSourceException;

    public void initParameters() throws ParameterNotResolved, CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, DSException, ParseFormulaFailedException {
        this.putMapFldsInParamToBuff();
    }

    protected void putMapFldsInParamToBuff() throws ParameterNotResolved, CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, DSException, ParseFormulaFailedException {
        RptFormulaContainer fmlsInParamContainer = new RptFormulaContainer(this.unvs, this.dataSourceName, this.strQueryName);
        if (this.groupParams != null) {
            Enumeration e = this.paramsBuff.elements();
            while (e.hasMoreElements()) {
                ParamDesc p = (ParamDesc)e.nextElement();
                if (!this.groupParams.contains(p.name.toUpperCase()) || !p.isColumnCal()) continue;
                String strRscName = p.getInternalValue().toUpperCase();
                if (strRscName == null) {
                    throw new ParameterNotResolved(p.name);
                }
                JetUResourceEntity re = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strRscName);
                if (re == null && this.groupParams != null && this.groupParams.contains(p.name.toUpperCase())) {
                    throw new CannotFindEntity(strRscName);
                }
                if (re instanceof JetUDBField) {
                    this.htDbFields.put(strRscName, re);
                    continue;
                }
                if (re instanceof JetUFormulaInterface) {
                    this.putFormula(this.fmlsContainer, strRscName, (JetUFormulaInterface)((Object)re));
                    this.putFormula(fmlsInParamContainer, strRscName, (JetUFormulaInterface)((Object)re));
                    continue;
                }
                if (re instanceof JetUParameter) {
                    this.putParameter(strRscName.toUpperCase(), (JetUParameter)re);
                    String binding = ((JetUParameter)re).getBinding();
                    if (binding == null) continue;
                    re = this.unvs.getMaterialByName(this.dataSourceName, binding);
                    this.putParameter(binding.toUpperCase(), (JetUParameter)re);
                    continue;
                }
                assert (false) : "Unknow type of field";
            }
        }
        this.putRefFldsToBuf(fmlsInParamContainer, this.htDbFields);
        this.putRefParamToBuf(fmlsInParamContainer);
    }

    protected JdbcDatabase createJdbcDatabase(int iIsolation, int iReadOnly) {
        if (this.userDbConnection != null) {
            JdbcDatabase ret = new JdbcDatabase(this.userDbConnection);
            ret.setNeedCloseSettingConnection(this.needCloseSettingConnection);
            return ret;
        }
        if (this.bUseDefaultConnection) {
            this.strURL = this.jCnnt.getURL();
            this.strUID = this.jCnnt.getUID();
            this.strPSWD = this.jCnnt.getPSWD();
            this.strJdbcDriver = this.jCnnt.getJdbcDriver();
        } else {
            if (this.strURL == null) {
                this.strURL = this.jCnnt.getURL();
            }
            if (this.strUID == null) {
                this.strUID = this.jCnnt.getUID();
            }
            if (this.strPSWD == null) {
                this.strPSWD = this.jCnnt.getPSWD();
            }
            if (this.strJdbcDriver == null) {
                this.strJdbcDriver = this.jCnnt.getJdbcDriver();
            }
        }
        JdbcDatabase ret = new JdbcDatabase(this.strURL, this.strUID, this.strPSWD, this.strJdbcDriver, DbTools.mergeTransactionIsolation(this.jCnnt.getTransactionIsolation(), iIsolation), DbTools.mergeReadOnly(this.jCnnt.getReadOnly(), iReadOnly));
        ret.setNeedCloseSettingConnection(this.needCloseSettingConnection);
        return ret;
    }

    protected abstract void createDbQuery() throws FldNotFoundInQuery, SubLinkError, LoadUserDataSourceException, JRUserDataSourceException, JRResultSetException;

    protected void setUserSupportInfoRptPsql() {
    }

    protected void prepareBuffers() throws DSException, ParseFormulaFailedException {
        block3: {
            JetUResourceEntity entity;
            String strMapName;
            int i;
            block4: {
                DbValueComparer link;
                this.vecFormulas = this.fmlsContainer.getFormulas();
                if (!this.haveLocalWhere()) break block3;
                this.vecFormulasInLocalWhere = this.fmlsInLocalWhere.getFormulas();
                int iSize = this.localLinks.size();
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.localLinks.elementAt(i);
                    strMapName = link.columnName;
                    entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                    if (!(entity instanceof JetUFormulaInterface)) continue;
                    this.fmlsContainer.setFormulaWhere(strMapName, (JetUFormulaInterface)((Object)entity));
                }
                iSize = this.localSecurity.size();
                if (iSize <= 0) break block4;
                for (i = 0; i < iSize; ++i) {
                    link = (DbValueComparer)this.localSecurity.elementAt(i);
                    strMapName = link.columnName;
                    entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                    if (!(entity instanceof JetUFormulaInterface)) continue;
                    this.fmlsContainer.setFormulaWhere(strMapName, (JetUFormulaInterface)((Object)entity));
                }
                break block3;
            }
            if (this.mpNames == null) break block3;
            for (i = 0; i < this.mpNames.size(); ++i) {
                strMapName = (String)this.mpNames.elementAt(i);
                entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
                if (!(entity instanceof JetUFormulaInterface)) continue;
                this.fmlsContainer.setFormulaWhere(strMapName, (JetUFormulaInterface)((Object)entity));
            }
        }
    }

    protected void putParameter(String strRscName, JetUParameter uParam, int bInGroup) {
        if (!this.paramsBuff.containsKey(strRscName)) {
            JetUParameter param;
            ParamDesc parameter = uParam.getParamDesc();
            parameter.setBeColumn(bInGroup);
            this.paramsBuff.put(strRscName, parameter);
            String binding = parameter.getBinding();
            String colName = parameter.getColumn();
            if (binding != null && (param = (JetUParameter)this.unvs.getMaterialByName(this.dataSourceName, binding)) != null) {
                parameter = param.getParamDesc();
                parameter.setBeColumn(5);
                this.paramsBuff.put(binding.toUpperCase(), parameter);
            }
            if (bInGroup == 0 && colName != null && colName.length() > 0) {
                parameter.setBeColumn(4);
            }
            if (uParam.isReferPara()) {
                Hashtable referUParam = new Hashtable();
                uParam.getAllReferP(this.unvs, this.dataSourceName, this.strQueryName, referUParam);
                Enumeration e = referUParam.keys();
                while (e.hasMoreElements()) {
                    String name2 = (String)e.nextElement();
                    if (this.mappingFlds.contains(name2.toUpperCase())) continue;
                    this.putParameter(name2.toUpperCase(), (JetUParameter)referUParam.get(name2));
                }
            }
        }
    }

    protected void putParameter(String strRscName, JetUParameter uParam) {
        this.putParameter(strRscName, uParam, 0);
    }

    public void setParameterValue(String strRscName, DbValue value) throws InvalidParameterException {
        block0: {
            ParamDesc parameter = (ParamDesc)this.paramsBuff.get(strRscName);
            if (parameter == null) break block0;
            parameter.set(value);
        }
    }

    public void setParameterValue(String strRscName, String value) throws InvalidParameterException {
        block0: {
            ParamDesc parameter = (ParamDesc)this.paramsBuff.get(strRscName);
            if (parameter == null) break block0;
            parameter.setValue(value, ParamDesc.defaultLocale);
        }
    }

    protected void putRefFldsToBuf(RptFormulaContainer fmlsContainer, Hashtable htDbFields) throws CannotFindFrmlRefFld, FormulaHasGrammarError {
        Hashtable refFields = fmlsContainer.getRefDbFlds();
        Enumeration e = refFields.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JetUResourceEntity entity = (JetUResourceEntity)refFields.get(key);
            if (entity != null) {
                key = entity.getResourceName();
            }
            if (htDbFields.containsKey(key)) continue;
            htDbFields.put(key, entity);
        }
    }

    protected void putRefParamToBuf(RptFormulaContainer frmlContainer) throws CannotFindFrmlRefFld {
        Hashtable htRefParams = frmlContainer.getRefParameters();
        if (htRefParams != null) {
            Enumeration e = htRefParams.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                JetUParameter entity = (JetUParameter)htRefParams.get(key);
                this.putParameter(key.toUpperCase(), entity);
            }
        }
    }

    public boolean supportServerSubLink() {
        return !this.bUseResultFile && !this.bUseDSDriver && !this.bIsJinfonetOOJDBCDriver;
    }

    public boolean supportOrderBy() {
        return !this.bUseResultFile && !this.bUseDSDriver && !this.bIsJinfonetOOJDBCDriver;
    }

    public void setWherePortionName(String strName) {
        this.strWherePortionName = strName;
        this.strWherePortion = this.unvs.getWherePortion(this.dataSourceName, strName);
    }

    public void setWherePortionString(String strWherePortion) {
        this.strWherePortion = strWherePortion;
    }

    public JetUWherePortion getUWherePortion() {
        return this.unvs.getUWherePortion(this.dataSourceName, this.strWherePortionName);
    }

    public String getWherePortionString() {
        return this.strWherePortion;
    }

    public Vector getSubLinks() {
        return this.subLinks;
    }

    public Vector[] getOrderBys() {
        return this.aOrderBys;
    }

    public JetUJDBCConnection getConnection() {
        return this.jCnnt;
    }

    public String getQueryName() {
        return this.strQueryName;
    }

    public void setOrderBy(Vector mapFlds, Vector sorts) {
        this.aOrderBys = new Vector[]{mapFlds, sorts};
        String orderBy = this.prepareOrderByString(mapFlds, sorts);
        if (this.dbQuery != null && !orderBy.equals("")) {
            this.dbQuery.setOrderByClause(orderBy);
        }
    }

    protected String prepareOrderByString(Vector mapFlds, Vector sorts) {
        if (this.jCnnt != null) {
            StringBuffer strbuf = new StringBuffer("");
            int iSize = mapFlds.size();
            for (int i = 0; i < iSize; ++i) {
                String strField = (String)mapFlds.elementAt(i);
                String strSort = (String)sorts.elementAt(i);
                String strQualifiedName = this.getQaulifiedName(strField);
                strbuf.append(strQualifiedName);
                strbuf.append(" ");
                strbuf.append(strSort);
                strbuf.append(",");
            }
            String orderby = strbuf.toString();
            if (orderby.length() > 0) {
                orderby = orderby.substring(0, orderby.length() - 1);
            }
            return orderby;
        }
        return null;
    }

    protected JetUSupportInfo getSupportInfo() {
        JetUJdbcSupportInfo ret = this.getUserSupportInfo();
        if (ret != null) {
            return ret;
        }
        return this.jCnnt.getSupportInfo();
    }

    protected String getQaulifiedName(String strMapName) {
        int qlfOpt = this.jCnnt.getQualifiedNamePattern();
        JetUSupportInfo suppInfo = this.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strQuoteChar = suppInfo.getQuoteChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        JetUResourceEntity entity = this.unvs.getMaterialByName(this.dataSourceName, strMapName);
        if (entity == null || !(entity instanceof JetUDBField)) {
            entity = this.unvs.getResourceByName(this.dataSourceName, this.strQueryName, strMapName);
        }
        if (entity != null && entity instanceof JetUDBField) {
            String strQualifiedName;
            JetUDBField dbFld = (JetUDBField)((Object)entity);
            String strColumnName = dbFld.getFldName();
            boolean bHive = this.jCnnt.isHive();
            if (entity instanceof JetUField && !bHive) {
                JetUTableView table = dbFld.getTable();
                String strQualifier = table.getQualifier();
                String strOwner = table.getOwner();
                String strTableName = null;
                if (table.isAlias()) {
                    strTableName = RptPsqlTools.UTableToPsqlTable(table, false).getCorrelationName();
                    strQualifiedName = DbTools.quotedWhenNeed(strTableName, strExtraNameChar, strQuoteChar, strExtraKeywords) + "." + DbTools.quotedWhenNeed(strColumnName, strExtraNameChar, strQuoteChar, strExtraKeywords);
                } else {
                    strTableName = table.getTableName();
                    strQualifiedName = PsqlTable.getQaulifiedName(qlfOpt, strQualifier, strOwner, strTableName, table.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, null) + "." + DbQuery.quotedWhenNeed(strColumnName, strExtraNameChar, strQuoteChar, strExtraKeywords);
                }
            } else if (entity instanceof JetUFldQueryField && !bHive) {
                String strTableAlias = ((JetUFldQueryField)dbFld).getTableAlias();
                strQualifiedName = DbQuery.quotedWhenNeed(strTableAlias, strExtraNameChar, strQuoteChar, strExtraKeywords) + "." + DbQuery.quotedWhenNeed(strColumnName, strExtraNameChar, strQuoteChar, strExtraKeywords);
            } else {
                strQualifiedName = DbQuery.quotedWhenNeed(strColumnName, strExtraNameChar, strQuoteChar, strExtraKeywords);
            }
            return strQualifiedName;
        }
        if (entity == null) {
            assert (false) : "Can not find entity";
        } else assert (false) : "mapping name is not a JetUDBField";
        return null;
    }

    protected void checkParameters() throws ParameterNotResolved {
        Enumeration e = this.paramsBuff.elements();
        while (e.hasMoreElements()) {
            ParamDesc p = (ParamDesc)e.nextElement();
            if (p.getInternalValue() != null) continue;
            throw new ParameterNotResolved(p.name);
        }
    }

    public void start() throws ParameterNotResolved, FldNotFoundInQuery, SubLinkError, CannotFindFrmlRefFld, FormulaHasGrammarError, LoadUserDataSourceException, JRUserDataSourceException, JRResultSetException, DSException, ParseFormulaFailedException {
        if (!this.bResolveRpt) {
            this.checkParameters();
        }
        if (this.haveLocalWhere()) {
            this.purifyFmlsInLocalWhereCon();
            this.purifyFldsInLocalWhereCon();
        }
        if (this.jCnnt != null || this.bUseUserDataSource) {
            this.setUserSupportInfoRptPsql();
            this.createDbQuery();
            this.prepareBuffers();
            this.setUserDefinedSqlString();
        }
    }

    protected abstract void setUserDefinedSqlString() throws DSException;

    public JetUJdbcSupportInfo getUserSupportInfo() {
        JetUJdbcSupportInfo suppInfo = null;
        if (this.fetchSupportInfo && this.userDbConnection != null) {
            suppInfo = new JetUJdbcSupportInfo();
            suppInfo.fetchJDBCSupportInfo(this.userDbConnection);
        } else if (this.fetchSupportInfo && !this.bUseDefaultConnection) {
            if (this.strURL == null) {
                this.strURL = this.jCnnt.getURL();
            }
            if (this.strUID == null) {
                this.strUID = this.jCnnt.getUID();
            }
            if (this.strPSWD == null) {
                this.strPSWD = this.jCnnt.getPSWD();
            }
            if (this.strJdbcDriver == null) {
                this.strJdbcDriver = this.jCnnt.getJdbcDriver();
            }
            try {
                Connection dbcon = ConnectionsBroker.getConnection(this.strURL, this.strUID, this.strPSWD, this.strJdbcDriver, this.jCnnt.getTransactionIsolation(), this.jCnnt.getReadOnly());
                if (dbcon != null) {
                    suppInfo = new JetUJdbcSupportInfo();
                    suppInfo.fetchJDBCSupportInfo(dbcon);
                    ConnectionsBroker.freeConnection(dbcon);
                }
            }
            catch (Exception e) {
                logger.debug(e);
            }
        }
        return suppInfo;
    }

    public void updateSubLink(Vector theSubLinks) throws DSException {
        int iSize;
        if (theSubLinks == null) {
            return;
        }
        int theiSize = theSubLinks.size();
        if (theiSize == (iSize = this.subLinks.size())) {
            for (int i = 0; i < iSize; ++i) {
                DbValueComparer link = (DbValueComparer)this.subLinks.elementAt(i);
                DbValueComparer theLink = (DbValueComparer)theSubLinks.elementAt(i);
                if (!link.columnName.equals(theLink.columnName)) continue;
                link.value = theLink.value;
            }
        }
        try {
            this.initParamLink();
        }
        catch (SubLinkError e) {
            // empty catch block
        }
    }

    public void end() throws SQLException {
        block8: {
            if (this.rs != null && (this.dbQuery == null || this.dbQuery.getRS() != this.rs)) {
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Exception e) {
                    this.rs = null;
                }
            }
            if (this.dbQuery != null && this.bStarted) {
                this.bStarted = false;
                if (this.sqlStatement == null || this.sqlStatement.trim().length() <= 0) {
                    this.sqlStatement = this.dbQuery.getSqlStatement(true);
                }
                try {
                    this.dbQuery.close();
                    this.dbQuery = null;
                    this.rs = null;
                }
                catch (Exception EQ) {
                    this.dbQuery = null;
                    this.rs = null;
                    if (!logger.isErrorEnabled()) break block8;
                    logger.error("", EQ);
                }
            }
        }
        if (this.jreqRunner != null && this.bRunnerStart) {
            this.jreqRunner.releaseResultSet(this.rs);
        }
    }

    public void closeResultSet() throws SQLException {
        if (this.rs != null && (this.dbQuery == null || this.dbQuery.getRS() != this.rs)) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Exception e) {
                this.rs = null;
            }
        }
    }

    protected void putFormula(RptFormulaContainer fmlsContainer, String strRscName, JetUFormulaInterface fmlinterface) throws FormulaHasGrammarError, DSException, ParseFormulaFailedException {
        FormulaInfo formulainfo = fmlinterface.getFormulaInfo();
        if (!formulainfo.parseOK) {
            throw new FormulaHasGrammarError(strRscName);
        }
        fmlsContainer.putFormula(strRscName, fmlinterface);
    }

    public void setResultFile(File flResultFile) {
        this.flResultFile = flResultFile;
        this.bUseResultFile = true;
    }

    public String getSqlStatement() {
        if (this.dbQuery != null) {
            this.sqlStatement = this.dbQuery.getSqlStatement(true);
            return this.sqlStatement;
        }
        return this.sqlStatement;
    }

    public String getRawSqlStatement() {
        if (this.dbQuery != null) {
            return this.dbQuery.getSqlStatement(false);
        }
        return "";
    }

    public void setResultSet(ResultSet rs) {
        if (this.rs != null && this.rs != rs) {
            block4: {
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error("", e);
                }
            }
            if (this.dbQuery != null) {
                this.dbQuery.refresh();
            }
        }
        this.rs = rs;
    }

    public ResultSet getResultSet() throws SQLException, ClassNotFoundException, LoadUserDataSourceException, ParameterFormatInvalid, DSException {
        try {
            ResultSet ret;
            long start = 0L;
            if (this.htDbFields.isEmpty() && (this.htDbFieldsInLocalWhere == null || this.htDbFieldsInLocalWhere.isEmpty())) {
                return null;
            }
            if (this.userResultSet != null) {
                ret = this.userResultSet;
            } else {
                if (this.rs == null) {
                    if (this.bUseDSDriver) {
                        JRColDesc[] colDescs = this.getColDescs();
                        if (colDescs != null) {
                            String strClassName = null;
                            String[] strParams = null;
                            try {
                                strClassName = this.dsdriver.getClassName();
                                strParams = this.dsdriver.getParams();
                                Class<?> clsDataSource = Class.forName(strClassName);
                                Object oDataSource = clsDataSource.newInstance();
                                if (!(oDataSource instanceof JRResultSet)) {
                                    throw new LoadUserDataSourceException(0, strClassName);
                                }
                                this.rs = (ResultSet)oDataSource;
                                ((JRResultSet)this.rs).initialize(colDescs, strParams);
                            }
                            catch (ClassNotFoundException e) {
                                throw new LoadUserDataSourceException(1, strClassName);
                            }
                            catch (InstantiationException e) {
                                throw new LoadUserDataSourceException(2, strClassName);
                            }
                            catch (IllegalAccessException e) {
                                throw new LoadUserDataSourceException(3, strClassName);
                            }
                        }
                    } else if (this.bUseResultFile) {
                        Vector colMap = this.getColumnMap();
                        this.rs = new UResultFileResultSet(this.flResultFile, colMap);
                    } else {
                        this._getResultSet();
                    }
                }
                ret = this.rs;
            }
            return ret;
        }
        catch (SQLException e) {
            this.end();
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.end();
            throw e;
        }
        catch (ParameterFormatInvalid e) {
            this.end();
            throw e;
        }
    }

    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid, DSException {
        if (this.dbQuery != null) {
            if (this.jreqRunner != null) {
                this.rs = this.jreqRunner.getResultSet(this.dbQuery.getSqlStatement(true));
                this.bRunnerStart = true;
            } else {
                String sOptimizer;
                this.bStarted = true;
                if (this.isDynamic) {
                    this.dbQuery.setSqlStatement(this.sqlStatement);
                }
                if (this.jCnnt != null && (sOptimizer = this.jCnnt.customQueryOptimizer.get()) != null && sOptimizer.trim().length() > 0) {
                    QueryOptimizer optimizer = null;
                    try {
                        optimizer = this.unvs.createCustomQueryOptimzer(this.dataSourceName);
                    }
                    catch (Exception e) {
                        throw new DSException(2151, new Object[0], (Throwable)e);
                    }
                    ConnectionInfo conInfo = null;
                    conInfo = this.sJNDIdatasource != null ? new ConnectionInfo(this.sJNDIdatasource, this.strUID, this.strPSWD) : new ConnectionInfo(this.strJdbcDriver, this.strURL, this.strUID, this.strPSWD);
                    Optimizer ret = optimizer.optimizeQuery(new QueryInfo(this.dbQuery.getSqlStatement(), this.rptUserName, conInfo, this.buildColumnInfos()));
                    if (ret.shouldBeCanceled()) {
                        throw new DSException(2150, new Object[]{ret.getCancelMessage()});
                    }
                    this.dbQuery.setSqlStatement(ret.getOptimizedSqlString());
                    this.dbQuery.setUserCreatedQuery(true);
                    List colInfos = ret.getColumnInfos();
                    int iSize = colInfos.size();
                    for (int i = 0; i < iSize; ++i) {
                        ColumnInfo info = (ColumnInfo)colInfos.get(i);
                        JAttribute dbfield = this.attributeContainer.getElementByAliasName(info.getMappingName());
                        if (!(dbfield instanceof RdbDataField)) continue;
                        ((RdbDataField)dbfield).setFieldIndex(info.getColumnIndex());
                    }
                }
                try {
                    this.rs = this.dbQuery.getResultSet();
                }
                catch (JRStopEngineException jRStopEngineException) {
                    // empty catch block
                }
            }
        }
    }

    public Vector getDbFlds() {
        return this.vecDbFields;
    }

    public int[] getDbFldsBackIndex() {
        return this.aiDbFieldsBackIndex;
    }

    public Vector getDbFldsInLocalWhere() {
        return this.vecDbFieldsInLocalWhere;
    }

    public int[] getDbFldsInLocalWhereBackIndex() {
        return this.aiDbFieldsInLocalWhereBackIndex;
    }

    public RptFormulaContainer getFormulaContainer() {
        return this.fmlsContainer;
    }

    public HashVector getFormulas() {
        return this.vecFormulas;
    }

    public HashVector getFormulasInLocalWhere() {
        return this.vecFormulasInLocalWhere;
    }

    public VarsTable getFormulasGVarTable() {
        return this.fmlsContainer.getGVarTable();
    }

    public Hashtable getParamsBuff() {
        return this.paramsBuff;
    }

    public ParamDesc getParameter(String name2) {
        return (ParamDesc)this.paramsBuff.get(name2.toUpperCase());
    }

    public String getFormulaWhere() {
        return null;
    }

    public Vector getLocalLinks() {
        return this.localLinks;
    }

    public Vector getLocalSecurity() {
        return this.localSecurity;
    }

    public boolean metaChanged(ResultSet rs) throws SQLException {
        return false;
    }

    public int[] updateColMap(ResultSet rst) throws SQLException {
        return null;
    }

    protected abstract Vector getTotalCols();

    public abstract JRColDesc[] getColDescs();

    public Vector getColumnMap() {
        int iTotalCol;
        if (this instanceof UPsqlQueryEngine) {
            iTotalCol = this.vecDbFields.size();
            if (this.haveLocalWhere()) {
                iTotalCol += this.vecDbFieldsInLocalWhere.size();
            }
        } else {
            iTotalCol = this.getTotalCols().size();
        }
        Vector<DbColDesc> vecColDescs = new Vector<DbColDesc>();
        String strFieldName = null;
        DbColDesc coldesc = null;
        int index = 0;
        for (int i = 1; i <= iTotalCol; ++i) {
            strFieldName = null;
            if (this.aiDbFieldsBackIndex[i] != -1) {
                strFieldName = (String)this.vecDbFields.elementAt(this.aiDbFieldsBackIndex[i] - 1);
                index = this.aiDbFieldsBackIndex[i] - 1;
            } else if (this.haveLocalWhere()) {
                strFieldName = (String)this.vecDbFieldsInLocalWhere.elementAt(this.aiDbFieldsInLocalWhereBackIndex[i] - 1);
                index = this.aiDbFieldsInLocalWhereBackIndex[i] - 1;
            }
            if (strFieldName == null) continue;
            coldesc = this.unvs.getSQLType(this.dataSourceName, this.strQueryName, strFieldName);
            coldesc.setColName(strFieldName);
            if (index == vecColDescs.size()) {
                vecColDescs.add(coldesc);
                continue;
            }
            if (index > vecColDescs.size()) {
                int size = vecColDescs.size();
                for (int addedNullIndex = 0; addedNullIndex < index - size; ++addedNullIndex) {
                    vecColDescs.add(null);
                }
                vecColDescs.add(coldesc);
                continue;
            }
            vecColDescs.setElementAt(coldesc, index);
        }
        return vecColDescs;
    }

    public Vector getFmlsColDescs() {
        DbColDesc desc;
        JetRptFormula f;
        String s;
        Enumeration e;
        Vector<DbColDesc> vColDescs = new Vector<DbColDesc>(5);
        Hashtable<String, DbColDesc> extColDescs = new Hashtable<String, DbColDesc>();
        if (this.vecFormulas != null && this.vecFormulas.size() != 0) {
            e = this.vecFormulas.keys();
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                f = (JetRptFormula)this.vecFormulas.get(s);
                desc = (DbColDesc)extColDescs.get(s);
                if (desc == null) {
                    desc = f.getColDesc();
                    desc.setColName(s);
                    extColDescs.put(s, desc);
                }
                if (f.isConstant()) {
                    desc.setConstant(true);
                }
                vColDescs.addElement(desc);
            }
        }
        if (this.vecFormulasInLocalWhere != null && this.vecFormulasInLocalWhere.size() != 0) {
            e = this.vecFormulasInLocalWhere.keys();
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                f = (JetRptFormula)this.vecFormulasInLocalWhere.get(s);
                desc = (DbColDesc)extColDescs.get(s);
                if (desc == null) {
                    desc = f.getColDesc();
                    desc.setColName(s);
                    extColDescs.put(s, desc);
                }
                if (f.isConstant()) {
                    desc.setConstant(true);
                }
                vColDescs.addElement(desc);
            }
        }
        return vColDescs;
    }

    public void clearMem() {
        this.unvs = null;
        this.mappingFlds = null;
        this.orderBy = null;
        this.subLinks = null;
        if (this.htDbFields != null) {
            this.htDbFields.clear();
        }
        this.htDbFields = null;
        this.fmlsContainer = null;
        if (this.paramsBuff != null) {
            this.paramsBuff.clear();
        }
        this.paramsBuff = null;
        if (this.vecDbFields != null) {
            this.vecDbFields.removeAllElements();
        }
        this.vecDbFields = null;
        if (this.vecFormulas != null) {
            this.vecFormulas.clear();
        }
        this.vecFormulas = null;
        if (this.dbQuery != null && this.bStarted) {
            try {
                this.end();
            }
            catch (Exception e) {
                logger.debug(e);
            }
        }
        this.rs = null;
        this.jCnnt = null;
    }

    public static UQueryEngine createEngine(JetUUniverse unvs, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(unvs, "", strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
    }

    public static UQueryEngine createEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, null, bUseResultFile, null);
    }

    public static UQueryEngine createEngine(JetUUniverse unvs, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        return UQueryEngine.createEngine(unvs, "", strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, null);
    }

    public static UQueryEngine createEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLinks, Vector rptSubLinks, boolean bUseResultFile, RptPsqlQuery demandPsqlQuery) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError {
        JetUConnection cnnt;
        UQueryEngine engine = null;
        JetUQueriable uQuery = unvs.getQueriableByResourceName(dataSourceName, strQueryName);
        JetUConnection[] cnnts = demandPsqlQuery == null ? uQuery.getConnections() : null;
        JetUConnection jetUConnection = cnnt = demandPsqlQuery == null ? null : demandPsqlQuery.getUConnection();
        if (cnnt == null && cnnts != null && cnnts.length > 0) {
            cnnt = cnnts[0];
        }
        if (uQuery != null) {
            if (uQuery instanceof JetUQuery) {
                engine = cnnt != null && cnnt instanceof JetUMongoConnection ? new UMongoEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, demandPsqlQuery) : new UPsqlQueryEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile, demandPsqlQuery);
            } else if (uQuery instanceof JetUFileQuery) {
                engine = new UFileQueryEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, rptSubLinks, bUseResultFile);
            } else if (uQuery instanceof JetUProcedure) {
                engine = new UProcedureEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
            } else if (uQuery instanceof JetUUserDataSource) {
                engine = new UUDSEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
            } else if (uQuery instanceof JetUHierDataSource) {
                engine = new UHDSEngine(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLinks, bUseResultFile);
            }
        } else {
            throw new CannotFindQuery(strQueryName);
        }
        return engine;
    }

    void PrintInput() {
    }

    void PrintInitialized() {
    }

    void PrintParameters() {
    }

    void PrintOrderBy(Vector mapFlds, Vector sorts) {
    }

    void PrintServerSubLink(String where) {
    }

    void PrintDbQuery() {
    }

    void PrintOutPut() {
    }

    public void setID(int id) {
        this.id = id;
    }

    public String toString() {
        return super.toString() + '@' + this.id;
    }

    public DbQuery getDBQuery() {
        return this.dbQuery;
    }

    public boolean isJinfonetOOJDBCDriver() {
        return this.bIsJinfonetOOJDBCDriver;
    }

    public HashVector checkDAG(Frame frame, Hashtable formulaToSection, Vector groupOrder, Hashtable parameters) {
        HashVector ret;
        block2: {
            ret = null;
            try {
                ret = this.fmlsContainer.checkDAG(frame, formulaToSection, groupOrder, parameters);
            }
            catch (UserException ue) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, ue);
            }
        }
        return ret;
    }

    public Hashtable getFormulaToSection() {
        return this.fmlsContainer.getFormulaToSection();
    }

    public void setDbBufferInfo(int[] dbBufferInfo) {
        this.dbBufferInfo = dbBufferInfo;
    }

    public void setResolveRpt(boolean b) {
        this.bResolveRpt = b;
    }

    public void setRptUserName(String name2) {
        if (this instanceof UPsqlQueryEngine) {
            ((UPsqlQueryEngine)this).psqlQuery.setRptUserName(name2);
        } else if (this instanceof UHDSEngine) {
            ((UHDSEngine)this).uHDS.setRptUserName(name2);
        }
        this.rptUserName = name2;
    }

    public String getRptUserName() {
        return this.rptUserName;
    }

    public void setAddtionWhereString(String pushDownWhereString) {
        this.pushDownWhereString = pushDownWhereString;
    }

    public void setSQLStatement(String sqlStatement) {
        this.isDynamic = true;
        this.sqlStatement = sqlStatement;
    }

    public void setJdbcDriversConfig(JdbcDriversConfig jdbcDriversConfig) {
        this.jdbcDriversConfig = jdbcDriversConfig;
    }

    public void setAggInfos(AggInfos agginfos) {
        this.aggInfos = agginfos;
    }

    public void setJNDIdatasource(String strJNDI, String strUID, String strPSWD) {
        this.sJNDIdatasource = strJNDI;
        this.strUID = strUID;
        this.strPSWD = strPSWD;
    }

    public void setAttributeContainer(AttributeContainer attributeContainer) {
        this.attributeContainer = attributeContainer;
    }

    public AttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    private ArrayList buildColumnInfos() {
        JDSDataField[] dbfields = this.attributeContainer.getAllDBFields();
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>(dbfields.length);
        for (int i = 0; i < dbfields.length; ++i) {
            if (!(dbfields[i] instanceof JRdbDataField)) continue;
            JRdbDataField dataField = (JRdbDataField)dbfields[i];
            columnInfos.add(new ColumnInfo(dataField.getAliasName(), dataField.getFieldIndex()));
        }
        return columnInfos;
    }

    public void setReportLevelFormula(Hashtable reportFormulas) {
        this.reportFormulas = reportFormulas;
    }
}

