/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.engine;

import com.jinfonet.ibus.InformationBus;
import com.jinfonet.util.loader.DynamicClassManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.bean.EngSInfo;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.datasource.JRColDesc;
import jet.datasource.JREnhancedUserDataSource;
import jet.datasource.JRParameter;
import jet.datasource.JRResultSet;
import jet.datasource.JRResultSetException;
import jet.datasource.JRSecurityUserDataSource;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.JRUserInformationDataSource;
import jet.datasource.JRUserInstanceDataSource;
import jet.datasource.JRUserServerInfoDataSource;
import jet.datasource.LoadUserDataSourceException;
import jet.datasource.ProcedureUDS;
import jet.datasource.enterprisedb.EnterpriseDbProcedureUDS;
import jet.datasource.oracle.OracleProcedureUDS;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.DataTypeDef;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.log.JRLogger;
import jet.report.JetRptColumn;
import jet.report.JetRptDBField;
import jet.server.api.ServerInfo;
import jet.universe.JetField;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.RptPsqlQuery;
import jet.util.DbValueFormat;
import jet.util.ReportFormat;
import toolkit.db.DbTools;
import toolkit.db.ParameterFormatInvalid;

public class UUDSEngine
extends UQueryEngine {
    protected JetUUserDataSource uUDS;
    JRUserDataSource userDataSource = null;
    JRResultSet oldUserDataSource = null;
    boolean bOldUDS = false;
    String strResolvedParameter = null;
    Hashtable htParameters = new Hashtable();
    Hashtable cols = new Hashtable();
    private static String NULL = " ";
    private static String delimeter = ",";
    private static JRLogger logger = JRLogger.getLogger(UUDSEngine.class.getName());
    private EngSInfo engsinfo = null;
    private ServerInfo serverInfo;
    private InformationBus ibus = null;
    private static char strParaValueSeparator = (char)44;
    private static char strParaValueTranferSymbol = (char)92;
    public static String inparamvalue = "INPARAMVALUE";
    private static char strParaValueSeparatorSeamless = (char)59;
    private static char strParaSeparator = (char)38;
    boolean isRelease = false;

    public UUDSEngine(JetUUniverse unvs, String dataSourceName, String strQueryName, Vector mappingFlds, Vector groupParams, Vector subLink, boolean bUseResultFile) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, SubLinkError {
        super(unvs, dataSourceName, strQueryName, mappingFlds, groupParams, subLink, bUseResultFile);
        this.bUseUserDataSource = true;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public InformationBus getInformationBus() {
        return this.ibus;
    }

    public void setInformationBus(InformationBus ibus) {
        this.ibus = ibus;
    }

    public void setInstance(EngSInfo engsinfo) {
        this.engsinfo = engsinfo;
    }

    public EngSInfo getInstance() {
        return this.engsinfo;
    }

    @Override
    protected void setQuery(String dataSourceName, String strQueryName, RptPsqlQuery demandPsqlQuery) {
        super.setQuery(dataSourceName, strQueryName, demandPsqlQuery);
        this.uUDS = (JetUUserDataSource)this.unvs.getQueriableByResourceName(dataSourceName, strQueryName);
    }

    @Override
    protected void initMappingFields() throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, FldNotFoundInQuery, DSException, ParseFormulaFailedException {
        super.initMappingFields();
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
            if (!(dbfld instanceof JetUUDSField)) {
                throw new FldNotFoundInQuery(this.strQueryName, (String)key);
            }
            if (((JetUUDSField)dbfld).getUDS() == this.uUDS) continue;
            throw new FldNotFoundInQuery(this.strQueryName, (String)key);
        }
    }

    @Override
    public void updateSubLink(Vector theSubLinks) throws DSException {
        super.updateSubLink(theSubLinks);
        if (!this.paramLinks.isEmpty()) {
            this.putParameterToDataSource();
        }
    }

    @Override
    void initParamNamesInQry() throws LoadUserDataSourceException {
        this.initQuery();
    }

    @Override
    protected void initQuery() throws LoadUserDataSourceException {
        this.initQuery(false);
    }

    protected void initQuery(boolean cache) throws LoadUserDataSourceException {
        String strClassName = this.uUDS.getUDSClassName();
        try {
            Class clsUDS = DynamicClassManager.getInstance().getClass(strClassName);
            Object objUDS = clsUDS.newInstance();
            if (objUDS instanceof JRUserDataSource) {
                this.userDataSource = (JRUserDataSource)objUDS;
                this.bOldUDS = false;
                if (this.userDataSource instanceof JRUserServerInfoDataSource) {
                    ((JRUserServerInfoDataSource)this.userDataSource).setServerInfo(this.serverInfo);
                }
                if (this.userDataSource instanceof JRUserInstanceDataSource) {
                    ((JRUserInstanceDataSource)this.userDataSource).setInstance(this.engsinfo);
                }
            } else if (objUDS instanceof JRResultSet) {
                this.oldUserDataSource = (JRResultSet)objUDS;
                this.bOldUDS = true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new LoadUserDataSourceException(1, strClassName);
        }
        catch (InstantiationException e) {
            throw new LoadUserDataSourceException(2, strClassName);
        }
        catch (IllegalAccessException e) {
            throw new LoadUserDataSourceException(3, strClassName);
        }
        try {
            if (cache) {
                this.putParamInUDSToBuf(true);
            } else {
                this.putParamInUDSToBuf();
            }
        }
        catch (JRUserDataSourceException e) {
            throw new LoadUserDataSourceException(3, "Can not load the parameter to a Properties object.");
        }
    }

    protected void putParamInUDSToBuf() throws JRUserDataSourceException {
        this.putParamInUDSToBuf(false);
    }

    protected void putParamInUDSToBuf(boolean cache) throws JRUserDataSourceException {
        if (!this.bOldUDS && this.userDataSource instanceof JREnhancedUserDataSource) {
            Vector vecParamNames = ((JREnhancedUserDataSource)this.userDataSource).getParameterNames(this.uUDS.getParameter());
            int iSize = vecParamNames.size();
            String paramName = null;
            for (int i = 0; i < iSize; ++i) {
                paramName = (String)vecParamNames.elementAt(i);
                if (cache) {
                    this.paramNames.add(paramName.toUpperCase());
                    continue;
                }
                this.putParamToBuf(paramName);
            }
        } else {
            StringBuffer strBuf = new StringBuffer(this.uUDS.getParameter());
            String strParamName = null;
            while ((strParamName = DbTools.getFirstParameterNameInString(strBuf, new StringBuffer())) != null) {
                if (cache) {
                    this.paramNames.add(strParamName.toUpperCase());
                    continue;
                }
                this.putParamToBuf(strParamName);
            }
        }
    }

    protected void putParamToBuf(String strParamName) {
        if (DbTools.isSpecialField(strParamName) != -1) {
            return;
        }
        JetUDatabase udb = this.unvs.getDatabase(this.dataSourceName);
        JetUResourceEntity re = udb.getResourceByName(strParamName);
        if (re != null && re instanceof JetUParameter) {
            JetUParameter up = (JetUParameter)re;
            ParamDesc parameter = up.getParamDesc();
            String colName = parameter.getColumn();
            if (parameter.getBeColumn() == 0 && colName != null && colName.length() > 0) {
                parameter.setBeColumn(4);
            } else {
                parameter.setBeColumn(0);
            }
            this.paramsBuff.put(strParamName.toUpperCase(), parameter);
        }
    }

    protected void putParameterToDataSource() {
        if (!this.bOldUDS && this.userDataSource instanceof JREnhancedUserDataSource) {
            String strParamName = null;
            JRParameter jrParam = null;
            Enumeration e = this.paramsBuff.keys();
            while (e.hasMoreElements()) {
                strParamName = (String)e.nextElement();
                ParamDesc rptParam = (ParamDesc)this.paramsBuff.get(strParamName);
                jrParam = new JRParameter(rptParam);
                this.htParameters.put(strParamName, jrParam);
            }
        } else {
            StringBuffer retStr = new StringBuffer();
            StringBuffer strBuf = new StringBuffer(this.uUDS.getParameter());
            String originality = strBuf.toString();
            StringBuffer strBefore = new StringBuffer();
            String strParamName = null;
            Hashtable paramFormats = this.uUDS.getNameFormatPair();
            String spInParameterValue = null;
            String spParameterValue = null;
            if (this.isSeamlessUDS(this.userDataSource)) {
                try {
                    Properties prop = OracleProcedureUDS.string2Properties(originality);
                    spInParameterValue = prop.getProperty(inparamvalue);
                    spParameterValue = prop.getProperty("PARAMVALUE");
                }
                catch (JRUserDataSourceException ue) {
                    // empty catch block
                }
            }
            boolean bEscape = false;
            while ((strParamName = DbTools.getFirstParameterNameInString(strBuf, strBefore)) != null) {
                ParamDesc rp2 = (ParamDesc)this.paramsBuff.get(strParamName.toUpperCase());
                DbValue constantValue = null;
                if (rp2 == null) {
                    constantValue = this.getConstantFormulaValue(strParamName.toUpperCase());
                }
                if (this.isSeamlessUDS(this.userDataSource)) {
                    if (spInParameterValue != null && spInParameterValue.indexOf(strParamName) != -1) {
                        bEscape = true;
                    } else if (spParameterValue != null && spParameterValue.indexOf(strParamName) != -1) {
                        bEscape = true;
                    }
                }
                if (rp2 != null) {
                    retStr.append(strBefore);
                    String format = (String)paramFormats.get(strParamName);
                    if (!rp2.type.equalsIgnoreCase("String") && format != null) {
                        String oldFormat = rp2.getFormat();
                        rp2.setFormat(format);
                        if (bEscape && this.isSeamlessUDS(this.userDataSource)) {
                            retStr.append(UUDSEngine.addEscapeChar(rp2.getDisplayValue(rp2.getValue(), Locale.getDefault()), originality));
                        } else {
                            retStr.append(rp2.getDisplayValue(rp2.getValue(), Locale.getDefault()));
                        }
                        rp2.setFormat(oldFormat);
                        continue;
                    }
                    if (bEscape && this.isSeamlessUDS(this.userDataSource)) {
                        retStr.append(UUDSEngine.addEscapeChar(rp2.getValue().toString(), originality));
                        continue;
                    }
                    retStr.append(rp2.getValue().toString());
                    continue;
                }
                if (constantValue != null) {
                    retStr.append(strBefore);
                    String format = (String)paramFormats.get(strParamName);
                    DbValueFormat fmat = null;
                    if (constantValue.isNull()) {
                        retStr.append(NULL);
                        continue;
                    }
                    int dataType = constantValue.getSqlType();
                    if (DataTypeDef.isArray(dataType)) {
                        dataType -= 11;
                    }
                    if (format != null) {
                        fmat = ReportFormat.getOneFormat(dataType, format, Locale.getDefault(), TimeZone.getDefault());
                    }
                    String formatStr = null;
                    if (constantValue instanceof fArray) {
                        if (fmat == null) {
                            formatStr = constantValue.toString();
                        } else {
                            DbValue[] values = ((fArray)constantValue).value;
                            for (int i = 0; i < values.length; ++i) {
                                formatStr = i > 0 ? formatStr + delimeter + fmat.format(values[i]) : fmat.format(values[i]);
                            }
                        }
                    } else if (constantValue instanceof DbArray) {
                        formatStr = fmat != null ? fmat.format(constantValue, delimeter) : constantValue.toString();
                    } else {
                        String string = formatStr = fmat != null ? fmat.format(constantValue) : constantValue.toString();
                    }
                    if (bEscape && this.isSeamlessUDS(this.userDataSource)) {
                        retStr.append(UUDSEngine.addEscapeChar(formatStr, originality));
                        continue;
                    }
                    retStr.append(formatStr);
                    continue;
                }
                int spec = DbTools.isSpecialField(strParamName);
                switch (spec) {
                    case 0: {
                        retStr.append(strBefore);
                        if (this.isSeamlessUDS(this.userDataSource)) {
                            retStr.append(this.rptUserName == null ? "" : UUDSEngine.addEscapeChar(this.rptUserName, originality));
                            break;
                        }
                        retStr.append(this.rptUserName == null ? "" : this.rptUserName);
                    }
                }
            }
            retStr.append(strBefore);
            this.strResolvedParameter = retStr.toString();
        }
    }

    public static String addEscapeChar(String value, String originality) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(strParaValueSeparator) != -1 || value.indexOf(strParaValueSeparatorSeamless) != -1 || value.indexOf(strParaSeparator) != -1) {
            value = UUDSEngine.returnValue(value, originality);
        }
        return value;
    }

    private static String returnValue(String value, String originality) {
        StringBuffer temp = new StringBuffer();
        char[] tempChar = value.toCharArray();
        String result = "";
        if (originality.indexOf(inparamvalue) == -1) {
            for (int i = 0; i < tempChar.length; ++i) {
                if (tempChar[i] == strParaValueSeparator) {
                    temp.append(strParaValueTranferSymbol);
                    temp.append(strParaValueTranferSymbol);
                } else if (tempChar[i] == strParaSeparator) {
                    temp.append(strParaValueTranferSymbol);
                    temp.append(strParaValueTranferSymbol);
                }
                temp.append(tempChar[i]);
            }
            result = temp.toString();
        } else {
            for (int i = tempChar.length - 1; i >= 0; --i) {
                if (tempChar[i] == strParaValueSeparatorSeamless) {
                    temp.append(strParaValueTranferSymbol);
                    temp.append(strParaValueTranferSymbol);
                } else if (tempChar[i] == strParaValueSeparator) {
                    temp.append(strParaValueTranferSymbol);
                    temp.append(strParaValueTranferSymbol);
                } else if (tempChar[i] == strParaSeparator) {
                    temp.append(strParaValueTranferSymbol);
                    temp.append(strParaValueTranferSymbol);
                }
                temp.append(tempChar[i]);
            }
            char[] charStr = temp.toString().toCharArray();
            for (int j = charStr.length - 1; j >= 0; --j) {
                if (charStr[j] == strParaValueSeparatorSeamless) {
                    if (charStr[j - 1] == strParaValueTranferSymbol) {
                        result = result + String.valueOf(charStr[j - 1]);
                        result = result + String.valueOf(charStr[j - 1]);
                        result = result + String.valueOf(charStr[j]);
                        j -= 2;
                        continue;
                    }
                } else if (charStr[j] == strParaValueSeparator) {
                    if (charStr[j - 1] == strParaValueTranferSymbol) {
                        result = result + String.valueOf(charStr[j - 1]);
                        result = result + String.valueOf(charStr[j - 1]);
                        result = result + String.valueOf(charStr[j]);
                        j -= 2;
                        continue;
                    }
                } else if (charStr[j] == strParaSeparator && charStr[j - 1] == strParaValueTranferSymbol) {
                    result = result + String.valueOf(charStr[j - 1]);
                    result = result + String.valueOf(charStr[j - 1]);
                    result = result + String.valueOf(charStr[j]);
                    j -= 2;
                    continue;
                }
                result = result + String.valueOf(charStr[j]);
            }
        }
        return result;
    }

    @Override
    protected void createDbQuery() throws JRUserDataSourceException, LoadUserDataSourceException, JRResultSetException {
        this.putParameterToDataSource();
        this.sqlStatement = this.strResolvedParameter;
    }

    @Override
    public JRColDesc[] getColDescs() {
        this.prepareBuffers();
        int iDbFldsCount = 0;
        if (this.vecDbFields != null) {
            iDbFldsCount += this.vecDbFields.size();
        }
        if (this.haveLocalWhere()) {
            iDbFldsCount += this.vecDbFieldsInLocalWhere.size();
        }
        if (iDbFldsCount > 0) {
            JRColDesc[] ColDescs = new JRColDesc[iDbFldsCount + 1];
            for (int i = 1; i <= iDbFldsCount; ++i) {
                String strFieldName;
                if (this.aiDbFieldsBackIndex[i] != -1) {
                    strFieldName = (String)this.vecDbFields.elementAt(this.aiDbFieldsBackIndex[i] - 1);
                } else {
                    assert (this.vecDbFieldsInLocalWhere != null && this.aiDbFieldsInLocalWhereBackIndex != null) : "Fields in formula can not be null";
                    strFieldName = (String)this.vecDbFieldsInLocalWhere.elementAt(this.aiDbFieldsInLocalWhereBackIndex[i] - 1);
                }
                DbColDesc coldesc = this.unvs.getSQLType(this.dataSourceName, this.strQueryName, strFieldName);
                ColDescs[i] = new JRColDesc(strFieldName, coldesc.getSqlType(), coldesc.getPrecision(), coldesc.getScale(), coldesc.getNullable());
            }
            return ColDescs;
        }
        return null;
    }

    @Override
    public boolean haveLocalWhere() {
        return !this.localLinks.isEmpty();
    }

    @Override
    protected void prepareBuffers() {
        if (this.userDataSource != null || this.oldUserDataSource != null) {
            Vector vecUDSFields = this.uUDS.getFields();
            int iTotalCol = vecUDSFields.size();
            int idbFieldIndex = 1;
            this.vecDbFields = new Vector(this.htDbFields.size() + 1);
            this.aiDbFieldsBackIndex = new int[iTotalCol + 1];
            for (int i = 1; i < iTotalCol + 1; ++i) {
                this.aiDbFieldsBackIndex[i] = -1;
            }
            if (this.bUseCacheQuery) {
                int iColIndex = 1;
                Enumeration e = this.htDbFields.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
                    this.vecDbFields.addElement(key);
                    this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                    ++iColIndex;
                }
            } else {
                Enumeration e = this.htDbFields.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    JetUDBField dbfld = (JetUDBField)this.htDbFields.get(key);
                    int iColIndex = ((JetUUDSField)dbfld).getColIndex();
                    this.vecDbFields.addElement(key);
                    this.aiDbFieldsBackIndex[iColIndex] = idbFieldIndex++;
                }
            }
        }
        this.vecFormulas = this.fmlsContainer.getFormulas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _getResultSet() throws SQLException, ClassNotFoundException, ParameterFormatInvalid {
        if (this.bOldUDS) {
            String[] strParams = this.uUDS.parseParameter();
            JRColDesc[] colDescs = this.getColDescs();
            this.oldUserDataSource.initialize(colDescs, strParams);
            this.rs = this.oldUserDataSource;
        } else {
            ClassLoader origThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(DynamicClassManager.getInstance().getRootClassLoader());
                if (this.userDataSource instanceof JRUserInformationDataSource && this.ibus != null) {
                    this.rs = ((JRUserInformationDataSource)this.userDataSource).getResultSet(this.ibus, this.strResolvedParameter);
                } else if (this.userDataSource instanceof JRSecurityUserDataSource && this.secCxt != null) {
                    this.rs = ((JRSecurityUserDataSource)this.userDataSource).getResultSet(this.secCxt, this.strResolvedParameter);
                } else if (this.userDataSource instanceof JREnhancedUserDataSource) {
                    this.rs = ((JREnhancedUserDataSource)this.userDataSource).getResultSet(this.uUDS.getParameter(), this.htParameters, true);
                } else if (this.userDataSource instanceof JRUserInstanceDataSource) {
                    this.rs = ((JRUserInstanceDataSource)this.userDataSource).getResultSet(this.strResolvedParameter);
                } else {
                    if (this.isSeamlessUDS(this.userDataSource)) {
                        ProcedureUDS oracleUDS = (ProcedureUDS)this.userDataSource;
                        oracleUDS.setRuntimeConnectionInfo(this.strURL, this.strJdbcDriver, this.strUID, this.strPSWD);
                        if (this.jCnnt != null) {
                            oracleUDS.setCatalogConnectionInfo(this.jCnnt.getURL(), this.jCnnt.getJdbcDriver(), this.jCnnt.getUID(), this.jCnnt.getPSWD());
                        }
                        oracleUDS.setConnection(this.userDbConnection);
                        oracleUDS.setJdbcDriversConfig(this.jdbcDriversConfig);
                    }
                    this.rs = this.userDataSource.getResultSet(this.strResolvedParameter);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origThreadContextClassLoader);
            }
        }
        this.isRelease = false;
    }

    private boolean isSeamlessUDS(JRUserDataSource userDataSource) {
        return userDataSource instanceof OracleProcedureUDS || userDataSource instanceof EnterpriseDbProcedureUDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() throws SQLException {
        if (!this.isRelease) {
            if (!this.bOldUDS) {
                ClassLoader origThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(DynamicClassManager.getInstance().getRootClassLoader());
                    this.userDataSource.releaseResultSet();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origThreadContextClassLoader);
                }
            } else {
                this.oldUserDataSource.close();
            }
            if (this.needCloseSettingConnection() && this.userDbConnection != null) {
                this.userDbConnection.close();
                this.userDbConnection = null;
            }
            this.isRelease = true;
        }
    }

    @Override
    public boolean supportServerSubLink() {
        return false;
    }

    @Override
    public boolean supportOrderBy() {
        return false;
    }

    @Override
    public void setOrderBy(Vector mapFlds, Vector sorts) {
    }

    @Override
    public boolean metaChanged(ResultSet rs) throws SQLException {
        ResultSetMetaData tmpRS = rs.getMetaData();
        if (!this.uUDS.specifyMetaData.get() && rs != null && tmpRS != null) {
            return tmpRS.getColumnCount() < this.getTotalCols().size();
        }
        return false;
    }

    @Override
    public int[] updateColMap(ResultSet rst) throws SQLException {
        int count = 0;
        int i = 1;
        int[] idxDb = null;
        ResultSetMetaData meda = rst.getMetaData();
        count = meda.getColumnCount();
        idxDb = new int[this.getTotalCols().size() + 1];
        for (int j = 1; j < idxDb.length; ++j) {
            idxDb[j] = -1;
        }
        for (int idx = 1; idx <= count; ++idx) {
            this.cols.put(meda.getColumnName(idx).toLowerCase(), new Integer(idx));
        }
        Enumeration e = this.htDbFields.keys();
        while (e.hasMoreElements()) {
            Object dkey = e.nextElement();
            JetUDBField dbfld = (JetUDBField)this.htDbFields.get(dkey);
            String realName = dbfld.getFldName().toLowerCase();
            if (this.cols.containsKey(realName)) {
                int index = (Integer)this.cols.get(realName);
                idxDb[index] = i++;
                continue;
            }
            ++i;
        }
        return idxDb;
    }

    public boolean isInRst(JetRptColumn col) {
        JetField dbfld = null;
        String mapName = null;
        JetObject[] objs = col.refers.get();
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof JetRptDBField)) continue;
            mapName = ((JetRptDBField)objs[i]).sNColumnName;
        }
        if (mapName != null) {
            dbfld = (JetUDBField)this.htDbFields.get(mapName);
        }
        if (dbfld != null) {
            String realName = dbfld.getFldName().toLowerCase();
            return this.cols.size() <= 0 ? true : this.cols.containsKey(realName);
        }
        return true;
    }

    @Override
    public Vector getTotalCols() {
        return this.uUDS.getFields();
    }

    @Override
    protected void setUserDefinedSqlString() {
    }

    public void setJetUJDBCConnection(JetUJDBCConnection jC) {
        if (jC != null) {
            this.jCnnt = jC;
        }
    }
}

