/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.ibus;

import com.jinfonet.ibus.InformationBus;
import com.jinfonet.ibus.InformationContainer;
import java.util.ArrayList;
import java.util.Hashtable;
import jet.cs.util.APIUtil;
import jet.universe.Ibus;
import jet.universe.JetUInformationBusEntry;
import jet.universe.JetUInformationBusItem;
import jet.universe.ibus.InformationContainerImpl;

public class InformationBusImpl
implements InformationBus {
    public static final String SYSTEM = "System";
    JetUInformationBusEntry iBusEntry;
    String orgID;
    String userID;
    Hashtable<Key, InformationContainerImpl> cache = new Hashtable();

    public InformationBusImpl(JetUInformationBusEntry iBusEntry, String principalDisplayName) {
        this.iBusEntry = iBusEntry;
        String[] orgUser = APIUtil.parsePrincipalDisplayName(principalDisplayName);
        this.orgID = orgUser[0] == null ? SYSTEM : orgUser[0];
        this.userID = SYSTEM.equals(orgUser[0]) ? orgUser[1] : principalDisplayName;
    }

    @Override
    public InformationContainer getGlobalInformationContainer() {
        Key k = new Key(3, "Global");
        InformationContainerImpl ret = this.cache.get(k);
        if (ret == null) {
            JetUInformationBusItem ibus = this.iBusEntry.getIbusItem(3, "Global");
            ret = ibus == null ? new InformationContainerImpl(new ArrayList<Ibus>()) : new InformationContainerImpl(ibus.getIbusList());
            this.cache.put(k, ret);
        }
        return ret;
    }

    @Override
    public InformationContainer getOrganizationInformationContainer() {
        return this.getOrganizationInformationContainer(this.orgID);
    }

    @Override
    public InformationContainer getOrganizationInformationContainer(String orgName) throws UnsupportedOperationException {
        Key k = new Key(2, orgName);
        InformationContainerImpl ret = this.cache.get(k);
        if (ret == null) {
            JetUInformationBusItem ibus = this.iBusEntry.getIbusItem(2, orgName);
            ret = ibus == null ? new InformationContainerImpl(new ArrayList<Ibus>()) : new InformationContainerImpl(ibus.getIbusList());
            this.cache.put(k, ret);
        }
        return ret;
    }

    @Override
    public InformationContainer getUserInformationContainer() {
        return this.getUserInformationContainer(this.userID);
    }

    @Override
    public InformationContainer getUserInformationContainer(String userName) throws UnsupportedOperationException {
        Key k = new Key(1, userName);
        InformationContainerImpl ret = this.cache.get(k);
        if (ret == null) {
            JetUInformationBusItem ibus = this.iBusEntry.getIbusItem(1, userName);
            ret = ibus == null ? new InformationContainerImpl(new ArrayList<Ibus>()) : new InformationContainerImpl(ibus.getIbusList());
            this.cache.put(k, ret);
        }
        return ret;
    }

    class Key {
        int type;
        String name;

        public Key(int type, String name2) {
            this.type = type;
            this.name = name2 == null ? "" : name2;
        }

        public int hashCode() {
            int nameHash = this.name == null ? 0 : this.name.hashCode();
            return this.type * 11 + nameHash * 13;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            if (this == o) {
                return true;
            }
            Key k = (Key)o;
            return this.type == k.type && this.name.equals(k.name);
        }
    }
}

