/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.mongodb;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUPath;
import jet.universe.JetUPrejoin;
import jet.universe.JetUResourceContainer;
import jet.util.HashVector;
import toolkit.db.mongo.ElementNode;

public class JetUBsonElement
extends JetUResourceContainer {
    public JetString fullName = new JetString(this, "FullName");
    public JetNumber dataType = new JetNumber(this, "DataType");
    public JetNumber subDataType = new JetNumber(this, "SubDataType");
    public JetBoolean isTable = new JetBoolean(this, "IsTable");
    private static final HashVector grpDesc = new HashVector(1);

    public JetUBsonElement() {
        this.init();
    }

    public JetUBsonElement(String strName, String strDesc) {
        super(strName, strDesc);
        this.init();
    }

    public JetUBsonElement(ElementNode bsonElement) {
        super(bsonElement.getName(), "");
        this.fullName.set(bsonElement.getFullName());
        this.dataType.set(bsonElement.getType());
        this.subDataType.set(bsonElement.getSubtype());
        this.isTable.set(bsonElement.isTable());
        List sChildren = bsonElement.getChildren();
        int size = sChildren.size();
        for (int i = 0; i < size; ++i) {
            ElementNode be = (ElementNode)sChildren.get(i);
            this.add(new JetUBsonElement(be));
        }
        this.init();
    }

    private void init() {
        this.dataType.setPropertyChoice(DataTypeUtils.getBsonDataTypeChoiceVector());
        this.dataType.setEditorType(JetProperty.COMBO_EDITOR);
        this.subDataType.setPropertyChoice(DataTypeUtils.getBsonBinarySubTypeChoiceVector());
        this.subDataType.setEditorType(JetProperty.COMBO_EDITOR);
    }

    public JetUBsonElement[] getSubElements() {
        if (this.children.size() == 0) {
            return new JetUBsonElement[0];
        }
        return this.children.toArray(new JetUBsonElement[this.children.size()]);
    }

    public final String getDataTypeName() {
        return (String)DataTypeUtils.bsonDataTypeNameMap.get(this.dataType.get());
    }

    public final String getSubDataTypeName() {
        return (String)DataTypeUtils.bsonBinarySubDataTypeNameMap.get(this.subDataType.get());
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    public String buildTableName() {
        if (!this.isTable.get()) {
            return null;
        }
        JetContainable parentEle = this.getParent();
        if (parentEle instanceof JetUBsonElement) {
            return ((JetUBsonElement)parentEle).buildTableName() + '.' + this.getResourceName();
        }
        return this.getResourceName();
    }

    public void buildPrejoin(JetUPath ret) {
        String fromTable = this.buildTableName();
        String fromcolumn = "PrimaryKey";
        JetUBsonElement[] eles = this.getSubElements();
        for (int i = 0; i < eles.length; ++i) {
            if (!eles[i].isTable.get()) continue;
            String toTable = eles[i].buildTableName();
            String toColumn = "ForeignKey";
            JetUPrejoin prejoin = new JetUPrejoin();
            prejoin.tableFrom.set(fromTable);
            prejoin.columnFrom.set(fromcolumn);
            prejoin.tableTo.set(toTable);
            prejoin.columnTo.set(toColumn);
            prejoin.operator.set("=");
            prejoin.outerJoin.set(4);
            ret.add(prejoin);
            eles[i].buildPrejoin(ret);
        }
    }

    public ElementNode getElement() {
        ElementNode ret = new ElementNode(this.getResourceName());
        ret.setType(this.dataType.get());
        ret.setSubtype(this.subDataType.get());
        ret.setTable(this.isTable.get());
        ret.setFullName(this.fullName.get());
        JetUBsonElement[] bsonEles = this.getSubElements();
        ArrayList<ElementNode> children = new ArrayList<ElementNode>();
        for (int i = 0; i < bsonEles.length; ++i) {
            children.add(bsonEles[i].getElement());
        }
        ret.setChildren(children);
        return ret;
    }

    static {
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(4);
        grpItems.add("DataType");
        grpItems.add("SubDataType");
        grpItems.add("Name");
        grpDesc.put(grpName, grpItems);
    }
}

