/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.mongodb;

import java.util.ArrayList;
import java.util.List;
import jet.universe.JetUPath;
import jet.universe.JetUPrejoin;
import jet.universe.JetUResourceContainer;
import jet.universe.mongodb.JetUBsonElement;
import toolkit.db.mongo.CollectionNode;
import toolkit.db.mongo.ElementNode;
import toolkit.db.mongo.MongoDbException;

public class JetUMongoCollection
extends JetUResourceContainer {
    public JetUMongoCollection() {
    }

    public JetUMongoCollection(String strName, String strDesc) {
        super(strName, strDesc);
    }

    public JetUMongoCollection(CollectionNode mongoCollection) {
        super(mongoCollection.getName(), "");
        List sChildren = null;
        try {
            sChildren = mongoCollection.getChildren();
        }
        catch (MongoDbException e) {
            return;
        }
        int size = sChildren.size();
        for (int i = 0; i < size; ++i) {
            ElementNode bsonElement = (ElementNode)sChildren.get(i);
            this.add(new JetUBsonElement(bsonElement));
        }
    }

    public JetUBsonElement[] getBsonElements() {
        if (this.children.size() == 0) {
            return new JetUBsonElement[0];
        }
        return this.children.toArray(new JetUBsonElement[this.children.size()]);
    }

    public JetUPath buildPreJoin() {
        JetUPath ret = new JetUPath();
        ret.setResourceName(this.getResourceName());
        ret.pathName.set(this.getResourceName());
        String fromTable = "";
        String fromcolumn = "PrimaryKey";
        JetUBsonElement[] eles = this.getBsonElements();
        for (int i = 0; i < eles.length; ++i) {
            if (!eles[i].isTable.get()) continue;
            String toTable = eles[i].buildTableName();
            String toColumn = "ForeignKey";
            JetUPrejoin prejoin = new JetUPrejoin();
            prejoin.tableFrom.set(fromTable);
            prejoin.columnFrom.set(fromcolumn);
            prejoin.tableTo.set(toTable);
            prejoin.columnTo.set(toColumn);
            prejoin.operator.set("=");
            prejoin.outerJoin.set(4);
            ret.add(prejoin);
            eles[i].buildPrejoin(ret);
        }
        return ret;
    }

    public CollectionNode getCollections() {
        CollectionNode ret = new CollectionNode(this.getResourceName());
        JetUBsonElement[] bsonEles = this.getBsonElements();
        ArrayList<ElementNode> children = new ArrayList<ElementNode>();
        for (int i = 0; i < bsonEles.length; ++i) {
            children.add(bsonEles[i].getElement());
        }
        ret.setChildren(children);
        return ret;
    }
}

