/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.mongodb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.api.DSException;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUPath;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.mongodb.JetUMongoCollection;
import jet.universe.mongodb.JetUMongoDatabase;
import jet.universe.mongodb.JetUMongoSchema;
import jet.util.HashVector;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoDbException;

public class JetUMongoConnection
extends JetUJDBCConnection {
    public static final String MONGODBDRIVER = " toolkit.db.mongo.MongoDriver";
    public static final String MONGOURIPREFIX = "mongodb://";
    public JetVector dataBaseNames = new JetVector(this, "DataBaseNames");
    public JetString mongoConnectionOptions = new JetString(this, "MongoConnectionOptions");
    private static final HashMap nameIdx = new HashMap(8);
    private static final HashVector grpDesc;

    public JetUMongoConnection() {
        this.pushDownGroupQuery = new JetBoolean(this, "PushDownGroupQuery", true);
        this.init();
    }

    private void init() {
        this.preJoin.setEditFlag(0);
        this.customQueryOptimizer.setEditFlag(3);
        this.dateFormat.setEditFlag(3);
        this.drv.setEditFlag(3);
        this.explicitInnerJoin.setEditFlag(3);
        this.sqlStmtCreator.setEditFlag(3);
        this.qualifiedNamePattern.setEditFlag(3);
        this.readOnly.setEditFlag(3);
        this.security.setEditFlag(3);
        this.timestampFormat.setEditFlag(3);
        this.timeFormat.setEditFlag(3);
        this.transactionIsolation.setEditFlag(3);
        this.readOnly.setEditFlag(3);
        this.schemaNames.setEditFlag(3);
        this.extraNamePattern.setEditFlag(3);
        this.url.setEditFlag(3);
    }

    public JetUMongoConnection(String[] hosts, int[] ports, String strUser, String strPassword, String options) throws SQLException, ClassNotFoundException, DSException, MongoDbException, IOException {
        super(JetUMongoConnection.toUri(hosts, ports, options), "", JetUMongoConnection.toUri(hosts, ports, options), strUser, strPassword, 0, MONGODBDRIVER);
        this.pushDownGroupQuery = new JetBoolean(this, "PushDownGroupQuery", true);
        this.mongoConnectionOptions.set(options);
        this.init();
        new MongoConnection(this.url.get(), this.user.get(), this.password.get()).close();
    }

    public void setConnectionInfo(String[] hosts, int[] ports, String strUser, String strPassword, String options) throws MongoDbException, IOException {
        this.url.set(JetUMongoConnection.toUri(hosts, ports, options));
        this.user.set(strUser);
        this.password.set(strPassword);
        this.mongoConnectionOptions.set(options);
        new MongoConnection(this.url.get(), this.user.get(), this.password.get()).close();
    }

    public void resetConnectionInfo(String[] hosts, int[] ports, String strUser, String strPassword, String options) {
        this.url.set(JetUMongoConnection.toUri(hosts, ports, options));
        this.user.set(strUser);
        this.password.set(strPassword);
        this.mongoConnectionOptions.set(options);
    }

    private static String toUri(String[] hosts, int[] ports, String options) {
        String hostPort = "";
        for (int i = 0; i < hosts.length; ++i) {
            hostPort = hostPort + hosts[i] + ':' + ports[i] + ',';
        }
        hostPort = hostPort.substring(0, hostPort.length() - 1);
        if (options.trim().length() > 0) {
            return MONGOURIPREFIX + hostPort + "/?" + options;
        }
        return MONGOURIPREFIX + hostPort;
    }

    public String getServerAddressStr() {
        return this.getURL().substring(MONGOURIPREFIX.length());
    }

    public ServerAddress[] getServerAddress() {
        String uri = this.getURL();
        int idx = (uri = uri.substring(MONGOURIPREFIX.length())).lastIndexOf("/");
        String serverPart = idx < 0 ? uri : uri.substring(0, idx);
        String[] servers = serverPart.split(",");
        ServerAddress[] ret = new ServerAddress[servers.length];
        for (int i = 0; i < ret.length; ++i) {
            String server = servers[i];
            int index = server.indexOf(58);
            ret[i] = new ServerAddress(server.substring(0, index), Integer.parseInt(server.substring(index + 1, server.length())));
        }
        return ret;
    }

    public String getOptions() {
        return this.mongoConnectionOptions.get();
    }

    public JetUMongoSchema getSchema() {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Object child = this.children.get(i);
            if (!(child instanceof JetUMongoSchema)) continue;
            return (JetUMongoSchema)child;
        }
        return null;
    }

    public void setSchema(JetUMongoSchema sc) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof JetUMongoSchema)) continue;
            it.remove();
        }
        this.add(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetUMongoSchema getWholeSchema() throws DSException, SQLException {
        MongoConnection conn = null;
        try {
            conn = this.getConnection(false);
            JetUMongoSchema jetUMongoSchema = new JetUMongoSchema(conn.getMetaData().getSchemaRoot());
            return jetUMongoSchema;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public MongoConnection getConnection(boolean withAddedSchema) throws DSException {
        MongoConnection conn;
        try {
            conn = new MongoConnection(this.url.get(), this.user.get(), this.password.get());
        }
        catch (MongoDbException e) {
            throw new DSException(0, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            throw new DSException(0, new Object[]{e.getMessage()});
        }
        if (withAddedSchema && this.getSchema() != null) {
            conn.setRoot(this.getSchema().getSchemaRoot());
        }
        if (conn.isNeedInputDb() && this.dataBaseNames != null && this.dataBaseNames.get().size() > 0) {
            try {
                conn.setDatabases(this.dataBaseNames.get());
            }
            catch (MongoDbException e) {
                throw new DSException(0, (Throwable)e);
            }
        }
        return conn;
    }

    @Override
    public MongoConnection getConnection() throws DSException {
        return this.getConnection(true);
    }

    @Override
    public JetUConnection createNew() {
        JetUMongoConnection newCnnt = new JetUMongoConnection();
        newCnnt.setResourceName(this.getResourceName());
        newCnnt.setUptoDateSupportInfo(true);
        JetObject.copyProperties(newCnnt, this);
        newCnnt.add(this.getSupportInfo().createNew());
        JetUSupportInfo newSupportInfo = newCnnt.getSupportInfo();
        JetUSupportInfo supportInfo = this.getSupportInfo();
        newSupportInfo.setExtraNameChar(supportInfo.getExtraNameChar());
        newSupportInfo.setQuoteChar(supportInfo.getQuoteChar());
        newCnnt.setSchema((JetUMongoSchema)this.getSchema().deepDup());
        return newCnnt;
    }

    public void fetchSupportInfo(Connection connection) {
    }

    @Override
    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
        MongoConnection con;
        try {
            con = this.getConnection();
        }
        catch (DSException e) {
            return;
        }
        JetUJdbcSupportInfo suppInfo = this.getJdbcSupportInfo();
        suppInfo.fetchJDBCSupportInfo(con);
        con.close();
    }

    @Override
    protected JetUJDBCTypeInfo getTypeInfo(int iSQLType) {
        return null;
    }

    public boolean addLogicTableView(JetUTableView tableview) {
        tableview.removeall();
        return super.addTableView(tableview);
    }

    public JetUPath[] getPreJoinPaths() {
        ArrayList<JetUPath> ret = new ArrayList<JetUPath>();
        JetUMongoDatabase[] databases = this.getSchema().getDataBases();
        for (int i = 0; i < databases.length; ++i) {
            JetUMongoCollection[] colls = databases[i].getCollections();
            for (int j = 0; j < colls.length; ++j) {
                JetUPath path = colls[j].buildPreJoin();
                ret.add(path);
            }
        }
        JetUPath[] joinPath = ret.toArray(new JetUPath[ret.size()]);
        return joinPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNeedInputDb() throws DSException {
        MongoConnection conn = null;
        try {
            conn = this.getConnection(false);
            boolean bl = conn.isNeedInputDb();
            return bl;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void tryAccessRight(String dbName) throws DSException {
        try {
            this.getConnection(false).tryAccessRight(dbName);
        }
        catch (MongoDbException e) {
            throw new DSException(0, new Object[]{e.getMessage()});
        }
    }

    public void setDatabases(Vector<String> dbNames) throws DSException {
        this.dataBaseNames.set(dbNames);
    }

    public Vector<String> getDatabases() throws DSException {
        return this.dataBaseNames.get();
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    @Override
    public HashMap<String, Vector> groupTablesToOneExe(Vector<String> tables) {
        HashMap<String, Vector> ret = new HashMap<String, Vector>();
        int iSize = tables.size();
        for (int i = 0; i < iSize; ++i) {
            String tName = tables.get(i);
            JetUTableView table = this.GetTableOrViewByResourceName(tName);
            if (table == null) continue;
            Vector<String> list = ret.get(table.getOwner());
            if (list != null) {
                list.add(tName);
                continue;
            }
            list = new Vector<String>();
            list.add(tables.get(i));
            ret.put(table.getOwner(), list);
        }
        return ret;
    }

    static {
        int start = 0;
        nameIdx.put("Description", new Integer(start++));
        nameIdx.put("User", new Integer(start++));
        nameIdx.put("Name", new Integer(start++));
        nameIdx.put("Password", new Integer(start++));
        nameIdx.put("Pre-join", new Integer(start++));
        nameIdx.put("ExplicitInnerJoin", new Integer(start++));
        nameIdx.put("MongoConnectionOptions", new Integer(start++));
        nameIdx.put("IsDefaultConnection", new Integer(start++));
        grpDesc = new HashVector(1);
        String grpName = "anonymous";
        Vector<String> grpItems = new Vector<String>(20);
        grpItems.add("Description");
        grpItems.add("User");
        grpItems.add("URL");
        grpItems.add("Name");
        grpItems.add("Password");
        grpItems.add("Pre-join");
        grpItems.add("PushDownGroupQuery");
        grpItems.add("MongoConnectionOptions");
        grpItems.add("IsDefaultConnection");
        grpDesc.put(grpName, grpItems);
    }

    public class ServerAddress {
        public String host;
        public int port;

        public ServerAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

