/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.mongodb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUTableView;
import jet.universe.mongodb.JetUMongoCollection;
import jet.universe.mongodb.JetUMongoConnection;
import jet.universe.mongodb.JetUMongoTable;
import toolkit.db.TableInfo;
import toolkit.db.mongo.CollectionNode;
import toolkit.db.mongo.DatabaseNode;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoDatabaseMetaData;
import toolkit.db.mongo.MongoDbException;

public class JetUMongoDatabase
extends JetUResourceContainer {
    public JetUMongoDatabase() {
    }

    public JetUMongoDatabase(String strName, String strDesc) {
        super(strName, strDesc);
    }

    public JetUMongoDatabase(DatabaseNode mongoDataBase) throws DSException {
        super(mongoDataBase.getName(), "");
        List sChildren = null;
        try {
            sChildren = mongoDataBase.getChildren();
        }
        catch (MongoDbException e) {
            throw new DSException(0, (Throwable)e);
        }
        int size = sChildren.size();
        for (int i = 0; i < size; ++i) {
            CollectionNode mongoCollection = (CollectionNode)sChildren.get(i);
            this.add(new JetUMongoCollection(mongoCollection));
        }
    }

    public JetUMongoCollection[] getCollections() {
        if (this.children.size() == 0) {
            return new JetUMongoCollection[0];
        }
        return this.children.toArray(new JetUMongoCollection[this.children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JetUTableView[] getWholeTableviews(HashSet localNameSpace) throws SQLException, DSException {
        JetUMongoConnection conn = (JetUMongoConnection)((JetObject)((Object)this.getParent())).getParent();
        MongoConnection mongoconn = null;
        try {
            mongoconn = conn.getConnection();
            ArrayList<JetUMongoTable> retVec = new ArrayList<JetUMongoTable>();
            MongoDatabaseMetaData md = mongoconn.getMetaData();
            String strCatalogName = this.getResourceName();
            ResultSet rs = md.getTables(strCatalogName, "%", "%", null);
            String strSchemaName = "";
            String strTableName_ElementPath = "";
            String strTableType = "";
            while (rs.next()) {
                strSchemaName = rs.getString(2);
                strTableName_ElementPath = rs.getString(3);
                int iTypeInCatalog = this.getIntValueFromType(rs.getString(4));
                String strResourceName = strSchemaName + ' ' + strTableName_ElementPath.replace('.', ' ');
                String candidateResourceName = strResourceName = strResourceName.trim();
                int sn = 1;
                while (localNameSpace.contains(strResourceName.toUpperCase())) {
                    strResourceName = candidateResourceName + sn;
                    ++sn;
                }
                localNameSpace.add(strResourceName.toUpperCase());
                TableInfo tableInfo = conn.createTableInfo(strCatalogName, strSchemaName, strTableName_ElementPath, iTypeInCatalog);
                JetUMongoTable table = new JetUMongoTable(strResourceName, "", tableInfo);
                table.buildFieldForLogicTable();
                retVec.add(table);
            }
            JetUTableView[] jetUTableViewArray = retVec.toArray(new JetUTableView[retVec.size()]);
            return jetUTableViewArray;
        }
        finally {
            if (mongoconn != null) {
                mongoconn.close();
            }
        }
    }

    public JetUTableView[] getTableviews() {
        JetUMongoConnection conn = (JetUMongoConnection)((JetObject)((Object)this.getParent())).getParent();
        Vector tvs = conn.getTableViews();
        ArrayList<JetUTableView> ret = new ArrayList<JetUTableView>();
        int size = tvs.size();
        for (int i = 0; i < size; ++i) {
            JetUTableView tv = (JetUTableView)tvs.get(i);
            if (!tv.getQualifier().equals(this.name.get())) continue;
            ret.add(tv);
        }
        return ret.toArray(new JetUTableView[ret.size()]);
    }

    private int getIntValueFromType(String strType) {
        if (strType.indexOf("TABLE") != -1) {
            return 1;
        }
        if (strType.indexOf("VIEW") != -1) {
            return 2;
        }
        return -1;
    }

    public DatabaseNode getDataBase() {
        DatabaseNode ret = new DatabaseNode(this.getResourceName());
        JetUMongoCollection[] colls = this.getCollections();
        ArrayList<CollectionNode> children = new ArrayList<CollectionNode>();
        for (int i = 0; i < colls.length; ++i) {
            children.add(colls[i].getCollections());
        }
        ret.setChildren(children);
        return ret;
    }
}

