/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.mongodb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.universe.JetUResourceContainer;
import jet.universe.mongodb.JetUMongoCollection;
import jet.universe.mongodb.JetUMongoConnection;
import jet.universe.mongodb.JetUMongoDatabase;
import toolkit.db.mongo.DatabaseNode;
import toolkit.db.mongo.SchemaNode;

public class JetUMongoSchema
extends JetUResourceContainer {
    public JetUMongoSchema() {
    }

    public JetUMongoSchema(String strName, String strDesc) {
        super(strName, strDesc);
    }

    public JetUMongoSchema(SchemaNode schemaRoot) throws DSException {
        super(schemaRoot.getName(), "");
        List sChildren = schemaRoot.getChildren();
        int size = sChildren.size();
        for (int i = 0; i < size; ++i) {
            DatabaseNode mongoDataBase = (DatabaseNode)sChildren.get(i);
            this.add(new JetUMongoDatabase(mongoDataBase));
        }
    }

    public void refresh() throws DSException, SQLException {
        JetUMongoSchema wholeSchema = ((JetUMongoConnection)this.getParent()).getWholeSchema();
        JetUMongoDatabase[] wholeDb = wholeSchema.getDataBases();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JetUMongoDatabase db = (JetUMongoDatabase)it.next();
            boolean findFlag = false;
            for (int j = 0; j < wholeDb.length; ++j) {
                if (!db.getResourceName().equals(wholeDb[j].getResourceName())) continue;
                JetUMongoCollection[] jcs = db.getCollections();
                JetUMongoCollection[] wholeJc = wholeDb[j].getCollections();
                ArrayList<JetUMongoCollection> newChildren = new ArrayList<JetUMongoCollection>();
                for (JetUMongoCollection jc : jcs) {
                    for (JetUMongoCollection wjc : wholeJc) {
                        if (!jc.getResourceName().equals(wjc.getResourceName())) continue;
                        newChildren.add(wjc);
                    }
                }
                db.removeall();
                for (JetUMongoCollection jetUMongoCollection : newChildren) {
                    db.add(jetUMongoCollection);
                }
                findFlag = true;
                break;
            }
            if (findFlag) continue;
            it.remove();
        }
    }

    public JetUMongoDatabase[] getDataBases() {
        if (this.children.size() == 0) {
            return new JetUMongoDatabase[0];
        }
        return this.children.toArray(new JetUMongoDatabase[this.children.size()]);
    }

    public SchemaNode getSchemaRoot() {
        SchemaNode ret = new SchemaNode(this.getResourceName());
        JetUMongoDatabase[] dataBases = this.getDataBases();
        ArrayList<DatabaseNode> children = new ArrayList<DatabaseNode>();
        for (int i = 0; i < dataBases.length; ++i) {
            children.add(dataBases[i].getDataBase());
        }
        ret.setChildren(children);
        return ret;
    }
}

