/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetSet;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUFileQuery;
import jet.universe.psql.FileQuery;
import jet.universe.psql.JetStmtSelCol;
import jet.util.TreeIterater;
import toolkit.db.StmtSelCol;

public class JetFileQuery
extends JetSet {
    private static JRLogger logger = JRLogger.getLogger(JetUFileQuery.class.getName());
    public JetString mappingName = new JetString(this, "mappingName");
    public JetString file = new JetString(this, "file");
    public JetString stmt = new JetString(this, "stmt");
    public JetString origStmt = new JetString(this, "originalStatement");
    public JetString qualifier = new JetString(this, "qualifier");
    private static final HashMap nameIdx = new HashMap(5);

    public JetFileQuery() {
    }

    public JetFileQuery(FileQuery qry) {
        this.init(qry);
    }

    public void init(FileQuery qry) {
        this.mappingName.set(qry.getMappingName());
        this.file.set(qry.filename);
        this.stmt.set(qry.stmt);
        this.origStmt.set(qry.getOriginalStatement());
        this.qualifier.set(qry.qualifier);
        Vector v = qry.getColumns();
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            StmtSelCol col = (StmtSelCol)v.elementAt(i);
            JetStmtSelCol jcol = new JetStmtSelCol(col);
            this.add(jcol, -1);
        }
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public synchronized void clearMem() {
        try {
            JetObject o;
            TreeIterater t = new TreeIterater(this, true);
            while ((o = (JetObject)t.next()) != null) {
                o.delete();
            }
        }
        catch (Exception ex) {
            logger.debug(ex);
        }
        catch (Error err) {
            logger.debug(err);
        }
    }

    @Override
    public synchronized void delete() {
        try {
            Vector v = this.getChildren();
            for (int i = v.size() - 1; i >= 0; --i) {
                JetObject jo = (JetObject)v.elementAt(i);
                this.remove(jo);
            }
            super.delete();
            JetContainable p = this.getParent();
            if (p != null && p instanceof JetUFileQuery) {
                ((JetUFileQuery)p).remove(this);
            }
        }
        catch (Exception ex) {
            logger.debug(ex);
        }
        catch (Error err) {
            logger.debug(err);
        }
    }

    @Override
    public String getInstancePrefix() {
        return "FileQuery";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("stmt", new Integer(0));
        nameIdx.put("file", new Integer(1));
        nameIdx.put("mappingName", new Integer(2));
        nameIdx.put("qualifier", new Integer(3));
        nameIdx.put("originalStatement", new Integer(4));
    }
}

