/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUResourceContainer;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.util.HashVector;
import toolkit.db.PsqlJoin;

public class JetPsqlJoin
extends JetUResourceContainer {
    public JetNumber idxTblFrom = new JetNumber(this, "idxTblFrom");
    public JetNumber idxTblTo = new JetNumber(this, "idxTblTo");
    public JetString fromCol = new JetString(this, "fromColumn");
    public JetString toCol = new JetString(this, "toColumn");
    public JetString operator = new JetString(this, "operator");
    public JetNumber outerJoin = new JetNumber(this, "outerJoin");
    public JetBoolean isOrcl = new JetBoolean(this, "isOrclOJ");
    private static final HashMap nameIdx = new HashMap(7);

    public JetPsqlJoin() {
    }

    public JetPsqlJoin(PsqlJoin jn) {
        this.name.set(jn.name);
        this.idxTblFrom.set(jn.getIndexOfTableFrom());
        this.idxTblTo.set(jn.getIndexOfTableTo());
        this.fromCol.set(jn.getColumnFrom().getMappingName());
        this.toCol.set(jn.getColumnTo().getMappingName());
        this.operator.set(jn.getOperator());
        this.outerJoin.set(jn.getOuterJoin());
        this.setJoinCondition(jn.getJoinCondition());
    }

    public PsqlJoin makePsqlJoin(int ver) {
        PsqlJoin jn = new PsqlJoin();
        jn.name = this.name.get();
        jn.idxTblFrom = this.idxTblFrom.get();
        jn.idxTblTo = this.idxTblTo.get();
        jn.sColFrom = this.fromCol.get();
        jn.sColTo = this.toCol.get();
        jn.strOperator = this.operator.get();
        jn.setOuterJoin(this.outerJoin.get());
        jn.setJoinCondition(this.getJoinCondition());
        return jn;
    }

    @Override
    public String getInstancePrefix() {
        return "PsqlJoin";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropertyGroups() {
        HashVector grps = super.getPropertyGroups();
        if (grps == null || grps.size() == 0) {
            return null;
        }
        return grps;
    }

    public void setJoinCondition(IExpression expression) {
        if (expression == null) {
            return;
        }
        IExpression2Jet itoj = new IExpression2Jet();
        UFilterExpression condition = null;
        try {
            condition = itoj.convert(expression);
        }
        catch (ConditionException e) {
            // empty catch block
        }
        if (this.getChildren().size() != 0) {
            this.removeall();
        }
        this.add(condition);
        condition.setParent(this);
    }

    public IExpression getJoinCondition() {
        if (this.children.isEmpty()) {
            return null;
        }
        Jet2IExpression jtoi = new Jet2IExpression();
        IExpression ret = null;
        try {
            ret = jtoi.convert((UFilterExpression)this.children.get(0), null, null, null);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void BeforeRemove() {
    }

    @Override
    public JetProperty nameToProperty(String propname) {
        if ("name".equals(propname)) {
            return super.nameToProperty("Name");
        }
        return super.nameToProperty(propname);
    }

    static {
        nameIdx.put("fromColumn", new Integer(0));
        nameIdx.put("isOrclOJ", new Integer(1));
        nameIdx.put("outerJoin", new Integer(2));
        nameIdx.put("toColumn", new Integer(3));
        nameIdx.put("idxTblFrom", new Integer(4));
        nameIdx.put("idxTblTo", new Integer(5));
        nameIdx.put("operator", new Integer(6));
    }
}

