/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetSet;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.universe.JetUQuery;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.psql.JetPsqlAndCondition;
import jet.universe.psql.JetPsqlJoin;
import jet.universe.psql.JetPsqlSelColumn;
import jet.universe.psql.JetPsqlTable;
import jet.universe.psql.JetPsqlUnion;
import jet.universe.psql.JetStmtSelCol;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import jet.util.TreeIterater;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlQuery;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.PsqlUnion;

public abstract class JetPsqlQuery
extends JetSet {
    public JetNumber ver = new JetNumber(this, "ver");
    public JetString mappingName = new JetString(this, "mappingName");
    public JetString extWhere = new JetString(this, "extWhere");
    public JetString replWhere = new JetString(this, "replWhere");
    public JetBoolean bStateOfUnqualifiedName = new JetBoolean(this, "isQualifiedName");
    public JetBoolean bStateOfJoinOnForeignKeys = new JetBoolean(this, "isJoinOnFKey");
    public JetBoolean bStateOfJoinOnPrimaryKey = new JetBoolean(this, "isJoinOnPKey");
    public JetBoolean bStateOfJoinOnLikeName = new JetBoolean(this, "isJoinOnName");
    public JetBoolean bStateOfShowTableNames = new JetBoolean(this, "isShowTableName");
    public JetBoolean bShowMappingName = new JetBoolean(this, "isShowMappingName");
    public JetBoolean bStateOfProhibitCartesianProducts = new JetBoolean(this, "isProhibitCartesianProducts");
    public JetBoolean bDistinct = new JetBoolean(this, "isDistinct");
    public JetBoolean bIgnorePredicateIfParamIsNull = new JetBoolean(this, "ignorePredicateIfParamIsNull");
    public JetString username = new JetString(this, "UserName");
    public JetString password = new JetString(this, "PassWord");
    public JetBoolean share = new JetBoolean(this, "Share", true);
    private JetString userDefinedQueryStmt = new JetString(this, "UserDefinedQueryStmt");
    public JetVector parsedMappingNames = new JetVector(this, "ParsedMappingNames");
    private static final HashMap nameIdx = new HashMap(18);

    public JetPsqlQuery() {
    }

    public JetPsqlQuery(PsqlQuery qry) {
        this.initFromPsqlQuery(qry);
    }

    public void initFromPsqlQuery(PsqlQuery qry) {
        IExpression scExpression;
        this.ver.set(1);
        this.mappingName.set(qry.getMappingName());
        this.extWhere.set(qry.getExtendedWhere());
        this.replWhere.set(qry.getReplacedWhere());
        this.bDistinct.set(qry.isDistinct());
        this.bIgnorePredicateIfParamIsNull.set(qry.isIgnorePredicateIfParamIsNull());
        this.bStateOfUnqualifiedName.set(qry.getStateOfUnqualifiedName());
        this.bStateOfJoinOnForeignKeys.set(qry.getStateOfJoinOnForeignKeys());
        this.bStateOfJoinOnPrimaryKey.set(qry.getStateOfJoinOnPrimaryKey());
        this.bStateOfJoinOnLikeName.set(qry.getStateOfJoinOnLikeName());
        this.bStateOfShowTableNames.set(qry.getStateOfShowTableNames());
        this.bShowMappingName.set(qry.isShowMappingName());
        this.bStateOfProhibitCartesianProducts.set(qry.getStateOfProhibitCartesianProducts());
        this.username.set(((RptPsqlQuery)qry).getUsername());
        this.password.set(((RptPsqlQuery)qry).getPassword());
        this.share.set(((RptPsqlQuery)qry).getShare());
        Vector v = qry.getPsqlTablesVector();
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            PsqlTable tbl = (PsqlTable)v.elementAt(i);
            JetPsqlTable jtbl = new JetPsqlTable(tbl);
            this.add(jtbl, -1);
        }
        v = qry.getSelColsVector();
        sz = v.size();
        JetStmtSelCol jstcol = null;
        for (int i = 0; i < sz; ++i) {
            PsqlSelColumn col = (PsqlSelColumn)v.elementAt(i);
            if (col.isCompCol() && !(col instanceof RptPsqlFormulaColumn)) {
                jstcol = new JetStmtSelCol(col);
                this.add(jstcol, -1);
                continue;
            }
            JetPsqlSelColumn jcol = new JetPsqlSelColumn(qry, col);
            this.add(jcol, -1);
        }
        v = qry.getPsqlJoinsVector();
        sz = v.size();
        for (int i = 0; i < sz; ++i) {
            PsqlJoin jn = (PsqlJoin)v.elementAt(i);
            JetPsqlJoin jjn = new JetPsqlJoin(jn);
            this.add(jjn, -1);
        }
        v = qry.getAndExpressionVector();
        sz = v.size();
        for (int i = 0; i < sz; ++i) {
            String s1 = (String)v.elementAt(i++);
            if (i >= sz) break;
            String s2 = (String)v.elementAt(i++);
            if (i >= sz) break;
            String s3 = (String)v.elementAt(i++);
            if (i >= sz) break;
            String s4 = (String)v.elementAt(i);
            JetPsqlAndCondition jac = new JetPsqlAndCondition(s1, s2, s3, s4);
            this.add(jac, -1);
        }
        if ((scExpression = qry.getSearchConditionGroups()) != null) {
            IExpression2Jet itoj = new IExpression2Jet();
            UFilterExpression searchCondition = null;
            try {
                searchCondition = itoj.convert(scExpression);
            }
            catch (ConditionException e) {
                // empty catch block
            }
            this.add(searchCondition, -1);
        }
        v = qry.getUnionVector();
        sz = v.size();
        for (int i = 0; i < sz; ++i) {
            JetPsqlUnion union = new JetPsqlUnion((PsqlUnion)v.elementAt(i));
            this.add(union);
        }
        this.userDefinedQueryStmt.set(qry.getUserDefinedQueryStmt());
        Vector selColMappingNames = qry.getSelColMappingNamesFromParse();
        this.parsedMappingNames.set(selColMappingNames);
    }

    public void clearMem() {
        JetObject o;
        TreeIterater t = new TreeIterater(this, true);
        while ((o = (JetObject)t.next()) != null) {
            o.delete();
        }
        this.ver = null;
        this.mappingName = null;
        this.extWhere = null;
        this.replWhere = null;
        this.bDistinct = null;
        this.bIgnorePredicateIfParamIsNull = null;
        this.bStateOfUnqualifiedName = null;
        this.bStateOfJoinOnForeignKeys = null;
        this.bStateOfJoinOnPrimaryKey = null;
        this.bStateOfJoinOnLikeName = null;
        this.bStateOfShowTableNames = null;
        this.bShowMappingName = null;
        this.bStateOfProhibitCartesianProducts = null;
        this.username = null;
        this.password = null;
        this.share = null;
    }

    @Override
    public void delete() {
        Vector v = this.getChildren();
        for (int i = v.size() - 1; i >= 0; --i) {
            JetObject jo = (JetObject)v.elementAt(i);
            this.remove(jo);
        }
        super.delete();
        JetContainable p = this.getParent();
        if (p != null && p instanceof JetUQuery) {
            ((JetUQuery)p).remove(this);
        }
    }

    public String getUserDefinedQueryStmt() {
        return this.userDefinedQueryStmt.get();
    }

    public Vector<String> getParsedMappingNames() {
        return this.parsedMappingNames.get();
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("isShowTableName", new Integer(0));
        nameIdx.put("ver", new Integer(1));
        nameIdx.put("isDistinct", new Integer(2));
        nameIdx.put("isJoinOnName", new Integer(3));
        nameIdx.put("mappingName", new Integer(4));
        nameIdx.put("UserDefinedQueryStmt", new Integer(5));
        nameIdx.put("isShowMappingName", new Integer(6));
        nameIdx.put("extWhere", new Integer(7));
        nameIdx.put("UserName", new Integer(8));
        nameIdx.put("isQualifiedName", new Integer(9));
        nameIdx.put("Share", new Integer(10));
        nameIdx.put("replWhere", new Integer(11));
        nameIdx.put("isJoinOnPKey", new Integer(12));
        nameIdx.put("ignorePredicateIfParamIsNull", new Integer(13));
        nameIdx.put("isProhibitCartesianProducts", new Integer(14));
        nameIdx.put("PassWord", new Integer(15));
        nameIdx.put("isJoinOnFKey", new Integer(16));
        nameIdx.put("ParsedMappingNames", new Integer(17));
    }
}

