/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.psql.JetPsqlColumn;
import jet.universe.psql.JetPsqlCondition;
import jet.universe.psql.RptPsqlFormulaColumn;
import toolkit.db.PsqlQuery;
import toolkit.db.PsqlSelColumn;

public class JetPsqlSelColumn
extends JetPsqlColumn {
    public JetNumber tableIndex = new JetNumber(this, "tableIndex");
    public JetString tableName = new JetString(this, "TableName");
    public JetString qlf = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString corr = new JetString(this, "CorrelatinName");
    public JetString mappingName = new JetString(this, "mappingName");
    public JetBoolean isFormulaField = new JetBoolean(this, "isFormulaField");
    public JetBoolean isHidden = new JetBoolean(this, "isHidden");
    public JetBoolean isCompCol = new JetBoolean(this, "isCompCol");
    private static final HashMap nameIdx = new HashMap(11);

    public JetPsqlSelColumn() {
    }

    public JetPsqlSelColumn(PsqlQuery qry, PsqlSelColumn selcol) {
        super(selcol);
        Vector v;
        this.uname.set(selcol.getSuperMappingName());
        if (qry == null) {
            this.tableName.set(selcol.table.getMappingName());
            this.qlf.set(selcol.qualifier);
            this.owner.set(selcol.owner);
            return;
        }
        boolean bff = selcol.isCompCol();
        this.isFormulaField.set(bff);
        this.isHidden.set(selcol.isHide());
        this.isCompCol.set(selcol.bCompCol);
        this.mappingName.set(selcol.getMappingName());
        if (bff) {
            this.tableName.set((String)null);
            this.qlf.set((String)null);
            this.owner.set((String)null);
            this.corr.set((String)null);
        } else {
            v = qry.getPsqlTablesVector();
            int idx = v.indexOf(selcol.table);
            if (idx >= 0) {
                this.tableIndex.set(idx);
            }
            this.tableName.set(selcol.table.getMappingName());
            this.qlf.set(selcol.table.getQualifier());
            this.owner.set(selcol.table.getOwner());
            this.corr.set(selcol.table.getCorrelationName());
        }
        v = selcol.vConditions;
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            String str = (String)v.elementAt(i);
            if (str == null || str.length() == 0) continue;
            this.add(new JetPsqlCondition(str, i), -1);
        }
    }

    @Override
    public void setName(String strName) {
        super.setName(strName);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    private JetUFormula getJetUFormula() {
        JetObject parent = (JetObject)((Object)this.getParent());
        while (!(parent instanceof JetUDatabase)) {
            parent = (JetObject)((Object)parent.getParent());
        }
        if (parent instanceof JetUDatabase) {
            JetUDatabase db = (JetUDatabase)parent;
            String mapName = this.mappingName.toString().toUpperCase();
            return db.getFormulaByResourceName(mapName);
        }
        return null;
    }

    public PsqlSelColumn makePsqlSelColumn(int ver) {
        PsqlSelColumn selcol = null;
        if (this.isFormulaField.get()) {
            selcol = new RptPsqlFormulaColumn();
            JetUFormula uFormula = this.getJetUFormula();
            if (uFormula != null) {
                ((RptPsqlFormulaColumn)selcol).setUFormulaEntity(uFormula);
            }
        } else {
            selcol = new PsqlSelColumn();
        }
        selcol.setName(this.name.get());
        selcol.setSuperMappingName(this.uname.get());
        selcol.setMappingName(this.mappingName.get());
        selcol.qualifier = this.qlf.get();
        selcol.owner = this.owner.get();
        selcol.corr = this.corr.get();
        selcol.sTableName = this.tableName.get();
        selcol.tableIndex = this.tableIndex.get();
        selcol.setCompCol(this.isCompCol.get());
        if (this.isFormulaField.get()) {
            selcol.setCompCol(true);
        }
        selcol.setHide(this.isHidden.get());
        Vector v = selcol.vConditions;
        if (v.size() < 16) {
            v.setSize(16);
        }
        Vector children = this.getChildren();
        int sz = children.size();
        for (int i = 0; i < sz; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetPsqlCondition)) continue;
            String str = ((JetPsqlCondition)child).cond.get();
            int row = ((JetPsqlCondition)child).row.get();
            if (row >= 16) continue;
            v.setElementAt(str, row);
        }
        return selcol;
    }

    @Override
    public void delete() {
        Vector v = this.getChildren();
        for (int i = v.size() - 1; i >= 0; --i) {
            JetObject jo = (JetObject)v.elementAt(i);
            this.remove(jo);
        }
        super.delete();
    }

    @Override
    public String getInstancePrefix() {
        return "PSQLSelColumn";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Qualifier", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("isCompCol", new Integer(2));
        nameIdx.put("tableIndex", new Integer(3));
        nameIdx.put("CorrelatinName", new Integer(4));
        nameIdx.put("isHidden", new Integer(5));
        nameIdx.put("isFormulaField", new Integer(6));
        nameIdx.put("mappingName", new Integer(7));
        nameIdx.put("UName", new Integer(8));
        nameIdx.put("TableName", new Integer(9));
        nameIdx.put("Owner", new Integer(10));
    }
}

