/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.util.HashVector;
import toolkit.db.PsqlTable;

public class JetPsqlTable
extends JetObject {
    public JetString name = new JetString(this, "Name");
    public JetString connection = new JetString(this, "connection");
    public JetString qlf = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString corrName = new JetString(this, "corrName");
    public JetString mappingName = new JetString(this, "mappingName");
    private static final HashMap nameIdx = new HashMap(6);

    public JetPsqlTable() {
    }

    public JetPsqlTable(PsqlTable tbl) {
        if (!tbl.isQueriable()) {
            this.name.set(tbl.getName());
            this.connection.set(tbl.getDataObj().getResourceName());
            this.qlf.set(tbl.getQualifier());
            this.owner.set(tbl.getOwner());
            this.corrName.set(tbl.getCorrelationName());
        }
        this.mappingName.set(tbl.getMappingName());
    }

    public void setName(String strName) {
        this.name.set(strName);
    }

    public String getName() {
        return this.name.get();
    }

    public PsqlTable makePsqlTable(int ver) {
        PsqlTable tbl = new PsqlTable();
        tbl.setName(this.name.get());
        tbl.setConnection(this.connection.get());
        tbl.setQualifier(this.qlf.get());
        tbl.setOwner(this.owner.get());
        tbl.setCorrelationName(this.corrName.get());
        tbl.setMappingName(this.mappingName.get());
        if ("".equals(tbl.name) && "".equals(tbl.qualifier) && "".equals(tbl.owner)) {
            tbl.isTable = false;
            tbl.setQueriable(true);
        }
        return tbl;
    }

    @Override
    public String getInstancePrefix() {
        return "PSQLTable";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropertyGroups() {
        HashVector grps = super.getPropertyGroups();
        if (grps.size() == 0) {
            return null;
        }
        return grps;
    }

    static {
        nameIdx.put("Name", new Integer(0));
        nameIdx.put("mappingName", new Integer(1));
        nameIdx.put("corrName", new Integer(2));
        nameIdx.put("Owner", new Integer(3));
        nameIdx.put("Qualifier", new Integer(4));
        nameIdx.put("connection", new Integer(5));
    }
}

