/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.HashMap;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.util.HashVector;
import toolkit.db.PsqlSelColumn;
import toolkit.db.StmtSelCol;

public class JetStmtSelCol
extends JetObject {
    public JetString name = new JetString(this, "name");
    public JetString tableName = new JetString(this, "TableName");
    public JetString qlf = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString mappingName = new JetString(this, "mappingName");
    public JetString expr = new JetString(this, "expression");
    public JetBoolean isTypeSet = new JetBoolean(this, "isTypeSet");
    public JetNumber type = new JetNumber(this, "type");
    public JetString type_name = new JetString(this, "typeName");
    public JetNumber precision = new JetNumber(this, "precision");
    public JetNumber length = new JetNumber(this, "length");
    public JetNumber scale = new JetNumber(this, "scale");
    public JetNumber radix = new JetNumber(this, "radix");
    public JetNumber nullable = new JetNumber(this, "nullable");
    public JetString remarks = new JetString(this, "remarks");
    private static final HashMap nameIdx = new HashMap(15);

    public JetStmtSelCol() {
    }

    public JetStmtSelCol(PsqlSelColumn selcol) {
        this.name.set(selcol.getName());
        this.tableName.set(selcol.sTableName);
        this.qlf.set(selcol.qualifier);
        this.owner.set(selcol.owner);
        this.mappingName.set(selcol.getMappingName());
        this.expr.set(selcol.getExpressionOfCompCol());
        this.isTypeSet.set(selcol.isTypeSet);
        this.type.set(selcol.type);
        this.type_name.set(selcol.type_name);
        this.precision.set(selcol.precision);
        this.length.set(selcol.length);
        this.scale.set(selcol.scale);
        this.radix.set(selcol.radix);
        this.nullable.set(selcol.nullable);
        this.remarks.set(selcol.remarks);
    }

    public StmtSelCol makeStmtSelCol() {
        StmtSelCol selcol = new StmtSelCol();
        this.setInfo(selcol);
        return selcol;
    }

    public PsqlSelColumn makeCompCol() {
        PsqlSelColumn selcol = new PsqlSelColumn();
        this.setInfo(selcol);
        selcol.isTypeSet = this.isTypeSet.get();
        String s = this.expr.get();
        if (s == null || s.trim().length() == 0) {
            s = "";
        }
        selcol.setExpressionOfCompCol(s);
        selcol.setCompCol(true);
        return selcol;
    }

    private void setInfo(PsqlSelColumn selcol) {
        selcol.setName(this.name.get());
        selcol.setMappingName(this.mappingName.get());
        selcol.qualifier = this.qlf.get();
        selcol.owner = this.owner.get();
        selcol.sTableName = this.tableName.get();
        selcol.type = this.type.get();
        selcol.type_name = this.type_name.get();
        selcol.precision = this.precision.get();
        selcol.length = this.length.get();
        selcol.scale = this.scale.get();
        selcol.radix = this.radix.get();
        selcol.nullable = this.nullable.get();
        selcol.remarks = this.remarks.get();
    }

    @Override
    public String getInstancePrefix() {
        return "SelectColumn";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropertyGroups() {
        HashVector grps = super.getPropertyGroups();
        if (grps.size() == 0) {
            return null;
        }
        return grps;
    }

    static {
        nameIdx.put("Qualifier", new Integer(0));
        nameIdx.put("precision", new Integer(1));
        nameIdx.put("name", new Integer(2));
        nameIdx.put("radix", new Integer(3));
        nameIdx.put("length", new Integer(4));
        nameIdx.put("isTypeSet", new Integer(5));
        nameIdx.put("remarks", new Integer(6));
        nameIdx.put("scale", new Integer(7));
        nameIdx.put("mappingName", new Integer(8));
        nameIdx.put("nullable", new Integer(9));
        nameIdx.put("expression", new Integer(10));
        nameIdx.put("type", new Integer(11));
        nameIdx.put("typeName", new Integer(12));
        nameIdx.put("TableName", new Integer(13));
        nameIdx.put("Owner", new Integer(14));
    }
}

