/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.connect.DbColumnLink;
import jet.connect.DbQuery;
import jet.connect.DbTableLink;
import jet.connect.JoinsIntf;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine8.core.queryengine.transform.AggInfos;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUFileQuery;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.psql.JoinedTable;
import toolkit.db.DbTools;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;
import toolkit.db.QueryIntf;
import toolkit.db.TableIntf;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.gui.JdbcDatabase;

public class JoinsImpl
implements JoinsIntf {
    private static JRLogger logger = JRLogger.getLogger(JetUFileQuery.class.getName());
    private static final String SYS_PROP_USE_LONG_OUTER_JOIN_TERM = "jrpt.outer";
    private static boolean use_long_outer_join_term = false;
    public static final String JOIN_TERM;
    public static final String LEFT_TERM = " LEFT";
    public static final String RIGHT_TERM = " RIGHT";
    public static final String FULL_TERM = " FULL OUTER";
    public static final String INNER_TERM = " INNER";
    public static final String ON_TERM = " ON ";
    private String strExtraNameChar = "";
    private String strQuoteChar = "\"";
    private String strExtraKeywords = "";
    private Vector joins = new Vector();
    private QueryIntf dbQry = null;
    private Vector tableLinks = null;
    private boolean changed = false;
    private SQLMapInfo sqlMapInfo = null;
    private AggInfos agginfos;
    private String sJoinedTables = null;
    private String sNon_joinedTables = null;
    private String selfConds = null;
    private String selectedColumns = null;
    private JetUUniverse universe;
    private String dataSourceName;
    private String queryName;
    private JetUConnection conn;
    private int innerJoinSpellType = -1;
    private String IN_JOIN_TERM = JOIN_TERM;
    private String OUT_JOIN_TERM = JOIN_TERM;
    private boolean noParentheses = false;
    private boolean isHive = false;

    public JoinsImpl(JetUUniverse universe, String dataSourceName, String queryName, JetUConnection conn) {
        this.universe = universe;
        this.dataSourceName = dataSourceName;
        this.queryName = queryName;
        this.conn = conn;
        if (conn instanceof JetUJDBCConnection) {
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)conn;
            this.innerJoinSpellType = jetUJDBCConnection.getInnerJoinSpellType();
            if (jetUJDBCConnection.isHive()) {
                this.OUT_JOIN_TERM = " OUTER JOIN ";
                this.IN_JOIN_TERM = " JOIN ";
                this.noParentheses = true;
                this.isHive = true;
            } else {
                String s = jetUJDBCConnection.getJdbcDriver();
                this.noParentheses = s.indexOf("org.hsqldb") != -1;
            }
        }
        this.changed = true;
    }

    @Override
    public String getJoinedTables() {
        if (this.changed || this.sJoinedTables == null) {
            this.resolveJoins();
        }
        return this.sJoinedTables;
    }

    @Override
    public String getNon_JoinedTables() {
        if (this.changed || this.sNon_joinedTables == null) {
            this.resolveOthers();
        }
        return this.sNon_joinedTables;
    }

    @Override
    public String getSelectedColumns() {
        if (this.changed || this.selectedColumns == null) {
            this.resolveOthers();
        }
        return this.selectedColumns;
    }

    @Override
    public String getSelfJoinConditions() {
        if (this.changed || this.selfConds == null) {
            this.resolveJoins();
        }
        return this.selfConds;
    }

    public void setSupportInfo(String strExtraNameChar, String strQuoteChar, String strExtraKeywords) {
        this.strExtraNameChar = strExtraNameChar;
        this.strQuoteChar = strQuoteChar;
        this.strExtraKeywords = strExtraKeywords;
    }

    public void addPsqlJoin(PsqlJoin psqlJ) {
        this.joins.addElement(psqlJ);
        this.changed = true;
    }

    public void setDbQuery(QueryIntf dbQry) {
        DbQuery dbQuery;
        JdbcDatabase db;
        this.dbQry = dbQry;
        this.tableLinks = dbQry.getTableLinksVector();
        this.changed = true;
        if (!this.isHive && this.dbQry instanceof DbQuery && (db = (dbQuery = (DbQuery)this.dbQry).getDb()) != null) {
            if (db.isSettingConnectionObject()) {
                Connection conn = db.getConnection();
                String databaseProductName = null;
                try {
                    databaseProductName = conn.getMetaData().getDatabaseProductName();
                }
                catch (SQLException e) {
                    return;
                }
                this.noParentheses = databaseProductName.indexOf("HSQL") != -1;
            } else {
                this.noParentheses = db.getJdbcDriver().indexOf("org.hsqldb") != -1;
            }
        }
    }

    public boolean isHSQL() {
        boolean ret = false;
        if (this.dbQry instanceof DbQuery) {
            DbQuery dbQuery = (DbQuery)this.dbQry;
            JdbcDatabase db = dbQuery.getDb();
            if (db != null) {
                if (db.isSettingConnectionObject()) {
                    String databaseProductName;
                    Connection conn = db.getConnection();
                    try {
                        databaseProductName = conn.getMetaData().getDatabaseProductName();
                    }
                    catch (SQLException e) {
                        return false;
                    }
                    ret = databaseProductName.indexOf("HSQL") != -1;
                } else {
                    ret = db.getJdbcDriver().indexOf("org.hsqldb") != -1;
                }
            }
        } else if (this.conn instanceof JetUJDBCConnection) {
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)this.conn;
            String s = jetUJDBCConnection.getJdbcDriver();
            ret = s.indexOf("org.hsqldb") != -1;
        }
        return ret;
    }

    public void setSQLMapInfo(SQLMapInfo sqlMapInfo) {
        this.sqlMapInfo = sqlMapInfo;
        this.changed = true;
    }

    private void resolveJoins() {
        if (this.joins == null || this.dbQry == null) {
            return;
        }
        this.sJoinedTables = "";
        this.selfConds = "";
        int sz = this.joins.size();
        Vector<PsqlJoin> outerJoins = new Vector<PsqlJoin>(20);
        Vector<TableIntf> ojTables = new Vector<TableIntf>(20);
        Hashtable<PsqlJoin, TableIntf[]> ojRefs = new Hashtable<PsqlJoin, TableIntf[]>();
        Object alias = null;
        for (int i = 0; i < sz; ++i) {
            boolean isSql92;
            TableIntf totbl;
            PsqlJoin pj = (PsqlJoin)this.joins.elementAt(i);
            if (pj.isSelfJoin() && pj.getTableFrom() == pj.getTableTo() && (totbl = DbTableLink.getTableByName(this.tableLinks, pj.getTableTo().getName(), pj.getTableTo().getCorrelationName(), pj.getTableTo().getOwner(), pj.getTableTo().getQualifier())) != null) {
                totbl.setSelfJoined(true);
                String cn = DbTools.getCorrelationNameOfTable(100, totbl.getTableName(false));
                totbl.setCorrelationName(cn);
                if (!this.selfConds.equals("")) {
                    this.selfConds = this.selfConds + " AND ";
                }
                this.selfConds = this.selfConds + pj.getTableFrom().getNameCorr(this.sqlMapInfo) + '.' + DbTools.quotedWhenNeed(pj.getColumnFrom().getName(this.sqlMapInfo), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords) + pj.getOperator() + cn + '.' + DbTools.quotedWhenNeed(pj.getColumnTo().getName(this.sqlMapInfo), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords);
            }
            boolean bl = isSql92 = this.conn instanceof JetUJDBCConnection ? ((JetUJDBCConnection)this.conn).isSql92() : false;
            if ((!pj.isOuterJoin() || !isSql92) && (pj.isOuterJoin() || this.innerJoinSpellType != 2)) continue;
            TableIntf fromtbl = DbTableLink.getTableByName(this.tableLinks, pj.getTableFrom().getName(), pj.getTableFrom().getCorrelationName(), pj.getTableFrom().getOwner(), pj.getTableFrom().getQualifier());
            totbl = DbTableLink.getTableByName(this.tableLinks, pj.getTableTo().getName(), pj.getTableTo().getCorrelationName(), pj.getTableTo().getOwner(), pj.getTableTo().getQualifier());
            if (fromtbl == null || totbl == null) continue;
            outerJoins.addElement(pj);
            ojRefs.put(pj, new TableIntf[]{fromtbl, totbl});
            if (!ojTables.contains(fromtbl)) {
                fromtbl.setOuterJoined(true);
                ojTables.addElement(fromtbl);
            }
            if (ojTables.contains(totbl)) continue;
            totbl.setOuterJoined(true);
            ojTables.addElement(totbl);
        }
        this.processOuterJoins(outerJoins, ojTables, ojRefs, this.universe, this.dataSourceName, this.queryName);
        this.changed = false;
    }

    private Vector getFirstJT(Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs) {
        joinedTables.removeAllElements();
        if (outerJoins.size() <= 0) {
            return null;
        }
        Vector ret = new Vector(20);
        PsqlJoin pj = (PsqlJoin)outerJoins.elementAt(0);
        TableIntf[] jts = (TableIntf[])ojRefs.get(pj);
        this.appendJT(new JoinedTable(pj, jts[0], jts[1]), outerJoins, tables, joinedTables, ojRefs, ret);
        return ret;
    }

    private void appendJT(JoinedTable jt, Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs, Vector vjts) {
        this.updateVectors(jt, outerJoins, tables, joinedTables, vjts);
        this.findANDJT(jt, outerJoins, tables, joinedTables, ojRefs, vjts);
    }

    private void updateVectors(JoinedTable jt, Vector outerJoins, Vector tables, Vector joinedTables, Vector vjts) {
        outerJoins.removeElement(jt.pj);
        vjts.addElement(jt);
        tables.removeElement(jt.from);
        tables.removeElement(jt.to);
        if (!joinedTables.contains(jt.from)) {
            joinedTables.addElement(jt.from);
        }
        if (!joinedTables.contains(jt.to)) {
            joinedTables.addElement(jt.to);
        }
    }

    private void findANDJT(JoinedTable jt, Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs, Vector vjts) {
        PsqlJoin pj = null;
        TableIntf[] jts = null;
        int sz = outerJoins.size();
        for (int i = sz - 1; i >= 0; --i) {
            pj = (PsqlJoin)outerJoins.elementAt(i);
            jts = (TableIntf[])ojRefs.get(pj);
            if (jts[0] == jt.from && jts[1] == jt.to || jts[1] == jt.from && jts[0] == jt.to) {
                this.updateVectors(new JoinedTable(pj, jts[0], jts[1]), outerJoins, tables, joinedTables, vjts);
                continue;
            }
            int sz2 = joinedTables.size();
            for (int j = 0; j < sz2; ++j) {
                TableIntf ti = (TableIntf)joinedTables.elementAt(j);
                if (!(jts[0] == jt.from && jts[1] == ti || jts[1] == jt.from && jts[0] == ti || jts[0] == jt.to && jts[1] == ti) && (jts[1] != jt.to || jts[0] != ti)) continue;
                this.updateVectors(new JoinedTable(pj, jts[0], jts[1]), outerJoins, tables, joinedTables, vjts);
            }
        }
    }

    private boolean findTable(TableIntf ti, Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs, Vector vjts) {
        PsqlJoin pj = null;
        TableIntf[] jts = null;
        int sz = outerJoins.size();
        for (int i = sz - 1; i >= 0; --i) {
            pj = (PsqlJoin)outerJoins.elementAt(i);
            jts = (TableIntf[])ojRefs.get(pj);
            if (jts[0] != ti && jts[1] != ti) continue;
            this.appendJT(new JoinedTable(pj, jts[0], jts[1]), outerJoins, tables, joinedTables, ojRefs, vjts);
            return true;
        }
        return false;
    }

    private boolean findJT(JoinedTable jtFrom, Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs, Vector vjts) {
        return this.findTable(jtFrom.to, outerJoins, tables, joinedTables, ojRefs, vjts) || this.findTable(jtFrom.from, outerJoins, tables, joinedTables, ojRefs, vjts);
    }

    private Vector getNextJT(JoinedTable jtFrom, Vector outerJoins, Vector tables, Vector joinedTables, Hashtable ojRefs) {
        if (outerJoins.size() <= 0) {
            return null;
        }
        Vector ret = new Vector(20);
        if (!this.findJT(jtFrom, outerJoins, tables, joinedTables, ojRefs, ret)) {
            int sz = joinedTables.size();
            for (int i = 0; i < sz && !this.findTable((TableIntf)joinedTables.elementAt(i), outerJoins, tables, joinedTables, ojRefs, ret); ++i) {
            }
        }
        return ret;
    }

    private void makeJTString(JoinedTable jt, Vector outTables, StringBuffer sb, JetUUniverse universe, String dataSourceName, String queryName) {
        PsqlTable t2;
        PsqlJoin pj = jt.pj;
        boolean reverse = false;
        if (outTables.contains(jt.from)) {
            t2 = pj.getTableTo();
            if (!(this.isHive || this.noParentheses && !pj.isOuterJoin())) {
                sb.insert(0, '(');
                sb.append(')');
            }
        } else if (outTables.contains(jt.to)) {
            t2 = pj.getTableFrom();
            reverse = true;
            if (!(this.isHive || this.noParentheses && !pj.isOuterJoin())) {
                sb.insert(0, '(');
                sb.append(')');
            }
        } else {
            t2 = pj.getTableTo();
            sb.append(pj.getTableFrom().getTableRef(this.dbQry.getQlfOpt(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, this.sqlMapInfo));
            outTables.addElement(jt.from);
        }
        if (!pj.isOuterJoin()) {
            sb.append(INNER_TERM).append(this.IN_JOIN_TERM);
        } else if (pj.isFullOuterJoin()) {
            sb.append(FULL_TERM).append(this.IN_JOIN_TERM);
        } else if (pj.isLeftOuterJoin()) {
            sb.append(reverse ? RIGHT_TERM : LEFT_TERM).append(this.OUT_JOIN_TERM);
        } else {
            sb.append(reverse ? LEFT_TERM : RIGHT_TERM).append(this.OUT_JOIN_TERM);
        }
        sb.append(t2.getTableRef(this.dbQry.getQlfOpt(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, this.sqlMapInfo));
        sb.append(ON_TERM);
        this.makeCondString(jt, sb, universe, dataSourceName, queryName);
        outTables.addElement(reverse ? jt.from : jt.to);
    }

    private void makeCondString(JoinedTable jt, StringBuffer sb, JetUUniverse universe, String dataSourceName, String queryName) {
        PsqlJoin pj = jt.pj;
        sb.append('(');
        sb.append(ExpressionToolKit.getJoinCondition((IUnCheckedExpression)jt.pj.getJoinCondition(), universe, dataSourceName, queryName));
        sb.append(')');
    }

    private void makeJTString(Vector jts, Vector outTables, StringBuffer sb, JetUUniverse universe, String dataSourceName, String queryName) {
        JoinedTable jt = null;
        Object pj = null;
        this.makeJTString((JoinedTable)jts.elementAt(0), outTables, sb, universe, dataSourceName, queryName);
        int sz = jts.size();
        for (int i = 1; i < sz; ++i) {
            jt = (JoinedTable)jts.elementAt(i);
            sb.append(" AND ");
            this.makeCondString(jt, sb, universe, dataSourceName, queryName);
        }
    }

    private void processOuterJoins(Vector outerJoins, Vector ojTables, Hashtable ojRefs, JetUUniverse universe, String dataSourceName, String queryName) {
        if (outerJoins.size() <= 0) {
            return;
        }
        this.sJoinedTables = "";
        Vector joins = (Vector)outerJoins.clone();
        Vector tables = (Vector)ojTables.clone();
        Vector joinedTables = new Vector(20);
        Vector outTables = new Vector(40);
        Vector pjs = null;
        int sz = joins.size();
        while (joins.size() > 0) {
            StringBuffer sb = new StringBuffer();
            pjs = this.getFirstJT(joins, tables, joinedTables, ojRefs);
            while (pjs != null && pjs.size() > 0) {
                this.makeJTString(pjs, outTables, sb, universe, dataSourceName, queryName);
                pjs = this.getNextJT((JoinedTable)pjs.elementAt(0), joins, tables, joinedTables, ojRefs);
            }
            if (this.sJoinedTables.length() > 0) {
                sb.insert(0, ", ");
            }
            this.sJoinedTables = this.sJoinedTables + sb.toString();
        }
        this.changed = false;
    }

    private void resolveOthers() {
        if (this.changed || this.sJoinedTables == null || this.selfConds == null) {
            this.resolveJoins();
        }
        if (this.joins == null || this.dbQry == null) {
            return;
        }
        this.sNon_joinedTables = "";
        this.selectedColumns = "";
        int qlfOpt = this.dbQry.getQlfOpt();
        Vector vTables = this.tableLinks;
        int sz = vTables.size();
        HashMap hColumnsList = null;
        HashMap<String, String> hAlias_mapp = null;
        if (this.agginfos != null) {
            hColumnsList = this.agginfos.getColumns();
            hAlias_mapp = new HashMap<String, String>();
        }
        for (int iTable = 0; iTable < sz; ++iTable) {
            TableIntf xoTheTable = (TableIntf)vTables.elementAt(iTable);
            List columnLinks = xoTheTable.getColumns();
            DbColumnLink clink = null;
            if (!xoTheTable.isOuterJoined()) {
                String tbn = xoTheTable.getTableRef(qlfOpt, this.sqlMapInfo);
                if (!this.sNon_joinedTables.equals("")) {
                    this.sNon_joinedTables = this.sNon_joinedTables + ',';
                }
                this.sNon_joinedTables = this.sNon_joinedTables + tbn;
            }
            Vector vColumns = xoTheTable.getColumnsVector(this.sqlMapInfo);
            int iCols = vColumns.size();
            for (int iCol = 0; iCol < iCols; ++iCol) {
                String colName = (String)vColumns.elementAt(iCol);
                String tname = xoTheTable.getQaulifiedName(qlfOpt, this.sqlMapInfo);
                String strTheCol = tname + '.' + DbTools.quotedWhenNeed(colName, this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords);
                if (!this.selectedColumns.equals("")) {
                    this.selectedColumns = this.selectedColumns + ',';
                }
                this.selectedColumns = this.selectedColumns + strTheCol;
                if (hColumnsList == null) continue;
                clink = (DbColumnLink)columnLinks.get(iCol);
                String colNameQuoted = DbTools.quotedWhenNeed(colName, this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords);
                if (!hAlias_mapp.containsKey(colNameQuoted)) {
                    hColumnsList.put(clink.getMappingName().toUpperCase(), colNameQuoted);
                    hAlias_mapp.put(colNameQuoted, clink.getMappingName().toUpperCase());
                    continue;
                }
                String aliasName = null;
                colNameQuoted = null;
                int postfix = 1;
                while (hAlias_mapp.containsKey(colNameQuoted = DbTools.quotedWhenNeed(aliasName = colName + postfix++, this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords))) {
                }
                this.selectedColumns = this.selectedColumns + " AS " + colNameQuoted;
                hColumnsList.put(clink.getMappingName().toUpperCase(), colNameQuoted);
                hAlias_mapp.put(colNameQuoted, clink.getMappingName().toUpperCase());
            }
        }
    }

    @Override
    public void setAggInfos(AggInfos agginfos) {
        this.agginfos = agginfos;
    }

    @Override
    public AggInfos getAggInfos() {
        return this.agginfos;
    }

    static {
        try {
            String s = System.getProperty(SYS_PROP_USE_LONG_OUTER_JOIN_TERM);
            if (s != null && s.trim().equalsIgnoreCase("true")) {
                use_long_outer_join_term = true;
            }
        }
        catch (Throwable t) {
            logger.debug(t);
        }
        JOIN_TERM = use_long_outer_join_term ? " OUTER JOIN " : " JOIN ";
    }
}

