/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import com.jinfonet.dataservice.expression.set.SortInformationImpl;
import com.jinfonet.dataservice.expression.variable.ReferenceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.transform.ModelKey;
import jet.universe.JetUConnection;
import jet.universe.JetUQuery;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;

public class OneExecutionQueryInfo {
    public static int TABLE = 0;
    public static int QUERIABLE = 1;
    private String key = null;
    private Vector<String> tableMappingNames = new Vector();
    int iType = 0;
    String formulaSelection = null;
    String serverSelection = null;
    Vector<PsqlJoin> joins = new Vector();
    private JetUConnection jcon = null;
    HashMap<PsqlTable, SortInformationImpl[]> sorts = null;
    HashSet<PsqlTable> localJoines = null;
    String whereFormulaName = null;

    public OneExecutionQueryInfo(int type, String tableName, JetUConnection jcon, String parentQueryName) {
        this.jcon = jcon;
        this.iType = type;
        if (type == TABLE) {
            this.key = jcon.getResourceName();
            this.tableMappingNames.add(tableName);
        } else if (type == QUERIABLE) {
            this.key = parentQueryName;
            this.tableMappingNames.add(tableName);
        }
    }

    public String getParentName() {
        return this.key;
    }

    public OneExecutionQueryInfo(Vector<String> tableNames, JetUConnection jcon, String keyWithLevel2) {
        this.jcon = jcon;
        this.iType = TABLE;
        this.key = keyWithLevel2;
        this.tableMappingNames = tableNames;
    }

    public boolean isValid(HashSet<ModelKey> tabMappingNames) {
        int iSize = tabMappingNames.size();
        for (ModelKey key : tabMappingNames) {
            if (key.getType() == this.getType() && this.tableMappingNames.contains(key.getMappingName())) continue;
            return false;
        }
        return true;
    }

    public void setFormulaSelection(String formulaSelection) {
        if (!jet.util.StringTools.nullOrAllSpaces(formulaSelection)) {
            this.formulaSelection = this.formulaSelection == null ? formulaSelection : this.formulaSelection + " && " + formulaSelection;
        }
    }

    public String getFormulaSelection() {
        return this.formulaSelection;
    }

    public void setServerSelection(String serverSelection) {
        if (!jet.util.StringTools.nullOrAllSpaces(serverSelection)) {
            this.serverSelection = this.serverSelection == null ? serverSelection : this.serverSelection + " AND " + serverSelection;
        }
    }

    public String getServerSelection() {
        return this.serverSelection;
    }

    public void addTable(String table) {
        this.tableMappingNames.add(table);
    }

    public Vector<String> getTables() {
        return this.tableMappingNames;
    }

    public JetUConnection getConnection() {
        return this.jcon;
    }

    public int getType() {
        return this.iType;
    }

    public boolean put(PsqlJoin join, JetUQuery uQuery) {
        PsqlTable from = join.getTableFrom();
        PsqlTable to = join.getTableTo();
        PsqlTable localJoined = null;
        if (this.tableMappingNames.contains(from.getMappingName())) {
            if (this.tableMappingNames.contains(to.getMappingName())) {
                this.joins.add(join);
                return true;
            }
            localJoined = from;
        } else if (this.tableMappingNames.contains(to.getMappingName())) {
            localJoined = to;
        }
        if (localJoined != null) {
            if (this.localJoines == null) {
                this.localJoines = new HashSet();
            }
            if (!this.localJoines.contains(localJoined)) {
                this.localJoines.add(localJoined);
            }
            IUnCheckedExpression ie = (IUnCheckedExpression)join.getJoinCondition();
            IUnCheckedVariableExpression[] variables = ExpressionToolKit.getUnCheckedVariableExpressions(ie);
            String name2 = null;
            ArrayList<SortInformationImpl> ret = new ArrayList<SortInformationImpl>();
            SortInformationImpl cur = null;
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isConstantValue() || (name2 = variables[i].getValue()).indexOf(46) < 0) continue;
                String tableMappingName = name2.substring(0, name2.indexOf(46));
                String columnMappingName = name2.substring(name2.indexOf(46) + 1);
                if (StringTools.isStartAndEndWithSpecialChar(tableMappingName, '\"')) {
                    tableMappingName = StringTools.removeChar4BeginAndEnd(tableMappingName, '\"');
                }
                if (StringTools.isStartAndEndWithSpecialChar(columnMappingName, '\"')) {
                    columnMappingName = StringTools.removeChar4BeginAndEnd(columnMappingName, '\"');
                }
                if (!tableMappingName.equalsIgnoreCase(localJoined.getMappingName()) || !uQuery.canPushdownSort(columnMappingName)) continue;
                try {
                    cur = new SortInformationImpl(new ReferenceImpl(columnMappingName), 1, false);
                    ret.add(cur);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ret.size() > 0) {
                if (this.sorts == null) {
                    this.sorts = new HashMap();
                }
                this.sorts.put(localJoined, ret.toArray(new SortInformationImpl[0]));
            }
        }
        return false;
    }

    public HashMap<PsqlTable, SortInformationImpl[]> getPushdownSorts() {
        return this.sorts;
    }

    public Vector<OneExecutionQueryInfo> splitCartesianProduct() {
        if (this.tableMappingNames.size() < 2) {
            return null;
        }
        Vector<OneExecutionQueryInfo> ret = null;
        OneExecutionQueryInfo tmp = null;
        if (this.localJoines != null && this.localJoines.size() > 1) {
            for (PsqlTable key : this.localJoines) {
                String mName = key.getMappingName();
                int iSize = this.joins != null ? this.joins.size() : 0;
                boolean bJoined = false;
                for (int i = 0; i < iSize; ++i) {
                    PsqlJoin cur = this.joins.get(i);
                    if (!cur.getTableFrom().getMappingName().equals(mName) && !cur.getTableTo().getMappingName().equals(mName)) continue;
                    bJoined = true;
                    break;
                }
                if (bJoined) continue;
                Vector<String> newNames = new Vector<String>();
                newNames.add(mName);
                tmp = new OneExecutionQueryInfo(newNames, this.getConnection(), this.key + "." + mName);
                if (this.sorts != null && this.sorts.get(key) != null) {
                    tmp.putSorts(key, this.sorts.get(key));
                    this.sorts.remove(key);
                }
                if (ret == null) {
                    ret = new Vector<OneExecutionQueryInfo>();
                }
                ret.add(tmp);
                this.tableMappingNames.remove(mName);
                if (this.tableMappingNames.size() >= 2) continue;
                break;
            }
        }
        return ret;
    }

    public void putSorts(PsqlTable table, SortInformationImpl[] sInfo) {
        if (table != null && sInfo != null) {
            if (this.sorts == null) {
                this.sorts = new HashMap();
            }
            this.sorts.put(table, sInfo);
        }
    }

    public void setWhereFormulaName(String whereFormulaName) {
        this.whereFormulaName = whereFormulaName;
    }

    public String getWhereFormulaName() {
        return this.whereFormulaName;
    }

    public Vector<PsqlJoin> getJoins() {
        return this.joins;
    }
}

