/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.universe.JetUConnection;
import jet.universe.JetUField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.engine.UPsqlQueryEngine;
import jet.universe.psql.RptPsqlQuery;
import jet.util.DbValueComparer;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.ColumnInfo;
import toolkit.db.api.ParameterInfo;
import toolkit.db.api.QueryInfo;

public class QueryInfoBuilder {
    public static QueryInfo buildQueryInfo(UPsqlQueryEngine queryEngine) {
        Vector[] aOrderBys;
        Hashtable htParameters;
        Vector vSubLinks;
        QueryInfo queryInfo = new QueryInfo();
        RptPsqlQuery query = queryEngine.getPsqlQuery();
        QueryInfoBuilder.setQueryName(queryInfo, queryEngine.getQueryName());
        QueryInfoBuilder.setConnection(queryInfo, queryEngine.getConnection());
        QueryInfoBuilder.setDistinct(queryInfo, query.isDistinct());
        QueryInfoBuilder.setIgnorePredicateIfParamIsNull(queryInfo, query.isIgnorePredicateIfParamIsNull());
        QueryInfoBuilder.addPsqlTablesAndPsqlColumns(queryInfo, query.getPsqlTablesVector());
        QueryInfoBuilder.addPsqlSelColumns(queryInfo, query.getSelColsVector(), queryEngine.getSelectColNames());
        Hashtable canSqlFmlwheres = queryEngine.getCanbeSqlFormulaWhere();
        JetRptFormula rptFormula = null;
        JetUFormula ufml = null;
        String value = null;
        Enumeration fmls = canSqlFmlwheres.keys();
        while (fmls.hasMoreElements()) {
            ufml = (JetUFormula)fmls.nextElement();
            rptFormula = ufml.createNewJetRptFmlInstance();
            String val = (String)canSqlFmlwheres.get(ufml);
            value = ufml.isConstant() ? (val.trim().length() > 0 ? val : null) : null;
            queryInfo.addFormula(rptFormula.getName(), rptFormula.getExpression(), value, false);
        }
        QueryInfoBuilder.addPsqlJoins(queryInfo, query.getPsqlJoinsVector(), queryEngine.getConnection());
        Vector vPsqlColumns = query.getSelColsVector();
        for (int i = 0; i < vPsqlColumns.size(); ++i) {
            PsqlSelColumn column = (PsqlSelColumn)vPsqlColumns.elementAt(i);
            String colMappingName = column.getMappingName();
            Vector conditions = column.getConditionsVector();
            for (int j = 0; j < conditions.size(); ++j) {
                String cond = (String)conditions.elementAt(j);
                if (cond == null || cond.trim().equals("")) continue;
                queryInfo.addQbeCriterion(colMappingName, j, cond);
            }
        }
        Vector vGrps = null;
        vGrps = queryEngine.getUWherePortion() != null ? queryEngine.getUWherePortion().getGroups() : query.getSearchConditionGroupsAsQuaternion();
        if (vGrps != null) {
            for (int i = 0; i < vGrps.size(); ++i) {
                Vector grp = (Vector)vGrps.elementAt(i);
                for (int j = 0; j < grp.size(); ++j) {
                    String[] rec = (String[])grp.elementAt(j);
                    queryInfo.addAnd(rec[0], rec[1], rec[2], rec[3], j == grp.size() - 1);
                }
            }
        }
        if (queryEngine.getUWherePortion() == null) {
            queryInfo.setWherePortionString(queryEngine.getWherePortionString());
        }
        if ((vSubLinks = queryEngine.getSubLinks()) != null) {
            for (int i = 0; i < vSubLinks.size(); ++i) {
                DbValueComparer link = (DbValueComparer)vSubLinks.elementAt(i);
                queryInfo.addSubLink(link.getColumnName(), link.getOperString(), link.value.isNull() ? null : link.getValueString());
            }
        }
        if ((htParameters = queryEngine.getParamsBuff()) != null) {
            Enumeration e = htParameters.elements();
            while (e.hasMoreElements()) {
                ParamDesc paramDesc = (ParamDesc)e.nextElement();
                queryInfo.addParameter(paramDesc.name, paramDesc.type, paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
            }
        }
        if ((aOrderBys = queryEngine.getOrderBys()) != null) {
            for (int i = 0; i < aOrderBys[0].size(); ++i) {
                String mapname = (String)aOrderBys[0].elementAt(i);
                ParamDesc paramDesc = (ParamDesc)htParameters.get(mapname.toUpperCase());
                if (paramDesc != null) {
                    mapname = paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault());
                }
                if (queryInfo.getColumn(mapname.toUpperCase()) == null) continue;
                queryInfo.addOrderBy(mapname, (String)aOrderBys[1].elementAt(i));
            }
        }
        return queryInfo;
    }

    public static void updateSubLinks(QueryInfo queryInfo, Vector theSubLinks) {
        queryInfo.removeAllSubLinks();
        for (int i = 0; i < theSubLinks.size(); ++i) {
            DbValueComparer link = (DbValueComparer)theSubLinks.elementAt(i);
            String col = link.getColumnName();
            Object o = queryInfo.getEntityByName(col);
            if (o instanceof ColumnInfo) {
                queryInfo.addSubLink(link.getColumnName(), link.getOperString(), link.value.isNull() ? null : link.getValueString());
                continue;
            }
            queryInfo.updateParameterValue(col, link.getValue().toString());
        }
    }

    public static QueryInfo buildQueryInfo(JetUUniverse unvs, JetUTableView table, JetUField[] aFields, boolean bDistinct) {
        QueryInfo queryInfo = new QueryInfo();
        QueryInfoBuilder.setQueryName(queryInfo, null);
        QueryInfoBuilder.setConnection(queryInfo, (JetUJDBCConnection)table.getConnection());
        QueryInfoBuilder.setDistinct(queryInfo, bDistinct);
        QueryInfoBuilder.addUTable(queryInfo, table);
        QueryInfoBuilder.addUFields(queryInfo, aFields);
        return queryInfo;
    }

    private static void setQueryName(QueryInfo queryInfo, String queryName) {
        queryInfo.setQueryName(queryName);
    }

    private static void setConnection(QueryInfo queryInfo, JetUJDBCConnection jCon) {
        queryInfo.setConnection(jCon.drv.get(), jCon.url.get(), jCon.user.get(), jCon.password.get(), jCon.dateFormat.get(), jCon.timeFormat.get(), jCon.timestampFormat.get(), (Integer)jCon.transactionIsolation.get(), (Integer)jCon.readOnly.get(), (Integer)jCon.qualifiedNamePattern.get(), (Integer)jCon.extraNamePattern.get(), (Integer)jCon.encodingPattern.get());
    }

    private static void setDistinct(QueryInfo queryInfo, boolean bDistinct) {
        queryInfo.setDistinct(bDistinct);
    }

    private static void setIgnorePredicateIfParamIsNull(QueryInfo queryInfo, boolean bIgnorePredicateIfParamIsNull) {
        queryInfo.setIgnorePredicateIfParamIsNull(bIgnorePredicateIfParamIsNull);
    }

    private static void addPsqlTablesAndPsqlColumns(QueryInfo queryInfo, Vector vTables) {
        Vector columns = null;
        for (int i = 0; i < vTables.size(); ++i) {
            PsqlTable table = (PsqlTable)vTables.elementAt(i);
            queryInfo.addTable(table.getMappingName(), table.getName(), table.getCorrelationName(), table.getOwner(), table.getQualifier());
            columns = table.getColumns();
            for (int j = 0; j < columns.size(); ++j) {
                PsqlColumn column = (PsqlColumn)columns.elementAt(j);
                queryInfo.addColumn(column.getMappingName(), column.getName(), null, false, table.getMappingName(), Integer.MIN_VALUE);
            }
        }
    }

    private static void addUTable(QueryInfo queryInfo, JetUTableView table) {
        queryInfo.addTable(table.getResourceName(), table.getTableName(), null, table.getOwner(), table.getQualifier());
    }

    private static void addPsqlSelColumns(QueryInfo queryInfo, Vector vColumns, String[] selectColumnNames) {
        for (int i = 0; i < vColumns.size(); ++i) {
            PsqlSelColumn column = (PsqlSelColumn)vColumns.elementAt(i);
            String mappingName = column.getMappingName();
            int columnIndex = -2147483647;
            for (int j = 0; j < selectColumnNames.length; ++j) {
                if (!selectColumnNames[j].equalsIgnoreCase(mappingName)) continue;
                columnIndex = j;
            }
            queryInfo.addColumn(column.getMappingName(), column.getName(), column.getExpressionOfCompCol(), column.isCompCol(), column.getPsqlTable() == null ? null : column.getPsqlTable().getMappingName(), columnIndex);
        }
    }

    private static void addUFields(QueryInfo queryInfo, JetUField[] aFields) {
        for (int i = 0; i < aFields.length; ++i) {
            queryInfo.addColumn(aFields[i].getResourceName(), aFields[i].getFldName(), null, false, aFields[i].getTable().getResourceName(), i);
        }
    }

    private static void addPsqlJoins(QueryInfo queryInfo, Vector vJoins, JetUConnection conn) {
        boolean isSql92 = conn instanceof JetUJDBCConnection ? ((JetUJDBCConnection)conn).isSql92() : false;
        for (int i = 0; i < vJoins.size(); ++i) {
            PsqlJoin join = (PsqlJoin)vJoins.elementAt(i);
            queryInfo.addJoin(join.getColumnFrom().getMappingName(), join.getOperator(), join.getColumnTo().getMappingName(), join.getOuterJoin(), isSql92, join.isSelfJoin());
        }
    }

    public static ParameterInfo buildParameterInfo(ParamDesc paramDesc) {
        return new ParameterInfo(paramDesc.name, paramDesc.type, paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault()));
    }
}

