/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.psql.RptPsqlTools;
import jet.util.StringTools;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.sql.ColumnReference;
import toolkit.db.sql.MappingName;
import toolkit.db.sql.NameFinder;
import toolkit.db.sql.RowValueConstructor;
import toolkit.db.sql.SqlTools;
import toolkit.db.sql.Subquery;

public class RptPsqlNameFinder
implements NameFinder {
    public RptPsqlQuery qry = null;
    boolean isJinfonetJdbcObjDrv = false;
    private static JRLogger logger = JRLogger.getLogger(RptPsqlNameFinder.class.getName());

    public RptPsqlNameFinder(RptPsqlQuery qry) {
        this.qry = qry;
    }

    @Override
    public boolean isLocalName(MappingName mapn) {
        this.isJinfonetJdbcObjDrv = this.qry.isJinfonetObjProtocal();
        if (this.isJinfonetJdbcObjDrv) {
            mapn.toLocal = true;
        }
        Object obj = null;
        JetUDatabase udb = this.qry.getDatabase();
        JetUConnection ucon = this.qry.getUConnection();
        if (mapn != null && mapn.hasAt) {
            int specType = DbTools.isSpecialField(mapn.name);
            switch (specType) {
                case 0: {
                    mapn.type = 4;
                    String uName = this.qry.getRptUserName();
                    mapn.paramVal = DbTools.makeSqlString(uName);
                    return false;
                }
            }
        }
        if (mapn instanceof ColumnReference) {
            ColumnReference colref = (ColumnReference)mapn;
            String name2 = SqlTools.removeQuotes(colref.col);
            mapn.obj = udb.getFormulaByResourceName(name2);
            String strExtraNameChar = "";
            String strQuoteChar = "\"";
            String strExtraKeywords = "";
            if (mapn.obj != null && colref.tab == null) {
                colref.type = 1;
                colref.name = DbTools.quotedWhenNeed(name2, strExtraNameChar, strQuoteChar, strExtraKeywords);
                this.qry.getFormulaValuePairs().put(mapn.obj, "");
                this.qry.getMappingNameFormulaPairs().put(mapn, mapn.obj);
                return this.qry.getLocalId((JetUFormula)mapn.obj);
            }
            JetUParameter up = udb.getParameterByResourceName(name2);
            if (up != null && colref.tab == null) {
                colref.name = DbTools.quotedWhenNeed(name2, strExtraNameChar, strQuoteChar, strExtraKeywords);
                colref.type = 2;
                colref.obj = up;
                colref.paramVal = RptPsqlTools.getDefaultValueOfUParameter(up);
                this.qry.getParameterValuePairs().put(up, "");
                this.qry.getParameterObjectPairs().put(new MappingName[]{colref}, up);
                return this.isJinfonetJdbcObjDrv;
            }
            JetUTableView utb = null;
            String tab = SqlTools.removeQuotes(colref.tab);
            String strQualifier = SqlTools.removeQuotes(colref.cat);
            String strOwner = SqlTools.removeQuotes(colref.sch);
            if (colref.tab != null) {
                PsqlColumn col;
                String stmp = tab;
                PsqlTable ptb = PsqlTable.getTableByName(this.qry.getPsqlTables(), strQualifier, strOwner, tab, false);
                if (ptb != null && (col = ptb.getColumnByName(name2)) != null) {
                    mapn.obj = udb.getResourceByName(col.getMappingName());
                    colref.name = DbTools.quotedWhenNeed(col.getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
                    return this.isJinfonetJdbcObjDrv;
                }
                if (ucon == null) {
                    JetUConnection[] cons = this.qry.getALLConnections();
                    for (int i = 0; i < cons.length && (utb = cons[i].getTableViewBy3PartName(strQualifier, strOwner, tab, 15)) == null; ++i) {
                    }
                } else {
                    utb = ucon.getTableViewBy3PartName(strQualifier, strOwner, tab, 15);
                }
                if (utb == null) {
                    utb = ucon != null ? udb.GetTableOrViewByResourceName(ucon.getResourceName(), tab) : udb.GetTableOrViewByResourceName(tab);
                }
                if (utb == null && (col = this.qry.findSelColByTableAliasColName(tab, name2)) != null) {
                    mapn.obj = udb.getResourceByName(((PsqlSelColumn)col).getMappingName());
                    colref.name = DbTools.quotedWhenNeed(((PsqlSelColumn)col).getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
                    return this.isJinfonetJdbcObjDrv;
                }
            } else {
                PsqlSelColumn selectedColumn = PsqlSelColumn.getSelColByDBColumnName(this.qry.getSelColsVector(), name2);
                if (selectedColumn != null) {
                    colref.name = DbTools.quotedWhenNeed(selectedColumn.getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
                    mapn.obj = udb.getResourceByName(selectedColumn.getMappingName());
                    return this.isJinfonetJdbcObjDrv;
                }
                Vector tables = this.qry.getPsqlTablesVector();
                int tabSize = tables.size();
                for (int i = 0; i < tabSize; ++i) {
                    PsqlTable ptb = (PsqlTable)tables.get(i);
                    PsqlColumn col = ptb.getColumnByName(name2);
                    if (col == null) continue;
                    mapn.obj = udb.getResourceByName(col.getMappingName());
                    colref.name = DbTools.quotedWhenNeed(col.getMappingName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
                    return this.isJinfonetJdbcObjDrv;
                }
                JetUResourceEntity ure = udb.getResourceByName(name2);
                if (ure != null && (ure instanceof JetUDBField || ure instanceof JetUFldQueryField)) {
                    mapn.obj = ure;
                    colref.name = DbTools.quotedWhenNeed(name2, strExtraNameChar, strQuoteChar, strExtraKeywords);
                    return this.isJinfonetJdbcObjDrv;
                }
                String stmp = ((PsqlTable)this.qry.getPsqlTablesVector().elementAt(0)).getName();
                if (ucon != null) {
                    utb = udb.GetTableOrViewByRealName(ucon.getResourceName(), stmp);
                } else {
                    JetUConnection[] cons = this.qry.getALLConnections();
                    for (int i = 0; i < cons.length && (utb = udb.GetTableOrViewByRealName(cons[i].getResourceName(), stmp)) == null; ++i) {
                    }
                }
            }
            JetUField ufld = null;
            colref.name = utb == null ? DbTools.quotedWhenNeed(name2, strExtraNameChar, strQuoteChar, strExtraKeywords) : ((ufld = utb.getFieldByFieldName(name2)) != null ? DbTools.quotedWhenNeed(ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords) : DbTools.quotedWhenNeed(name2, strExtraNameChar, strQuoteChar, strExtraKeywords));
            mapn.obj = ufld;
            return this.isJinfonetJdbcObjDrv;
        }
        String name3 = SqlTools.removeQuotes(mapn.name);
        mapn.obj = udb.getFormulaByResourceName(name3);
        if (mapn.obj != null) {
            mapn.type = 1;
            this.qry.getFormulaValuePairs().put(mapn.obj, "");
            this.qry.getMappingNameFormulaPairs().put(mapn, mapn.obj);
            boolean b = this.qry.getLocalId((JetUFormula)mapn.obj);
            return b;
        }
        JetUParameter up = udb.getParameterByResourceName(name3);
        if (up != null) {
            mapn.type = 2;
            mapn.paramVal = RptPsqlTools.getDefaultValueOfUParameter(up);
            mapn.obj = up;
            this.qry.getParameterValuePairs().put(up, "");
            this.qry.getParameterObjectPairs().put(new MappingName[]{mapn}, up);
            return this.isJinfonetJdbcObjDrv;
        }
        JetUResourceEntity ure = udb.getResourceByName(name3);
        mapn.obj = ure;
        if (ure != null) {
            if (ure instanceof JetUDBField || ure instanceof JetUFldQueryField) {
                mapn.type = 0;
                return this.isJinfonetJdbcObjDrv;
            }
            if (ure instanceof JetUFmlQueryField) {
                mapn.type = 1;
                return true;
            }
        }
        return this.isJinfonetJdbcObjDrv;
    }

    @Override
    public String getParameterValue(String name2) {
        JetUParameter up = this.qry.getDatabase().getParameterByResourceName(name2);
        if (up != null) {
            return RptPsqlTools.getDefaultValueOfUParameter(up);
        }
        return null;
    }

    @Override
    public String getFieldName(MappingName mapn) {
        JetUSupportInfo suppInfo;
        String strExtraNameChar = "";
        String strQuoteChar = "\"";
        String strExtraKeywords = "";
        JetUConnection jCnnt = this.qry.getUConnection();
        if (jCnnt == null && mapn.obj != null && mapn.obj instanceof JetUResourceEntity) {
            jCnnt = ExpressionToolKit.getJetUConnectionByField(this.qry.getUniverse(), this.qry.getDataSourceName(), ((JetUResourceEntity)mapn.obj).getResourceName());
        }
        if ((suppInfo = this.qry.getSupportInfoByConn(jCnnt)) != null) {
            strExtraNameChar = suppInfo.getExtraNameChar();
            strQuoteChar = suppInfo.getQuoteChar();
            strExtraKeywords = suppInfo.getExtraKeywords();
        }
        String str = mapn.name;
        switch (mapn.type) {
            case 0: {
                if (mapn.obj == null) break;
                int qlfopt = jCnnt != null ? jCnnt.getQualifiedNamePattern() : 1;
                SQLMapInfo sqlMapInfo = this.qry.getSQLMapInfo();
                if (mapn.obj instanceof JetUField) {
                    JetUField ufld = (JetUField)mapn.obj;
                    JetUTableView utbl = ufld.getTable();
                    if (utbl != null && utbl.isAlias()) {
                        str = PsqlTable.getQaulifiedName(qlfopt, "", "", utbl.getResourceName(), utbl.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
                        break;
                    }
                    if (utbl != null && !StringTools.nullOrAllSpaces(utbl.getTableName())) {
                        str = PsqlTable.getQaulifiedName(qlfopt, utbl.getQualifier(), utbl.getOwner(), utbl.getTableName(), utbl.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
                        break;
                    }
                    str = PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
                    break;
                }
                if (!(mapn.obj instanceof JetUFldQueryField)) break;
                JetUFldQueryField ufld = (JetUFldQueryField)mapn.obj;
                PsqlSelColumn pcol = ufld.getPsqlSelColumn();
                if (pcol != null) {
                    if (pcol.isCompCol()) {
                        str = pcol.getExpressionOfCompCol();
                        break;
                    }
                    PsqlTable ptbl = pcol.getPsqlTable();
                    if (ptbl != null) {
                        str = ptbl.getQaulifiedNameCorr(qlfopt, strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo) + "." + pcol.getQuotedName(strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
                        break;
                    }
                    str = PsqlTable.getQaulifiedName(qlfopt, "", "", ufld.getTable().getTableName(), ufld.getTable().getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
                    break;
                }
                str = PsqlTable.getQaulifiedName(qlfopt, "", "", ufld.getTable().getTableName(), ufld.getTable().getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords, sqlMapInfo);
            }
        }
        return str;
    }

    @Override
    public Object prepareSubquery(Subquery subquery) {
        JetUUniverse unvs = this.qry.getUniverse();
        JetUQuery uq = this.qry.getDatabase().GetQueryByResourceName(subquery.name);
        String nameWithoutquote = SqlTools.removeQuotes(subquery.name);
        if (uq == null) {
            uq = this.qry.getDatabase().GetQueryByResourceName(nameWithoutquote);
        }
        JetUFileQuery ufq = null;
        if (uq == null) {
            JetUConnection ucon = this.qry.getUConnection();
            if (ucon != null) {
                ufq = ucon.GetFileQueryByResourceName(subquery.name);
                if (ufq == null) {
                    ufq = ucon.GetFileQueryByResourceName(nameWithoutquote);
                }
            } else {
                JetUConnection[] cons = this.qry.getALLConnections();
                for (int i = 0; i < cons.length && (ufq = cons[i].GetFileQueryByResourceName(subquery.name)) == null && (ufq = cons[i].GetFileQueryByResourceName(nameWithoutquote)) == null; ++i) {
                }
            }
            if (ufq != null) {
                FileQuery fq = ufq.getFileQuery();
                fq = fq.getCopy();
                FileQuery.prepareFileQuery(fq, this.qry.getParameterValuePairs(), this.qry.getParameterObjectPairs(), unvs, this.qry.getDataSourceName(), ucon);
                subquery.setIsFileQuery(true);
                subquery.setQuery(fq);
                return fq;
            }
        } else {
            RptPsqlQuery sq = uq.getPsqlQuery();
            sq.setRptUserName(this.qry.getRptUserName());
            sq = sq.getCopy();
            FileQuery.preparePsqlQuery(sq, this.qry.getParameterValuePairs(), this.qry.getParameterObjectPairs());
            subquery.setIsFileQuery(false);
            subquery.setQuery(sq);
            return sq;
        }
        if (logger.isErrorEnabled()) {
            logger.error("", new Exception("Cannot find the subquery: " + subquery.name + "!"));
        }
        return null;
    }

    @Override
    public String getResolvedStatement(Subquery subquery) {
        String ret = null;
        JetUUniverse unvs = this.qry.getUniverse();
        if (subquery.isFileQuery()) {
            JetUConnection ucon = this.qry.getUConnection();
            FileQuery fq = (FileQuery)subquery.getQuery();
            if (fq != null) {
                SQLMapInfo sqlMapInfo = this.qry.getSQLMapInfo();
                ret = FileQuery.getResolvedStatement(fq.getStatement(), this.qry.getParameterValuePairs(), unvs, this.qry.getDataSourceName(), ucon, this.qry.getSupportInfo(), sqlMapInfo, this.qry.getRptUserName(), null);
            }
        } else {
            RptPsqlQuery sq = (RptPsqlQuery)subquery.getQuery();
            if (sq != null) {
                DbTools.updateHT(this.qry.getParameterValuePairs(), sq.getParameterValuePairs());
                ret = sq.getResolvedStatement();
            }
        }
        return ret;
    }

    @Override
    public MappingName getFormulaMappingName(MappingName mp) {
        Hashtable htMFPairs = this.qry.getMappingNameFormulaPairs();
        Enumeration e = htMFPairs.keys();
        while (e.hasMoreElements()) {
            MappingName mpn = (MappingName)e.nextElement();
            if (!mpn.equals(mp)) continue;
            return mpn;
        }
        return null;
    }

    public boolean isBigDSBesidesHive(ArrayList<RowValueConstructor> list) {
        int iSize;
        int i;
        if (this.qry == null) {
            return false;
        }
        JetUDatabase udb = this.qry.getDatabase();
        JetUConnection ucon = this.qry.getUConnection();
        Vector<JetUConnection> cons = new Vector<JetUConnection>();
        if (ucon == null) {
            Vector mapNs = new Vector();
            for (i = 0; i < list.size(); ++i) {
                RowValueConstructor rowValue = list.get(i);
                rowValue.getMappingNames(mapNs);
                int iSize2 = mapNs.size();
                for (int j = 0; j < iSize2; ++j) {
                    MappingName mn = (MappingName)mapNs.get(j);
                    Vector fieldNames = new Vector();
                    if (mn.obj instanceof JetUFormula) {
                        fieldNames = ((JetUFormula)mn.obj).getRefAllDbFld();
                    } else {
                        fieldNames.add(mn.name);
                    }
                    for (int k = 0; k < fieldNames.size(); ++k) {
                        ucon = ExpressionToolKit.getJetUConnectionByField(this.qry.getUniverse(), this.qry.getDataSourceName(), (String)fieldNames.get(k));
                        if (ucon == null || cons.contains(ucon)) continue;
                        cons.add(ucon);
                    }
                }
            }
        }
        if ((iSize = cons.size()) > 0) {
            for (i = 0; i < iSize; ++i) {
                boolean isHive;
                ucon = (JetUConnection)cons.get(i);
                if (!ucon.isBigDataSource() || !(ucon instanceof JetUJDBCConnection) || (isHive = ((JetUJDBCConnection)ucon).isHive())) continue;
                return true;
            }
        } else if (ucon != null && ucon.isBigDataSource() && ucon instanceof JetUJDBCConnection) {
            boolean isHive = ((JetUJDBCConnection)ucon).isHive();
            return !isHive;
        }
        return false;
    }

    @Override
    public boolean isRecordLevel(MappingName mapn) {
        if (mapn.obj != null) {
            if (mapn.obj instanceof JetUDBField) {
                return true;
            }
        } else if (mapn.obj instanceof JetUFormula) {
            JetUFormula uf = (JetUFormula)mapn.obj;
            return uf.canSummary();
        }
        return false;
    }
}

