/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.psql;

import java.util.Vector;
import jet.connect.DbColDesc;
import jet.naming.EnumerationConstant;
import jet.universe.JetUConnection;
import jet.universe.JetUField;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.psql.RptPsqlFormulaColumn;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlTable;

public class RptPsqlTools {
    public static final String ADD = " + ";
    public static final String MIN = " - ";
    public static final String MUL = " * ";
    public static final String DIV = " / ";
    public static final String CMPL = " < ";
    public static final String CMPG = " > ";
    public static final String CMPE = " = ";
    public static final String CMPLE = " <= ";
    public static final String CMPGE = " >= ";
    public static final String CMPNE = " <> ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String NOT = " NOT ";
    public static final String CONCAT = " || ";

    public static Vector getRefTablesOfFormula(JetUUniverse unv, JetUFormula fe) {
        String sourceName = fe.getDatabase().getResourceName();
        Vector<Object> vRet = new Vector<Object>();
        if (unv == null || fe == null) {
            return vRet;
        }
        Vector vColumns = new Vector();
        RptPsqlTools.getColumnsOfFormula(unv, fe, vColumns);
        int sz = vColumns.size();
        for (int i = 0; i < sz; ++i) {
            JetUQueriable queriable;
            JetUResourceEntity ure;
            String str = (String)vColumns.elementAt(i);
            if (str == null || (ure = unv.getDatabase(sourceName).getResourceByName(str)) == null) continue;
            if (ure instanceof JetUField) {
                JetUField ufe = (JetUField)ure;
                JetUTableView utbl = ufe.getTable();
                if (utbl == null) continue;
                vRet.addElement(utbl);
                continue;
            }
            if (!(ure instanceof JetUQueriableField) || (queriable = ((JetUQueriableField)((Object)ure)).getQueriable()) == null) continue;
            vRet.addElement(queriable);
        }
        return vRet;
    }

    public static void getColumnsOfFormula(JetUUniverse unv, JetUFormula fe, Vector vColumns) {
        String str;
        int i;
        String sourceName = fe.getDatabase().getResourceName();
        Vector vRefd = fe.getRefDbFld();
        int sz = vRefd.size();
        for (i = 0; i < sz; ++i) {
            str = (String)vRefd.elementAt(i);
            if (str == null || DbTools.hasTheStringInVector(str, vColumns)) continue;
            vColumns.addElement(str);
        }
        Vector vReff = fe.getRefFormuFld();
        sz = vReff.size();
        for (i = 0; i < sz; ++i) {
            JetUResourceEntity tempURE;
            str = (String)vReff.elementAt(i);
            if (str == null || (tempURE = unv.getDatabase(sourceName).getResourceByName(str)) == null || !(tempURE instanceof JetUFormula)) continue;
            JetUFormula tempUFE = (JetUFormula)tempURE;
            RptPsqlTools.getColumnsOfFormula(unv, tempUFE, vColumns);
        }
    }

    public static PsqlTable UTableToPsqlTable(JetUTableView utbl, boolean bShowMappingName) {
        if (utbl == null) {
            return null;
        }
        String qlf = utbl.getQualifier();
        String owner = utbl.getOwner();
        String tbname = utbl.getTableName();
        PsqlTable qrytbl = new PsqlTable(qlf, owner, tbname, EnumerationConstant.TABLETYPE_STR_NAMES[utbl.getTableType()].toUpperCase());
        if (utbl.isAlias()) {
            qrytbl.setCorrelationName(utbl.getResourceName());
        }
        qrytbl.setDataObj(utbl.getConnection());
        qrytbl.setConnection(utbl.getConnection().getResourceName());
        qrytbl.setMappingName(utbl.getResourceName());
        qrytbl.setShowMappingName(bShowMappingName);
        Vector vUFields = utbl.getFields();
        if (vUFields == null) {
            return qrytbl;
        }
        int sz1 = vUFields.size();
        for (int j = 0; j < sz1; ++j) {
            JetUField ufld = (JetUField)vUFields.elementAt(j);
            PsqlColumn pcol = new PsqlColumn(ufld.getFldName(), ufld.getSqlType(), null, ufld.getPrecision(), ufld.getPrecision(), ufld.getScale(), 10, ufld.getNullable(), null, ufld.getArray());
            pcol.setMappingName(ufld.getResourceName());
            pcol.setShowMappingName(bShowMappingName);
            qrytbl.addPsqlColumn(pcol);
        }
        return qrytbl;
    }

    public static PsqlTable UQueryToPsqlTable(JetUQueriable uQueriable) {
        if (uQueriable == null) {
            return null;
        }
        PsqlTable qrytbl = new PsqlTable(null, null, null, null);
        qrytbl.setQueriable(true);
        qrytbl.isTable = false;
        qrytbl.setMappingName(uQueriable.getResourceName());
        qrytbl.setShowMappingName(true);
        Vector vUFields = uQueriable.getFields();
        if (vUFields == null) {
            return qrytbl;
        }
        int sz1 = vUFields.size();
        for (int j = 0; j < sz1; ++j) {
            JetUQueriableField uQueryField = (JetUQueriableField)vUFields.elementAt(j);
            DbColDesc colDesc = uQueryField.getColDesc();
            PsqlColumn pcol = new PsqlColumn(uQueryField.getResourceName(), uQueryField.getSqlType(), null, colDesc.getPrecision(), colDesc.getPrecision(), colDesc.getScale(), 10, colDesc.getNullable(), null, colDesc.isArray());
            pcol.setMappingName(uQueryField.getResourceName());
            pcol.setShowMappingName(true);
            qrytbl.addPsqlColumn(pcol);
        }
        return qrytbl;
    }

    public static String getDefaultValueOfUParameter(JetUParameter jp) {
        if (jp == null || jp.getDefaultValue() == null) {
            return null;
        }
        if (jp.getType().equalsIgnoreCase("string") || jp.getType().equalsIgnoreCase("date") || jp.getType().equalsIgnoreCase("time") || jp.getType().equalsIgnoreCase("datetime")) {
            return "'" + jp.getDefaultValue().getUserInput() + "'";
        }
        return jp.getDefaultValue().getUserInput();
    }

    public static RptPsqlFormulaColumn getPsqlFmlCol(Vector cols, JetUFormula fe) {
        int sz = cols.size();
        for (int i = 0; i < sz; ++i) {
            Object o = cols.elementAt(i);
            if (!(o instanceof RptPsqlFormulaColumn) || !((RptPsqlFormulaColumn)o).getName().equals(fe.getResourceName())) continue;
            return (RptPsqlFormulaColumn)o;
        }
        return null;
    }

    @Deprecated
    public static boolean isQueryLevelAlias(PsqlTable t, JetUConnection connection) {
        return t.correlationName != null && connection.getTableViewsByResourceName(t.correlationName, 11) == null;
    }
}

