/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import com.jinfonet.dataservice.relational.ResultSetMetaDataAdapterRelationMetaData;
import com.jinfonet.resstore.DiskStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine8.dbbuffer.MetaDataTool;
import jet.datasource.JRColDesc;
import jet.datasource.JRResultSetException;
import jet.universe.resultfile.ResultSetTool;
import jet.universe.resultfile.URecordModel;
import jet.universe.resultfile.UResultFileResultSetWithMetaData;
import jet.util.RAFile;

public final class CachedQueryResult {
    private static final String CACHED_QUERY_RESULT_VERSION = "Cached Query Result File,Version:";
    private static final int VERSION = 8;
    private static final int SUB_VERSION = 0;

    private CachedQueryResult() {
    }

    public static final void saveResult(ResultSet resultSet, String cachedFileName) throws DSException {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cachedFileName)));
            out.writeChars(CACHED_QUERY_RESULT_VERSION);
            out.writeInt(8);
            out.writeInt(0);
            ResultSetTool.writeResultSet(out, resultSet);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new DSException(6901, new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (IOException e) {
            throw new DSException(6902, new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (SQLException e) {
            throw new DSException(6903, new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    public static final ResultSet loadResult(String cachedFileName, DiskStore diskStore) throws DSException {
        DataInputStream in = null;
        int version = -1;
        int subVersion = -1;
        boolean matchFlag = false;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(cachedFileName)));
            int size = CACHED_QUERY_RESULT_VERSION.length();
            char[] characteristicString = new char[size];
            for (int i = 0; i < size; ++i) {
                characteristicString[i] = in.readChar();
            }
            version = in.readInt();
            subVersion = in.readInt();
            matchFlag = new String(characteristicString).equals(CACHED_QUERY_RESULT_VERSION) && version == 8 && subVersion == 0;
        }
        catch (FileNotFoundException e) {
            throw new DSException(6904, new Object[]{e.getMessage()}, (Throwable)e);
        }
        catch (IOException e) {
            matchFlag = false;
        }
        ResultSet ret = null;
        if (matchFlag) {
            try {
                try {
                    ret = ResultSetTool.loadResultSet(in, diskStore);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    in.close();
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(cachedFileName)));
                    int size = CACHED_QUERY_RESULT_VERSION.length();
                    char[] characteristicString = new char[size];
                    for (int i = 0; i < size; ++i) {
                        characteristicString[i] = in.readChar();
                    }
                    version = in.readInt();
                    subVersion = in.readInt();
                    ret = ResultSetTool.loadResultSet4bug112293(in, diskStore);
                }
            }
            catch (IOException e) {
                throw new DSException(6906, new Object[]{e.getMessage()}, (Throwable)e);
            }
            try {
                in.close();
            }
            catch (IOException e) {}
        } else {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ret = CachedQueryResult.getResultSetFromV7(cachedFileName);
        }
        return ret;
    }

    private static ResultSet getResultSetFromV7(String cachedFileName) throws DSException {
        URecordModel recordModel = null;
        try {
            RAFile raFile = new RAFile(cachedFileName + ".desc", "r");
            recordModel = URecordModel.read(raFile);
            raFile.close();
        }
        catch (IOException e) {
            throw new DSException(6908, new Object[]{e.getMessage()}, (Throwable)e);
        }
        ResultSetMetaDataAdapterRelationMetaData rsMetaData = new ResultSetMetaDataAdapterRelationMetaData(MetaDataTool.ColDesc2RelationMetaData(recordModel.getColDescs()));
        UResultFileResultSetWithMetaData ret = new UResultFileResultSetWithMetaData(rsMetaData);
        String[] args = new String[]{cachedFileName};
        DbColDesc[] colDescs = recordModel.getColDescs();
        JRColDesc[] jrColDescs = new JRColDesc[colDescs.length + 1];
        for (int i = 1; i < jrColDescs.length; ++i) {
            jrColDescs[i] = new JRColDesc(colDescs[i - 1].colName, colDescs[i - 1].getSqlType(), colDescs[i - 1].getPrecision(), colDescs[i - 1].getScale(), colDescs[i - 1].getNullable());
        }
        try {
            ret.initialize(jrColDescs, args);
        }
        catch (JRResultSetException e) {
            throw new DSException(6909, new Object[]{e.getMessage()}, (Throwable)e);
        }
        return ret;
    }
}

