/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.ibus.InformationBusManager;
import com.jinfonet.resstore.defaultimpl.DefaultResourceStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.dataengine.api.DSException;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.api.DataServiceFactory;
import jet.dataservice.api.JDataService;
import jet.formula.ParamDesc;
import jet.parameter.definition.BindColumn;
import jet.parameter.runtime.ParameterRuntime;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.util.ParameterSortor;
import jet.rptservice.util.Tools;
import jet.universe.JetUUniverse;
import jet.universe.resultfile.CachedQueryResult;
import jet.universe.resultfile.ResultSetMaker;
import jet.universe.tools.ParseParametersForQuery;
import jet.universe.tools.UniverseTools;
import jet.util.CatalogKeyCreater;
import jet.util.ValueListFetcherContextImpl;

public class CachedQueryResultTool {
    private JDataService dataService = null;

    public static boolean saveCachedQueryResult(JetUUniverse unv, String dataSourceName, String queryName, Date modifyDate, ParamDesc[] pds, String fileName) throws DSException, JRScheduleException, JRStopEngineException {
        ResultSetMaker rsMaker = new ResultSetMaker();
        String userName = "";
        ResultSet rs = rsMaker.makeResultSet(unv, dataSourceName, queryName, userName, modifyDate, pds);
        if (rs == null) {
            return false;
        }
        CachedQueryResult.saveResult(rs, fileName);
        rsMaker.close();
        return true;
    }

    public Vector getParameters(JetUUniverse unv, String dataSourceName, String queryName) throws DSException, JRScheduleException {
        Vector vParamDesc;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CachedQueryResultTool.getParameters()..., dataSourceName: " + dataSourceName + " queryName: " + queryName);
        }
        if ((vParamDesc = this.getParamsInQuery(unv, dataSourceName, queryName)) == null || vParamDesc.isEmpty()) {
            return vParamDesc;
        }
        this.addReferenceParameters(vParamDesc, unv);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "sort parameter, vParamDesc: " + vParamDesc);
        }
        this.sortParameter(vParamDesc);
        this.buildRuntimeReference(vParamDesc, unv);
        return vParamDesc;
    }

    private Vector getParamsInQuery(JetUUniverse unv, String dataSourceName, String queryName) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CachedQueryResultTool.getParamsInQuery()..., dataSourceName: " + dataSourceName + " queryName: " + queryName);
        }
        Vector<ParamDesc> v = new Vector<ParamDesc>();
        String[] paramNames = new ParseParametersForQuery(unv, dataSourceName, queryName).getParameterNamesInQuery(null, null, false, false);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "parameter used in query, names:" + Tools.toString(paramNames));
        }
        if (paramNames == null || paramNames.length == 0) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of CachedQueryResultTool.getParamsInQuery(), return null.");
            }
            return null;
        }
        Vector<String> vName = new Vector<String>();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i].toUpperCase();
            if (vName.contains(paramName)) continue;
            vName.addElement(paramName);
            v.addElement(UniverseTools.getParamDesc(paramName, unv, dataSourceName));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CachedQueryResultTool.getParamsInQuery(), return: " + v);
        }
        return v;
    }

    private void addReferenceParameters(Vector<ParamDesc> vParamDesc, JetUUniverse unv) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CachedQueryResultTool.addReferenceParameters()..., vParamDesc: " + vParamDesc);
        }
        if (vParamDesc == null || vParamDesc.isEmpty()) {
            return;
        }
        String[] paramNames = new String[vParamDesc.size()];
        HashMap<String, ParamDesc> paramBuff = new HashMap<String, ParamDesc>();
        for (int i = 0; i < vParamDesc.size(); ++i) {
            ParamDesc pd = vParamDesc.get(i);
            paramNames[i] = pd.getName().toUpperCase();
            paramBuff.put(paramNames[i], pd);
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < paramNames.length; ++i) {
            ParamDesc pd = (ParamDesc)paramBuff.get(paramNames[i]);
            if (pd == null) continue;
            this.getReferencedParameterNames(al, pd, paramBuff, unv);
        }
        vParamDesc.clear();
        for (String paramName : al) {
            vParamDesc.add(paramBuff.get(paramName));
        }
        paramBuff.clear();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CachedQueryResultTool.addReferenceParameters()..., vParamDesc: " + vParamDesc);
        }
    }

    private void getReferencedParameterNames(List<String> dest, ParamDesc pd, HashMap<String, ParamDesc> paramBuff, JetUUniverse unv) throws DSException {
        String paramName;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CachedQueryResultTool.getReferencedParameterNames()..., pd: " + pd + " dest: " + dest + " paramBuff: " + paramBuff);
        }
        if (!dest.contains(paramName = pd.getName().toUpperCase())) {
            String queryName;
            Vector vParamDesc;
            BindColumn bc;
            ParameterRuntime pr;
            Vector vParamName;
            dest.add(paramName);
            String dataSourceName = pd.getDataSource();
            String binding = pd.getBinding();
            if (binding != null && !binding.equals("") && !dest.contains(paramName = binding.toUpperCase())) {
                ParamDesc desc;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "add bind name: " + binding);
                }
                if ((desc = this.getOrGenParamDesc(paramName, paramBuff, unv, dataSourceName)) != null) {
                    dest.add(desc.getName().toUpperCase());
                }
            }
            if ((vParamName = pd.getImportParams()) != null && !vParamName.isEmpty()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "add import params names: " + vParamName);
                }
                for (int k = 0; k < vParamName.size(); ++k) {
                    ParamDesc desc;
                    paramName = ((String)vParamName.elementAt(k)).toUpperCase();
                    if (dest.contains(paramName) || (desc = this.getOrGenParamDesc(paramName, paramBuff, unv, dataSourceName)) == null) continue;
                    this.getReferencedParameterNames(dest, desc, paramBuff, unv);
                }
            }
            if ((pr = pd.getParameterRuntime()) != null && (bc = pd.getDefinition().getBindColumn()) != null && bc.getBindType() == 0 && (vParamDesc = this.getParamsInQuery(unv, dataSourceName, queryName = bc.getQueryName())) != null && !vParamDesc.isEmpty()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "add static bind names: " + vParamDesc);
                }
                String[] paramNames = new String[vParamDesc.size()];
                for (int i = 0; i < vParamDesc.size(); ++i) {
                    ParamDesc desc = (ParamDesc)vParamDesc.get(i);
                    paramNames[i] = desc.getName().toUpperCase();
                    if (desc == null) continue;
                    if (!paramBuff.containsKey(paramNames[i])) {
                        paramBuff.put(paramNames[i], desc);
                    }
                    this.getReferencedParameterNames(dest, desc, paramBuff, unv);
                }
                pr.setParamsUsedInQuery(new Vector<String>(Arrays.asList(paramNames)));
            }
        }
    }

    private ParamDesc getOrGenParamDesc(String paramName, HashMap<String, ParamDesc> paramBuff, JetUUniverse unv, String dataSourceName) {
        ParamDesc pd = paramBuff.get(paramName);
        if (pd == null) {
            pd = UniverseTools.getParamDesc(paramName, unv, dataSourceName);
            paramBuff.put(paramName, pd);
        }
        return pd;
    }

    private void sortParameter(Vector vParamDesc) {
        int i;
        if (vParamDesc == null || vParamDesc.isEmpty()) {
            return;
        }
        String[] paramNames = new String[vParamDesc.size()];
        Hashtable<String, ParamDesc> htParam = new Hashtable<String, ParamDesc>();
        for (i = 0; i < vParamDesc.size(); ++i) {
            ParamDesc pd = (ParamDesc)vParamDesc.elementAt(i);
            paramNames[i] = pd.getName().toUpperCase();
            htParam.put(paramNames[i], pd);
        }
        paramNames = new ParameterSortor(paramNames, htParam).sort();
        vParamDesc.clear();
        for (i = 0; i < paramNames.length; ++i) {
            vParamDesc.add(htParam.get(paramNames[i]));
        }
    }

    private void buildRuntimeReference(Vector<ParamDesc> vParamDesc, JetUUniverse unv) throws DSException {
        if (vParamDesc == null || vParamDesc.isEmpty()) {
            return;
        }
        InformationBusManager ibm = unv.getInfoBusManager();
        DefaultResourceStore rs = new DefaultResourceStore(new File(ReportEnv.getTemporaryPath()));
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "CachedQueryResultTool.buildRuntimeReference(), InformationBusManager: " + ibm + " rs: " + rs);
        }
        DataServiceConfig dsc = new DataServiceConfig(null, ReportEnv.getTemporaryPath(), ibm, rs);
        this.dataService = DataServiceFactory.createDataSerivce(dsc);
        CatalogKey catKey = CatalogKeyCreater.createCatalogKey(unv.getFullFileName());
        catKey = this.dataService.registCatalog(catKey, unv);
        Hashtable<String, ParamDesc> htParam = new Hashtable<String, ParamDesc>();
        for (ParamDesc pd : vParamDesc) {
            htParam.put(pd.getName().toUpperCase(), pd);
        }
        for (ParamDesc pd : vParamDesc) {
            this.initParamRuntimeEnv(pd, htParam, unv, catKey);
        }
        this.addReferedParameters(htParam, htParam);
    }

    private void initParamRuntimeEnv(ParamDesc param, Hashtable<String, ParamDesc> htParam, JetUUniverse unv, CatalogKey catKey) {
        ParameterRuntime pr = param.getParameterRuntime();
        if (pr != null) {
            ValueListFetcherContextImpl vf = new ValueListFetcherContextImpl();
            vf.setUniverse(unv);
            vf.setRelatedParameters(this.getRelatedParameters(param, htParam));
            vf.setParamUsedByQuery(this.getUsedInQueryParameters(param, htParam));
            pr.createValueListFetcher(this.dataService, catKey, vf);
        }
    }

    private Hashtable<String, ParamDesc> getRelatedParameters(ParamDesc param, Hashtable<String, ParamDesc> htParam) {
        Hashtable<String, ParamDesc> ret = new Hashtable<String, ParamDesc>();
        Vector params = param.getImportParams();
        ParamDesc pd = null;
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                pd = htParam.get(((String)params.get(i)).toUpperCase());
                if (pd == null) continue;
                ret.put(pd.getName().toUpperCase(), pd);
            }
        }
        return ret;
    }

    private Vector<ParamDesc> getUsedInQueryParameters(ParamDesc param, Hashtable<String, ParamDesc> htParam) {
        Vector<ParamDesc> ret = new Vector<ParamDesc>();
        Vector v = param.getParameterRuntime().getParamsUsedInQuery();
        if (v == null || v.isEmpty()) {
            return null;
        }
        for (String paramName : v) {
            String pName = paramName.toUpperCase();
            ParamDesc pd = htParam.get(pName);
            if (pd == null || ret.contains(pd)) continue;
            ret.add(pd);
        }
        return ret;
    }

    private void addReferedParameters(Hashtable allParam, Hashtable curParamDescs) {
        if (curParamDescs == null) {
            return;
        }
        Vector vSortedParams = new Vector();
        Enumeration em = curParamDescs.elements();
        ParamDesc param = null;
        while (em.hasMoreElements()) {
            ParameterRuntime pr;
            param = (ParamDesc)em.nextElement();
            if (param.getImportParams().size() != 0) {
                param.addReferParamToVsortParams(allParam, curParamDescs, vSortedParams);
            }
            if ((pr = param.getParameterRuntime()) == null) continue;
            pr.cascadeParams(allParam, curParamDescs, vSortedParams);
        }
        for (int i = 0; i < vSortedParams.size(); ++i) {
            if (curParamDescs.get(((String)vSortedParams.get(i)).toUpperCase()) != null) continue;
            curParamDescs.put(((String)vSortedParams.get(i)).toUpperCase(), vSortedParams.get(i));
        }
    }

    public void close() throws DSException {
        if (this.dataService != null) {
            this.dataService.clear();
        }
    }
}

