/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.ibus.InformationBusManager;
import com.jinfonet.resstore.defaultimpl.DefaultResourceStore;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.api.DataServiceFactory;
import jet.dataservice.api.JDataService;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUUniverse;
import jet.universe.tools.UniverseTools;
import jet.util.CatalogKeyCreater;
import jet.util.ThreadErrorListener;

public class ResultSetMaker
implements ThreadErrorListener {
    public static final String PARAM_ALL_VALUE = "\u0007";
    private Throwable threadError;
    private JDataService dataService = null;
    private JDataSourceQuery query = null;
    private int rawDataId = -1;

    @Override
    public void ThreadException(Thread thread, Throwable e) {
        this.threadError = e;
    }

    public ResultSet makeResultSet(JetUUniverse unv, String dataSourceName, String queryName, String userName, java.util.Date modifyDate, ParamDesc[] pds) throws DSException, JRScheduleException, JRStopEngineException {
        InformationBusManager ibm = unv.getInfoBusManager();
        DefaultResourceStore rs = new DefaultResourceStore(new File(ReportEnv.getTemporaryPath()));
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "ResultSetMaker.makeResultSet(), InformationBusManager: " + ibm + " rs: " + rs);
        }
        DataServiceConfig dsc = new DataServiceConfig(null, ReportEnv.getTemporaryPath(), ibm, rs);
        this.dataService = DataServiceFactory.createDataSerivce(dsc);
        CatalogKey catKey = CatalogKeyCreater.createCatalogKey(unv.getFullFileName());
        catKey = this.dataService.registCatalog(catKey, unv);
        this.query = this.dataService.getQueryFactory().createDataSourceQuery(catKey);
        this.rawDataId = this.query.getQueryId();
        this.query.setCatalog(unv);
        this.query.setDataSourceName(dataSourceName);
        this.query.setBVQueryName(queryName, 2);
        this.query.setOption(this.genRawDataQueryOption());
        Vector vDbField = UniverseTools.getFieldResourceNames(unv, dataSourceName, queryName);
        this.query.setMappingNames(vDbField.toArray(new String[0]));
        this.query.setJavaFormula(ReportTools.loadJavaFormula(dataSourceName, unv));
        this.query.setBatchRun(true);
        try {
            this.query.setParameterValues(this.getParamValues(unv, dataSourceName, queryName, pds));
        }
        catch (InvalidParameterException e) {
            throw new JRScheduleException(e);
        }
        this.query.setSpecialFields(this.getSpecialFields(userName, modifyDate));
        try {
            this.dataService.sendQuery(this.query);
        }
        catch (DSException e) {
            this.dataService.closeQuery(this.rawDataId);
            this.dataService.clear();
            throw e;
        }
        catch (JRStopEngineException e) {
            this.dataService.closeQuery(this.rawDataId);
            this.dataService.clear();
            throw e;
        }
        if (this.threadError != null) {
            this.dataService.closeQuery(this.rawDataId);
            this.dataService.clear();
            throw new JRScheduleException(this.threadError);
        }
        ResultSet resultSet = this.dataService.getDataResult(this.rawDataId);
        return resultSet;
    }

    private RawDataQueryOption genRawDataQueryOption() throws DSException {
        RawDataQueryOption option = new RawDataQueryOption();
        option.setErrorlisteners(null);
        option.setFastPass(false);
        boolean bLazyRun = false;
        option.setLazyRun(bLazyRun);
        option.setMaxRecords(-1L);
        option.setMaxPageNumber(-1L);
        option.setRecordsPerPage(-1L);
        option.setSingleThread(true);
        option.setNoRecord(false);
        return option;
    }

    private ParameterValueList getParamValues(JetUUniverse unv, String dataSourceName, String queryName, ParamDesc[] pds) throws DSException, InvalidParameterException {
        if (pds == null) {
            return null;
        }
        ParameterValueList list = new ParameterValueList();
        for (int i = 0; i < pds.length; ++i) {
            list.addParameterValue(pds[i]);
        }
        return list;
    }

    private SpecialFields getSpecialFields(String userName, java.util.Date modifyDate) {
        SpecialFields sf = new SpecialFields();
        sf.setUserName(new DbChar(userName));
        java.util.Date date = new java.util.Date();
        sf.setModifiedDate(new DbDate(new Date(modifyDate.getTime())));
        sf.setModifiedTime(new DbTime(new Time(modifyDate.getTime())));
        sf.setPrintDate(new DbDate(new Date(date.getTime())));
        sf.setPrintTime(new DbTime(new Time(date.getTime())));
        return sf;
    }

    public void close() throws DSException {
        this.dataService.closeQuery(this.rawDataId);
        this.dataService.clear();
    }
}

