/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.relational.Attribute;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.dataservice.relational.RelationOption;
import com.jinfonet.dataservice.relational.ResultSetAdapterRelationData;
import com.jinfonet.dataservice.relational.swap.RelationPool;
import com.jinfonet.datatypes.JinfonetArray;
import com.jinfonet.datatypes.JinfonetBlob;
import com.jinfonet.datatypes.JinfonetClob;
import com.jinfonet.datatypes.JinfonetDate;
import com.jinfonet.datatypes.JinfonetTime;
import com.jinfonet.datatypes.JinfonetTimeStamp;
import com.jinfonet.resstore.DiskStore;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.dataengine.api.DSException;
import jet.dataengine.api.EnvironmentPropertiesFactory;
import jet.dataengine.api.JEnvironmentProperties;
import jet.ie.VersionRecord;
import jet.util.TempFile;

public class ResultSetTool {
    public static void writeResultSet(DataOutputStream out, ResultSet resultSet) throws IOException, DSException, SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        JEnvironmentProperties env = EnvironmentPropertiesFactory.getEnviromentProperties();
        String path = env.getTemporaryPath();
        TempFile tempFileCreator = new TempFile(path, "ResultSet", "tem");
        File tempFile = tempFileCreator.createTempFile();
        RandomAccessFile outFile = new RandomAccessFile(tempFile, "rw");
        int columnCount = md.getColumnCount();
        long recordCount = 0L;
        out.writeShort(columnCount);
        JAttribute[] attributeSet = new JAttribute[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            int colType = md.getColumnType(i + 1);
            out.writeInt(colType);
            String colName = md.getColumnName(i + 1);
            if (colName == null) {
                colName = "";
            }
            out.writeUTF(colName);
            int precision = md.getPrecision(i + 1);
            out.writeInt(precision);
            short scale = (short)md.getScale(i + 1);
            out.writeShort(scale);
            short nullAble = (short)md.isNullable(i + 1);
            out.writeShort(nullAble);
            short colIndex = (short)(i + 1);
            out.writeShort(colIndex);
            boolean currency = md.isCurrency(i + 1);
            out.writeBoolean(currency);
            attributeSet[i] = new Attribute(colName, Types.sqlTypeToType(colType), precision, scale, precision, nullAble, currency);
        }
        RelationMetaData relationMedata = new RelationMetaData(attributeSet);
        VersionRecord rsdRecord = new VersionRecord(relationMedata);
        while (resultSet.next()) {
            int recordSize = 0;
            ++recordCount;
            block21: for (int i = 1; i <= columnCount; ++i) {
                switch (md.getColumnType(i)) {
                    case 2003: {
                        Array array = resultSet.getArray(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(2003);
                            continue block21;
                        }
                        rsdRecord.putArray(new JinfonetArray(array));
                        continue block21;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(3);
                            continue block21;
                        }
                        rsdRecord.putBigDecimal(bigDecimal);
                        continue block21;
                    }
                    case 2004: {
                        Blob blob = resultSet.getBlob(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(2004);
                            continue block21;
                        }
                        rsdRecord.putBlob(new JinfonetBlob(blob));
                        continue block21;
                    }
                    case -7: 
                    case 16: {
                        boolean bool = resultSet.getBoolean(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(-7);
                            continue block21;
                        }
                        rsdRecord.putBoolean(bool);
                        continue block21;
                    }
                    case -6: {
                        byte b = resultSet.getByte(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(-6);
                            continue block21;
                        }
                        rsdRecord.putByte(b);
                        continue block21;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] bytes = resultSet.getBytes(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(-2);
                            continue block21;
                        }
                        rsdRecord.putBytes(bytes);
                        continue block21;
                    }
                    case 2005: {
                        Clob clob = resultSet.getClob(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(2005);
                            continue block21;
                        }
                        rsdRecord.putClob(new JinfonetClob(clob));
                        continue block21;
                    }
                    case 91: {
                        Date date = resultSet.getDate(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(91);
                            continue block21;
                        }
                        rsdRecord.putDate(new JinfonetDate(date.getTime()));
                        continue block21;
                    }
                    case 6: 
                    case 8: {
                        double db = resultSet.getDouble(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(8);
                            continue block21;
                        }
                        rsdRecord.putDouble(db);
                        continue block21;
                    }
                    case 7: {
                        float f = resultSet.getFloat(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(6);
                            continue block21;
                        }
                        rsdRecord.putFloat(f);
                        continue block21;
                    }
                    case 4: {
                        int integer = resultSet.getInt(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(4);
                            continue block21;
                        }
                        rsdRecord.putInt(integer);
                        continue block21;
                    }
                    case -5: {
                        long l = resultSet.getLong(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(-5);
                            continue block21;
                        }
                        rsdRecord.putLong(l);
                        continue block21;
                    }
                    case 0: {
                        rsdRecord.putNull(0);
                        continue block21;
                    }
                    case 5: {
                        short s = resultSet.getShort(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(5);
                            continue block21;
                        }
                        rsdRecord.putLong(s);
                        continue block21;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        String str = resultSet.getString(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(12);
                            continue block21;
                        }
                        rsdRecord.putString(str);
                        continue block21;
                    }
                    case 92: {
                        Time time2 = resultSet.getTime(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(92);
                            continue block21;
                        }
                        rsdRecord.putTime(new JinfonetTime(time2.getTime()));
                        continue block21;
                    }
                    case 93: {
                        Timestamp timeStamp = resultSet.getTimestamp(i);
                        if (resultSet.wasNull()) {
                            rsdRecord.putNull(93);
                            continue block21;
                        }
                        rsdRecord.putTimeStamp(new JinfonetTimeStamp(timeStamp.getTime()));
                        continue block21;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            recordSize = rsdRecord.getRecordSize();
            outFile.writeInt(recordSize);
            outFile.write(rsdRecord.getRecordData(), 0, recordSize);
            rsdRecord.reset();
        }
        outFile.close();
        out.writeLong(recordCount);
        ResultSetTool.writeStream(out, tempFile);
        tempFile.delete();
    }

    private static void writeStream(DataOutputStream out, File tempFile) throws IOException {
        int c;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile));
        long length = tempFile.length();
        out.writeInt((int)length);
        while ((c = ((InputStream)in).read()) != -1) {
            out.write(c);
        }
        ((InputStream)in).close();
    }

    public static ResultSet loadResultSet(DataInput in) throws IOException, DSException {
        throw new UnsupportedOperationException("When load ResultSet,need DiskStore. Please use loadResultSet(DataInput in,DiskStore diskStore) instead");
    }

    public static ResultSet loadResultSet(DataInput in, DiskStore diskStore) throws IOException, DSException {
        IRelationData relationData = ResultSetTool.loadIRelationData(in, diskStore);
        ResultSetTool resultSetTool = new ResultSetTool();
        resultSetTool.getClass();
        ResultSetAdapterRelationDataCanClose ret = resultSetTool.new ResultSetAdapterRelationDataCanClose(relationData);
        return ret;
    }

    public static IRelationData loadIRelationData(DataInput in, DiskStore diskStore) throws IOException, DSException {
        int columnCount = in.readShort();
        JAttribute[] attributeSet = new JAttribute[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            int sqlType = in.readInt();
            int colType = Types.sqlTypeToType(sqlType);
            String colName = in.readUTF();
            if ("".equals(colName)) {
                colName = "NULL";
            }
            int precision = in.readInt();
            short scale = in.readShort();
            short nullAble = in.readShort();
            in.readShort();
            boolean currency = in.readBoolean();
            attributeSet[i] = new Attribute(colName, colType, precision, scale, precision, nullAble, currency);
        }
        RelationMetaData relationMedata = new RelationMetaData(attributeSet);
        RelationOption ro = new RelationOption();
        ro.setDiskStore(diskStore);
        RelationPool relationData = new RelationPool(null, relationMedata, ro);
        VersionRecord rsdRecord = new VersionRecord(relationMedata);
        long recordCount = in.readLong();
        in.readInt();
        byte[] data = rsdRecord.getRecordData();
        int i = 0;
        while ((long)i < recordCount) {
            int recordSize = in.readInt();
            rsdRecord.setDataLength(recordSize);
            if (data.length < recordSize) {
                rsdRecord.resetRecordSize(recordSize);
                data = rsdRecord.getRecordData();
            }
            in.readFully(data, 0, recordSize);
            relationData.appendRecord(rsdRecord);
            ++i;
        }
        relationData.appendFinished();
        return relationData;
    }

    public static ResultSet loadResultSet4bug112293(DataInput in, DiskStore diskStore) throws IOException, DSException {
        int columnCount = in.readShort();
        JAttribute[] attributeSet = new JAttribute[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String colName;
            int sqlType = in.readInt();
            int colType = Types.sqlTypeToType(sqlType);
            if (sqlType == 6) {
                colType = 6;
            }
            if ("".equals(colName = in.readUTF())) {
                colName = "NULL";
            }
            int precision = in.readInt();
            short scale = in.readShort();
            short nullAble = in.readShort();
            in.readShort();
            boolean currency = in.readBoolean();
            attributeSet[i] = new Attribute(colName, colType, precision, scale, precision, nullAble, currency);
        }
        RelationMetaData relationMedata = new RelationMetaData(attributeSet);
        RelationOption ro = new RelationOption();
        ro.setDiskStore(diskStore);
        RelationPool relationData = new RelationPool(null, relationMedata, ro);
        VersionRecord rsdRecord = new VersionRecord(relationMedata);
        long recordCount = in.readLong();
        in.readInt();
        byte[] data = rsdRecord.getRecordData();
        int i = 0;
        while ((long)i < recordCount) {
            int recordSize = in.readInt();
            rsdRecord.setDataLength(recordSize);
            if (data.length < recordSize) {
                rsdRecord.resetRecordSize(recordSize);
                data = rsdRecord.getRecordData();
            }
            in.readFully(data, 0, recordSize);
            relationData.appendRecord(rsdRecord);
            ++i;
        }
        relationData.appendFinished();
        ResultSetTool resultSetTool = new ResultSetTool();
        resultSetTool.getClass();
        ResultSetAdapterRelationDataCanClose ret = resultSetTool.new ResultSetAdapterRelationDataCanClose(relationData);
        return ret;
    }

    class ResultSetAdapterRelationDataCanClose
    extends ResultSetAdapterRelationData {
        IRelationData relationData;

        public ResultSetAdapterRelationDataCanClose(IRelationData relationData) throws DSException {
            super(relationData);
            this.relationData = relationData;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            try {
                this.relationData.close();
            }
            catch (DSException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }
}

