/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbRecordModel;
import jet.connect.Groupable;

public class URecordModel
extends DbRecordModel {
    private int recordCount;

    public URecordModel(DbColDesc[] colDescs) {
        super(colDescs, (Groupable)null);
    }

    public void setRecordCount(int c) {
        this.recordCount = c;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void write(DataOutput out) throws IOException {
        DbColDesc[] coldescs = this.getColDescs();
        out.writeInt(coldescs.length);
        if (coldescs.length != 0) {
            for (int i = 0; i < coldescs.length; ++i) {
                out.writeUTF(coldescs[i].getColName());
                out.writeInt(coldescs[i].getSqlType());
                out.writeInt(coldescs[i].getPrecision());
                out.writeInt(coldescs[i].getScale());
                out.writeInt(coldescs[i].getNullable());
                out.writeInt(coldescs[i].getFlag());
                out.writeUTF(coldescs[i].getEncodingName());
            }
            out.writeInt(this.recordCount);
        }
    }

    public static URecordModel read(DataInput in) throws IOException {
        int colLen = in.readInt();
        URecordModel ret = null;
        if (colLen != 0) {
            DbColDesc[] coldescs = new DbColDesc[colLen];
            for (int i = 0; i < coldescs.length; ++i) {
                coldescs[i] = new DbColDesc(in.readUTF(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
                coldescs[i].setFlag(in.readInt());
                coldescs[i].setEncodingName(in.readUTF());
            }
            ret = new URecordModel(coldescs);
            ret.setRecordCount(in.readInt());
        }
        return ret;
    }
}

