/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.connect.DbBufSQLException;
import jet.connect.DbColDesc;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.datasource.JRResultSetException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.EndOfRecordsException;
import jet.exception.FormulaRingException;
import jet.exception.InvalidParameterException;
import jet.exception.NoRecordsFoundException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.universe.DataCollection;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.resultfile.UDbBuffer;
import jet.universe.resultfile.URecordModel;
import jet.universe.resultfile.UResultFileException;
import jet.util.RAFile;
import toolkit.db.ParameterFormatInvalid;

public class UResultFile {
    public static final String BLOB_FILE_EXTENSION = ".col";
    public static final String DESCRIPTION_FILE_EXTENSION = ".desc";
    Frame frame = null;
    Container parentDialog = null;
    JetUUniverse unvs = null;
    JetUQueriable uQueriable = null;
    File flResultFile = null;
    UQueryEngine engine = null;
    ResultSet rs = null;
    DbColDesc[] coldescs = null;
    URecordModel recordModel = null;
    Hashtable blobs = new Hashtable();
    UDbBuffer dbBuffer;
    DataCollection collection;
    private static JRLogger logger = JRLogger.getLogger(UResultFile.class.getName());

    public UResultFile(JetUUniverse unvs, JetUQueriable uQueriable, File flResultFile) {
        this.unvs = unvs;
        this.uQueriable = uQueriable;
        this.flResultFile = flResultFile;
    }

    public void setContainerDialog(Container dialog) {
        this.parentDialog = dialog;
    }

    public boolean generateQueryResultFile() throws UResultFileException {
        boolean bSuc = this.createQueryEngine();
        if (!bSuc) {
            return bSuc;
        }
        this.getResultSet();
        this.createRecordModel();
        this.createBlobFiles();
        this.generateResultFile();
        return true;
    }

    protected boolean createQueryEngine() throws UResultFileException {
        Vector qryFields = this.uQueriable.getFields();
        int iSize = qryFields.size();
        Vector<String> vecQryFldNames = new Vector<String>(iSize);
        for (int i = 0; i < iSize; ++i) {
            JetUResourceEntity entity = (JetUResourceEntity)qryFields.elementAt(i);
            vecQryFldNames.addElement(entity.getResourceName());
        }
        try {
            this.engine = UQueryEngine.createEngine(this.unvs, this.uQueriable.getDatabase().getResourceName(), this.uQueriable.getResourceName(), vecQryFldNames, null, null, false);
            this.engine.initialize();
            Hashtable paramsBuff = this.engine.getParamsBuff();
            this.getShowValue(paramsBuff);
            boolean bInit = UResultFile.initParameters(this.parentDialog, paramsBuff);
            if (!bInit) {
                return false;
            }
            this.engine.initParameters();
            this.engine.start();
            return true;
        }
        catch (CannotFindQuery e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (CannotFindEntity e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (InvalidParameterException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (CannotFindFrmlRefFld e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (ParameterNotResolved e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (FormulaHasGrammarError e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (FldNotFoundInQuery e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (SubLinkError e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (CannotUseGlobalVarInFrmlWhere e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (ParseFormulaFailedException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (QueryWhereFormulaGrammarError e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (FormulaRingException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (LoadUserDataSourceException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (JRUserDataSourceException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (JRResultSetException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (SQLException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UResultFileException(1, e.getMessage());
        }
        catch (DSException e) {
            throw new UResultFileException(1, e.getMessage());
        }
    }

    protected static boolean initParameters(Container parentDialog, Hashtable paramsBuff) throws InvalidParameterException {
        if (paramsBuff.isEmpty()) {
            return true;
        }
        Hashtable hashtable = paramsBuff;
        return false;
    }

    void getShowValue(Hashtable paramDescs) throws SQLException, ClassNotFoundException, InvalidParameterException {
        Enumeration e = paramDescs.elements();
        while (e.hasMoreElements()) {
            ParamDesc param = (ParamDesc)e.nextElement();
            if (param.getBeColumn() != 4) continue;
            if (this.collection == null) {
                this.collection = new DataCollection();
            }
            Vector[] values = this.collection.getResultSet(this.unvs, this.uQueriable.getDatabase().getResourceName(), param.getColumn(), param.getColumns(), param.isDistinct(), param.getFormat());
            param.setValues(values[0], Locale.getDefault());
            param.setShowValues(values.length > 1 ? values[1] : values[0]);
            if (values[0].isEmpty()) continue;
            param.setDefaultIndex(0);
        }
    }

    protected void getResultSet() throws UResultFileException {
        try {
            this.rs = this.engine.getResultSet();
        }
        catch (LoadUserDataSourceException e) {
            throw new UResultFileException(2, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UResultFileException(2, e.getMessage());
        }
        catch (SQLException e) {
            throw new UResultFileException(2, e.getMessage());
        }
        catch (ParameterFormatInvalid e) {
            throw new UResultFileException(2, e.getMessage());
        }
        catch (DSException e) {
            throw new UResultFileException(2, e.getMessage());
        }
    }

    protected void createRecordModel() throws UResultFileException {
        Vector vecDbFieldsInSel = this.engine.getDbFlds();
        int[] aiDbFieldsInSelIdx = this.engine.getDbFldsBackIndex();
        Vector vecDbFieldsInWhere = null;
        int[] aiDbFieldsInWhereIdx = null;
        if (this.engine.haveLocalWhere()) {
            vecDbFieldsInWhere = this.engine.getDbFldsInLocalWhere();
            aiDbFieldsInWhereIdx = this.engine.getDbFldsInLocalWhereBackIndex();
        }
        int iDbFldsCount = vecDbFieldsInSel.size();
        if (this.engine.haveLocalWhere()) {
            iDbFldsCount += vecDbFieldsInWhere.size();
        }
        Vector vecDbFields = new Vector(iDbFldsCount + 1);
        int[] aiDbFieldsIdx = new int[iDbFldsCount + 1];
        int iIndex = 0;
        for (int i = 1; i <= iDbFldsCount; ++i) {
            if (aiDbFieldsInSelIdx[i] != -1) {
                vecDbFields.addElement(vecDbFieldsInSel.elementAt(aiDbFieldsInSelIdx[i] - 1));
                aiDbFieldsIdx[i] = iIndex++;
                continue;
            }
            if (vecDbFieldsInWhere != null && aiDbFieldsInWhereIdx != null) {
                vecDbFields.addElement(vecDbFieldsInWhere.elementAt(aiDbFieldsInWhereIdx[i] - 1));
                aiDbFieldsIdx[i] = iIndex++;
                continue;
            }
            aiDbFieldsIdx[i] = -1;
        }
        this.coldescs = new DbColDesc[iDbFldsCount];
        for (int i = 0; i < iDbFldsCount; ++i) {
            String strFieldName = (String)vecDbFields.elementAt(i);
            this.coldescs[i] = new DbColDesc(this.unvs.getSQLType(this.uQueriable.getDatabase().getResourceName(), this.uQueriable.getResourceName(), strFieldName));
            this.coldescs[i].setColName(strFieldName);
        }
        try {
            this.recordModel = new URecordModel(this.coldescs);
            this.recordModel.setResultSet(this.rs);
            this.recordModel.setColumnMap(aiDbFieldsIdx);
        }
        catch (SQLException e) {
            throw new UResultFileException(3, e.getMessage());
        }
    }

    protected void createBlobFiles() throws UResultFileException {
        try {
            for (int i = 0; i < this.coldescs.length; ++i) {
                if (this.coldescs[i].getSqlType() != -1 && this.coldescs[i].getSqlType() != -4 && this.coldescs[i].getSqlType() != 2005 && this.coldescs[i].getSqlType() != 2004 && !this.coldescs[i].isArray()) continue;
                String strBlobFileName = this.flResultFile.getPath() + BLOB_FILE_EXTENSION + i;
                RAFile raFile = new RAFile(strBlobFileName, "rw");
                this.blobs.put(this.coldescs[i], raFile);
            }
        }
        catch (IOException e) {
            throw new UResultFileException(4, e.getMessage());
        }
    }

    protected void generateResultFile() throws UResultFileException {
        try {
            this.dbBuffer = new UDbBuffer(this.recordModel, this.flResultFile, this.blobs);
            this.dbBuffer.setNeedWaitFetch(false);
            try {
                while (true) {
                    this.recordModel.fetch();
                    Record record = this.recordModel.currentRecord;
                    this.dbBuffer.addRecord(record);
                }
            }
            catch (NoRecordsFoundException e) {
                this.dbBuffer.finish();
                this.dbBuffer.refreshAllToFile();
                this.dbBuffer.close();
                this.generateDescriptionFile();
                this.close();
                return;
            }
            catch (EndOfRecordsException e) {
                this.dbBuffer.finish();
                this.dbBuffer.refreshAllToFile();
                this.dbBuffer.close();
                this.generateDescriptionFile();
                this.close();
                return;
            }
        }
        catch (SQLException e) {
            if (e instanceof DbBufSQLException) {
                throw new UResultFileException(7, e.getMessage());
            }
            throw new UResultFileException(6, e.getMessage());
        }
        catch (IOException e) {
            throw new UResultFileException(7, e.getMessage());
        }
    }

    protected void generateDescriptionFile() throws UResultFileException {
        int iRecordCount = this.dbBuffer.countRecords();
        this.recordModel.setRecordCount(iRecordCount);
        try {
            RAFile raFile = new RAFile(this.flResultFile.getPath() + DESCRIPTION_FILE_EXTENSION, "rw");
            this.recordModel.write(raFile);
            raFile.close();
        }
        catch (IOException e) {
            throw new UResultFileException(8, e.getMessage());
        }
    }

    public void close() throws SQLException {
        if (this.engine != null) {
            this.engine.end();
        }
    }
}

