/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbBuffer;
import jet.connect.DbColDesc;
import jet.datasource.JRColDesc;
import jet.datasource.JRResultSetException;
import jet.log.JRLogger;
import jet.universe.resultfile.UDbBuffer;
import jet.universe.resultfile.URecordModel;
import jet.universe.resultfile.XResultFileResultSet;
import jet.util.RAFile;

public class UResultFileResultSet
extends XResultFileResultSet {
    private static JRLogger logger = JRLogger.getLogger(UResultFileResultSet.class.getName());

    public UResultFileResultSet() {
    }

    public UResultFileResultSet(File flResultFile, Vector colsMap) throws JRResultSetException {
        this.init(this.initDataBuffer(flResultFile), colsMap);
    }

    @Override
    public void initialize(JRColDesc[] colDescs, String[] args) throws JRResultSetException {
        if (args.length < 1 || args[0] == null) {
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_7", (Object)this.getClass().getName()));
        }
        File flResultFile = new File(args[0]);
        DbBuffer buffer = this.initDataBuffer(flResultFile);
        Vector<DbColDesc> colsMap = new Vector<DbColDesc>();
        int iColsCount = colDescs.length;
        for (int i = 1; i < iColsCount; ++i) {
            DbColDesc colDesc = new DbColDesc(colDescs[i].colName, colDescs[i].sqlType, colDescs[i].precision, colDescs[i].scale, colDescs[i].nullable);
            colsMap.addElement(colDesc);
        }
        this.init(buffer, colsMap);
    }

    protected DbBuffer initDataBuffer(File flResultFile) throws JRResultSetException {
        URecordModel recordModel = null;
        try {
            RAFile raFile = new RAFile(flResultFile.getPath() + ".desc", "r");
            recordModel = URecordModel.read(raFile);
            raFile.close();
        }
        catch (IOException e) {
            String strErr = e.getMessage();
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_2", (Object)(strErr != null ? strErr : "")));
        }
        Hashtable<DbColDesc, RAFile> blobs = new Hashtable<DbColDesc, RAFile>();
        try {
            DbColDesc[] coldescs = recordModel.getColDescs();
            for (int i = 0; i < coldescs.length; ++i) {
                if (coldescs[i].getSqlType() != -1 && coldescs[i].getSqlType() != -4 && coldescs[i].getSqlType() != 2005 && coldescs[i].getSqlType() != 2004 && !coldescs[i].isArray()) continue;
                String strBlobFileName = flResultFile.getPath() + ".col" + i;
                RAFile raFile = new RAFile(strBlobFileName, "r");
                blobs.put(coldescs[i], raFile);
            }
        }
        catch (IOException e) {
            String strErr = e.getMessage();
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_3", (Object)(strErr != null ? strErr : "")));
        }
        try {
            UDbBuffer dbBuffer = new UDbBuffer(recordModel, flResultFile, blobs);
            dbBuffer.Read();
            return dbBuffer;
        }
        catch (IOException e) {
            String strErr = e.getMessage();
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_1", (Object)(strErr != null ? strErr : "")));
        }
    }

    @Override
    protected void initResultSet() {
        super.initResultSet();
        this.iRcdCount = ((URecordModel)this.recordModel).getRecordCount();
    }

    @Override
    public void close() throws JRResultSetException {
        try {
            ((UDbBuffer)this.dbBuffer).close();
        }
        catch (SQLException e) {
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_TITLE_2"));
        }
    }
}

