/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.resultfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbBuffer;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbRecordModel;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.datasource.JRColDesc;
import jet.datasource.JRResultSet;
import jet.datasource.JRResultSetException;

public abstract class XResultFileResultSet
extends JRResultSet {
    protected DbRecordModel recordModel;
    protected DbBuffer dbBuffer;
    private DbColDesc[] colDescs;
    protected Record record;
    protected int iRcdCount;
    protected int iRecordIndex;
    private int[] aiColumnMap = null;
    private boolean bWasNull;
    private DbValue value;

    public XResultFileResultSet() {
    }

    public XResultFileResultSet(DbBuffer dbBuffer, Vector colsMap) throws JRResultSetException {
        this.init(dbBuffer, colsMap);
    }

    protected final void init(DbBuffer dbBuffer, Vector colsMap) throws JRResultSetException {
        this.dbBuffer = dbBuffer;
        this.recordModel = dbBuffer.getRecordModel();
        this.initResultSet();
        this.setColumnMap(colsMap);
    }

    protected void initResultSet() {
        this.colDescs = this.recordModel.getColDescs();
        this.record = this.recordModel.currentRecord;
        this.iRecordIndex = -1;
    }

    public void setColumnMap(Vector colsMap) throws JRResultSetException {
        int iSize = colsMap.size();
        this.aiColumnMap = new int[iSize + 1];
        for (int i = 1; i <= iSize; ++i) {
            DbColDesc colDesc = (DbColDesc)colsMap.elementAt(i - 1);
            String strColName = colDesc.getColName();
            int iColIndex = this.getColumnIndex(strColName);
            if (iColIndex < 0) {
                throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_5", (Object)strColName));
            }
            if (!colDesc.typeEquals(this.colDescs[iColIndex])) {
                throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(iColIndex)));
            }
            this.aiColumnMap[i] = iColIndex;
        }
    }

    protected int getColumnIndex(String strColName) {
        int iSize = this.colDescs.length;
        for (int i = 0; i < iSize; ++i) {
            DbColDesc colDesc = this.colDescs[i];
            if (!strColName.equalsIgnoreCase(colDesc.getColName())) continue;
            return i;
        }
        return -1;
    }

    protected DbValue getDbValue(int iColumnIndex) {
        DbValue value = this.record.getCell(this.aiColumnMap[iColumnIndex]);
        return value;
    }

    @Override
    public boolean next() throws JRResultSetException {
        ++this.iRecordIndex;
        if (this.iRecordIndex < this.iRcdCount) {
            this.recordModel.currentRecord.setRecordIndex(this.iRecordIndex);
            this.recordModel.currentRecord.refresh(true);
            return true;
        }
        return false;
    }

    @Override
    public void close() throws JRResultSetException {
        try {
            this.dbBuffer.clearMem();
        }
        catch (Exception e) {
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_TITLE_2"));
        }
        finally {
            this.dbBuffer = null;
            this.recordModel = null;
            this.colDescs = null;
            this.record = null;
            this.aiColumnMap = null;
        }
    }

    @Override
    public boolean wasNull() throws JRResultSetException {
        return this.bWasNull;
    }

    @Override
    public String getString(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == -1 || type == 1 || type == 12 || type == 2005) {
                this.bWasNull = false;
                return ((DbChar)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            this.bWasNull = false;
            return ((DbArray)this.value).toSqlArray();
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == -7) {
                this.bWasNull = false;
                return ((DbBit)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == -6) {
                this.bWasNull = false;
                return (byte)((DbTinyInt)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 5) {
                this.bWasNull = false;
                return ((DbSmallInt)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 4) {
                this.bWasNull = false;
                return ((DbInteger)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == -5) {
                this.bWasNull = false;
                return ((DbBigInt)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 6 || type == 7 || type == 8) {
                this.bWasNull = false;
                return ((DbNumber)this.value).floatValue();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 6 || type == 7 || type == 8) {
                this.bWasNull = false;
                return ((DbNumber)this.value).doubleValue();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 3 || type == 2) {
                this.bWasNull = false;
                return ((DbDecimal)this.value).get();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws JRResultSetException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 91) {
                this.bWasNull = false;
                return ((DbDate)this.value).getDate();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 92) {
                this.bWasNull = false;
                return ((DbTime)this.value).getTime();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == 93) {
                this.bWasNull = false;
                return ((DbTimestamp)this.value).getTimestamp();
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws JRResultSetException {
        this.value = this.getDbValue(columnIndex);
        if (!this.value.isNull()) {
            int type = this.value.getSqlType();
            if (type == -2 || type == -3 || type == -4 || type == 2004) {
                this.bWasNull = false;
                return new ByteArrayInputStream(((DbBinary)this.value).get());
            }
            throw new JRResultSetException(JResource.getMessage("CAT_CQR_EXCP_6", new Integer(columnIndex)));
        }
        this.bWasNull = true;
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws JRResultSetException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws JRResultSetException {
        return null;
    }

    @Override
    public String getString(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public boolean getBoolean(String columnName) throws JRResultSetException {
        return false;
    }

    @Override
    public byte getByte(String columnName) throws JRResultSetException {
        return 0;
    }

    @Override
    public short getShort(String columnName) throws JRResultSetException {
        return 0;
    }

    @Override
    public int getInt(String columnName) throws JRResultSetException {
        return 0;
    }

    @Override
    public long getLong(String columnName) throws JRResultSetException {
        return 0L;
    }

    @Override
    public float getFloat(String columnName) throws JRResultSetException {
        return 0.0f;
    }

    @Override
    public double getDouble(String columnName) throws JRResultSetException {
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws JRResultSetException {
        return null;
    }

    @Override
    public byte[] getBytes(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public Date getDate(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public Time getTime(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws JRResultSetException {
        return null;
    }

    @Override
    public void clearWarnings() throws JRResultSetException {
    }

    @Override
    public String getCursorName() throws JRResultSetException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws JRResultSetException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws JRResultSetException {
        return null;
    }

    @Override
    public Object getObject(String columnName) throws JRResultSetException {
        return null;
    }

    @Override
    public int findColumn(String columnName) throws JRResultSetException {
        return 0;
    }

    @Override
    public void initialize(JRColDesc[] colDescs, String[] args) throws JRResultSetException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

