/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.summary;

import java.util.HashMap;
import java.util.TimeZone;
import jet.controls.JetNumber;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.universe.summary.JetUSpecFuncInfo;

public class JetUSpecFuncDateTime
extends JetUSpecFuncInfo {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int HOUR = 10;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int HALFYEAR = 20;
    public static final int HALFMONTH = 21;
    public static final int QUATER = 22;
    public static final int BIWEEK = 23;
    public static final int WEEK = 24;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public JetNumber unit = new JetNumber(this, "Unit", 13);
    public JetString bechPoint = new JetString(this, "BenchPoint", Long.toString(-2206339552000L));
    public JetNumber zoneOffset = new JetNumber(this, "ZoneOffset", 0);
    public JetNumber firstDayOfWeek = new JetNumber(this, "firstDayOfWeek", 1);
    private static final HashMap nameIdx = new HashMap(7);

    public JetUSpecFuncDateTime() {
        this.interNum = new JetString(this, "InterNum", "1");
        this.type = new JetNumber(this, "Type", 2);
    }

    public int getUnit() {
        return this.unit.get();
    }

    public void setUnit(int val) {
        this.unit.set(val);
    }

    public String getBenchPoint() {
        return this.bechPoint.get();
    }

    public void setBenchPoint(String val) {
        this.bechPoint.set(val);
    }

    public int getZoneOffset() {
        return TimeZone.getDefault().getRawOffset() / 60000;
    }

    public void setZoneOffset(int val) {
        this.zoneOffset.set(val);
    }

    public void setfirstDayOfWeek(int val) {
        this.firstDayOfWeek.set(val);
    }

    public int getfirstDayOfWeek() {
        return this.firstDayOfWeek.get();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getSimpleDesc() throws DSException {
        return SumrySpecKeyTool.getDateDesc(this.getUnit(), this.getInterNum());
    }

    public boolean isSimilar(JetUSpecFuncDateTime jsft) {
        return super.isSimilar(jsft) && this.unit.equal(jsft.unit) && this.bechPoint.equal(jsft.bechPoint) && this.zoneOffset.equal(jsft.zoneOffset) && this.firstDayOfWeek.equal(jsft.firstDayOfWeek);
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Type", new Integer(0));
        nameIdx.put("Unit", new Integer(1));
        nameIdx.put("firstDayOfWeek", new Integer(2));
        nameIdx.put("ZoneOffset", new Integer(3));
        nameIdx.put("InterNum", new Integer(4));
        nameIdx.put("BenchPoint", new Integer(5));
        nameIdx.put("OtherName", new Integer(6));
    }
}

