/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.impl.IExpressionExecutorEnv;
import com.jinfonet.dataservice.expression.executor.impl.ProjectOpExecutor;
import com.jinfonet.dataservice.expression.relational.ProjectInformationImpl;
import com.jinfonet.dataservice.expression.relational.op.ProjectImpl;
import com.jinfonet.dataservice.relational.DistinctRelationData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import com.jinfonet.datatypes.DataTypeUtils;
import com.jinfonet.designer.util.JDesgResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.Env;
import jet.JRStopEngineException;
import jet.connect.DbArray;
import jet.connect.DbChar;
import jet.connect.DbColumnLink;
import jet.connect.DbDate;
import jet.connect.DbQuery;
import jet.connect.DbTableLink;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine8.dbbuffer.DbBufferDataAdapterRelation;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.api.DataServiceFactory;
import jet.dataservice.api.JDataService;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.jetc.ReadFailureException;
import jet.log.JRLogger;
import jet.parameter.runtime.valuelist.DefaultFetcherContext;
import jet.parameter.runtime.valuelist.item.ValueListItem;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.util.ParameterGraph;
import jet.rptservice.util.ParameterTools;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.util.CatalogKeyCreater;
import jet.util.DbValueFormat;
import jet.util.ReportFormat;
import toolkit.db.gui.JdbcDatabase;

public class DataEntryKeyListTool {
    JetUUniverse unv;
    JetUTreeNode[] entities;
    Hashtable<String, ParamDesc> holdParamDesc = new Hashtable();
    protected static JRLogger logger = JRLogger.getLogger(DataEntryKeyListTool.class.getName());

    public DataEntryKeyListTool(JetUUniverse unv, JetUTreeNode[] entities) {
        this.unv = unv;
        this.entities = entities;
    }

    public List<ParamDesc> getDataEntryRefPara() throws JRScheduleException {
        int i;
        ArrayList<String> selfNames = new ArrayList<String>();
        for (int i2 = 0; i2 < this.entities.length; ++i2) {
            if (!(this.entities[i2] instanceof JetUParameter)) continue;
            selfNames.add(((JetUParameter)this.entities[i2]).getResourceName().toUpperCase());
        }
        ParameterTools pt = ParameterTools.getInstance();
        ParameterGraph gpg = pt.getAllParamDescs(this.entities, this.unv);
        ArrayList<ParamDesc> ret = new ArrayList<ParamDesc>();
        ArrayList holdTemp = new ArrayList();
        ArrayList<Hashtable> relatedPrams = new ArrayList<Hashtable>();
        if (gpg != null) {
            String[] sortNames = gpg.sort();
            Map paramBuff1 = gpg.getParamBuff();
            for (i = 0; i < sortNames.length; ++i) {
                if (!selfNames.contains(sortNames[i]) || gpg.getOutDegree(sortNames[i]) > 0) {
                    ret.add((ParamDesc)paramBuff1.get(sortNames[i]));
                }
                relatedPrams.add((Hashtable)this.holdParamDesc.clone());
                this.holdParamDesc.put(sortNames[i].toUpperCase(), (ParamDesc)paramBuff1.get(sortNames[i]));
                holdTemp.add(paramBuff1.get(sortNames[i]));
            }
        }
        Vector paramUsedByQuery = new Vector();
        String userName = null;
        for (i = 0; i < holdTemp.size(); ++i) {
            try {
                DefaultFetcherContext fc = new DefaultFetcherContext(this.unv, (Hashtable)relatedPrams.get(i), paramUsedByQuery, userName);
                ((ParamDesc)holdTemp.get(i)).getParameterRuntime().createValueListFetcher(CatalogKeyCreater.createCatalogKey(this.unv.getFullFileName()), fc);
                continue;
            }
            catch (DSException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public DbValue[] getDataEntryKeyList(ParameterValueList parameterValues) throws DSException, JRStopEngineException, ReadFailureException, FileNotFoundException, GenerateFormulasCodeException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, LoadJavaFormulaException, ConditionException, FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity, SQLException {
        ArrayList<DbValue> retList = new ArrayList<DbValue>();
        for (int i = 0; i < this.entities.length; ++i) {
            DbValue[] Keys = this.getDataEntryKeyList(this.entities[i], parameterValues);
            for (int j = 0; j < Keys.length; ++j) {
                retList.add(Keys[j]);
            }
        }
        DbValue[] ret = new DbValue[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    private DbValue[] getDataEntryKeyList(JetUTreeNode entity, ParameterValueList parameterValues) throws DSException, JRStopEngineException, ReadFailureException, FileNotFoundException, GenerateFormulasCodeException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, LoadJavaFormulaException, ConditionException, FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity, SQLException {
        if (entity instanceof JetUField) {
            Vector retVector = this.getValuesFromField((JetUField)entity);
            DbValue[] ret = new DbChar[retVector.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new DbChar();
                ret[i].setValue((String)retVector.get(i));
            }
            return ret;
        }
        if (entity instanceof JetUParameter) {
            JetUParameter p = (JetUParameter)entity;
            Vector retVector = this.holdParamDesc.get(p.getResourceName().toUpperCase()).getValueList(Locale.getDefault());
            DbValue[] ret = new DbValue[retVector.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = ((ValueListItem)retVector.get(i)).getValue();
            }
            return ret;
        }
        String dataSourceName = null;
        String queryName = null;
        String mappingName = null;
        if (entity instanceof JetUFormula) {
            queryName = null;
            JetUFormula formula2 = (JetUFormula)entity;
            Vector qbs = formula2.getDatabase().getQueriables();
            for (int i = 0; i < qbs.size(); ++i) {
                if (!((JetUQueriable)qbs.get(i)).isFieldValidToQuery(this.unv, formula2)) continue;
                queryName = ((JetUQueriable)qbs.get(i)).getResourceName();
                break;
            }
            if (queryName == null) {
                return new DbValue[0];
            }
            dataSourceName = formula2.getDatabase().getResourceName();
            mappingName = formula2.getResourceName();
            HashSet<String> mappingNameSet = new HashSet<String>();
            Vector fs = formula2.getRefAllFormuFld();
            for (int i = 0; i < fs.size(); ++i) {
                String fName = (String)fs.get(i);
                mappingNameSet.add(fName);
            }
            String[] mappingNames = new String[mappingNameSet.size() + 1];
            mappingNames[0] = mappingName;
            Iterator it = mappingNameSet.iterator();
            for (int i = 1; i < mappingNames.length; ++i) {
                mappingNames[i] = (String)it.next();
            }
            return this.getValuesByQuery(this.unv, dataSourceName, queryName, mappingNames, parameterValues);
        }
        if (entity instanceof JetUQueriableField) {
            JetUQueriableField queryField = (JetUQueriableField)((Object)entity);
            JetUQueriable queriable = queryField.getQueriable();
            dataSourceName = queriable.getDatabase().getResourceName();
            queryName = queriable.getResourceName();
            mappingName = queryField.getResourceName();
            return this.getValuesByQuery(this.unv, dataSourceName, queryName, new String[]{mappingName}, parameterValues);
        }
        if (entity instanceof DataElement) {
            DataElement de = (DataElement)entity;
            JUnifiedBusinessView ubv = de.getUbv();
            JetUDemandQuery queriable = ubv.getQuery();
            dataSourceName = queriable.getDatabase().getResourceName();
            queryName = queriable.getResourceName();
            mappingName = de.getRefMappingName();
            return this.getValuesByQuery(this.unv, dataSourceName, queryName, new String[]{mappingName}, parameterValues);
        }
        logger.error("getDataEntryKeyList the tree node is " + entity + ". Can not get DataEntryKeyList.");
        return null;
    }

    private DbValue[] getValuesByQuery(JetUUniverse unv, String dataSoureceName, String queryName, String[] mappingNames, ParameterValueList parameterValues) throws DSException, ReadFailureException, FileNotFoundException, GenerateFormulasCodeException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, LoadJavaFormulaException, ConditionException, JRStopEngineException, CannotFindEntity {
        JetUFormula f;
        JetUDatabase udb = unv.getDatabase(dataSoureceName);
        JetUQueriable query = udb.getQueriableByResourceName(queryName);
        boolean id = true;
        JDataService ds = DataEntryKeyListTool.createDataService(unv);
        CatalogKey ck = CatalogKeyCreater.createCatalogKey(unv.getFullFileName());
        ds.registCatalog(ck, unv);
        JDataSourceQuery dsQuery = null;
        dsQuery = ds.getQueryFactory().createDataSourceQuery(ck);
        dsQuery.setCatalog(unv);
        dsQuery.setDataSourceName(udb.getResourceName());
        dsQuery.setBVQueryName(query.getResourceName(), 2);
        RawDataQueryOption qo = new RawDataQueryOption();
        qo.setDistinct(true);
        qo.setMaxRecords(-1L);
        qo.setCutData(false);
        dsQuery.setOption(qo);
        SpecialFields sf = new SpecialFields();
        DbDate d = new DbDate();
        d.set(Calendar.getInstance().getTimeInMillis());
        sf.setModifiedDate(d);
        DbTime dtime = new DbTime();
        dtime.set(d.value);
        sf.setModifiedTime(dtime);
        sf.setUserName(new DbChar(""));
        dsQuery.setSpecialFields(sf);
        dsQuery.setMappingNames(mappingNames);
        JavaFormula jf = unv.loadJavaFormula(udb.getResourceName());
        dsQuery.setJavaFormula(jf);
        dsQuery.setParameterValues(parameterValues);
        IReference sortby = ExpressionFactoryCreator.getIExpressionFactory().createReference(mappingNames[0]);
        ISortInformation sortinfo = ExpressionFactoryCreator.getIOperatorInforFactory().createSortInfo(sortby, 1, false);
        ISortInformationCollector sortInfoList = ExpressionFactoryCreator.getIOperatorInforFactory().createSortInfoCollector();
        sortInfoList.addSortInformation(sortinfo);
        ISortOperator groupOp = ExpressionFactoryCreator.getIOperatorFactory().createSortOp(sortInfoList);
        ISortExpression iSorter = ExpressionFactoryCreator.getIExpressionFactory().createSortExp(groupOp);
        dsQuery.setSorter(iSorter);
        JetUResourceEntity entity = udb.getResourceByName(mappingNames[0]);
        if (entity instanceof JetUFormula && (f = (JetUFormula)entity).isConstant()) {
            ArrayList<JetRptFormula> RptFormulaSet = new ArrayList<JetRptFormula>();
            RptFormulaSet.add(f.getRptFormula());
            Vector fs = f.getRefAllFormuFld();
            for (int i = 0; i < fs.size(); ++i) {
                String fName = (String)fs.get(i);
                JetUFormula fi = (JetUFormula)udb.getResourceByName(fName);
                RptFormulaSet.add(fi.getRptFormula());
            }
            JetRptFormula[] jetRptFormulas = new JetRptFormula[RptFormulaSet.size()];
            RptFormulaSet.toArray(jetRptFormulas);
            DataDescription dd = DataDescription.create(jetRptFormulas);
            Hashtable dynamicConnections = dsQuery.getDynamicConnections();
            dynamicConnections.put("", dd);
        }
        ds.sendQuery(dsQuery);
        IRelationData rd = ds.getRelation(dsQuery.getQueryId());
        RelationMetaData targetMetaData = null;
        JAttribute[] targetAttr = new JAttribute[1];
        JRelationMetaData md = rd.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            JAttribute attr = md.getAttribute(i);
            if (!mappingNames[0].equalsIgnoreCase(attr.getAliasName())) continue;
            targetAttr[0] = attr;
            targetMetaData = new RelationMetaData(targetAttr);
        }
        int targetCount = 1;
        String[][] targetMapping = new String[2][targetCount];
        targetMapping[0][0] = mappingNames[0];
        targetMapping[1][0] = mappingNames[0];
        ProjectInformationImpl projectInfo = new ProjectInformationImpl(targetMapping);
        ProjectImpl project = new ProjectImpl(projectInfo);
        ProjectOpExecutor executor = new ProjectOpExecutor(project, "", rd, (JRelationMetaData)targetMetaData, new IExpressionExecutorEnv());
        rd = executor.execute();
        DistinctRelationData drd = new DistinctRelationData("", rd, new String[]{mappingNames[0]});
        DbBufferDataAdapterRelation dbBuffer = new DbBufferDataAdapterRelation(drd, false, new DbValue[0]);
        JDbBufferCursor cursor = dbBuffer.createCursor();
        JRecord record = cursor.createRecord();
        ArrayList<DbValue> ret = new ArrayList<DbValue>();
        while (cursor.next()) {
            record.setPosition(cursor.getPosition());
            record.refresh();
            DbValue val = record.getCell(0);
            if (val.isNull()) continue;
            if (val instanceof DbArray) {
                String format = DataTypeUtils.getDefaultFormat(val.getSqlType());
                DbValueFormat fmat = ReportFormat.getOneFormat(val.getSqlType(), format);
                String[] fmatVals = fmat.formatArray((DbArray)val);
                for (int i = 0; i < fmatVals.length; ++i) {
                    DbChar o = new DbChar(fmatVals[i]);
                    if (ret.contains(o)) continue;
                    ret.add(o);
                }
                continue;
            }
            ret.add((DbValue)val.clone());
        }
        return ret.toArray(new DbValue[ret.size()]);
    }

    private static JDataService createDataService(JetUUniverse unv) throws DSException {
        DataServiceConfig dsc = new DataServiceConfig(DriverConfigFactory.getJdbcDriversConfig(), Env.getTemporaryPath(), unv.getInfoBusManager(), unv.getResourceStore());
        dsc.setSingleThread(true);
        dsc.setCacheZip(false);
        dsc.setThreadPriority(Thread.currentThread().getPriority());
        JDataService dataService = null;
        dataService = DataServiceFactory.createDataSerivce(dsc);
        return dataService;
    }

    private static BusinessLogic getBusinessLogic(DimensionInfo dimen) {
        JetObject jo = (JetObject)((Object)dimen);
        while (!(jo instanceof BusinessLogic)) {
            jo = (JetObject)((Object)jo.getParent());
        }
        return (BusinessLogic)jo;
    }

    public Vector getValuesFromField(JetUField fld) throws SQLException, ClassNotFoundException, JRStopEngineException {
        Vector<String> vecData = new Vector<String>();
        JetUTableView table = fld.getTable();
        String strColumnName = fld.getFldName();
        String strQualifier = table.getQualifier();
        String strOwner = table.getOwner();
        JetUConnection cnnt = fld.getConnection();
        if (cnnt != null && cnnt instanceof JetUJDBCConnection) {
            boolean isBit;
            JetUJDBCConnection connection = (JetUJDBCConnection)cnnt;
            JetUSupportInfo suppInfo = connection.getSupportInfo();
            String strExtraNameChar = suppInfo.getExtraNameChar();
            String strQuoteChar = suppInfo.getQuoteChar();
            String strExtraKeywords = suppInfo.getExtraKeywords();
            JdbcDatabase jdb = new JdbcDatabase(connection.getURL(), connection.getUID(), connection.getPSWD(), connection.getJdbcDriver(), connection.getTransactionIsolation(), connection.getReadOnly());
            DbQuery dbQuery = new DbQuery(jdb, strExtraNameChar, strQuoteChar, strExtraKeywords);
            dbQuery.setQlfOpt(connection.getQualifiedNamePattern());
            String strTableName = table.getTableName();
            DbTableLink dbTable = new DbTableLink(strQualifier, strOwner, strTableName, null, table.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
            dbTable.appendColumn(new DbColumnLink(fld.getResourceNameInUpperCase(), strColumnName));
            dbQuery.appendTable(dbTable);
            ResultSet rs = dbQuery.getResultSet();
            boolean bl = isBit = rs.getMetaData().getColumnType(1) == -7;
            if (rs != null) {
                while (rs.next()) {
                    String value = rs.getString(1);
                    if (isBit) {
                        value = "1".equals(value) ? "true" : "false";
                    }
                    vecData.addElement(value);
                }
            }
            dbQuery.close();
        } else assert (false) : JDesgResource.getMessage("CONNECTION_TYPE_UNKNOW");
        return vecData;
    }
}

