/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.dataservice.api.schema.relational.JAttribute;
import com.jinfonet.dataservice.api.schema.relational.JRelationMetaData;
import com.jinfonet.dataservice.expression.executor.impl.IExpressionExecutorEnv;
import com.jinfonet.dataservice.expression.executor.impl.ProjectOpExecutor;
import com.jinfonet.dataservice.expression.relational.ProjectInformationImpl;
import com.jinfonet.dataservice.expression.relational.op.ProjectImpl;
import com.jinfonet.dataservice.relational.DistinctRelationData;
import com.jinfonet.dataservice.relational.IRelationData;
import com.jinfonet.dataservice.relational.RelationMetaData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import jet.Env;
import jet.JRStopEngineException;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.JetObject;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.info.ISortInformation;
import jet.dataengine.api.expression.info.ISortInformationCollector;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.expression.set.op.ISortOperator;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.query.DataDescription;
import jet.dataengine.api.query.JDataSourceQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.RawDataQueryOption;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine8.dbbuffer.DbBufferDataAdapterRelation;
import jet.dataservice.api.DataServiceConfig;
import jet.dataservice.api.DataServiceFactory;
import jet.dataservice.api.JDataService;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.jetc.ReadFailureException;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.CategoryInfo;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.util.CatalogKeyCreater;

public class DimensionMemberListTool {
    public static DbValue[] getValueList(DimensionInfo dimen) throws DSException, JRStopEngineException, ReadFailureException, FileNotFoundException, GenerateFormulasCodeException, ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, LoadJavaFormulaException, ConditionException {
        JetUFormula f;
        String mappingName = dimen.getRefMappingName();
        CategoryInfo bl = DimensionMemberListTool.getBusinessRoot(dimen);
        JetUQueriable query = null;
        JetUDatabase udb = null;
        String[] ps = null;
        if (bl instanceof JUnifiedBusinessView) {
            query = ((JUnifiedBusinessView)bl).getQuery();
            udb = ((JUnifiedBusinessView)bl).getDatabase();
            ps = ((JUnifiedBusinessView)bl).getBvAndQueryRefParameter();
        } else {
            query = (JetUQueriable)((Object)((BusinessLogic)bl).getParent());
            udb = ((BusinessLogic)bl).getDatabase();
            ps = ((BusinessLogic)bl).getBvAndQueryRefParameter();
        }
        JetUUniverse unv = (JetUUniverse)udb.getParent();
        boolean id = true;
        JDataService ds = DimensionMemberListTool.createDataService(unv);
        CatalogKey ck = CatalogKeyCreater.createCatalogKey(unv.getFullFileName());
        ds.registCatalog(ck, unv);
        JDataSourceQuery dsQuery = null;
        dsQuery = ds.getQueryFactory().createDataSourceQuery(ck);
        dsQuery.setCatalog(unv);
        dsQuery.setDataSourceName(udb.getResourceName());
        dsQuery.setBVQueryName(query.getResourceName(), 2);
        RawDataQueryOption qo = new RawDataQueryOption();
        qo.setDistinct(true);
        qo.setMaxRecords(-1L);
        qo.setCutData(false);
        dsQuery.setOption(qo);
        SpecialFields sf = new SpecialFields();
        DbDate d = new DbDate();
        d.set(Calendar.getInstance().getTimeInMillis());
        sf.setModifiedDate(d);
        DbTime dtime = new DbTime();
        dtime.set(d.value);
        sf.setModifiedTime(dtime);
        sf.setUserName(new DbChar(""));
        dsQuery.setSpecialFields(sf);
        dsQuery.setMappingNames(new String[]{mappingName});
        JavaFormula jf = unv.loadJavaFormula(udb.getResourceName());
        dsQuery.setJavaFormula(jf);
        ParameterValueList parameterValues = new ParameterValueList();
        for (int i = 0; i < ps.length; ++i) {
            JetUParameter p = unv.getDatabase().getParameterByResourceName(ps[i]);
            parameterValues.addParameterValue(p.getParamDesc());
        }
        dsQuery.setParameterValues(parameterValues);
        IReference sortby = ExpressionFactoryCreator.getIExpressionFactory().createReference(mappingName);
        ISortInformation sortinfo = ExpressionFactoryCreator.getIOperatorInforFactory().createSortInfo(sortby, 1, false);
        ISortInformationCollector sortInfoList = ExpressionFactoryCreator.getIOperatorInforFactory().createSortInfoCollector();
        sortInfoList.addSortInformation(sortinfo);
        ISortOperator groupOp = ExpressionFactoryCreator.getIOperatorFactory().createSortOp(sortInfoList);
        ISortExpression iSorter = ExpressionFactoryCreator.getIExpressionFactory().createSortExp(groupOp);
        dsQuery.setSorter(iSorter);
        JetUResourceEntity entity = udb.getResourceByName(mappingName);
        if (entity instanceof JetUFormula && (f = (JetUFormula)entity).isConstant()) {
            DataDescription dd = DataDescription.create(new JetRptFormula[]{f.getRptFormula()});
            Hashtable dynamicConnections = dsQuery.getDynamicConnections();
            dynamicConnections.put("", dd);
        }
        ds.sendQuery(dsQuery);
        IRelationData rd = ds.getRelation(dsQuery.getQueryId());
        RelationMetaData targetMetaData = null;
        JAttribute[] targetAttr = new JAttribute[1];
        JRelationMetaData md = rd.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            JAttribute attr = md.getAttribute(i);
            if (!mappingName.equalsIgnoreCase(attr.getAliasName())) continue;
            targetAttr[0] = attr;
            targetMetaData = new RelationMetaData(targetAttr);
        }
        int targetCount = 1;
        String[][] targetMapping = new String[2][targetCount];
        targetMapping[0][0] = mappingName;
        targetMapping[1][0] = mappingName;
        ProjectInformationImpl projectInfo = new ProjectInformationImpl(targetMapping);
        ProjectImpl project = new ProjectImpl(projectInfo);
        ProjectOpExecutor executor = new ProjectOpExecutor(project, "", rd, (JRelationMetaData)targetMetaData, new IExpressionExecutorEnv());
        rd = executor.execute();
        DistinctRelationData drd = new DistinctRelationData("", rd, new String[]{mappingName});
        DbBufferDataAdapterRelation dbBuffer = new DbBufferDataAdapterRelation(drd, false, new DbValue[0]);
        JDbBufferCursor cursor = dbBuffer.createCursor();
        JRecord record = cursor.createRecord();
        ArrayList<DbValue> ret = new ArrayList<DbValue>();
        while (cursor.next()) {
            record.setPosition(cursor.getPosition());
            record.refresh();
            DbValue val = record.getCell(0);
            if (val.isNull()) continue;
            ret.add((DbValue)val.clone());
        }
        return ret.toArray(new DbValue[ret.size()]);
    }

    private static JDataService createDataService(JetUUniverse unv) throws DSException {
        DataServiceConfig dsc = new DataServiceConfig(DriverConfigFactory.getJdbcDriversConfig(), Env.getTemporaryPath(), unv.getInfoBusManager(), unv.getResourceStore());
        dsc.setSingleThread(true);
        dsc.setCacheZip(false);
        dsc.setThreadPriority(Thread.currentThread().getPriority());
        JDataService dataService = null;
        dataService = DataServiceFactory.createDataSerivce(dsc);
        return dataService;
    }

    private static CategoryInfo getBusinessRoot(DimensionInfo dimen) {
        JetObject jo = (JetObject)((Object)dimen);
        while (!(jo instanceof BusinessLogic) && !(jo instanceof JUnifiedBusinessView)) {
            jo = (JetObject)((Object)jo.getParent());
        }
        return (CategoryInfo)((Object)jo);
    }
}

