/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools;

import com.jinfonet.jdbc.model.ParameterDesc;
import com.jinfonet.jdbc.obj.ObjectConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.sqltoolkit.ResourceContainer;
import jet.dataengine8.core.queryengine.transform.PrepareInfoTools;
import jet.dataengine8.core.queryengine.transform.WSElementToolkit;
import jet.dataengine8.util.SFT;
import jet.log.JRLogger;
import jet.universe.JetField;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWSOperationConnection;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUXMLConnection;
import jet.universe.businesslogic.FilterInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.exception.CannotFindEntity;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.tools.IParseParametersForQuery;
import jet.universe.tools.ParseParametersForQueryFactory;
import jet.universe.webservice.JetUWSElement;
import jet.upgrade.UpgradeBV;
import jet.util.URIParameterResolver;
import toolkit.db.ConnectionToolkit;
import toolkit.db.DbTools;
import toolkit.db.PsqlTable;

public class ParseParametersForQuery
implements IParseParametersForQuery {
    DSLog log = DSLog.getDSLog(this.getClass().getName());
    private static JRLogger logger = JRLogger.getLogger(ParseParametersForQuery.class.getName());
    private JetUUniverse universe;
    private ResourceContainer resourceContainer = null;
    private static final char QUOTE_CHAR = '\"';
    private static final char FORMULA_VALUE_REFERENCE_CHAR = '@';
    private static final char FORMULA_DRIECT_REFERENCE_CHAR = ':';
    private static final char PARAMETER_VALUE_REFERENCE_CHAR = '@';
    private static final char PARAMETER_DRIECT_REFERENCE_CHAR = ':';
    private static final char QUERY_CHAR = '@';
    private static final char WHEREPORTION_REFERENCE_CHAR = '@';
    private boolean isRefQuery = false;
    private boolean isSQLQuery = false;
    private boolean isFileSQLQuery = false;
    private boolean isProcedureQuery = false;
    private boolean isUDSQuery = false;
    private JetUQueriable jetUQueriable;
    private String dataSourceName;
    private String queryName;
    private String SQLStirngInQuery = "";
    private boolean containsSubQuery;
    private boolean isHDSQuery;
    private String[] fileQueryParameterNames;
    private String[] fileQueryFormulaNames;

    public ParseParametersForQuery() {
    }

    public ParseParametersForQuery(JetUUniverse universe, String dataSourceName, String queryName) throws DSException {
        this.init(universe, dataSourceName, queryName, 0, null, null, null);
    }

    public ParseParametersForQuery(ResourceContainer container) {
        this.resourceContainer = container;
        this.universe = null;
    }

    public void init(JetUUniverse universe, String dataSourceName, String queryName) throws DSException {
        this.init(universe, dataSourceName, queryName, 0, null, null, null);
    }

    public void init(JetUUniverse universe, String dataSourceName, String queryName, int blType, String blName, SecurityData sd, String userName) throws DSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Universe's hashCode :" + String.valueOf(universe.hashCode()));
            this.log.debug("Data Source Name :" + dataSourceName);
            this.log.debug("QueryName :" + queryName);
        }
        this.universe = universe;
        this.dataSourceName = dataSourceName;
        this.queryName = queryName;
        this.resourceContainer = new ResourceContainer(universe, dataSourceName, null);
        this.jetUQueriable = universe.getQueriableByResourceName(dataSourceName, queryName);
        if (this.jetUQueriable == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Universe's hashCode :" + String.valueOf(universe.hashCode()));
                logger.debug("Data Source Name :" + dataSourceName);
                logger.debug("QueryName :" + queryName);
            }
            throw new DSException(2138, new Object[]{queryName});
        }
        if (this.jetUQueriable instanceof JetUQuery) {
            if (!((JetUQuery)this.jetUQueriable).getPsqlQuery().isSingleConnection()) {
                this.isRefQuery = true;
            } else {
                this.SQLStirngInQuery = ((JetUQuery)this.jetUQueriable).getSQLString();
                this.isSQLQuery = true;
            }
        } else if (this.jetUQueriable instanceof JetUHDSTable) {
            if (this.jetUQueriable instanceof JetUHierDataSource) {
                this.isHDSQuery = true;
            }
        } else if (this.jetUQueriable instanceof JetUProcedure) {
            this.isProcedureQuery = true;
        } else if (this.jetUQueriable instanceof JetUFileQuery) {
            JetUFileQuery uFileQuery = (JetUFileQuery)this.jetUQueriable;
            this.SQLStirngInQuery = uFileQuery.getSQLString();
            this.isSQLQuery = true;
            this.isFileSQLQuery = true;
            Hashtable ht = new Hashtable();
            Hashtable uv = new Hashtable();
            JetUConnection conn = uFileQuery.getConnection();
            if (conn == null) {
                throw new DSException(0, new String[]{"The connection " + uFileQuery.connectionName.get() + " can't be found."});
            }
            FileQuery.parseStatement(this.SQLStirngInQuery, ht, new Hashtable(), uv, new Hashtable(), new Vector(), this.universe, this.dataSourceName, conn, conn.getSupportInfo(), null, "");
            ArrayList<String> pNames = new ArrayList<String>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements()) {
                JetUParameter p = (JetUParameter)enumeration.nextElement();
                pNames.add(p.getResourceName());
            }
            this.fileQueryParameterNames = pNames.toArray(SFT.ZERO_STRING_ARRAY);
            ArrayList<String> fNames = new ArrayList<String>();
            Enumeration enumeration2 = uv.keys();
            while (enumeration2.hasMoreElements()) {
                Object ele = enumeration2.nextElement();
                if (!(ele instanceof JetUFormula)) continue;
                JetUFormula f = (JetUFormula)ele;
                fNames.add(f.getResourceName());
            }
            this.fileQueryFormulaNames = fNames.toArray(SFT.ZERO_STRING_ARRAY);
        } else if (this.jetUQueriable instanceof JetUUserDataSource) {
            this.isUDSQuery = true;
        } else {
            throw new RuntimeException("Unknow the query type or the query is null :" + this.jetUQueriable == null ? queryName : this.jetUQueriable.getClass().getName());
        }
    }

    public String[] getParameterNamesInQuery(String wherePortionString, String whereString) throws DSException {
        return this.getParameterNamesInQuery(wherePortionString, whereString, false);
    }

    public String[] getParameterNamesInQuery(String wherePortionString, String whereString, boolean withCascadingParameter) throws DSException {
        String[] paramNames = null;
        if (this.isRefQuery) {
            paramNames = this.getParameterNamesInRefQuery(false);
        } else if (this.isSQLQuery()) {
            paramNames = this.getParameterNamesInSqlQueryByWherePortionString(wherePortionString, whereString);
        } else if (this.isProcedureQuery()) {
            paramNames = this.getParameterNamesInProcedureQuery();
        } else if (this.isUDSQuery()) {
            paramNames = this.getParameterNamesInUDSQuery();
        } else if (this.isHDSQuery()) {
            paramNames = this.getParameterNamesInHDSQuery();
        }
        if (withCascadingParameter) {
            return this.addDependParameters(paramNames);
        }
        return paramNames;
    }

    private String[] getParameterNamesInRefQuery(boolean withFormula) throws DSException {
        ArrayList<String> parameters = new ArrayList<String>();
        JetUQuery uQuery = (JetUQuery)this.jetUQueriable;
        Vector tables = uQuery.getPsqlQuery().vTables;
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            PsqlTable pTable = (PsqlTable)tables.get(i);
            if (!pTable.isQueriable()) continue;
            String queryName = pTable.mappingName;
            ParseParametersForQuery p = ParseParametersForQueryFactory.CreateParseParametersForQuery(this.universe, this.dataSourceName, queryName);
            String[] ps = null;
            ps = withFormula ? p.getRefResourceNamesInQuery() : p.getParameterNamesInQuery();
            for (int j = 0; j < ps.length; ++j) {
                if (parameters.contains(ps[j])) continue;
                parameters.add(ps[j]);
            }
        }
        IExpression filter = uQuery.getPsqlQuery().getSearchConditionGroups();
        if (filter != null) {
            try {
                String[] paras = this.getAllUsedParameters(filter.getStringValue(true), withFormula);
                for (int j = 0; j < paras.length; ++j) {
                    if (parameters.contains(paras[j])) continue;
                    parameters.add(paras[j]);
                }
            }
            catch (ConditionException e) {
                // empty catch block
            }
        }
        String whereClause = uQuery.getPsqlQuery().getRawWhereClauseString(true);
        String[] pAndf = this.getAllUsedParameters(whereClause, withFormula);
        for (int j = 0; j < pAndf.length; ++j) {
            if (parameters.contains(pAndf[j])) continue;
            parameters.add(pAndf[j]);
        }
        String[] ret = new String[parameters.size()];
        parameters.toArray(ret);
        return ret;
    }

    public boolean isReferUserName() throws DSException {
        String[] allRefer = this.getAllReferNamesInQuery();
        for (int j = 0; j < allRefer.length; ++j) {
            if (DbTools.isSpecialField(allRefer[j]) != 0) continue;
            return true;
        }
        return false;
    }

    public String[] getParameterNamesInQuery(String wherePortionStringOrName, String whereString, boolean withCascadingParameter, boolean isWherePortionName) throws DSException {
        String[] paramNames = null;
        if (this.isRefQuery) {
            paramNames = this.getParameterNamesInRefQuery(false);
        } else if (this.isSQLQuery()) {
            String wherePortionString = null;
            if (isWherePortionName) {
                if (!StringTools.isEmptyString(wherePortionStringOrName)) {
                    wherePortionString = this.universe.getWherePortion(wherePortionStringOrName);
                }
                paramNames = this.getParameterNamesInSqlQueryByWherePortionString(wherePortionString, whereString);
            } else {
                wherePortionString = wherePortionStringOrName;
            }
            paramNames = this.getParameterNamesInSqlQueryByWherePortionString(wherePortionStringOrName, whereString);
        } else if (this.isProcedureQuery()) {
            paramNames = this.getParameterNamesInProcedureQuery();
        } else if (this.isUDSQuery()) {
            paramNames = this.getParameterNamesInUDSQuery();
        } else if (this.isHDSQuery()) {
            paramNames = this.getParameterNamesInHDSQuery();
        }
        if (withCascadingParameter) {
            return this.addDependParameters(paramNames);
        }
        return paramNames;
    }

    private String[] addDependParameters(String[] paramNames) throws DSException {
        JetUDatabase db = this.universe.getDatabase(this.dataSourceName);
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < paramNames.length; ++i) {
            ret.add(paramNames[i]);
            JetUParameter para = db.getParameterByResourceName(paramNames[i]);
            if (para == null) continue;
            ret.add(paramNames[i]);
            Hashtable referUParam = new Hashtable();
            para.getAllReferP(this.universe, this.dataSourceName, null, referUParam);
            ret.addAll(referUParam.keySet());
            String bindColumnName = para.column.get();
            JetField entity = (JetField)((Object)db.getResourceByName(bindColumnName));
            if (entity instanceof JetUQueriableField) {
                String[] ps;
                String queryName = ((JetUQueriableField)entity).getQueriableName();
                ParseParametersForQuery parser = new ParseParametersForQuery(this.universe, this.dataSourceName, queryName);
                for (String p : ps = parser.getParameterNamesInQuery(null, null, true)) {
                    ret.add(p);
                }
                continue;
            }
            if (!(entity instanceof JetUField)) continue;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] getParameterNamesInQuery() throws DSException {
        return this.getParameterNamesInQuery(null, null);
    }

    @Override
    public String[] getRefResourceNamesInQuery() throws DSException {
        HashSet<String> ret = new HashSet<String>();
        String[] allRefer = this.getAllReferNamesInQuery();
        for (int j = 0; j < allRefer.length; ++j) {
            if (DbTools.isSpecialField(allRefer[j]) != -1) continue;
            ret.add(allRefer[j]);
        }
        String[] formulaParaNames = ret.toArray(new String[ret.size()]);
        return this.addDependParameters(formulaParaNames);
    }

    private String[] getAllReferNamesInQuery() throws DSException {
        String[] formulaParaNames = new String[]{};
        if (this.isRefQuery) {
            formulaParaNames = this.getParameterNamesInRefQuery(true);
        } else if (this.isSQLQuery()) {
            formulaParaNames = this.getAllUsedParameters(this.SQLStirngInQuery, true);
        } else if (this.isProcedureQuery()) {
            formulaParaNames = ResourceContainer.getProcedureParameterFormulaNames(this.universe, this.dataSourceName, this.queryName);
            HashSet ret = new HashSet();
            for (int i = 0; i < formulaParaNames.length; ++i) {
                this.getParameter(formulaParaNames[i], ret, true);
            }
            formulaParaNames = ret.toArray(new String[ret.size()]);
        } else if (this.isUDSQuery()) {
            formulaParaNames = this.getRefResourceNamesInUDSQuery();
        } else if (this.isHDSQuery()) {
            formulaParaNames = this.getParameterNamesInHDSQuery();
        }
        return formulaParaNames;
    }

    private String[] getRefResourceNamesInUDSQuery() {
        String str = ((JetUUserDataSource)this.jetUQueriable).getParameter();
        HashSet parameters = new HashSet();
        this.getAllUsedParameters(str, parameters, true);
        return parameters.toArray(SFT.ZERO_STRING_ARRAY);
    }

    @Override
    public String[] getParameterNamesInString(String st) throws DSException {
        Hashtable htPVPairs = new Hashtable();
        Hashtable htPOPairs = new Hashtable();
        Hashtable htUVPairs = new Hashtable();
        Vector vPos = new Vector();
        JetUConnection theCnnt = this.universe.getDatabase(this.dataSourceName).getQueriableByResourceName(this.queryName).getConnections()[0];
        JetUSupportInfo suppinfo = theCnnt.getSupportInfo();
        boolean hasParam = FileQuery.parseStatement(st, htPVPairs, htPOPairs, htUVPairs, vPos, this.universe, this.dataSourceName, theCnnt, suppinfo, null);
        String[] paramName = new String[htPVPairs.size()];
        if (hasParam) {
            int i = 0;
            Enumeration e = htPVPairs.keys();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                if (!(obj instanceof JetUParameter)) continue;
                JetUParameter p = (JetUParameter)obj;
                paramName[i] = p.getResourceName();
                ++i;
            }
            return paramName;
        }
        return null;
    }

    private String[] getParameterNamesInSqlQueryByWherePortionString(String wherePortionString, String whereString) throws DSException {
        String str = "";
        if (!StringTools.isEmptyString(wherePortionString)) {
            str = wherePortionString;
            if (!StringTools.isEmptyStringWithTrim(this.SQLStirngInQuery)) {
                str = str + " and " + this.SQLStirngInQuery;
            }
        } else if (!StringTools.isEmptyString(whereString)) {
            str = whereString;
            if (!StringTools.isEmptyStringWithTrim(this.SQLStirngInQuery)) {
                str = str + " and " + this.SQLStirngInQuery;
            }
        } else if (!StringTools.isEmptyStringWithTrim(this.SQLStirngInQuery)) {
            str = str + this.SQLStirngInQuery;
        }
        return this.getAllUsedParameters(str);
    }

    public static String getReferenceName(String str, int beginIndex) {
        int sz = str.length();
        if (sz < beginIndex) {
            return "";
        }
        boolean needEnd = false;
        StringBuffer buf = new StringBuffer();
        block4: for (int i = beginIndex; i < sz; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ':': 
                case '@': {
                    if (needEnd || ++i >= sz) continue block4;
                    c = str.charAt(i);
                    buf.setLength(0);
                    if (c == '\"') {
                        ++i;
                        while (i < sz) {
                            c = str.charAt(i);
                            if (c == '\"') {
                                return buf.toString();
                            }
                            buf.append(c);
                            ++i;
                        }
                        continue block4;
                    }
                    int i0 = i;
                    while (i < sz) {
                        c = str.charAt(i);
                        if (i == i0 && c >= '0' && c <= '9' || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z') && c != '_' && (c < '0' || c > '9')) break;
                        buf.append(c);
                        ++i;
                    }
                    if (buf.length() <= 0) continue block4;
                    return buf.toString();
                }
                case '\"': {
                    needEnd = !needEnd;
                }
            }
        }
        return null;
    }

    private void parseParameterFromBC(JetUDemandQuery dq, Set parameters) throws DSException {
        FilterInfo fi;
        JBusinessLogic bc = UpgradeBV.getBL(dq);
        if (bc != null && (fi = bc.getBCFilterInfo()) != null) {
            try {
                String[] formulas;
                IExpression ie = fi.getFilter();
                String[] params = ExpressionToolKit.getDependentParNames(ie);
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        parameters.add(params[i]);
                    }
                }
                if ((formulas = ExpressionToolKit.getDependentForNames(ie)) != null) {
                    for (int i = 0; i < formulas.length; ++i) {
                        JetUFormula f;
                        Vector v;
                        JetUResourceEntity ent = this.universe.getResourceByName(formulas[i]);
                        if (!(ent instanceof JetUFormula) || (v = (f = (JetUFormula)ent).getRefParamFld()) == null || v.size() <= 0) continue;
                        parameters.addAll(v);
                    }
                }
            }
            catch (ConditionException e) {
                throw new DSException(e.getMessage());
            }
        }
    }

    public String[] getAllUsedParameters(String str) throws DSException {
        return this.getAllUsedParameters(str, false);
    }

    public String[] getAllUsedParameters(String str, boolean withFormulas) throws DSException {
        HashSet<String> parameters = new HashSet<String>();
        if (this.isFileSQLQuery) {
            int i;
            int iLen = this.fileQueryParameterNames.length;
            for (i = 0; i < iLen; ++i) {
                parameters.add(this.fileQueryParameterNames[i]);
            }
            if (withFormulas) {
                iLen = this.fileQueryFormulaNames.length;
                for (i = 0; i < iLen; ++i) {
                    parameters.add(this.fileQueryFormulaNames[i]);
                }
            }
        } else {
            JetUHierDataSource jetUHierDataSource;
            URIParameterResolver parameterResolver;
            Vector paramNames;
            this.getAllUsedParameters(str, parameters, withFormulas);
            if (this.jetUQueriable instanceof JetUQuery) {
                if (((JetUQuery)this.jetUQueriable).enableSQLStmtCreator.get()) {
                    assert (this.universe != null) : "JetUUniverse is null";
                    if (((JetUQuery)this.jetUQueriable).getPsqlQuery().isPureJdbc()) {
                        String connName = ((JetUQuery)this.jetUQueriable).getConnections()[0].getResourceName();
                        JetUParameter[] jetUParameters = this.universe.getSQLStmtCreatorParams(this.dataSourceName, connName);
                        int iLen = jetUParameters.length;
                        for (int i = 0; i < iLen; ++i) {
                            parameters.add(jetUParameters[i].getResourceName().toUpperCase());
                        }
                    }
                }
                JetUQuery jetUQuery = (JetUQuery)this.jetUQueriable;
                JetUConnection[] conns = jetUQuery.getConnections();
                for (int index = 0; index < conns.length; ++index) {
                    int i;
                    JetUJDBCConnection jetUJDBCConnection;
                    JetUConnection conn = conns[index];
                    if (conn != null && conn instanceof JetUXMLConnection) {
                        JetUXMLConnection jetUXMLConnection = (JetUXMLConnection)conn;
                        String[] params = jetUXMLConnection.getXMLMetadata().getInstSource().getParamNames();
                        int iLen = params.length;
                        for (int i2 = 0; i2 < iLen; ++i2) {
                            parameters.add(params[i2].toUpperCase());
                        }
                        ArrayList formulaAndPara = PrepareInfoTools.collectionMappingNameInConnection(jetUXMLConnection);
                        for (int i3 = 0; i3 < formulaAndPara.size(); ++i3) {
                            HashSet ret = new HashSet();
                            this.getParameter((String)formulaAndPara.get(i3), ret, withFormulas);
                            parameters.addAll(ret);
                        }
                    }
                    if (conn != null && conn instanceof JetUWebServiceConnection) {
                        JetUWebServiceConnection jetUWebServiceConnection = (JetUWebServiceConnection)conn;
                        RptPsqlQuery rptPsqlQuery = ((JetUQuery)this.jetUQueriable).getPsqlQuery();
                        Vector tables = rptPsqlQuery.getPsqlTables();
                        JetUWSOperationConnection[] operationConnections = RawDataQueryTools.getCorrOperationConnection(tables, jetUWebServiceConnection);
                        Vector paramInElements = new Vector();
                        for (int i4 = 0; i4 < operationConnections.length; ++i4) {
                            JetUWSElement[] wsElements = operationConnections[i4].getWSElements();
                            if (wsElements == null) continue;
                            for (int j = 0; j < wsElements.length; ++j) {
                                WSElementToolkit.getParameters(wsElements[j], paramInElements, this.universe, this.dataSourceName);
                            }
                        }
                        int iLen = paramInElements.size();
                        for (int i5 = 0; i5 < iLen; ++i5) {
                            String paramName = ((String)paramInElements.elementAt(i5)).toUpperCase();
                            if (parameters.contains(paramName)) continue;
                            parameters.add(paramName);
                        }
                        Vector paramInPolicyInfos = new Vector();
                        Vector constFmlNames = new Vector();
                        PrepareInfoTools.collectionFmlsInSecurityPolicy(jetUWebServiceConnection, constFmlNames);
                        PrepareInfoTools.getParametersInFormula(constFmlNames, paramInPolicyInfos, this.universe, this.dataSourceName);
                        int iLen2 = paramInPolicyInfos.size();
                        for (int i6 = 0; i6 < iLen2; ++i6) {
                            String paramName = ((String)paramInPolicyInfos.elementAt(i6)).toUpperCase();
                            if (parameters.contains(paramName)) continue;
                            parameters.add(paramName);
                        }
                    }
                    if (conn == null || !(conn instanceof JetUJDBCConnection) || !(jetUJDBCConnection = (JetUJDBCConnection)conn).getConnectionInfo().getDriver().equals("com.jinfonet.jdbc.obj.ObjectDriver")) continue;
                    Vector usedField = jetUQuery.getDBFields();
                    ArrayList<String> usedTableNames = new ArrayList<String>();
                    for (int i7 = 0; i7 < usedField.size(); ++i7) {
                        JetUFldQueryField field;
                        if (((JetUQueryField)usedField.get(i7)).getConnection() != conn || usedField.get(i7) instanceof JetURefQueryField || usedTableNames.contains((field = (JetUFldQueryField)usedField.get(i7)).getTable().getResourceName())) continue;
                        usedTableNames.add(field.getTable().getResourceName());
                    }
                    Vector ups = this.universe.getDatabase(this.dataSourceName).getParameters();
                    JetUParameter up = null;
                    Hashtable<String, JetUParameter> ht = new Hashtable<String, JetUParameter>();
                    int sz = ups.size();
                    for (i = 0; i < sz; ++i) {
                        up = (JetUParameter)ups.elementAt(i);
                        String s = up.objName.get();
                        String s2 = up.objParamName.get();
                        if (s == null || s.length() <= 0 || s2 == null || s2.length() <= 0) continue;
                        ht.put(s + "." + s2, up);
                    }
                    int iLen = usedTableNames.size();
                    for (i = 0; i < iLen; ++i) {
                        String tn = (String)usedTableNames.get(i);
                        JetUTableView table = jetUJDBCConnection.GetTableByResourceName(tn);
                        Vector params = null;
                        try {
                            params = ((ObjectConnection)ConnectionToolkit.getConnection(jetUJDBCConnection)).getTableParameters(tn);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ParameterDesc pd = null;
                        int psz = params == null ? 0 : params.size();
                        for (int n = 0; n < psz; ++n) {
                            pd = (ParameterDesc)params.elementAt(n);
                            up = table.isEmptyLinks() ? (JetUParameter)ht.get(tn + "." + pd.name) : table.getBindParameter(pd.name);
                            if (up == null) continue;
                            parameters.add(up.getResourceName());
                        }
                    }
                }
            } else if (this.jetUQueriable instanceof JetUHierDataSource && (paramNames = (parameterResolver = new URIParameterResolver((jetUHierDataSource = (JetUHierDataSource)this.jetUQueriable).getURI())).getParameterNames()) != null) {
                parameters.addAll(paramNames);
            }
        }
        if (this.jetUQueriable instanceof JetUDemandQuery) {
            this.parseParameterFromBC((JetUDemandQuery)this.jetUQueriable, parameters);
        }
        return parameters.toArray(SFT.ZERO_STRING_ARRAY);
    }

    public String getFullString(String str) throws DSException {
        return this.repaceAllUsedReference(str);
    }

    private String repaceAllUsedReference(String str) throws DSException {
        return this.repaceAllUsedReference(str, null);
    }

    public String getFullStringExceptFormula(String str) throws DSException {
        return this.repaceAllUsedReferenceExceptFormula(str);
    }

    private int parType(String s, String searchStr) {
        if (s.indexOf("@" + searchStr) != -1) {
            return 0;
        }
        if (s.indexOf("@\"" + searchStr + "\"") != -1) {
            return 1;
        }
        if (s.indexOf(":" + searchStr) != -1) {
            return 2;
        }
        if (s.indexOf(":\"" + searchStr + "\"") != -1) {
            return 3;
        }
        return -1;
    }

    private void getAllUsedParameters(String str, Set ret) {
        this.getAllUsedParameters(str, ret, false);
    }

    private void getAllUsedParameters(String str, Set ret, boolean withFormula) {
        String strTmp = str;
        boolean begin = false;
        ArrayList<String> refers = this.getAllRefers(strTmp);
        int size = refers.size();
        for (int i = 0; i < size; ++i) {
            this.getParameter(refers.get(i), ret, withFormula);
        }
    }

    private ArrayList<String> getAllRefers(String str) {
        ArrayList<String> ret = new ArrayList<String>();
        int sz = str.length();
        boolean needEnd = false;
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < sz; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ':': 
                case '@': {
                    if (needEnd || ++i >= sz) continue block4;
                    c = str.charAt(i);
                    buf.setLength(0);
                    if (c == '\"') {
                        ++i;
                        while (i < sz) {
                            c = str.charAt(i);
                            if (c == '\"') {
                                ret.add(buf.toString());
                                buf = new StringBuffer();
                                continue block4;
                            }
                            buf.append(c);
                            ++i;
                        }
                        continue block4;
                    }
                    int i0 = i;
                    while (i < sz) {
                        c = str.charAt(i);
                        if (i == i0 && c >= '0' && c <= '9' || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z') && c != '_' && (c < '0' || c > '9')) break;
                        buf.append(c);
                        ++i;
                    }
                    if (buf.length() > 0) {
                        ret.add(buf.toString());
                    }
                    --i;
                    buf = new StringBuffer();
                    continue block4;
                }
                case '\"': {
                    needEnd = !needEnd;
                }
            }
        }
        return ret;
    }

    private String repaceAllUsedReference(String str, HashSet replaceedFormula) throws DSException {
        String strTmp;
        String strTmp1 = strTmp = str;
        int idx = 0;
        String refName = ParseParametersForQuery.getReferenceName(str, idx);
        if (replaceedFormula == null) {
            replaceedFormula = new HashSet();
        }
        while (refName != null) {
            if (this.universe.getResourceByName(this.dataSourceName, null, refName) != null) {
                strTmp = this.replaceReference(strTmp, refName, replaceedFormula);
            }
            if (this.universe.getQueriableByResourceName(this.dataSourceName, refName) != null) {
                strTmp = this.replaceReference(strTmp, refName, replaceedFormula);
            }
            idx = strTmp1.indexOf(refName) + refName.length();
            strTmp1 = strTmp1.substring(idx);
            refName = ParseParametersForQuery.getReferenceName(strTmp1, 0);
        }
        return strTmp;
    }

    private String repaceAllUsedReferenceExceptFormula(String str) throws DSException {
        String strTmp;
        String strTmp1 = strTmp = str;
        int idx = 0;
        String refName = ParseParametersForQuery.getReferenceName(str, idx);
        while (refName != null) {
            if (this.universe.getResourceByName(this.dataSourceName, null, refName) != null) {
                str = this.replaceReferenceExceptFormula(strTmp, refName);
            }
            idx = strTmp1.indexOf(refName) + refName.length();
            strTmp1 = strTmp1.substring(idx);
            refName = ParseParametersForQuery.getReferenceName(strTmp1, 0);
        }
        return str;
    }

    private String replaceString(String str, char begineChar, String referenceName, String relpaceString, boolean needParentheses) {
        if (needParentheses) {
            str = StringTools.replaceAllIngnoreCase(str, begineChar + this.quoteNeeded(referenceName), " ( " + relpaceString + " ) ");
            str = StringTools.replaceAllIngnoreCase(str, begineChar + "\"" + referenceName + "\"", " ( " + relpaceString + " ) ");
        } else {
            str = StringTools.replaceAllIngnoreCase(str, begineChar + this.quoteNeeded(referenceName), relpaceString);
            str = StringTools.replaceAllIngnoreCase(str, begineChar + "\"" + referenceName + "\"", relpaceString);
        }
        return str;
    }

    private String replaceReference(String str, String referenceName, HashSet formula2) throws DSException {
        String strTmp = StringTools.removeChar4BeginAndEnd(referenceName, '\"');
        if (strTmp.startsWith(String.valueOf(':')) || strTmp.startsWith(String.valueOf('@'))) {
            strTmp = strTmp.substring(1);
        }
        String elem = null;
        if (this.resourceContainer.containsIgnoreCase(strTmp.trim())) {
            elem = this.resourceContainer.getStringValue();
            if (!this.resourceContainer.wasParameter()) {
                if (this.resourceContainer.wasQuery()) {
                    this.containsSubQuery = true;
                    str = this.replaceString(str, '@', referenceName, elem, true);
                    str = this.repaceAllUsedReference(str, formula2);
                } else if (this.resourceContainer.wasFormula()) {
                    if (formula2.contains(referenceName)) {
                        str = this.replaceString(str, '@', referenceName, "", false);
                        str = this.replaceString(str, ':', referenceName, "", false);
                    } else {
                        if (StringTools.isEmptyStringWithTrim(elem)) {
                            str = this.replaceString(str, '@', referenceName, elem, false);
                            str = this.replaceString(str, ':', referenceName, elem, false);
                            formula2.add(referenceName);
                            return str;
                        }
                        elem = this.repaceAllUsedReference(elem, null);
                        str = this.replaceString(str, '@', referenceName, elem, false);
                        str = this.replaceString(str, ':', referenceName, elem, false);
                        formula2.add(referenceName);
                    }
                } else if (this.resourceContainer.wasWherePortion()) {
                    str = this.replaceString(str, '@', referenceName, elem, false);
                    str = this.repaceAllUsedReference(str, formula2);
                } else if (this.resourceContainer.wasField()) {
                    str = this.replaceString(str, '@', referenceName, "", false);
                    str = this.replaceString(str, '@', referenceName, elem, false);
                } else {
                    throw new RuntimeException("Unknow the mapping name type, mapping name is :" + elem.trim());
                }
            }
        }
        return str;
    }

    private String replaceReferenceExceptFormula(String str, String referenceName) throws DSException {
        String strTmp = StringTools.removeChar4BeginAndEnd(referenceName, '\"');
        if (strTmp.startsWith(String.valueOf(':')) || strTmp.startsWith(String.valueOf('@'))) {
            strTmp = strTmp.substring(1);
        }
        String elem = null;
        if (this.resourceContainer.containsIgnoreCase(strTmp.trim())) {
            elem = this.resourceContainer.getStringValue();
            if (this.resourceContainer.wasParameter()) {
                if (this.resourceContainer.containsIgnoreCase(elem.trim())) {
                    String elemTmp = this.resourceContainer.getStringValue();
                    if (this.resourceContainer.wasQuery()) {
                        this.containsSubQuery = true;
                        str = this.replaceString(str, '@', referenceName, elem, false);
                        str = this.replaceReferenceExceptFormula(str, elemTmp);
                    } else if (!this.resourceContainer.wasFormula()) {
                        if (this.resourceContainer.wasParameter()) {
                            str = this.replaceString(str, ':', referenceName, elem, true);
                            str = this.replaceString(str, '@', referenceName, elem, true);
                            str = this.replaceReferenceExceptFormula(str, elemTmp);
                        } else if (this.resourceContainer.wasWherePortion()) {
                            str = this.replaceString(str, '@', referenceName, elem, false);
                            str = this.replaceReferenceExceptFormula(str, elemTmp);
                        } else if (!this.resourceContainer.wasField()) {
                            throw new RuntimeException("Unknow the mapping name type, mapping name is :" + elem.trim());
                        }
                    }
                }
            } else if (this.resourceContainer.wasQuery()) {
                this.containsSubQuery = true;
                str = this.replaceString(str, '@', referenceName, elem, false);
                str = this.repaceAllUsedReference(str);
            } else if (!this.resourceContainer.wasFormula()) {
                if (this.resourceContainer.wasWherePortion()) {
                    str = this.replaceString(str, '@', referenceName, elem, false);
                    str = this.repaceAllUsedReference(str);
                } else if (!this.resourceContainer.wasField()) {
                    throw new RuntimeException("Unknow the mapping name type, mapping name is :" + elem.trim());
                }
            }
        }
        return str;
    }

    private void getParameter(String str, Set ret, boolean withFormula) {
        String strTmp = StringTools.removeChar4BeginAndEnd(str, '\"');
        String elem = null;
        if (withFormula) {
            int spec = DbTools.isSpecialField(str);
            switch (spec) {
                case 0: {
                    ret.add(strTmp.trim());
                }
            }
        }
        if (this.resourceContainer.containsIgnoreCase(strTmp.trim())) {
            if (this.resourceContainer.wasField()) {
                return;
            }
            if (this.resourceContainer.wasParameter()) {
                ret.add(strTmp.trim());
            } else if (this.resourceContainer.wasQuery()) {
                JetUQueriable q = this.universe.getQueriableByResourceName(this.dataSourceName, strTmp);
                if (q instanceof JetUQuery) {
                    String sqlString = ((JetUQuery)q).getSQLString();
                    this.getAllUsedParameters(sqlString, ret);
                }
            } else if (this.resourceContainer.wasFormula()) {
                JetUFormula f = (JetUFormula)this.universe.getResourceByName(this.dataSourceName, null, strTmp);
                if (withFormula) {
                    ret.add(strTmp.trim());
                    try {
                        ret.addAll(f.getRefAllFormuFld());
                    }
                    catch (CannotFindEntity e) {
                        throw new RuntimeException(strTmp.trim() + " can not be resolved. Cause by " + e.getMessage());
                    }
                }
                ret.addAll(f.getRefAllParamFld());
            } else if (this.resourceContainer.wasWherePortion()) {
                elem = this.resourceContainer.getStringValue();
                this.getAllUsedParameters(elem, ret);
            } else {
                throw new RuntimeException("Unknow the mapping name type, mapping name is :" + strTmp.trim());
            }
        }
    }

    private String quoteNeeded(String str) {
        if (str.indexOf(" ") > 0) {
            return '\"' + str + '\"';
        }
        return str;
    }

    public boolean isSQLQuery() {
        return this.isSQLQuery;
    }

    public boolean isProcedureQuery() {
        return this.isProcedureQuery;
    }

    public String[] getParameterNamesInProcedureQuery() {
        return ResourceContainer.getProcedureParameterNames(this.universe, this.dataSourceName, this.queryName);
    }

    public boolean isUDSQuery() {
        return this.isUDSQuery;
    }

    public String[] getParameterNamesInUDSQuery() throws DSException {
        String udsParameterValue = ((JetUUserDataSource)this.jetUQueriable).getParameter();
        return this.getAllUsedParameters(udsParameterValue);
    }

    public String[] getParameterNamesInHDSQuery() throws DSException {
        return this.getAllUsedParameters("");
    }

    public boolean isHDSQuery() {
        return this.isHDSQuery;
    }

    public static String quatoWhenNeeded(String str) {
        if (str.indexOf(58) != -1 || str.indexOf(64) != -1) {
            return '\"' + str + '\"';
        }
        return str;
    }

    public boolean isContainsSubQuery() {
        return this.containsSubQuery;
    }
}

