/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.formula.FormulaInfo;
import jet.formula.ParamDesc;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUQueryField;
import jet.universe.JetURefQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;

public final class UniverseTools {
    public static final int FORMULA_TYPE_CONSTANT_LEVER = 100;
    public static final int FORMULA_TYPE_PAGE_LEVER = 101;
    public static final int FORMULA_TYPE_GLOBAL_LEVER = 102;
    public static final int FORMULA_TYPE_GROUP_LEVER = 103;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS1 = 104;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS2 = 105;

    public static Vector getFieldResourceNames(JetUUniverse unv, String dataSourceName, String queryName) {
        Vector v = null;
        JetUQueriable queriable = unv.getQueriableByResourceName(dataSourceName, queryName);
        if (queriable instanceof JetUFileQuery) {
            v = UniverseTools.getFieldResourceNames((JetUFileQuery)queriable);
        } else if (!(queriable instanceof JetUHierDataSource)) {
            if (queriable instanceof JetUProcedure) {
                v = UniverseTools.getFieldResourceNames((JetUProcedure)queriable);
            } else if (queriable instanceof JetUQuery) {
                v = UniverseTools.getDbFieldResourceNames((JetUQuery)queriable);
            } else if (queriable instanceof JetUUserDataSource) {
                v = UniverseTools.getFieldResourceNames((JetUUserDataSource)queriable);
            }
        }
        return v;
    }

    private static Vector getFieldResourceNames(JetUFileQuery query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUFileQueryField field = (JetUFileQueryField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getFieldResourceNames(JetUProcedure query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUProcField field = (JetUProcField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getDbFieldResourceNames(JetUQuery query) {
        Vector vField = query.getDBFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                JetUQueryField field = (JetUQueryField)vField.elementAt(i);
                if (field instanceof JetURefQueryField && ((JetURefQueryField)field).bHide.get()) continue;
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    private static Vector getFieldResourceNames(JetUUserDataSource query) {
        Vector vField = query.getFields();
        Vector<String> vFieldName = new Vector<String>();
        if (vField != null) {
            for (int i = 0; i < vField.size(); ++i) {
                Object o = vField.elementAt(i);
                JetUUDSField field = (JetUUDSField)vField.elementAt(i);
                vFieldName.addElement(field.getResourceNameInUpperCase());
            }
        }
        return vFieldName;
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe) {
        return UniverseTools.getParamDesc(paramName, universe, false);
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe, boolean ignoreRangeCheck) {
        JetUResourceEntity entity = universe.getAnyResourceByName(paramName);
        if (entity == null || !(entity instanceof JetUParameter)) {
            return null;
        }
        ParamDesc pd = ignoreRangeCheck ? ((JetUParameter)entity).getNoRangeCheckParamDesc() : ((JetUParameter)entity).getParamDesc();
        UniverseTools.setBindColumn(pd);
        return pd;
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe, String dataSourceName) {
        return UniverseTools.getParamDesc(paramName, universe, dataSourceName, false);
    }

    public static ParamDesc getParamDesc(String paramName, JetUUniverse universe, String dataSourceName, boolean ignoreRangeCheck) {
        JetUParameter entity = universe.getDatabase(dataSourceName).getParameterByResourceName(paramName);
        if (entity == null || !(entity instanceof JetUParameter)) {
            return null;
        }
        ParamDesc pd = ignoreRangeCheck ? entity.getNoRangeCheckParamDesc() : entity.getParamDesc();
        UniverseTools.setBindColumn(pd);
        return pd;
    }

    private static void setBindColumn(ParamDesc pd) {
        String colName;
        if (pd != null && (colName = pd.getColumn()) != null && colName.length() > 0) {
            pd.setBeColumn(4);
        }
    }

    public static Vector getAvlGroupFields(JetUUniverse universe, String dataSourceName, String uQueryName) {
        Vector<String> vecColumns = new Vector<String>();
        Vector vecAvailableColumns = universe.getAvailableResourceEntitys(dataSourceName, uQueryName);
        int iSize = vecAvailableColumns.size();
        for (int i = 0; i < iSize; ++i) {
            JetUResourceEntity re = (JetUResourceEntity)vecAvailableColumns.elementAt(i);
            if (re instanceof JetUDBField) {
                vecColumns.addElement(re.getResourceName());
                continue;
            }
            if (re instanceof JetUFmlQueryField) {
                vecColumns.addElement(re.getResourceName());
                continue;
            }
            if (!(re instanceof JetUFormula) || !((JetUFormula)re).canSummary() || UniverseTools.getFormulaType(universe, dataSourceName, (JetUFormula)re) == 101) continue;
            vecColumns.addElement(re.getResourceName());
        }
        return vecColumns;
    }

    public static int getFormulaType(JetUUniverse unv, String datasourceName, JetUFormula formula2) {
        int type = -1;
        if (!formula2.isParsedOK()) {
            return type;
        }
        FormulaInfo formulainfo = formula2.formulainfo;
        type = formulainfo.formulatype.getAttr() == 9 ? 100 : (formulainfo.isUsePageVar() || formulainfo.isNextPrev() || formulainfo.isNoRecordCalled() ? 101 : (formulainfo.formulatype.IsSum() ? 103 : (formulainfo.isGlobal && !formulainfo.isSysVar() && formulainfo.refDBfield.size() < 1 && formulainfo.refFormula.size() < 1 ? 102 : (formulainfo.isGroupby ? 105 : 104))));
        return type;
    }

    public static Vector getAvlGroupFields(JetUUniverse unv, String dataSourceName) {
        Vector v = new Vector();
        JetUDatabase db = unv.getDatabase(dataSourceName);
        Vector vQueriable = db.getQueriables();
        if (vQueriable != null) {
            for (int i = 0; i < vQueriable.size(); ++i) {
                JetUQueriable queriable = (JetUQueriable)vQueriable.elementAt(i);
                String queryName = queriable.getResourceName();
                Vector vField = UniverseTools.getAvlGroupFields(unv, dataSourceName, queryName);
                if (vField == null) continue;
                UniverseTools.merge(v, vField);
            }
        }
        return v;
    }

    public static void merge(Vector dest, Vector source) {
        if (source == null || dest == null) {
            return;
        }
        for (int j = 0; j < source.size(); ++j) {
            Object o = source.elementAt(j);
            if (dest.contains(o)) continue;
            dest.addElement(o);
        }
    }

    public static List<String> getConnections(JetUUniverse unv, String dataSourceName, String queriableName) {
        JetUConnection[] conns = unv.getQueriableByResourceName(dataSourceName, queriableName).getConnections();
        ArrayList<String> ret = new ArrayList<String>(conns.length);
        for (int i = 0; i < conns.length; ++i) {
            ret.add(conns[i].getResourceName());
        }
        return ret;
    }

    public static JetUQueriable getFirstAvailableQuery(JetUFormula formula2) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector queries = formula2.getDatabase().getQueries();
        for (int i = 0; i < queries.size(); ++i) {
            if (!((JetUQuery)queries.get(i)).isFormulaValidToQuery(formula2)) continue;
            return (JetUQueriable)queries.get(i);
        }
        return null;
    }
}

