/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools.impl;

import java.util.HashSet;
import java.util.Set;
import jet.dataengine.util.DSLog;
import jet.universe.tools.IConnectionKey;
import jet.universe.tools.ITableKey;
import jet.universe.tools.JinfonetComparable;

public final class ConnectionKeyImpl<T extends IConnectionKey>
implements IConnectionKey<T> {
    private IConnectionKey.ConnectionType connectionType;
    private String currentCatalog;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String driverClassName;
    private String driverVersion;
    private String instanceURI;
    private String password;
    private Set<ITableKey> tableKeys;
    private String URL;
    private String userName;
    private String JNDIDataSourceName;
    private DSLog log = DSLog.getDSLog(this.getClass().getName());

    void setConnectionType(IConnectionKey.ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    void setCurrentCatalog(String currentCatalog) {
        this.currentCatalog = currentCatalog;
    }

    void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    void setInstanceURI(String instanceURI) {
        this.instanceURI = instanceURI;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void addTableKeys(ITableKey tableKey) {
        this.tableKeys.add(tableKey);
    }

    void setURL(String url) {
        this.URL = url;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public IConnectionKey.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public String getCurrentCatalog() {
        return this.currentCatalog;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public String getInstanceURI() {
        return this.instanceURI;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public Set<ITableKey> getTableKeys(String catalog) {
        HashSet<ITableKey> ret = new HashSet<ITableKey>();
        for (ITableKey key : this.tableKeys) {
            if (catalog == null || !catalog.equalsIgnoreCase(key.getCatalogName())) continue;
            ret.add(key);
        }
        return ret;
    }

    @Override
    public String getURL() {
        return this.URL;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public JinfonetComparable.CompareResult CompareTo(T o) {
        if (o == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(CompareTo) o == null ==> false");
            }
            return JinfonetComparable.CompareResult.NotEquals;
        }
        block0 : switch (this.getConnectionType()) {
            case JDBC_Catalog: 
            case JDBC_JNDI: 
            case JDBC_Object: {
                switch (o.getConnectionType()) {
                    case XMLDataSource_URI: 
                    case XMLDataSource_InputFactory: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                }
                if (!this.getDriverClassName().equals(o.getDriverClassName())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                    }
                    return JinfonetComparable.CompareResult.NotEquals;
                }
                if (!this.getUserName().equals(o.getUserName())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                    }
                    return JinfonetComparable.CompareResult.NotEquals;
                }
                if (this.getConnectionType() != o.getConnectionType() || this.getConnectionType() != IConnectionKey.ConnectionType.JDBC_Catalog) break;
                switch (this.getConnectionType()) {
                    case JDBC_Catalog: {
                        if (this.getPassword().equals(o.getPassword())) break block0;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                    case JDBC_JNDI: {
                        if (!this.getJNDIDataSourceName().equals(o.getJNDIDataSourceName())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Compare(CompareTo) [" + this.getJNDIDataSourceName() + "] equals [" + o.getJNDIDataSourceName() + "] ==> " + false);
                            }
                            return JinfonetComparable.CompareResult.NotEquals;
                        }
                        if (!this.getUserName().equals(o.getUserName())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Compare(CompareTo) [" + this.getUserName() + "] equals [" + o.getUserName() + "] ==> " + false);
                            }
                            return JinfonetComparable.CompareResult.NotEquals;
                        }
                        if (this.getPassword().equals(o.getPassword())) break block0;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                    case JDBC_ConnectionInfo: {
                        if (!this.getDriverClassName().equals(o.getDriverClassName())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Compare(CompareTo) [" + this.getDriverClassName() + "] equals [" + o.getDriverClassName() + "] ==> " + false);
                            }
                            return JinfonetComparable.CompareResult.NotEquals;
                        }
                        if (!this.getUserName().equals(o.getUserName())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Compare(CompareTo) [" + this.getUserName() + "] equals [" + o.getUserName() + "] ==> " + false);
                            }
                            return JinfonetComparable.CompareResult.NotEquals;
                        }
                        if (this.getPassword().equals(o.getPassword())) break block0;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                }
                break;
            }
            case XMLDataSource_URI: {
                switch (o.getConnectionType()) {
                    case XMLDataSource_URI: {
                        if (this.getInstanceURI().equals(o.getInstanceURI())) break block0;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                    default: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                        }
                        return JinfonetComparable.CompareResult.NotEquals;
                    }
                }
            }
            case XMLDataSource_InputFactory: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
                }
                return JinfonetComparable.CompareResult.NotEquals;
            }
            default: {
                throw new IllegalArgumentException("Unknow connection type " + (Object)((Object)this.getConnectionType()));
            }
        }
        if (!this.getURL().equals(o.getURL())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(CompareTo) [" + (Object)((Object)this.getConnectionType()) + "] equals [" + (Object)((Object)o.getConnectionType()) + "] ==> " + false);
            }
            return JinfonetComparable.CompareResult.NotEquals;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compare(CompareTo) [" + this.toString() + "] equals [" + o.toString() + "] ==> " + true);
        }
        return JinfonetComparable.CompareResult.Equals;
    }

    @Override
    public String getJNDIDataSourceName() {
        return this.JNDIDataSourceName;
    }

    void setJNDIDataSourceName(String JNDIDataSourceName) {
        this.JNDIDataSourceName = JNDIDataSourceName;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConnectionKeyImpl::[");
        sb.append(super.toString() + " ");
        sb.append(" connectionType:=");
        sb.append((Object)this.connectionType);
        sb.append(" currentCatalog:=");
        sb.append(this.currentCatalog);
        sb.append(" driverMajorVersion:=");
        sb.append(this.driverMajorVersion);
        sb.append(" driverMinorVersion:=");
        sb.append(this.driverMinorVersion);
        sb.append(" driverClassName:=");
        sb.append(this.driverClassName);
        sb.append(" driverVersion:=");
        sb.append(this.driverVersion);
        sb.append(" instanceURI:=");
        sb.append(this.instanceURI);
        sb.append(" password:=");
        sb.append(this.password);
        sb.append(" URL:=");
        sb.append(this.URL);
        sb.append(" userName:=");
        sb.append(this.userName);
        sb.append(" JNDIDataSourceName:=");
        sb.append(this.JNDIDataSourceName);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectionType == null ? 0 : this.connectionType.hashCode());
        hashCode = 31 * hashCode + (this.currentCatalog == null ? 0 : this.currentCatalog.hashCode());
        hashCode = 31 * hashCode + this.driverMajorVersion;
        hashCode = 31 * hashCode + this.driverMinorVersion;
        hashCode = 31 * hashCode + (this.driverClassName == null ? 0 : this.driverClassName.hashCode());
        hashCode = 31 * hashCode + (this.driverVersion == null ? 0 : this.driverVersion.hashCode());
        hashCode = 31 * hashCode + (this.instanceURI == null ? 0 : this.instanceURI.hashCode());
        hashCode = 31 * hashCode + (this.password == null ? 0 : this.password.hashCode());
        hashCode = 31 * hashCode + (this.tableKeys == null ? 0 : ((Object)this.tableKeys).hashCode());
        hashCode = 31 * hashCode + (this.URL == null ? 0 : this.URL.hashCode());
        hashCode = 31 * hashCode + (this.userName == null ? 0 : this.userName.hashCode());
        hashCode = 31 * hashCode + (this.JNDIDataSourceName == null ? 0 : this.JNDIDataSourceName.hashCode());
        hashCode = 31 * hashCode + (this.log == null ? 0 : this.log.hashCode());
        return hashCode;
    }
}

