/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools.impl;

import jet.dataengine.util.StringTools;
import jet.universe.tools.IMappingName;
import jet.universe.tools.JinfonetComparable;

public final class MappingNameImpl<T extends IMappingName>
implements IMappingName<T> {
    private String mappingName;

    MappingNameImpl(String mappingName) {
        if (!this.valide(mappingName)) {
            throw new IllegalArgumentException("invalidate mapping name:[" + mappingName + "]");
        }
        this.mappingName = mappingName;
    }

    private boolean valide(String mappingName) {
        return !StringTools.isEmptyStringWithTrim(mappingName);
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public String getMappingNameKey() {
        return this.mappingName.toUpperCase();
    }

    @Override
    public JinfonetComparable.CompareResult CompareTo(T o) {
        if (this.getMappingNameKey().equals(o.getMappingNameKey())) {
            return JinfonetComparable.CompareResult.Equals;
        }
        return JinfonetComparable.CompareResult.NotEquals;
    }

    public boolean equals(Object o) {
        if (o instanceof IMappingName) {
            IMappingName m = (IMappingName)o;
            if (!StringTools.equals(this.getMappingNameKey(), m.getMappingNameKey(), true, false)) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return this.mappingName;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mappingName == null ? 0 : this.mappingName.hashCode());
        return hashCode;
    }
}

