/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools.impl;

import java.util.List;
import java.util.Set;
import jet.connect.DbValue;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.util.DSLog;
import jet.dataengine.util.StringTools;
import jet.universe.JetUQueriable;
import jet.universe.tools.IColumnKey;
import jet.universe.tools.IConnectionKey;
import jet.universe.tools.IMappingName;
import jet.universe.tools.IQueryKey;
import jet.universe.tools.ITableKey;
import jet.universe.tools.JinfonetComparable;
import jet.universe.tools.impl.QueryToolkits;

public final class QueryKeyImpl<T extends IQueryKey>
implements IQueryKey<T> {
    private Set<DbValue> constantFormulaValues = null;
    private List<IExpression> filterExpressions = null;
    private String catalogName;
    private IConnectionKey connectionKey;
    private ParameterValueList parameterValues;
    private String datasourceName;
    private JetUQueriable jetUQueriable;
    private Set<ITupleExpression> joinExpressions;
    private IMappingName mappingName;
    private Set<IColumnKey> metadata;
    private String queryString;
    private String queryStringWithoutMetadata;
    private List<IQueryKey> subQueryKeys;
    private Set<ITableKey<ITableKey>> tables;
    private List<IQueryKey> unionQueryKeys;
    private String whereFormulaString;
    private boolean isDistinct;
    private boolean isIgnorePredicateIfParamIsNull;
    private IQueryKey.QueryType queryType;
    private SpecialFields specialFields;
    private String UDSClazzName;
    private String DBMSCatalogName;
    private String DBMSSchemaName;
    private String FunctionName;
    private DSLog log = DSLog.getDSLog(this.getClass().getName());
    private String dynamicSQLCreatorClazzName;
    private IExpression queryExpression;

    void setConstantFormaulaValues(Set<DbValue> constantFormaulaValues) {
        this.constantFormulaValues = constantFormaulaValues;
    }

    void setFilterExpression(List<IExpression> filterExpression) {
        this.filterExpressions = filterExpression;
    }

    void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    void setConnectionKey(IConnectionKey connectionKey) {
        this.connectionKey = connectionKey;
    }

    void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    void setIgnorePredicateIfParamIsNull(boolean isIgnorePredicateIfParamIsNull) {
        this.isIgnorePredicateIfParamIsNull = isIgnorePredicateIfParamIsNull;
    }

    void setJetUQueriable(JetUQueriable jetUQueriable) {
        this.jetUQueriable = jetUQueriable;
    }

    void setJoinExpressions(Set<ITupleExpression> joinExpressions) {
        this.joinExpressions = joinExpressions;
    }

    void setMappingName(IMappingName mappingName) {
        this.mappingName = mappingName;
    }

    void setMetadata(Set<IColumnKey> metadata) {
        this.metadata = metadata;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    void setQueryStringWithoutMetadata(String queryStringWithoutMetadata) {
        this.queryStringWithoutMetadata = queryStringWithoutMetadata;
    }

    void setQueryType(IQueryKey.QueryType queryType) {
        this.queryType = queryType;
    }

    void setSubQueryKeys(List<IQueryKey> subQueryKeys) {
        this.subQueryKeys = subQueryKeys;
    }

    void setTables(Set<ITableKey<ITableKey>> tables) {
        this.tables = tables;
    }

    void setUnionQueryKeys(List<IQueryKey> unionQueryKeys) {
        this.unionQueryKeys = unionQueryKeys;
    }

    void setWhereFormulaString(String whereFormulaString) {
        this.whereFormulaString = whereFormulaString;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public IConnectionKey getConnectionKey() {
        return this.connectionKey;
    }

    @Override
    public Set<DbValue> getConstantFormulaValues() {
        return this.constantFormulaValues;
    }

    void setParameterValues(ParameterValueList parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public ParameterValueList getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Override
    public JetUQueriable getJetUQueriable() {
        return this.jetUQueriable;
    }

    @Override
    public Set<ITupleExpression> getJoinExpressions() {
        return this.joinExpressions;
    }

    @Override
    public IMappingName getMappingName() {
        return this.mappingName;
    }

    @Override
    public Set<IColumnKey> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getQueryStringWithoutMetadata() {
        return this.queryStringWithoutMetadata;
    }

    @Override
    public List<IQueryKey> getSubQueryKeys() {
        return this.subQueryKeys;
    }

    @Override
    public Set<ITableKey<ITableKey>> getTables() {
        return this.tables;
    }

    @Override
    public List<IQueryKey> getUnionQueryKeys() {
        return this.unionQueryKeys;
    }

    @Override
    public String getWhereFormulaString() {
        return this.whereFormulaString;
    }

    @Override
    public boolean haveSubQuery() {
        return this.subQueryKeys.size() > 0;
    }

    @Override
    public boolean haveUnion() {
        return this.unionQueryKeys.size() > 0;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public boolean isIgnorePredicateIfParamIsNull() {
        return this.isIgnorePredicateIfParamIsNull;
    }

    @Override
    public IQueryKey.QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public JinfonetComparable.CompareResult ShallowCompareTo(T o) {
        JinfonetComparable.CompareResult ret;
        JinfonetComparable.CompareResult compareResult = ret = this.equals(o) ? JinfonetComparable.CompareResult.Equals : JinfonetComparable.CompareResult.NotEquals;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compare(ShallowCompareTo) Query key[" + this.toString() + "] to [" + this.toString() + "] ==>" + (Object)((Object)ret));
        }
        return ret;
    }

    @Override
    public JinfonetComparable.CompareResult CompareTo(T o) {
        return this.ShallowCompareTo(o);
    }

    @Override
    public JinfonetComparable.CompareResult DeepCompareTo(T o) {
        if (o == null) {
            return JinfonetComparable.CompareResult.NotEquals;
        }
        if (this.getQueryType() != o.getQueryType()) {
            return JinfonetComparable.CompareResult.NotEquals;
        }
        if (this.getConnectionKey().CompareTo(o.getConnectionKey()) != JinfonetComparable.CompareResult.Equals) {
            return JinfonetComparable.CompareResult.NotEquals;
        }
        return QueryToolkits.compareTo(this.getMetadata(), o.getMetadata());
    }

    void setConstantFormulaValues(Set<DbValue> constantFormulaValues) {
        this.constantFormulaValues = constantFormulaValues;
    }

    void setFilterExpressions(List<IExpression> filterExpressions) {
        this.filterExpressions = filterExpressions;
    }

    @Override
    public SpecialFields getSpecialFields() {
        return this.specialFields;
    }

    void setSpecialFields(SpecialFields specialFields) {
        this.specialFields = specialFields;
    }

    public boolean equals(T o) {
        if (o == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) o == null ==> false");
            }
            return false;
        }
        if (this.getQueryType() != o.getQueryType()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) " + (Object)((Object)this.getQueryType()) + "==" + (Object)((Object)o.getQueryType()) + " ==> " + false);
            }
            return false;
        }
        if (!StringTools.equals(this.getCatalogName(), o.getCatalogName(), false, false)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) [" + this.getCatalogName() + "] equals [" + o.getCatalogName() + "] ==> " + false);
            }
            return false;
        }
        if (!StringTools.equals(this.getMappingName().getMappingNameKey(), o.getMappingName().getMappingNameKey(), false, false)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) [" + this.getMappingName() + "] equals [" + o.getMappingName() + "] ==> " + false);
            }
            return false;
        }
        if (!StringTools.equals(this.getDatasourceName(), o.getDatasourceName(), false, false)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) [" + this.getDatasourceName() + "] equals [" + o.getDatasourceName() + "] ==> " + false);
            }
            return false;
        }
        if (this.getConnectionKey() != null && o.getConnectionKey() != null && this.getConnectionKey().CompareTo(o.getConnectionKey()) != JinfonetComparable.CompareResult.Equals) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) [" + this.getConnectionKey() + "] equals [" + o.getConnectionKey() + "] ==> " + false);
            }
            return false;
        }
        if (!StringTools.equals(this.getQueryString(), o.getQueryString(), true, false)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Compare(equals) [" + this.getQueryString() + "] equals [" + o.getQueryString() + "] ==> " + false);
            }
            return false;
        }
        switch (this.getQueryType()) {
            case FileQuery: {
                if (StringTools.equals(this.getDBMSSchemaName(), o.getDBMSSchemaName(), true, false)) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compare(equals) [" + this.getDBMSSchemaName() + "] equals [" + o.getDBMSSchemaName() + "] ==> " + false);
                }
                return false;
            }
            case StoreProcedure: {
                if (!StringTools.equals(this.getDBMSSchemaName(), o.getDBMSSchemaName(), true, false)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(equals) [" + this.getDBMSSchemaName() + "] equals [" + o.getDBMSSchemaName() + "] ==> " + false);
                    }
                    return false;
                }
                if (StringTools.equals(this.getFunctionName(), o.getFunctionName(), true, false)) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compare(equals) [" + this.getFunctionName() + "] equals [" + o.getFunctionName() + "] ==> " + false);
                }
                return false;
            }
            case UDS: {
                if (StringTools.equals(this.getUDSClazzName(), o.getUDSClazzName(), false, false)) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compare(equals) getUDSClazzName() [" + this.getUDSClazzName() + "] equals [" + o.getUDSClazzName() + "] ==> " + false);
                }
                return false;
            }
            case PSQLQuery_Normal: {
                if (this.isDistinct() != o.isDistinct()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(equals) isDistinct() [" + this.isDistinct() + "] equals [" + o.isDistinct() + "] ==> " + false);
                    }
                    return false;
                }
                if (this.haveUnion() != o.haveUnion()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(equals) haveUnion() [" + this.haveUnion() + "] equals [" + o.haveUnion() + "] ==> " + false);
                    }
                    return false;
                }
                if (this.haveSubQuery() != o.haveSubQuery()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Compare(equals) haveSubQuery() [" + this.haveSubQuery() + "] equals [" + o.haveSubQuery() + "] ==> " + false);
                    }
                    return false;
                }
                if (this.isIgnorePredicateIfParamIsNull() == o.isIgnorePredicateIfParamIsNull()) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compare(equals) isIgnorePredicateIfParamIsNull() [" + this.isIgnorePredicateIfParamIsNull() + "] equals [" + o.isIgnorePredicateIfParamIsNull() + "] ==> " + false);
                }
                return false;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compare(equals) [" + this.toString() + "] equals [" + o.toString() + "] ==> " + true);
        }
        return true;
    }

    @Override
    public List<IExpression> getFilterExpressions() {
        return this.filterExpressions;
    }

    @Override
    public String getUDSClazzName() {
        return this.UDSClazzName;
    }

    void setUDSClazzName(String clazzName) {
        this.UDSClazzName = clazzName;
    }

    @Override
    public String getDBMSCatalogName() {
        return this.DBMSCatalogName;
    }

    @Override
    public String getDBMSSchemaName() {
        return this.DBMSSchemaName;
    }

    @Override
    public String getFunctionName() {
        return this.FunctionName;
    }

    final void setDBMSCatalogName(String catalogName) {
        this.DBMSCatalogName = catalogName;
    }

    final void setDBMSSchemaName(String schemaName) {
        this.DBMSSchemaName = schemaName;
    }

    final void setFunctionName(String functionName) {
        this.FunctionName = functionName;
    }

    public void setDynamicSQLCreatorClazzName(String name2) {
        this.dynamicSQLCreatorClazzName = name2;
    }

    @Override
    public String getDynamicSQLCreatorClazzName() {
        return this.dynamicSQLCreatorClazzName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("QueryKeyImpl::[");
        sb.append(super.toString() + " ");
        sb.append(" constantFormulaValues:=");
        sb.append(this.constantFormulaValues);
        sb.append(" filterExpressions:=");
        sb.append(this.filterExpressions);
        sb.append(" catalogName:=");
        sb.append(this.catalogName);
        sb.append(" connectionKey:=");
        sb.append(this.connectionKey);
        sb.append(" parameterValues:=");
        sb.append(this.parameterValues);
        sb.append(" datasourceName:=");
        sb.append(this.datasourceName);
        sb.append(" jetUQueriable:=");
        sb.append(this.jetUQueriable);
        sb.append(" joinExpressions:=");
        sb.append(this.joinExpressions);
        sb.append(" mappingName:=");
        sb.append(this.mappingName);
        sb.append(" metadata:=");
        sb.append(this.metadata);
        sb.append(" queryString:=");
        sb.append(this.queryString);
        sb.append(" queryStringWithoutMetadata:=");
        sb.append(this.queryStringWithoutMetadata);
        sb.append(" subQueryKeys:=");
        sb.append(this.subQueryKeys);
        sb.append(" tables:=");
        sb.append(this.tables);
        sb.append(" unionQueryKeys:=");
        sb.append(this.unionQueryKeys);
        sb.append(" whereFormulaString:=");
        sb.append(this.whereFormulaString);
        sb.append(" isDistinct:=");
        sb.append(this.isDistinct);
        sb.append(" isIgnorePredicateIfParamIsNull:=");
        sb.append(this.isIgnorePredicateIfParamIsNull);
        sb.append(" queryType:=");
        sb.append((Object)this.queryType);
        sb.append(" specialFields:=");
        sb.append(this.specialFields);
        sb.append(" UDSClazzName:=");
        sb.append(this.UDSClazzName);
        sb.append(" DBMSCatalogName:=");
        sb.append(this.DBMSCatalogName);
        sb.append(" DBMSSchemaName:=");
        sb.append(this.DBMSSchemaName);
        sb.append(" FunctionName:=");
        sb.append(this.FunctionName);
        sb.append(" log:=");
        sb.append(this.log);
        sb.append(" dynamicSQLCreatorClazzName:=");
        sb.append(this.dynamicSQLCreatorClazzName);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public IExpression getQueryExpression() {
        return this.queryExpression;
    }

    void setQueryExpression(IExpression queryExpression) {
        this.queryExpression = queryExpression;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.constantFormulaValues == null ? 0 : ((Object)this.constantFormulaValues).hashCode());
        hashCode = 31 * hashCode + (this.filterExpressions == null ? 0 : ((Object)this.filterExpressions).hashCode());
        hashCode = 31 * hashCode + (this.catalogName == null ? 0 : this.catalogName.hashCode());
        hashCode = 31 * hashCode + (this.connectionKey == null ? 0 : this.connectionKey.hashCode());
        hashCode = 31 * hashCode + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        hashCode = 31 * hashCode + (this.datasourceName == null ? 0 : this.datasourceName.hashCode());
        hashCode = 31 * hashCode + (this.jetUQueriable == null ? 0 : this.jetUQueriable.hashCode());
        hashCode = 31 * hashCode + (this.joinExpressions == null ? 0 : ((Object)this.joinExpressions).hashCode());
        hashCode = 31 * hashCode + (this.mappingName == null ? 0 : this.mappingName.hashCode());
        hashCode = 31 * hashCode + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        hashCode = 31 * hashCode + (this.queryString == null ? 0 : this.queryString.hashCode());
        hashCode = 31 * hashCode + (this.queryStringWithoutMetadata == null ? 0 : this.queryStringWithoutMetadata.hashCode());
        hashCode = 31 * hashCode + (this.subQueryKeys == null ? 0 : ((Object)this.subQueryKeys).hashCode());
        hashCode = 31 * hashCode + (this.tables == null ? 0 : ((Object)this.tables).hashCode());
        hashCode = 31 * hashCode + (this.unionQueryKeys == null ? 0 : ((Object)this.unionQueryKeys).hashCode());
        hashCode = 31 * hashCode + (this.whereFormulaString == null ? 0 : this.whereFormulaString.hashCode());
        hashCode = 31 * hashCode + (this.isDistinct ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.isIgnorePredicateIfParamIsNull ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.queryType == null ? 0 : this.queryType.hashCode());
        hashCode = 31 * hashCode + (this.specialFields == null ? 0 : this.specialFields.hashCode());
        hashCode = 31 * hashCode + (this.UDSClazzName == null ? 0 : this.UDSClazzName.hashCode());
        hashCode = 31 * hashCode + (this.DBMSCatalogName == null ? 0 : this.DBMSCatalogName.hashCode());
        hashCode = 31 * hashCode + (this.DBMSSchemaName == null ? 0 : this.DBMSSchemaName.hashCode());
        hashCode = 31 * hashCode + (this.FunctionName == null ? 0 : this.FunctionName.hashCode());
        hashCode = 31 * hashCode + (this.log == null ? 0 : this.log.hashCode());
        hashCode = 31 * hashCode + (this.dynamicSQLCreatorClazzName == null ? 0 : this.dynamicSQLCreatorClazzName.hashCode());
        hashCode = 31 * hashCode + (this.queryExpression == null ? 0 : ((Object)this.queryExpression).hashCode());
        return hashCode;
    }
}

