/*
 * Decompiled with CFR 0.152.
 */
package jet.universe.tools.impl;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.schema.relational.RelationModel;
import com.jinfonet.dataservice.schema.relational.TransformDataField;
import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.DSDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbDataField;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbRelationModel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingException;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.datasource.xml.XMLInstanceSource;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.util.StringTools;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.dataengine8.core.queryengine.RawDataQueryTools;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.datasource.InputStreamFactory;
import jet.datasource.JRResultSetException;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.exception.FormulaRingException;
import jet.exception.ParseFormulaFailedException;
import jet.universe.JetUCompColQueryField;
import jet.universe.JetUConnection;
import jet.universe.JetUField;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUProcField;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueryField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUXMLConnection;
import jet.universe.engine.UQueryEngine;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.CannotUseGlobalVarInFrmlWhere;
import jet.universe.exception.FldNotFoundInQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.ParameterNotResolved;
import jet.universe.exception.QueryWhereFormulaGrammarError;
import jet.universe.exception.SubLinkError;
import jet.universe.psql.RptPsqlFormulaColumn;
import jet.universe.psql.RptPsqlQuery;
import jet.universe.tools.IColumnKey;
import jet.universe.tools.IConnectionKey;
import jet.universe.tools.IMappingName;
import jet.universe.tools.IQueryKey;
import jet.universe.tools.ITableKey;
import jet.universe.tools.JinfonetComparable;
import jet.universe.tools.impl.ColumnKeyImpl;
import jet.universe.tools.impl.ConnectionKeyImpl;
import jet.universe.tools.impl.MappingNameImpl;
import jet.universe.tools.impl.QueryKeyImpl;
import jet.universe.tools.impl.TableKeyImpl;
import toolkit.db.PsqlSelColumn;
import toolkit.db.StmtSelCol;
import toolkit.db.gui.ConnectionsBroker;

public class QueryToolkits {
    public static IColumnKey<IColumnKey> create(JetUResourceEntity entity, Set<ITableKey<ITableKey>> tables) {
        IColumnKey ret = null;
        if (entity instanceof JetUQueryField) {
            if (entity instanceof JetUCompColQueryField) {
                ret = QueryToolkits.create((JetUCompColQueryField)entity);
            } else if (entity instanceof JetUFldQueryField) {
                ret = QueryToolkits.create((JetUFldQueryField)entity);
            } else if (entity instanceof JetUFmlQueryField) {
                ret = QueryToolkits.create((JetUFmlQueryField)entity);
            }
        } else if (entity instanceof JetUResourceField) {
            if (entity instanceof JetUField) {
                ret = QueryToolkits.create((JetUField)entity);
            } else if (entity instanceof JetUFileQueryField) {
                ret = QueryToolkits.create((JetUFileQueryField)entity);
            } else if (entity instanceof JetUProcField) {
                ret = QueryToolkits.create((JetUProcField)entity);
            } else if (entity instanceof JetUUDSField) {
                ret = QueryToolkits.create((JetUUDSField)entity);
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Unknow Field Type[" + entity.getClass().getName() + "]");
        }
        return ret;
    }

    private static IColumnKey create(JetUField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        return ret;
    }

    private static IMappingName<IMappingName> create(String mappingName) {
        return new MappingNameImpl<IMappingName>(mappingName);
    }

    private static void setNullableType(ColumnKeyImpl<IColumnKey> columnKey, int nullType) {
        switch (nullType) {
            case 0: {
                columnKey.setColumnNullableType(IColumnKey.ColumnNullableType.ColumnNoNulls);
                break;
            }
            case 1: {
                columnKey.setColumnNullableType(IColumnKey.ColumnNullableType.columnNullable);
                break;
            }
            case 2: {
                columnKey.setColumnNullableType(IColumnKey.ColumnNullableType.columnNullableUnknown);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow Null able Type :[" + nullType + "]");
            }
        }
    }

    private static IColumnKey create(JetUFileQueryField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        return ret;
    }

    private static IColumnKey create(JetUProcField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        return ret;
    }

    private static IColumnKey create(JetUUDSField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        return ret;
    }

    private static IColumnKey create(JetUCompColQueryField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        ret.setExpression(field.getExpression());
        return ret;
    }

    private static IColumnKey create(JetUFldQueryField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        return ret;
    }

    private static IColumnKey create(JetUFmlQueryField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        DbColDesc desc = field.getColDesc();
        ret.setColumnName(field.getFldName());
        ret.setColumnIndex(desc.getColIndex());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        ret.setArray(desc.isArray());
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(Types.sqlTypeToType(field.getSqlType()));
        } else {
            ret.setSqlType(Types.sqlTypeToType(field.getSqlType()));
        }
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        ret.setMappingName(QueryToolkits.create(field.getResourceName()));
        ret.setCurrency(desc.isCurrency());
        ret.setExpression(field.getExpression());
        return ret;
    }

    public static IConnectionKey create(JetUJDBCConnection conn) {
        ConnectionKeyImpl ret = new ConnectionKeyImpl();
        ret.setConnectionType(IConnectionKey.ConnectionType.JDBC_Catalog);
        ret.setDriverClassName(conn.getJdbcDriver());
        ret.setURL(conn.getURL());
        ret.setUserName(conn.getUID());
        ret.setPassword(conn.getPSWD());
        ret.setCurrentCatalog(null);
        ret.setDriverMajorVersion(-1);
        ret.setDriverMinorVersion(-1);
        return ret;
    }

    public static IConnectionKey create(JetUXMLConnection conn, ParameterValueList parameterValueList) throws DSException {
        return QueryToolkits.create(conn, null, parameterValueList);
    }

    public static IConnectionKey<IConnectionKey> create(JetUXMLConnection conn, InputStreamFactory inputStreamFactory, ParameterValueList parameterValueList) throws DSException {
        ConnectionKeyImpl<IConnectionKey> ret = new ConnectionKeyImpl<IConnectionKey>();
        if (inputStreamFactory != null) {
            ret.setConnectionType(IConnectionKey.ConnectionType.XMLDataSource_InputFactory);
        } else {
            ret.setConnectionType(IConnectionKey.ConnectionType.XMLDataSource_URI);
            MetadataContainerImpl metadataContainerImpl = conn.getXMLMetadata();
            ret.setURL(metadataContainerImpl.getSchemaURI());
            XMLInstanceSource instance = metadataContainerImpl.getInstSource();
            try {
                instance.setParamValueList(parameterValueList);
                ret.setInstanceURI(instance.getInstURI());
            }
            catch (DSException e) {
                ret.setInstanceURI("");
            }
        }
        ret.setDriverClassName(null);
        ret.setUserName(null);
        ret.setPassword(null);
        ret.setCurrentCatalog(null);
        ret.setDriverMajorVersion(-1);
        ret.setDriverMinorVersion(-1);
        ret.setCurrentCatalog(null);
        return ret;
    }

    public static ITableKey<ITableKey> create(JetUTableView table) {
        TableKeyImpl<ITableKey> ret = new TableKeyImpl<ITableKey>();
        ret.setTableName(table.getTableName());
        ret.setCatalogName(table.getQualifier());
        ret.setMappingName(QueryToolkits.create(table.getResourceName()));
        ret.setExpression(null);
        ret.setSchemaName(table.getOwner());
        return ret;
    }

    public static ITableKey<ITableKey> create(TransformRelationModel table) {
        TableKeyImpl<ITableKey> ret = new TableKeyImpl<ITableKey>();
        ret.setTableName(table.getName());
        ret.setCatalogName(null);
        ret.setMappingName(QueryToolkits.create(table.getAliasName()));
        ret.setSchemaName(null);
        return ret;
    }

    public static ITableKey<ITableKey> create(JetUHDSTable jetUHDSTable) {
        TableKeyImpl<ITableKey> ret = new TableKeyImpl<ITableKey>();
        return ret;
    }

    public static IColumnKey<IColumnKey> create(TransformDataField field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        ret.setArray(false);
        ret.setSqlType(Types.typeToSQLType(field.getDataType()));
        ret.setColumnIndex(-1);
        ret.setColumnName(field.getName());
        ret.setMappingName(QueryToolkits.create(field.getAliasName()));
        ret.setCurrency(field.isCurrency());
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getLength());
        ret.setScale(field.getScale());
        ret.setColumnNullableType(IColumnKey.ColumnNullableType.columnNullableUnknown);
        return ret;
    }

    public static JetUQueriable getJetUQueriable(JetUUniverse universe, String dataSourceName, String queryName) {
        return universe.getQueriableByResourceName(dataSourceName, queryName);
    }

    private static Set<IColumnKey> createTableKey(JetUUniverse universe, String dataSourceName, String queryName, QueryKeyImpl<IQueryKey> ret, RptPsqlQuery rptPsqlQuery, List<String> mappingNameList) throws DSException {
        Vector cols = rptPsqlQuery.getSelColsVector();
        Hashtable tables = new Hashtable();
        Hashtable<IMappingName<IMappingName>, IColumnKey<IColumnKey>> cs = new Hashtable<IMappingName<IMappingName>, IColumnKey<IColumnKey>>();
        Hashtable<IMappingName<IMappingName>, ITableKey<ITableKey>> ts = new Hashtable<IMappingName<IMappingName>, ITableKey<ITableKey>>();
        int iLen = cols.size();
        for (int i = 0; i < iLen; ++i) {
            Object o = cols.get(i);
            if (!(o instanceof PsqlSelColumn)) continue;
            PsqlSelColumn c = (PsqlSelColumn)o;
            String mappingName = c.getMappingName();
            mappingNameList.add(mappingName);
            JetUResourceEntity entity = universe.getResourceByName(dataSourceName, queryName, mappingName);
            if (entity == null) continue;
            QueryToolkits.convert(QueryTransform.createRdbDataField(entity, tables), ts, cs);
        }
        Collection vs = ts.values();
        HashSet<ITableKey<ITableKey>> tks = new HashSet<ITableKey<ITableKey>>();
        for (ITableKey v : vs) {
            tks.add(v);
        }
        ret.setTables(tks);
        Collection ckc = cs.values();
        HashSet<IColumnKey> css = new HashSet<IColumnKey>();
        for (IColumnKey cv : ckc) {
            css.add(cv);
        }
        return css;
    }

    private static UQueryEngine buildQueryEngine(JetUUniverse universe, JetUQueriable jetUQueriable, String dataSourceName, String queryName, Vector<String> mappingNames, ParameterValueList parameterValueList, Vector params) throws CannotFindEntity, CannotFindFrmlRefFld, FormulaHasGrammarError, CannotUseGlobalVarInFrmlWhere, FormulaRingException, ParseFormulaFailedException, QueryWhereFormulaGrammarError, FldNotFoundInQuery, CannotFindQuery, SubLinkError, LoadUserDataSourceException, DSException, ParameterNotResolved, JRUserDataSourceException, JRResultSetException {
        UQueryEngine engine = UQueryEngine.createEngine(universe, dataSourceName, queryName, mappingNames, params, null, false);
        engine.initialize();
        RawDataQueryTools.setParameterToProductQueryEngine(engine, parameterValueList);
        engine.start();
        return engine;
    }

    private static void convert(DSDataField dsField, Map<IMappingName<IMappingName>, ITableKey<ITableKey>> ts, Map<IMappingName<IMappingName>, IColumnKey<IColumnKey>> cs) {
        RelationModel relationModel = dsField.getRelationModel();
        ColumnKeyImpl<IColumnKey> c = null;
        TableKeyImpl<ITableKey> t = null;
        RdbRelationModel model = null;
        if (relationModel != null) {
            IMappingName<IMappingName> tm = QueryToolkits.create(relationModel.getAliasName());
            if (!ts.containsKey(tm)) {
                if (relationModel instanceof RdbRelationModel) {
                    model = (RdbRelationModel)relationModel;
                    t = new TableKeyImpl<ITableKey>();
                    t.setMappingName(tm);
                    t.setCatalogName(model.getCatalogName());
                    t.setSchemaName(model.getSchemaName());
                    t.setTableName(model.getTableName());
                    ts.put(tm, t);
                }
            } else {
                t = (TableKeyImpl<ITableKey>)ts.get(tm);
            }
        }
        c = new ColumnKeyImpl<IColumnKey>();
        int nt = dsField.isNullable();
        QueryToolkits.setNullableType(c, nt);
        IMappingName<IMappingName> cm = QueryToolkits.create(dsField.getAliasName());
        c.setMappingName(cm);
        c.setColumnName(dsField.getName());
        c.setCurrency(dsField.isCurrency());
        c.setLength(dsField.getLength());
        c.setPrecision(dsField.getPrecision());
        c.setScale(dsField.getScale());
        c.setSqlType(Types.typeToSQLType(dsField.getDataType()));
        if (c.getSqlType() == 2003) {
            c.setArray(true);
            c.setBaseSQLType(Types.typeToSQLType(dsField.getBaseType()));
        }
        if (dsField instanceof RdbDataField) {
            RdbDataField field = (RdbDataField)dsField;
            c.setColumnIndex(field.getFieldIndex());
            c.setExpression(field.getExpression());
        }
        c.setTableKey(t);
        cs.put(cm, c);
    }

    private static IColumnKey create(PsqlSelColumn field) {
        ColumnKeyImpl<IColumnKey> ret = new ColumnKeyImpl<IColumnKey>();
        ret.setArray(field.getArray());
        ret.setSqlType(field.getType());
        ret.setColumnIndex(-1);
        ret.setColumnName(field.name);
        ret.setMappingName(QueryToolkits.create(field.getMappingName()));
        ret.setCurrency(false);
        ret.setPrecision(field.getPrecision());
        ret.setLength(field.getPrecision());
        ret.setScale(field.getScale());
        int nt = field.getNullable();
        QueryToolkits.setNullableType(ret, nt);
        if (ret.isArray()) {
            ret.setSqlType(2003);
            ret.setBaseSQLType(field.getType());
        } else {
            ret.setSqlType(field.getType());
        }
        if (field instanceof RptPsqlFormulaColumn) {
            RptPsqlFormulaColumn rptPsqlFormulaColumn = (RptPsqlFormulaColumn)field;
            ret.setExpression(rptPsqlFormulaColumn.getUFormulaEntity().getExpression());
        } else if (field.isCompCol()) {
            ret.setExpression(field.getExpressionOfCompCol());
        } else if (field instanceof StmtSelCol) {
            StmtSelCol stmtSelCol = (StmtSelCol)field;
            ret.setColumnIndex(stmtSelCol.tableIndex);
        }
        return ret;
    }

    public static JetUConnection getJetUConnection(JetUUniverse universe, String dataSourceName) {
        return universe.getDatabase(dataSourceName).getConnection();
    }

    public static JinfonetComparable.CompareResult compareString(String s1, String s2) {
        if (StringTools.equals(s1, s2, true, true)) {
            return JinfonetComparable.CompareResult.Equals;
        }
        return JinfonetComparable.CompareResult.NotEquals;
    }

    public static IConnectionKey<IConnectionKey> create(Connection conn) throws SQLException {
        ConnectionKeyImpl<IConnectionKey> ret = new ConnectionKeyImpl<IConnectionKey>();
        ret.setConnectionType(IConnectionKey.ConnectionType.JDBC_Object);
        DatabaseMetaData metaData = conn.getMetaData();
        ret.setCurrentCatalog(conn.getCatalog());
        ret.setURL(metaData.getURL());
        ret.setDriverClassName(metaData.getDriverName());
        ret.setUserName(metaData.getUserName());
        return ret;
    }

    public static IConnectionKey<IConnectionKey> create(String url, String driverName, String userName, String pwd) throws SQLException, ClassNotFoundException {
        Connection conn = ConnectionsBroker.getConnection(url, userName, pwd, driverName);
        ConnectionKeyImpl ret = (ConnectionKeyImpl)QueryToolkits.create(conn);
        ret.setConnectionType(IConnectionKey.ConnectionType.JDBC_ConnectionInfo);
        ret.setPassword(pwd);
        ret.setDriverMajorVersion(-1);
        ret.setDriverMinorVersion(-1);
        conn.close();
        return ret;
    }

    public static IConnectionKey<IConnectionKey> create(Properties prop) throws NamingException, SQLException {
        Connection conn = ConnectionsBroker.getJNDIConnection((String)prop.get("jrs.jndi_datasource"), (String)prop.get("jrs.ds_user"), (String)prop.get("jrs.ds_pswd"));
        ConnectionKeyImpl ret = (ConnectionKeyImpl)QueryToolkits.create(conn);
        ret.setConnectionType(IConnectionKey.ConnectionType.JDBC_JNDI);
        ret.setDriverClassName(null);
        ret.setJNDIDataSourceName((String)prop.get("jrs.jndi_datasource"));
        ret.setUserName((String)prop.get("jrs.ds_user"));
        ret.setPassword((String)prop.get("jrs.ds_pswd"));
        ret.setDriverMajorVersion(-1);
        ret.setDriverMinorVersion(-1);
        return ret;
    }

    public static IConnectionKey<IConnectionKey> create(JetUConnection conn, ParameterValueList parameterValueList) throws DSException {
        if (conn instanceof JetUJDBCConnection) {
            return QueryToolkits.create((JetUJDBCConnection)conn);
        }
        if (conn instanceof JetUXMLConnection) {
            if (parameterValueList == null) {
                throw new IllegalArgumentException("ParameterValueList can not be null!");
            }
            return QueryToolkits.create((JetUXMLConnection)conn, parameterValueList);
        }
        throw new IllegalArgumentException("Unknow Connecion type [" + conn.getClass().getName() + "]");
    }

    public static JinfonetComparable.CompareResult compareTo(Collection<IColumnKey> set1, Collection<IColumnKey> set2) {
        if (set1.size() == set2.size()) {
            for (IColumnKey c1k : set1) {
                if (set2.contains(c1k)) continue;
                return JinfonetComparable.CompareResult.NotEquals;
            }
            return JinfonetComparable.CompareResult.Equals;
        }
        if (set1.size() < set2.size()) {
            for (IColumnKey c1k : set1) {
                if (set2.contains(c1k)) continue;
                return JinfonetComparable.CompareResult.NotEquals;
            }
            return JinfonetComparable.CompareResult.SubSet;
        }
        for (IColumnKey c2k : set2) {
            if (set1.contains(c2k)) continue;
            return JinfonetComparable.CompareResult.NotEquals;
        }
        return JinfonetComparable.CompareResult.SuperSet;
    }
}

